/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.cl.module;

import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIArraySite;
import com.ibm.storage.ess.ni.application.resource.NIArraySiteConfiguration;
import com.ibm.storage.ess.ni.cl.module.util.NICLGeneralUtils;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NICLArrayToSiteMap {
    private static final String CLASS_NAME = "NICLArrayToSiteMap";
    private static final int EQUAL = 0;
    private static final int ELEMENT_1 = 1;
    private static final int ELEMENT_2 = 2;
    private NIArraySite[] aSitesById = new NIArraySite[225];
    private NIArray[] aArraysBySiteId = new NIArray[225];
    private HashMap hmSitesByDa;
    private Integer[] daPairs = new Integer[16];
    private List lstAllSites;

    public NICLArrayToSiteMap(List list) {
        NIOlcLogger.enter(CLASS_NAME, "NICLArrayToSiteMap()");
        int n = list.size();
        this.lstAllSites = list;
        this.hmSitesByDa = new HashMap(16);
        int n2 = 0;
        while (n2 < 16) {
            this.daPairs[n2] = new Integer(n2);
            this.hmSitesByDa.put(this.daPairs[n2], new ArrayList());
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            NIArraySite nIArraySite = (NIArraySite)list.get(n2);
            int n3 = ((NIArraySiteID)nIArraySite.getID()).getArraySiteNumber();
            List list2 = (List)this.hmSitesByDa.get(this.daPairs[nIArraySite.getDeviceAdapterPair()]);
            if (list2 != null && n3 < this.aSitesById.length) {
                list2.add(nIArraySite);
                this.aSitesById[n3] = nIArraySite;
            }
            ++n2;
        }
        NIOlcLogger.exit(CLASS_NAME, "NICLArrayToSiteMap()");
    }

    public void clearReservation(NIArray nIArray) {
        NIOlcLogger.enter(CLASS_NAME, "clearReservation(NIArray)");
        int n = 0;
        while (n < nIArray.getArraySites().length) {
            int n2 = nIArray.getArraySites()[n].getArraySiteNumber();
            if (n2 >= 0 && n2 < this.aArraysBySiteId.length) {
                this.aArraysBySiteId[n2] = null;
            } else {
                NIOlcLogger.info("WARNING: S" + n2 + " is out of range");
            }
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, "clearReservation(NIArray)");
    }

    public void clearReservation(List list) {
        NIOlcLogger.enter(CLASS_NAME, "clearReservation(List)");
        if (list != null) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                NIArraySite nIArraySite = (NIArraySite)list.get(n2);
                int n3 = ((NIArraySiteID)nIArraySite.getID()).getArraySiteNumber();
                if (n3 >= 0 && n3 < this.aArraysBySiteId.length) {
                    this.aArraysBySiteId[n3] = null;
                } else {
                    NIOlcLogger.info("WARNING: S" + n3 + " is out of range");
                }
                ++n2;
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "clearReservation(List)");
    }

    public List getReservedSites(NIArray nIArray) {
        NIOlcLogger.enter(CLASS_NAME, "getReservedSites()");
        ArrayList<NIArraySite> arrayList = new ArrayList<NIArraySite>();
        int n = 0;
        while (n < this.aArraysBySiteId.length) {
            if (this.aArraysBySiteId[n].getID().equals(nIArray.getID())) {
                arrayList.add(this.aSitesById[n]);
            }
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, "getReservedSites()");
        return arrayList;
    }

    public List getReservedSiteIds(NIArray nIArray) {
        NIOlcLogger.enter(CLASS_NAME, "getReservedSiteIds()");
        ArrayList<NIResourceID> arrayList = new ArrayList<NIResourceID>();
        int n = 0;
        while (n < this.aArraysBySiteId.length) {
            if (this.aArraysBySiteId[n].getID().equals(nIArray.getID())) {
                arrayList.add(this.aSitesById[n].getID());
            }
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, "getReservedSiteIds()");
        return arrayList;
    }

    public List findAvailableSites(NIArray nIArray) {
        NIOlcLogger.enter(CLASS_NAME, "findAvailableSites()");
        boolean bl = false;
        int n = NICLGeneralUtils.convertDDMRPM(nIArray.getDiskRPM());
        int n2 = NICLGeneralUtils.convertDDMCapacityMBtoGB(nIArray.getDiskCapacity());
        ArrayList<NIArraySite> arrayList = new ArrayList<NIArraySite>();
        List list = (List)this.hmSitesByDa.get(this.daPairs[nIArray.getDeviceAdapterPairID()]);
        NIArraySite nIArraySite = null;
        NIArraySiteID[] nIArraySiteIDArray = nIArray.getArraySites();
        int n3 = list.size();
        int n4 = 0;
        while (n4 < nIArraySiteIDArray.length && !bl) {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            NIArraySite nIArraySite2 = null;
            int n5 = 0;
            while (!(n5 >= n3 || bl2 && bl4 && bl5 && bl3)) {
                NIArraySite nIArraySite3 = (NIArraySite)list.get(n5);
                if (!this.isSiteReserved(nIArraySite3)) {
                    int n6 = NICLGeneralUtils.convertDDMCapacityMBtoGB(nIArraySite3.getDiskCapacity());
                    if (nIArraySite2 == null && n6 >= n2 && (n4 == 0 && (nIArraySiteIDArray.length == 1 || this.matchingArrayExists(nIArraySite3, this.lstAllSites)) || nIArraySite != null && this.isMatchingSite(nIArraySite, nIArraySite3))) {
                        nIArraySite2 = nIArraySite3;
                        bl2 = n6 == n2;
                        bl4 = NICLGeneralUtils.convertDDMRPM(nIArraySite2.getDiskRPM()) == n;
                        boolean bl6 = bl5 = this.compareSiteIds(nIArraySite2.getID(), nIArraySiteIDArray[n4]) == 0;
                        bl3 = NICLGeneralUtils.isReef(nIArray) && n4 == 0 ? this.isWidthCompatible(nIArraySite3, nIArray) : true;
                    } else if (nIArraySite2 != null && n6 >= n2 && this.compareSiteCompatibility(nIArray, nIArraySiteIDArray[n4], nIArraySite2, nIArraySite3, n4 == 0) == 2 && (n4 == 0 && (nIArraySiteIDArray.length == 1 || this.matchingArrayExists(nIArraySite3, this.lstAllSites)) || nIArraySite != null && this.isMatchingSite(nIArraySite, nIArraySite3))) {
                        nIArraySite2 = nIArraySite3;
                        bl2 = n6 == n2;
                        bl4 = NICLGeneralUtils.convertDDMRPM(nIArraySite2.getDiskRPM()) == n;
                        bl5 = this.compareSiteIds(nIArraySite2.getID(), nIArraySiteIDArray[n4]) == 0;
                        bl3 = NICLGeneralUtils.isReef(nIArray) && n4 == 0 ? this.isWidthCompatible(nIArraySite2, nIArray) : true;
                    }
                }
                ++n5;
            }
            if (nIArraySite2 != null) {
                arrayList.add(nIArraySite2);
                this.aArraysBySiteId[((NIArraySiteID)nIArraySite2.getID()).getArraySiteNumber()] = nIArray;
                if (n4 == 0) {
                    nIArraySite = nIArraySite2;
                }
            } else {
                bl = true;
            }
            ++n4;
        }
        this.clearReservation(arrayList);
        int n7 = arrayList.size();
        n4 = 0;
        while (n4 < n7) {
            ++n4;
        }
        NIOlcLogger.exit(CLASS_NAME, "findAvailableSites()");
        return arrayList;
    }

    public boolean isSiteReserved(NIArraySite nIArraySite) {
        NIOlcLogger.enter(CLASS_NAME, "isSiteReserved()");
        int n = ((NIArraySiteID)nIArraySite.getID()).getArraySiteNumber();
        boolean bl = n < 0 || n >= this.aArraysBySiteId.length ? false : this.aArraysBySiteId[((NIArraySiteID)nIArraySite.getID()).getArraySiteNumber()] != null;
        NIOlcLogger.exit(CLASS_NAME, "isSiteReserved(): " + bl + ", S" + n);
        return bl;
    }

    public List reserveAvailableSites(NIArray nIArray) {
        NIOlcLogger.enter(CLASS_NAME, "reserveAvailableSites()");
        List list = new ArrayList();
        list = this.findAvailableSites(nIArray);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = ((NIArraySiteID)((NIArraySite)list.get(n2)).getID()).getArraySiteNumber();
            this.aArraysBySiteId[n3] = nIArray;
            ++n2;
        }
        NIOlcLogger.exit(CLASS_NAME, "reserveAvailableSites()");
        return list;
    }

    private int calcTotalSpares(NIArray nIArray) {
        NIOlcLogger.enter(CLASS_NAME, "calcTotalSpares()");
        int n = 0;
        NIArraySiteConfiguration[] nIArraySiteConfigurationArray = nIArray.getArraySiteConfiguration();
        if (nIArraySiteConfigurationArray != null) {
            int n2 = 0;
            while (n2 < nIArraySiteConfigurationArray.length) {
                n += nIArraySiteConfigurationArray[n2].getNumSpares();
                ++n2;
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "calcTotalSpares()");
        return n;
    }

    private int compareSizeCompatibility(int n, int n2, int n3) {
        NIOlcLogger.enter(CLASS_NAME, "compareSizeComaptibility()");
        int n4 = 0;
        int n5 = NICLGeneralUtils.convertDDMCapacityMBtoGB(n);
        int n6 = NICLGeneralUtils.convertDDMCapacityMBtoGB(n2);
        int n7 = NICLGeneralUtils.convertDDMCapacityMBtoGB(n3);
        int n8 = n6 - n5;
        int n9 = n7 - n5;
        if (n6 == n7) {
            n4 = 0;
        } else if (n8 >= 0 && n9 < 0) {
            n4 = 1;
        } else if (n8 < 0 && n9 >= 0) {
            n4 = 2;
        } else if (n8 >= 0 && n9 >= 0) {
            n4 = n8 < n9 ? 1 : 2;
        } else if (n8 <= 0 && n9 <= 0) {
            n4 = n8 > n9 ? 1 : 2;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareSizeComaptibility()");
        return n4;
    }

    private int compareSiteIds(NIResourceID nIResourceID, NIResourceID nIResourceID2) {
        return ((NIArraySiteID)nIResourceID).getArraySiteNumber() - ((NIArraySiteID)nIResourceID2).getArraySiteNumber();
    }

    private int compareSiteCompatibility(NIArray nIArray, NIArraySiteID nIArraySiteID, NIArraySite nIArraySite, NIArraySite nIArraySite2, boolean bl) {
        NIOlcLogger.enter(CLASS_NAME, "compareSiteComaptibility()");
        int n = NICLGeneralUtils.convertDDMCapacityMBtoGB(nIArray.getDiskCapacity());
        int n2 = NICLGeneralUtils.convertDDMRPM(nIArray.getDiskRPM());
        int n3 = 1;
        int n4 = NICLGeneralUtils.convertDDMCapacityMBtoGB(nIArraySite.getDiskCapacity());
        int n5 = NICLGeneralUtils.convertDDMCapacityMBtoGB(nIArraySite2.getDiskCapacity());
        int n6 = NICLGeneralUtils.convertDDMRPM(nIArraySite.getDiskRPM());
        int n7 = NICLGeneralUtils.convertDDMRPM(nIArraySite2.getDiskRPM());
        if (bl && n5 == n) {
            if (!this.isWidthCompatible(nIArraySite, nIArray) && this.isWidthCompatible(nIArraySite2, nIArray)) {
                n3 = 2;
            } else if (this.isWidthCompatible(nIArraySite, nIArray) && this.isWidthCompatible(nIArraySite2, nIArray) || !this.isWidthCompatible(nIArraySite, nIArray) && !this.isWidthCompatible(nIArraySite2, nIArray)) {
                int n8 = this.compareRpmCompatibility(nIArray.getDiskRPM(), nIArraySite.getDiskRPM(), nIArraySite2.getDiskRPM());
                int n9 = this.compareSizeCompatibility(nIArray.getDiskCapacity(), nIArraySite.getDiskCapacity(), nIArraySite2.getDiskCapacity());
                boolean bl2 = this.isWidthCompatible(nIArraySite, nIArray);
                boolean bl3 = this.isWidthCompatible(nIArraySite2, nIArray);
                n3 = n9 == 2 && (n6 == n7 || n8 == 2) || n9 == 0 && n8 == 2 || n5 >= n && n7 >= n2 && n6 < n2 || n9 == 0 && n8 == 0 && this.compareSiteIds(nIArraySite2.getID(), nIArraySiteID) == 0 ? 2 : 1;
            } else {
                n3 = 1;
            }
        } else {
            int n10 = this.compareRpmCompatibility(nIArray.getDiskRPM(), nIArraySite.getDiskRPM(), nIArraySite2.getDiskRPM());
            int n11 = this.compareSizeCompatibility(nIArray.getDiskCapacity(), nIArraySite.getDiskCapacity(), nIArraySite2.getDiskCapacity());
            boolean bl4 = this.isWidthCompatible(nIArraySite, nIArray);
            boolean bl5 = this.isWidthCompatible(nIArraySite2, nIArray);
            n3 = n11 == 2 && (n6 == n7 || n10 == 2) || n11 == 0 && n10 == 2 || n5 >= n && n7 >= n2 && n6 < n2 || n11 == 0 && n10 == 0 && (!bl || bl5 || !bl4) && this.compareSiteIds(nIArraySite2.getID(), nIArraySiteID) == 0 ? 2 : 1;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareSiteComaptibility()");
        return n3;
    }

    private int compareRpmCompatibility(int n, int n2, int n3) {
        NIOlcLogger.enter(CLASS_NAME, "compareRpmComaptibility()");
        int n4 = 0;
        int n5 = NICLGeneralUtils.convertDDMRPM(n);
        int n6 = NICLGeneralUtils.convertDDMRPM(n2);
        int n7 = NICLGeneralUtils.convertDDMRPM(n3);
        int n8 = n6 - n5;
        int n9 = n7 - n5;
        if (n6 == n7) {
            n4 = 0;
        } else if (n8 >= 0 && n9 < 0) {
            n4 = 1;
        } else if (n8 < 0 && n9 >= 0) {
            n4 = 2;
        } else if (n8 >= 0 && n9 >= 0) {
            n4 = n8 < n9 ? 1 : 2;
        } else if (n8 <= 0 && n9 <= 0) {
            n4 = n8 > n9 ? 1 : 2;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareRpmComaptibility()");
        return n4;
    }

    private boolean isMatchingSite(NIArraySite nIArraySite, NIArraySite nIArraySite2) {
        NIOlcLogger.enter(CLASS_NAME, "isMatchingSite()");
        int n = NICLGeneralUtils.convertDDMRPM(nIArraySite.getDiskRPM());
        int n2 = NICLGeneralUtils.convertDDMRPM(nIArraySite2.getDiskRPM());
        int n3 = NICLGeneralUtils.convertDDMCapacityMBtoGB(nIArraySite.getDiskCapacity());
        int n4 = NICLGeneralUtils.convertDDMCapacityMBtoGB(nIArraySite2.getDiskCapacity());
        boolean bl = nIArraySite.getDeviceAdapterPair() == nIArraySite2.getDeviceAdapterPair() && n3 == n4 && n == n2 && nIArraySite.getDiskInterfaceType().equals(nIArraySite2.getDiskInterfaceType()) && nIArraySite.getDiskInterfaceRate() == nIArraySite2.getDiskInterfaceRate() && nIArraySite.getDualLoop() == nIArraySite2.getDualLoop();
        NIOlcLogger.exit(CLASS_NAME, "isMatchingSite(): " + bl + "1=" + nIArraySite.getID() + ", 2=" + nIArraySite2.getID());
        return bl;
    }

    private boolean isWidthCompatible(NIArraySite nIArraySite, NIArray nIArray) {
        NIOlcLogger.enter(CLASS_NAME, "isWidthCompatible()");
        int n = this.calcTotalSpares(nIArray);
        int n2 = NICLGeneralUtils.convertDDMCapacityMBtoGB(nIArraySite.getDiskCapacity());
        int n3 = NICLGeneralUtils.convertDDMCapacityMBtoGB(nIArray.getDiskCapacity());
        NIArraySiteConfiguration[] nIArraySiteConfigurationArray = nIArray.getArraySiteConfiguration();
        boolean bl = NICLGeneralUtils.isMM(nIArray) ? true : (nIArraySiteConfigurationArray == null || nIArraySiteConfigurationArray.length < 0 ? false : n2 > n3 || n > 0 && nIArraySite.getRequiredSpares() > 0 || n == 0 && nIArraySite.getRequiredSpares() == 0);
        NIOlcLogger.exit(CLASS_NAME, "isWidthCompatible()");
        return bl;
    }

    private boolean matchingArrayExists(NIArraySite nIArraySite, List list) {
        NIOlcLogger.enter(CLASS_NAME, "matchingArrayExists()");
        boolean bl = false;
        int n = list.size();
        int n2 = 0;
        while (n2 < n && !bl) {
            NIArraySite nIArraySite2 = (NIArraySite)list.get(n2);
            if (this.compareSiteIds(nIArraySite2.getID(), nIArraySite.getID()) != 0 && !this.isSiteReserved(nIArraySite2)) {
                bl = this.isMatchingSite(nIArraySite, nIArraySite2);
            }
            ++n2;
        }
        NIOlcLogger.exit(CLASS_NAME, "matchingArrayExists(): " + bl);
        return bl;
    }
}

