/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.cl.module;

import com.ibm.storage.ess.ni.application.resource.NIUserAccount;
import com.ibm.storage.ess.ni.application.results.NICLResult;
import com.ibm.storage.ess.ni.cl.api.NICLTransfer;
import com.ibm.storage.ess.ni.cl.module.NICLTransferThread;
import com.ibm.storage.ess.ni.results.NICLResultImpl;
import com.ibm.storage.ess.ni.services.NICLService;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class NICLProcessor
implements NICLService {
    private static final String ADMIN = "administrator";
    private static final int UNDEFINED_LOCATION = -1;
    private static final int UNDEFINED_PROGRESS = -1;
    public static final int INDEX_SHIFT_VALUE = 3;
    public static final int STATE_MASK_VALUE = 3;
    private Hashtable activeTransfers = new Hashtable();
    private Hashtable completedTransfers = new Hashtable();
    private Hashtable pausedTransfers = new Hashtable();

    public NICLResult clearAllCompletedTransfers(NIUserAccount nIUserAccount) {
        NICLResultImpl nICLResultImpl;
        if (nIUserAccount == null || nIUserAccount.getName() == null) {
            ArrayList arrayList = null;
            nICLResultImpl = new NICLResultImpl(arrayList, false, -1099694077);
        } else {
            ArrayList arrayList = this.getTransfers(this.completedTransfers, nIUserAccount);
            this.completedTransfers.remove(nIUserAccount.getName());
            nICLResultImpl = new NICLResultImpl(arrayList, true, 0);
        }
        return nICLResultImpl;
    }

    public NICLResult[] clearTransfers(NICLTransfer[] nICLTransferArray) {
        NICLResult[] nICLResultArray;
        if (nICLTransferArray == null) {
            nICLResultArray = new NICLResultImpl[1];
            NICLTransfer nICLTransfer = null;
            nICLResultArray[0] = new NICLResultImpl(nICLTransfer, false, -1099694077);
        } else {
            nICLResultArray = new NICLResult[nICLTransferArray.length];
            int n = 0;
            while (n < nICLTransferArray.length) {
                NICLTransfer nICLTransfer = nICLTransferArray[n];
                NICLTransferThread nICLTransferThread = this.getTransferThread(nICLTransfer);
                if (nICLTransferThread == null) {
                    nICLResultArray[n] = new NICLResultImpl(nICLTransfer, false, -1099689471);
                } else {
                    NICLTransfer nICLTransfer2;
                    int n2;
                    ArrayList arrayList;
                    String string = nICLTransfer.getTargetAuthenticationInfo().getUsername();
                    int n3 = nICLTransferThread.getTransfer().getState();
                    if (n3 == 0) {
                        nICLTransfer = nICLTransferThread.getTransfer();
                        nICLResultArray[n] = new NICLResultImpl(nICLTransfer, false, -1099689470);
                    } else if (n3 == 1) {
                        arrayList = (ArrayList)this.pausedTransfers.get(string);
                        n2 = arrayList.indexOf(nICLTransferThread);
                        nICLTransfer2 = ((NICLTransferThread)arrayList.remove(n2)).getTransfer();
                        nICLTransferThread.shutdown();
                        nICLResultArray[n] = new NICLResultImpl(nICLTransfer2, true, 0);
                    } else if (n3 == 2) {
                        arrayList = (ArrayList)this.completedTransfers.get(string);
                        n2 = arrayList.indexOf(nICLTransferThread);
                        nICLTransfer2 = ((NICLTransferThread)arrayList.remove(n2)).getTransfer();
                        nICLResultArray[n] = new NICLResultImpl(nICLTransfer2, true, 0);
                    }
                }
                ++n;
            }
        }
        return nICLResultArray;
    }

    public NICLResult pauseTransfer(NICLTransfer nICLTransfer) {
        NICLResultImpl nICLResultImpl;
        if (nICLTransfer != null) {
            ArrayList arrayList = (ArrayList)this.activeTransfers.get(nICLTransfer.getTargetAuthenticationInfo().getUsername());
            if (arrayList != null) {
                int n = this.getIndex(nICLTransfer, arrayList);
                if (n >= 0) {
                    NICLTransferThread nICLTransferThread = (NICLTransferThread)arrayList.remove(n);
                    nICLTransferThread.pause();
                    this.addTransferThread(nICLTransferThread, this.pausedTransfers);
                    nICLResultImpl = new NICLResultImpl(nICLTransferThread.getTransfer(), true, 0);
                } else {
                    nICLResultImpl = new NICLResultImpl(nICLTransfer, false, -1099689471);
                }
            } else {
                nICLResultImpl = new NICLResultImpl(nICLTransfer, false, -1099689471);
            }
        } else {
            nICLResultImpl = new NICLResultImpl(nICLTransfer, false, -1099694077);
        }
        return nICLResultImpl;
    }

    public NICLResult resumeTransfer(NICLTransfer nICLTransfer) {
        NICLResultImpl nICLResultImpl;
        if (nICLTransfer != null) {
            ArrayList arrayList = (ArrayList)this.pausedTransfers.get(nICLTransfer.getTargetAuthenticationInfo().getUsername());
            if (arrayList != null) {
                int n = this.getIndex(nICLTransfer, arrayList);
                if (n != -1) {
                    NICLTransferThread nICLTransferThread = (NICLTransferThread)arrayList.remove(n);
                    nICLTransferThread.updateTarget(nICLTransfer);
                    Thread thread = new Thread(nICLTransferThread);
                    thread.setName(nICLTransferThread.getTransfer().getTransferID());
                    thread.start();
                    this.addTransferThread(nICLTransferThread, this.activeTransfers);
                    nICLResultImpl = new NICLResultImpl(nICLTransferThread.getTransfer(), true, 0);
                } else {
                    nICLResultImpl = new NICLResultImpl(nICLTransfer, false, -1099689471);
                }
            } else {
                nICLResultImpl = new NICLResultImpl(nICLTransfer, false, -1099689471);
            }
        } else {
            nICLResultImpl = new NICLResultImpl(nICLTransfer, false, -1099694077);
        }
        return nICLResultImpl;
    }

    public NICLResult startTransfer(NICLTransfer nICLTransfer) {
        NICLResultImpl nICLResultImpl;
        if (nICLTransfer != null) {
            NICLTransferThread nICLTransferThread = new NICLTransferThread(nICLTransfer, this);
            Thread thread = new Thread(nICLTransferThread);
            thread.setName(nICLTransferThread.getTransfer().getTransferID());
            thread.start();
            this.addTransferThread(nICLTransferThread, this.activeTransfers);
            nICLResultImpl = new NICLResultImpl(nICLTransferThread.getTransfer(), true, 0);
        } else {
            nICLResultImpl = new NICLResultImpl(nICLTransfer, false, -1099694077);
        }
        return nICLResultImpl;
    }

    public NICLTransfer[] getActiveTransfers(NIUserAccount nIUserAccount) {
        ArrayList arrayList = this.getTransfers(this.activeTransfers, nIUserAccount);
        return arrayList.toArray(new NICLTransfer[0]);
    }

    public NICLTransfer[] getAllTransfers(NIUserAccount nIUserAccount) {
        ArrayList arrayList = this.getTransfers(this.activeTransfers, nIUserAccount);
        ArrayList arrayList2 = this.getTransfers(this.completedTransfers, nIUserAccount);
        ArrayList arrayList3 = this.getTransfers(this.pausedTransfers, nIUserAccount);
        ArrayList arrayList4 = new ArrayList(arrayList.size() + arrayList2.size() + arrayList3.size());
        arrayList4.addAll(arrayList);
        arrayList4.addAll(arrayList2);
        arrayList4.addAll(arrayList3);
        return arrayList4.toArray(new NICLTransfer[0]);
    }

    public NICLTransfer[] getCompletedTransfers(NIUserAccount nIUserAccount) {
        ArrayList arrayList = this.getTransfers(this.completedTransfers, nIUserAccount);
        return arrayList.toArray(new NICLTransfer[0]);
    }

    public NICLTransfer[] getPausedTransfers(NIUserAccount nIUserAccount) {
        ArrayList arrayList = this.getTransfers(this.pausedTransfers, nIUserAccount);
        return arrayList.toArray(new NICLTransfer[0]);
    }

    public int getProgress(NICLTransfer nICLTransfer) {
        NICLTransferThread nICLTransferThread = this.getTransferThread(nICLTransfer);
        int n = nICLTransferThread == null ? -1 : nICLTransferThread.getProgress();
        return n;
    }

    protected void markCompleted(NICLTransferThread nICLTransferThread) {
        ArrayList arrayList = (ArrayList)this.activeTransfers.get(nICLTransferThread.getTransfer().getTargetAuthenticationInfo().getUsername());
        int n = arrayList.indexOf(nICLTransferThread);
        arrayList.remove(n);
        this.addTransferThread(nICLTransferThread, this.completedTransfers);
    }

    private int getTransferLoc(NICLTransfer nICLTransfer) {
        int n;
        if (nICLTransfer == null) {
            n = -1;
        } else {
            int n2;
            n = -1;
            String string = nICLTransfer.getTargetAuthenticationInfo().getUsername();
            ArrayList arrayList = (ArrayList)this.activeTransfers.get(string);
            if (arrayList != null) {
                n2 = this.getIndex(nICLTransfer, arrayList);
                n = this.getLocation(0, n2);
            }
            if (n == -1 && (arrayList = (ArrayList)this.pausedTransfers.get(string)) != null) {
                n2 = this.getIndex(nICLTransfer, arrayList);
                n = this.getLocation(1, n2);
            }
            if (n == -1 && (arrayList = (ArrayList)this.completedTransfers.get(string)) != null) {
                n2 = this.getIndex(nICLTransfer, arrayList);
                n = this.getLocation(2, n2);
            }
        }
        return n;
    }

    private ArrayList getTransfers(Hashtable hashtable, NIUserAccount nIUserAccount) {
        ArrayList arrayList;
        if (this.isAdmin(nIUserAccount)) {
            arrayList = new ArrayList();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                arrayList.addAll((ArrayList)enumeration.nextElement());
            }
        } else {
            arrayList = (ArrayList)hashtable.get(nIUserAccount.getName());
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        int n = arrayList.size();
        ArrayList<NICLTransfer> arrayList2 = new ArrayList<NICLTransfer>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList2.add(((NICLTransferThread)arrayList.get(n2)).getTransfer());
            ++n2;
        }
        return arrayList2;
    }

    private NICLTransferThread getTransferThread(NICLTransfer nICLTransfer) {
        NICLTransferThread nICLTransferThread;
        if (nICLTransfer == null) {
            nICLTransferThread = null;
        } else {
            int n;
            nICLTransferThread = null;
            String string = nICLTransfer.getTargetAuthenticationInfo().getUsername();
            ArrayList arrayList = (ArrayList)this.activeTransfers.get(string);
            if (arrayList != null && (n = this.getIndex(nICLTransfer, arrayList)) >= 0) {
                nICLTransferThread = (NICLTransferThread)arrayList.get(n);
            }
            if (nICLTransferThread == null && (arrayList = (ArrayList)this.pausedTransfers.get(string)) != null && (n = this.getIndex(nICLTransfer, arrayList)) >= 0) {
                nICLTransferThread = (NICLTransferThread)arrayList.get(n);
            }
            if (nICLTransferThread == null && (arrayList = (ArrayList)this.completedTransfers.get(string)) != null && (n = this.getIndex(nICLTransfer, arrayList)) >= 0) {
                nICLTransferThread = (NICLTransferThread)arrayList.get(n);
            }
        }
        return nICLTransferThread;
    }

    private int getLocation(int n, int n2) {
        return (n2 << 3) + n;
    }

    private int getState(int n) {
        return n & 3;
    }

    private int getIndex(NICLTransfer nICLTransfer, ArrayList arrayList) {
        boolean bl = false;
        int n = -1;
        if (nICLTransfer != null) {
            int n2 = arrayList.size();
            String string = nICLTransfer.getTransferID();
            int n3 = 0;
            while (n3 < n2 && !bl) {
                if (string.equalsIgnoreCase(((NICLTransferThread)arrayList.get(n3)).getTransfer().getTransferID())) {
                    bl = true;
                    n = n3;
                }
                ++n3;
            }
        }
        return n;
    }

    private void addTransferThread(NICLTransferThread nICLTransferThread, Hashtable hashtable) {
        String string = nICLTransferThread.getTransfer().getTargetAuthenticationInfo().getUsername();
        ArrayList<NICLTransferThread> arrayList = (ArrayList<NICLTransferThread>)hashtable.get(string);
        if (arrayList != null) {
            arrayList.add(nICLTransferThread);
        } else {
            arrayList = new ArrayList<NICLTransferThread>();
            arrayList.add(nICLTransferThread);
            hashtable.put(string, arrayList);
        }
    }

    private boolean isAdmin(NIUserAccount nIUserAccount) {
        String[] stringArray = nIUserAccount.getUserGroups();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(ADMIN)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

