/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.cl.module;

import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.cl.module.util.NICLGeneralUtils;
import com.ibm.storage.ess.ni.exception.NICLException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import com.ibm.storage.ess.ni.services.NIHostConfigurationService;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;
import java.util.ArrayList;
import java.util.List;

public class NICLReader {
    private static String CLASS_NAME = "NICLReader";
    private NIServices niServices;
    private NIESSID niEssId;
    private List lstArraySites;
    private List lstArrays;
    private List lstExtentPools;
    private List lstIoPorts;
    private List lstLsss;
    private List lstRanks;
    private List lstScsiHostPorts;
    private List lstVolumes;
    private List lstVolumeGroups;

    public NICLReader(NIServices nIServices, NIESSID nIESSID) throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "NICLReader()");
        if (nIServices == null) {
            throw new NICLException(-1099694077L, 2);
        }
        this.niServices = nIServices;
        this.niEssId = nIESSID;
        NIOlcLogger.exit(CLASS_NAME, "NICLReader()");
    }

    public List getArraySites() throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "getArraySites()");
        if (this.lstArraySites == null) {
            try {
                NILogicalConfigurationService nILogicalConfigurationService = this.niServices.getLogicalConfigurationService();
                NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getArraySites(this.niEssId);
                this.lstArraySites = this.getResourceList(nIConfigQueryResult);
            }
            catch (Exception exception) {
                this.handleException(exception);
                throw new NICLException(-1099694075L, 2, exception);
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "getArraySites()");
        return this.lstArraySites;
    }

    public List getArrays() throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "getArrays()");
        if (this.lstArrays == null) {
            try {
                NILogicalConfigurationService nILogicalConfigurationService = this.niServices.getLogicalConfigurationService();
                NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getArrays(this.niEssId);
                this.lstArrays = this.getResourceList(nIConfigQueryResult);
            }
            catch (Exception exception) {
                this.handleException(exception);
                throw new NICLException(-1099694075L, 2, exception);
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "getArrays()");
        return this.lstArrays;
    }

    public List getExtentPools() throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "getExtentPools()");
        if (this.lstExtentPools == null) {
            try {
                NILogicalConfigurationService nILogicalConfigurationService = this.niServices.getLogicalConfigurationService();
                NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getExtentPools(this.niEssId);
                this.lstExtentPools = this.getResourceList(nIConfigQueryResult);
            }
            catch (Exception exception) {
                this.handleException(exception);
                throw new NICLException(-1099694075L, 2, exception);
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "getExtentPools()");
        return this.lstExtentPools;
    }

    public List getIOPorts() throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "getIOPorts()");
        if (this.lstIoPorts == null) {
            try {
                NIPhysicalConfigurationService nIPhysicalConfigurationService = this.niServices.getPhysicalConfigurationService();
                NIConfigQueryResult nIConfigQueryResult = nIPhysicalConfigurationService.getFibreChannelPorts(this.niEssId);
                this.lstIoPorts = this.getResourceList(nIConfigQueryResult);
                nIConfigQueryResult = nIPhysicalConfigurationService.getESCONPorts(this.niEssId);
                this.lstIoPorts.addAll(this.getResourceList(nIConfigQueryResult));
            }
            catch (Exception exception) {
                this.handleException(exception);
                throw new NICLException(-1099694075L, 2, exception);
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "getIOPorts()");
        return this.lstIoPorts;
    }

    public List getLogicalSubsystems() throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "getLogicalSubsystems()");
        if (this.lstLsss == null) {
            try {
                NILogicalConfigurationService nILogicalConfigurationService = this.niServices.getLogicalConfigurationService();
                NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getLogicalSubsystems(this.niEssId);
                this.lstLsss = this.getResourceList(nIConfigQueryResult);
            }
            catch (Exception exception) {
                this.handleException(exception);
                throw new NICLException(-1099694075L, 2, exception);
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "getLogicalSubsystems()");
        return this.lstLsss;
    }

    public List getRanks() throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "getRanks()");
        if (this.lstRanks == null) {
            try {
                NILogicalConfigurationService nILogicalConfigurationService = this.niServices.getLogicalConfigurationService();
                NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getRanks(this.niEssId);
                this.lstRanks = this.getResourceList(nIConfigQueryResult);
            }
            catch (Exception exception) {
                this.handleException(exception);
                throw new NICLException(-1099694075L, 2, exception);
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "getRanks()");
        return this.lstRanks;
    }

    public List getVolumes() throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "getVolumes()");
        NILogicalConfigurationService nILogicalConfigurationService = this.niServices.getLogicalConfigurationService();
        if (this.lstVolumes == null) {
            this.getLogicalSubsystems();
            try {
                int n = this.lstLsss.size();
                ArrayList arrayList = new ArrayList();
                int n2 = 0;
                while (n2 < n) {
                    NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getVolumes((NILSSID)((NILSS)this.lstLsss.get(n2)).getID());
                    List list = this.getResourceList(nIConfigQueryResult);
                    int n3 = list.size();
                    int n4 = 0;
                    while (n4 < n3) {
                        arrayList.add(list.get(n4));
                        ++n4;
                    }
                    ++n2;
                }
                this.lstVolumes = arrayList;
            }
            catch (Exception exception) {
                this.handleException(exception);
                throw new NICLException(-1099694075L, 2, exception);
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "getVolumes()");
        return this.lstVolumes;
    }

    public List getVolumes(NILSSID nILSSID) throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "getVolumes(NILSSID)");
        ArrayList<NIVolume> arrayList = new ArrayList<NIVolume>();
        int n = NICLGeneralUtils.getIdIntValue(nILSSID);
        if (this.lstVolumes == null) {
            this.getVolumes();
        }
        int n2 = this.lstVolumes.size();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2 && !bl) {
            NIVolume nIVolume = (NIVolume)this.lstVolumes.get(n3);
            if (n == NICLGeneralUtils.getIdIntValue(((NIVolumeID)nIVolume.getID()).getLSS())) {
                arrayList.add(nIVolume);
            } else if (arrayList.size() > 0) {
                bl = true;
            }
            ++n3;
        }
        NIOlcLogger.exit(CLASS_NAME, "getVolumes(NILSSID)");
        return arrayList;
    }

    public List getVolumeGroups() throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "getVolumeGroups()");
        if (this.lstVolumeGroups == null) {
            try {
                NILogicalConfigurationService nILogicalConfigurationService = this.niServices.getLogicalConfigurationService();
                NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getVolumeGroups(this.niEssId);
                this.lstVolumeGroups = this.getResourceList(nIConfigQueryResult);
            }
            catch (Exception exception) {
                this.handleException(exception);
                throw new NICLException(-1099694075L, 2, exception);
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "getVolumeGroups()");
        return this.lstVolumeGroups;
    }

    public List getSCSIHostPorts() throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "getSCSIHostPorts()");
        if (this.lstScsiHostPorts == null) {
            try {
                NIHostConfigurationService nIHostConfigurationService = this.niServices.getHostConfigurationService();
                NIConfigQueryResult nIConfigQueryResult = nIHostConfigurationService.getSCSIHostPorts(this.niEssId);
                this.lstScsiHostPorts = this.getResourceList(nIConfigQueryResult);
            }
            catch (Exception exception) {
                this.handleException(exception);
                throw new NICLException(-1099694075L, 2, exception);
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "getSCSIHostPorts()");
        return this.lstScsiHostPorts;
    }

    public List getSCSIHostPorts(NIVolumeGroupID nIVolumeGroupID) throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "getSCSIHostPorts(NIVolumeGroupID)");
        ArrayList arrayList = new ArrayList();
        if (this.lstScsiHostPorts == null) {
            this.getSCSIHostPorts();
        }
        int n = this.lstScsiHostPorts.size();
        int n2 = 0;
        while (n2 < n) {
            NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)this.lstScsiHostPorts.get(n2);
            if (nISCSIHostPort.getVolumeGroup() != null && nISCSIHostPort.getVolumeGroup().equals(nIVolumeGroupID)) {
                arrayList.add(this.lstScsiHostPorts.get(n2));
            }
            ++n2;
        }
        NIOlcLogger.exit(CLASS_NAME, "getSCSIHostPorts(NIVolumeGroupID)");
        return arrayList;
    }

    public List queryVolumes(NIRankID nIRankID) throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "queryVolumes()");
        List list = null;
        List list2 = null;
        try {
            NILogicalConfigurationService nILogicalConfigurationService = this.niServices.getLogicalConfigurationService();
            NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.queryVolumes(nIRankID);
            list2 = this.getResourceList(nIConfigQueryResult);
            nIConfigQueryResult = nILogicalConfigurationService.getVolumes(list2.toArray(new NIVolumeID[0]));
            list = this.getResourceList(nIConfigQueryResult);
        }
        catch (Exception exception) {
            this.handleException(exception);
            throw new NICLException(-1099694075L, 2, exception);
        }
        return list;
    }

    private List getResourceList(NIConfigQueryResult nIConfigQueryResult) throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, "getResourceList()");
        ArrayList arrayList = null;
        if (!nIConfigQueryResult.isSuccessful()) {
            if (nIConfigQueryResult.getCode() != -1101516788) {
                NIOlcLogger.info("ERROR: Unsuccessful retrieving resources - " + nIConfigQueryResult.getCode());
                throw new NICLException((long)nIConfigQueryResult.getCode(), 2);
            }
            arrayList = new ArrayList();
        } else {
            arrayList = nIConfigQueryResult.getResourceList();
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "getResourceList()");
        return arrayList;
    }

    private void handleException(Exception exception) throws NICLException {
        NIOlcLogger.severe("*** RECEIVED EXCEPTION DURING TRANSFER ***", exception);
        throw new NICLException(16L, -1, exception);
    }
}

