/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.cl.module.util;

import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIESCONPort;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NIFibreChannelPort;
import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIPortMask;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroup;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupMap;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupVolumeList;
import com.ibm.storage.ess.ni.cl.module.util.NICLGeneralUtils;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Protected;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Unprotected;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupType;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Map256;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMap256;
import com.ibm.storage.ess.ni.resource.NIRankImpl;
import com.ibm.storage.ess.ni.resource.NIResourceImpl;
import java.util.Comparator;
import java.util.List;

public class NICLResourceComparator
implements Comparator {
    private static final String CLASS_NAME = "NICLResourceComparator";
    private static int MAX_VOLS_PER_SFI = 65536;

    public static boolean checkCorrespondence(NIResource nIResource, NIResource nIResource2) {
        NIOlcLogger.enter(CLASS_NAME, "checkCorrespondence()");
        boolean bl = nIResource == null || nIResource2 == null ? false : (!nIResource.getClass().isInstance(nIResource2) && !nIResource2.getClass().isInstance(nIResource) ? false : (nIResource instanceof NIESS ? NICLResourceComparator.checkCorrespondenceEsss((NIESS)nIResource, (NIESS)nIResource2) : (nIResource instanceof NIIOPort ? NICLResourceComparator.checkCorrespondenceIoPorts((NIIOPort)nIResource, (NIIOPort)nIResource2) : (nIResource instanceof NIArray ? NICLResourceComparator.checkCorrespondenceArrays((NIArray)nIResource, (NIArray)nIResource2) : (nIResource instanceof NIRank ? NICLResourceComparator.checkCorrespondenceRanks((NIRank)nIResource, (NIRank)nIResource2) : (nIResource instanceof NIExtentPool ? NICLResourceComparator.checkCorrespondenceExtentPools((NIExtentPool)nIResource, (NIExtentPool)nIResource2) : (nIResource instanceof NILSS ? NICLResourceComparator.checkCorrespondenceLsss((NILSS)nIResource, (NILSS)nIResource2) : (nIResource instanceof NIVolume ? NICLResourceComparator.checkCorrespondenceVolumes((NIVolume)nIResource, (NIVolume)nIResource2) : (nIResource instanceof NIVolumeGroup ? NICLResourceComparator.checkCorrespondenceVolumeGroups((NIVolumeGroup)nIResource, (NIVolumeGroup)nIResource2) : (nIResource instanceof NISCSIHostPort ? NICLResourceComparator.checkCorrespondenceScsiHostPorts((NISCSIHostPort)nIResource, (NISCSIHostPort)nIResource2) : false))))))))));
        NIOlcLogger.exit(CLASS_NAME, "checkCorrespondence()");
        return bl;
    }

    public int compare(Object object, Object object2) {
        int n;
        if (object instanceof NIResource && object2 instanceof NIResource) {
            int n2 = NICLGeneralUtils.getIdIntValue((NIResource)object);
            int n3 = NICLGeneralUtils.getIdIntValue((NIResource)object2);
            n = n2 - n3;
        } else {
            n = 0;
        }
        return n;
    }

    public static boolean compareModifiables(NIResource nIResource, NIResource nIResource2) {
        NIOlcLogger.enter(CLASS_NAME, "compareModifiables()");
        boolean bl = nIResource == null || nIResource2 == null ? false : (!nIResource.getClass().isInstance(nIResource2) && !nIResource2.getClass().isInstance(nIResource) ? false : (nIResource instanceof NIESS ? NICLResourceComparator.compareModifiablesEsss((NIESS)nIResource, (NIESS)nIResource2) : (nIResource instanceof NIIOPort ? NICLResourceComparator.compareModifiablesIoPorts((NIIOPort)nIResource, (NIIOPort)nIResource2) : (nIResource instanceof NIArray ? NICLResourceComparator.compareModifiablesArrays((NIArray)nIResource, (NIArray)nIResource2) : (nIResource instanceof NIRank ? NICLResourceComparator.compareModifiablesRanks((NIRank)nIResource, (NIRank)nIResource2) : (nIResource instanceof NIExtentPool ? NICLResourceComparator.compareModifiablesExtentPools((NIExtentPool)nIResource, (NIExtentPool)nIResource2) : (nIResource instanceof NILSS ? NICLResourceComparator.compareModifiablesLsss((NILSS)nIResource, (NILSS)nIResource2) : (nIResource instanceof NIVolume ? NICLResourceComparator.compareModifiablesVolumes((NIVolume)nIResource, (NIVolume)nIResource2) : (nIResource instanceof NIVolumeGroup ? NICLResourceComparator.compareModifiablesVolumeGroups((NIVolumeGroup)nIResource, (NIVolumeGroup)nIResource2) : (nIResource instanceof NISCSIHostPort ? NICLResourceComparator.compareModifiablesScsiHostPorts((NISCSIHostPort)nIResource, (NISCSIHostPort)nIResource2) : false))))))))));
        if (!bl) {
            NIOlcLogger.info("The following resources are inequal...");
            NIOlcLogger.info("SOURCE: " + nIResource);
            NIOlcLogger.info("TARGET: " + nIResource2);
        }
        NIOlcLogger.exit(CLASS_NAME, "compareModifiables()");
        return bl;
    }

    public static boolean compareNonmodifiables(NIResource nIResource, NIResource nIResource2) {
        NIOlcLogger.enter(CLASS_NAME, "compareNonmodifiables()");
        boolean bl = nIResource == null || nIResource2 == null ? false : (!nIResource.getClass().isInstance(nIResource2) && !nIResource2.getClass().isInstance(nIResource) ? false : (nIResource instanceof NIESS ? NICLResourceComparator.compareNonmodifiablesEsss((NIESS)nIResource, (NIESS)nIResource2) : (nIResource instanceof NIIOPort ? NICLResourceComparator.compareNonmodifiablesIoPorts((NIIOPort)nIResource, (NIIOPort)nIResource2) : (nIResource instanceof NIArray ? NICLResourceComparator.compareNonmodifiablesArrays((NIArray)nIResource, (NIArray)nIResource2) : (nIResource instanceof NIRank ? NICLResourceComparator.compareNonmodifiablesRanks((NIRank)nIResource, (NIRank)nIResource2) : (nIResource instanceof NIExtentPool ? NICLResourceComparator.compareNonmodifiablesExtentPools((NIExtentPool)nIResource, (NIExtentPool)nIResource2) : (nIResource instanceof NILSS ? NICLResourceComparator.compareNonmodifiablesLsss((NILSS)nIResource, (NILSS)nIResource2) : (nIResource instanceof NIVolume ? NICLResourceComparator.compareNonmodifiablesVolumes((NIVolume)nIResource, (NIVolume)nIResource2) : (nIResource instanceof NIVolumeGroup ? NICLResourceComparator.compareNonmodifiablesVolumeGroups((NIVolumeGroup)nIResource, (NIVolumeGroup)nIResource2) : (nIResource instanceof NISCSIHostPort ? NICLResourceComparator.compareNonmodifiablesScsiHostPorts((NISCSIHostPort)nIResource, (NISCSIHostPort)nIResource2) : false))))))))));
        NIOlcLogger.exit(CLASS_NAME, "compareNonmodifiables()");
        return bl;
    }

    public static boolean merge(NIResource nIResource, NIResource nIResource2) {
        NIOlcLogger.enter(CLASS_NAME, "merge()");
        boolean bl = false;
        bl = nIResource == null || nIResource2 == null ? false : (!nIResource.getClass().isInstance(nIResource2) && !nIResource2.getClass().isInstance(nIResource) ? false : (nIResource instanceof NIESS ? NICLResourceComparator.mergeEsss((NIESS)nIResource, (NIESS)nIResource2) : (nIResource instanceof NIIOPort ? NICLResourceComparator.mergeIoPorts((NIIOPort)nIResource, (NIIOPort)nIResource2) : (nIResource instanceof NIArray ? NICLResourceComparator.mergeArrays((NIArray)nIResource, (NIArray)nIResource2) : (nIResource instanceof NIRank ? NICLResourceComparator.mergeRanks((NIRank)nIResource, (NIRank)nIResource2) : (nIResource instanceof NIExtentPool ? NICLResourceComparator.mergeExtentPools((NIExtentPool)nIResource, (NIExtentPool)nIResource2) : (nIResource instanceof NILSS ? NICLResourceComparator.mergeLsss((NILSS)nIResource, (NILSS)nIResource2) : (nIResource instanceof NIVolume ? NICLResourceComparator.mergeVolumes((NIVolume)nIResource, (NIVolume)nIResource2) : (nIResource instanceof NIVolumeGroup ? NICLResourceComparator.mergeVolumeGroups((NIVolumeGroup)nIResource, (NIVolumeGroup)nIResource2) : (nIResource instanceof NISCSIHostPort ? NICLResourceComparator.mergeScsiHostPorts((NISCSIHostPort)nIResource, (NISCSIHostPort)nIResource2) : false))))))))));
        NIOlcLogger.exit(CLASS_NAME, "merge()");
        return bl;
    }

    private static boolean checkCorrespondenceEsss(NIESS nIESS, NIESS nIESS2) {
        NIOlcLogger.enter(CLASS_NAME, "checkCorrespondenceEsss()");
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        NIESSID nIESSID2 = (NIESSID)nIESS2.getID();
        int n = NICLGeneralUtils.getIdIntValue(nIESSID);
        int n2 = NICLGeneralUtils.getIdIntValue(nIESSID2);
        boolean bl = nIESSID == null || nIESSID2 == null ? false : n == n2;
        NIOlcLogger.exit(CLASS_NAME, "checkCorrespondenceEsss()");
        return bl;
    }

    private static boolean checkCorrespondenceArrays(NIArray nIArray, NIArray nIArray2) {
        NIOlcLogger.enter(CLASS_NAME, "checkCorrespondenceArrays()");
        NIArrayID nIArrayID = (NIArrayID)nIArray.getID();
        NIArrayID nIArrayID2 = (NIArrayID)nIArray2.getID();
        int n = NICLGeneralUtils.getIdIntValue(nIArrayID);
        int n2 = NICLGeneralUtils.getIdIntValue(nIArrayID2);
        boolean bl = nIArrayID == null || nIArrayID2 == null ? false : n == n2;
        NIOlcLogger.exit(CLASS_NAME, "checkCorrespondenceArrays()");
        return bl;
    }

    private static boolean checkCorrespondenceIoPorts(NIIOPort nIIOPort, NIIOPort nIIOPort2) {
        NIOlcLogger.enter(CLASS_NAME, "checkCorrespondenceIoPorts()");
        NIIOPortID nIIOPortID = (NIIOPortID)nIIOPort.getID();
        NIIOPortID nIIOPortID2 = (NIIOPortID)nIIOPort2.getID();
        int n = NICLGeneralUtils.getIdIntValue(nIIOPortID);
        int n2 = NICLGeneralUtils.getIdIntValue(nIIOPortID2);
        boolean bl = nIIOPortID == null || nIIOPortID2 == null ? false : n == n2;
        NIOlcLogger.exit(CLASS_NAME, "checkCorrespondenceIoPorts()");
        return bl;
    }

    private static boolean checkCorrespondenceRanks(NIRank nIRank, NIRank nIRank2) {
        NIOlcLogger.enter(CLASS_NAME, "checkCorrespondenceRanks()");
        NIArrayID[] nIArrayIDArray = nIRank.getArrayIDs();
        NIArrayID[] nIArrayIDArray2 = nIRank2.getArrayIDs();
        boolean bl = false;
        int n = 0;
        while (n < nIArrayIDArray.length && !bl) {
            int n2 = NICLGeneralUtils.getIdIntValue(nIArrayIDArray[n]);
            int n3 = 0;
            while (n3 < nIArrayIDArray2.length && !bl) {
                if (n2 == NICLGeneralUtils.getIdIntValue(nIArrayIDArray2[n3])) {
                    bl = true;
                }
                ++n3;
            }
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, "checkCorrespondenceRanks()");
        return bl;
    }

    private static boolean checkCorrespondenceExtentPools(NIExtentPool nIExtentPool, NIExtentPool nIExtentPool2) {
        NIOlcLogger.enter(CLASS_NAME, "checkCorrespondenceExtentPools()");
        NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        NIExtentPoolID nIExtentPoolID2 = (NIExtentPoolID)nIExtentPool2.getID();
        int n = NICLGeneralUtils.getIdIntValue(nIExtentPoolID);
        int n2 = NICLGeneralUtils.getIdIntValue(nIExtentPoolID2);
        boolean bl = nIExtentPoolID == null || nIExtentPoolID2 == null ? false : n == n2;
        NIOlcLogger.exit(CLASS_NAME, "checkCorrespondenceExtentPools()");
        return bl;
    }

    private static boolean checkCorrespondenceLsss(NILSS nILSS, NILSS nILSS2) {
        NIOlcLogger.enter(CLASS_NAME, "checkCorrespondenceLsss()");
        NILSSID nILSSID = (NILSSID)nILSS.getID();
        NILSSID nILSSID2 = (NILSSID)nILSS2.getID();
        int n = NICLGeneralUtils.getIdIntValue(nILSSID);
        int n2 = NICLGeneralUtils.getIdIntValue(nILSSID2);
        boolean bl = nILSSID == null || nILSSID2 == null ? false : n == n2;
        NIOlcLogger.exit(CLASS_NAME, "checkCorrespondenceLsss()");
        return bl;
    }

    private static boolean checkCorrespondenceVolumes(NIVolume nIVolume, NIVolume nIVolume2) {
        NIOlcLogger.enter(CLASS_NAME, "checkCorrespondenceVolumes()");
        NIVolumeID nIVolumeID = (NIVolumeID)nIVolume.getID();
        NIVolumeID nIVolumeID2 = (NIVolumeID)nIVolume2.getID();
        int n = NICLGeneralUtils.getIdIntValue(nIVolumeID);
        int n2 = NICLGeneralUtils.getIdIntValue(nIVolumeID2);
        boolean bl = nIVolumeID == null || nIVolumeID2 == null ? false : n == n2;
        NIOlcLogger.exit(CLASS_NAME, "checkCorrespondenceVolumes()");
        return bl;
    }

    private static boolean checkCorrespondenceVolumeGroups(NIVolumeGroup nIVolumeGroup, NIVolumeGroup nIVolumeGroup2) {
        NIOlcLogger.enter(CLASS_NAME, "checkCorrespondenceVolumeGroups()");
        NIVolumeGroupID nIVolumeGroupID = (NIVolumeGroupID)nIVolumeGroup.getID();
        NIVolumeGroupID nIVolumeGroupID2 = (NIVolumeGroupID)nIVolumeGroup2.getID();
        int n = NICLGeneralUtils.getIdIntValue(nIVolumeGroupID);
        int n2 = NICLGeneralUtils.getIdIntValue(nIVolumeGroupID2);
        boolean bl = nIVolumeGroupID == null || nIVolumeGroupID2 == null ? false : n == n2;
        NIOlcLogger.exit(CLASS_NAME, "checkCorrespondenceVolumeGroups()");
        return bl;
    }

    private static boolean checkCorrespondenceScsiHostPorts(NISCSIHostPort nISCSIHostPort, NISCSIHostPort nISCSIHostPort2) {
        NIOlcLogger.enter(CLASS_NAME, "checkCorrespondenceScsiHostPorts()");
        NISCSIHostPortID nISCSIHostPortID = (NISCSIHostPortID)nISCSIHostPort.getID();
        NISCSIHostPortID nISCSIHostPortID2 = (NISCSIHostPortID)nISCSIHostPort2.getID();
        int n = NICLGeneralUtils.getIdIntValue(nISCSIHostPortID);
        int n2 = NICLGeneralUtils.getIdIntValue(nISCSIHostPortID2);
        boolean bl = nISCSIHostPortID == null || nISCSIHostPortID2 == null ? false : n == n2;
        NIOlcLogger.exit(CLASS_NAME, "checkCorrespondenceScsiHostPorts()");
        return bl;
    }

    private static boolean compareArrays(NIArrayID[] nIArrayIDArray, NIArrayID[] nIArrayIDArray2) {
        boolean bl;
        NIOlcLogger.enter(CLASS_NAME, "compareArrays()");
        if (nIArrayIDArray.length != nIArrayIDArray2.length) {
            bl = false;
        } else {
            bl = true;
            int n = 0;
            while (n < nIArrayIDArray.length && bl) {
                bl = false;
                int n2 = nIArrayIDArray[n].getArrayNumber();
                int n3 = 0;
                while (n3 < nIArrayIDArray2.length) {
                    if (n2 == nIArrayIDArray2[n3].getArrayNumber()) {
                        bl = true;
                    }
                    ++n3;
                }
                ++n;
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "compareArrays()");
        return bl;
    }

    private static boolean compareModifiablesEsss(NIESS nIESS, NIESS nIESS2) {
        NIOlcLogger.enter(CLASS_NAME, "compareModifiablesEsss()");
        boolean bl = true;
        if (!NICLGeneralUtils.isEqual(nIESS.getUserDescription(), nIESS2.getUserDescription()) || !NICLGeneralUtils.isEqual(nIESS.getUserName(), nIESS2.getUserName())) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareModifiablesEsss()");
        return bl;
    }

    private static boolean compareModifiablesIoPorts(NIIOPort nIIOPort, NIIOPort nIIOPort2) {
        NIOlcLogger.enter(CLASS_NAME, "compareModifiablesIoPorts()");
        boolean bl = true;
        if (nIIOPort instanceof NIESCONPort && nIIOPort2 instanceof NIESCONPort) {
            NIESCONPort nIESCONPort = (NIESCONPort)nIIOPort;
            NIESCONPort nIESCONPort2 = (NIESCONPort)nIIOPort2;
            if (nIESCONPort.getESCONPortGroup() != nIESCONPort2.getESCONPortGroup()) {
                bl = false;
            }
        } else if (nIIOPort instanceof NIFibreChannelPort && nIIOPort2 instanceof NIFibreChannelPort) {
            NIFibreChannelPort nIFibreChannelPort = (NIFibreChannelPort)nIIOPort;
            NIFibreChannelPort nIFibreChannelPort2 = (NIFibreChannelPort)nIIOPort2;
            if (nIFibreChannelPort.getAnonymousFICONPortGroup() != nIFibreChannelPort2.getAnonymousFICONPortGroup() || !NICLGeneralUtils.isEqual(nIFibreChannelPort.getTopology(), nIFibreChannelPort2.getTopology()) || nIFibreChannelPort.getWWPN() != nIFibreChannelPort2.getWWPN()) {
                bl = false;
            }
        } else if (nIIOPort instanceof NIFibreChannelPort && !(nIIOPort2 instanceof NIFibreChannelPort) || nIIOPort instanceof NIESCONPort && !(nIIOPort2 instanceof NIESCONPort)) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareModifiablesIoPorts()");
        return bl;
    }

    private static boolean compareModifiablesArrays(NIArray nIArray, NIArray nIArray2) {
        NIOlcLogger.enter(CLASS_NAME, "compareModifiablesArrays()");
        boolean bl = true;
        NIOlcLogger.exit(CLASS_NAME, "compareModifiablesArrays()");
        return bl;
    }

    private static boolean compareModifiablesRanks(NIRank nIRank, NIRank nIRank2) {
        NIOlcLogger.enter(CLASS_NAME, "compareModifiablesRanks()");
        boolean bl = true;
        if (NICLGeneralUtils.getIdIntValue(nIRank.getExtentPoolID()) != NICLGeneralUtils.getIdIntValue(nIRank2.getExtentPoolID())) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareModifiablesRanks()");
        return bl;
    }

    private static boolean compareModifiablesExtentPools(NIExtentPool nIExtentPool, NIExtentPool nIExtentPool2) {
        NIOlcLogger.enter(CLASS_NAME, "compareModifiablesExtentPools()");
        boolean bl = true;
        if (nIExtentPool.getExtentLimit() != nIExtentPool2.getExtentLimit() || nIExtentPool.isExtentLimitEnabled() != nIExtentPool2.isExtentLimitEnabled() || nIExtentPool.getExtentThreshold() != nIExtentPool2.getExtentThreshold() || !NICLGeneralUtils.isEqual(nIExtentPool.getUserName(), nIExtentPool2.getUserName())) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareModifiablesExtentPools()");
        return bl;
    }

    private static boolean compareModifiablesLsss(NILSS nILSS, NILSS nILSS2) {
        NIOlcLogger.enter(CLASS_NAME, "compareModifiablesLsss()");
        boolean bl = true;
        if (nILSS.isCriticalModeEnabled() != nILSS2.isCriticalModeEnabled() || nILSS.isELBEnabled() != nILSS2.isELBEnabled() || nILSS.getCCTimeout() != nILSS2.getCCTimeout() || !NICLGeneralUtils.isEqual(nILSS.getCUBaseType(), nILSS2.getCUBaseType()) || nILSS.getELBActiveTime() != nILSS2.getELBActiveTime() || nILSS.getDeviceType() instanceof NIDeviceTypeCKD && nILSS.getSSID() != nILSS2.getSSID() || NICLGeneralUtils.isMM(nILSS2) && nILSS.getXRCTimeout() != nILSS2.getXRCTimeout()) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareModifiablesLsss()");
        return bl;
    }

    private static boolean compareModifiablesVolumes(NIVolume nIVolume, NIVolume nIVolume2) {
        NIOlcLogger.enter(CLASS_NAME, "compareModifiablesVolumes()");
        boolean bl = true;
        if (nIVolume.getDataType() instanceof NIDataTypeBlock520Protected && nIVolume2.getDataType() instanceof NIDataTypeBlock520Unprotected || nIVolume.getDataType() instanceof NIDataTypeBlock520Unprotected && nIVolume2.getDataType() instanceof NIDataTypeBlock520Protected || NICLGeneralUtils.getIdIntValue(nIVolume.getOriginalBaseVolumeID()) != NICLGeneralUtils.getIdIntValue(nIVolume2.getOriginalBaseVolumeID()) || !NICLGeneralUtils.isEqual(nIVolume.getUserName(), nIVolume2.getUserName()) || NICLGeneralUtils.isReef(nIVolume2) && nIVolume.getWriteCacheMode() != nIVolume2.getWriteCacheMode()) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareModifiablesVolumes()");
        return bl;
    }

    private static boolean compareModifiablesVolumeGroups(NIVolumeGroup nIVolumeGroup, NIVolumeGroup nIVolumeGroup2) {
        NIOlcLogger.enter(CLASS_NAME, "compareModifiablesVolumeGroups()");
        boolean bl = true;
        if (!(NICLGeneralUtils.isEqual(nIVolumeGroup.getType(), nIVolumeGroup2.getType()) && NICLGeneralUtils.isEqual(nIVolumeGroup.getUserName(), nIVolumeGroup2.getUserName()) && NICLResourceComparator.compareVolumeMaps(nIVolumeGroup, nIVolumeGroup2))) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareModifiablesVolumeGroups()");
        return bl;
    }

    private static boolean compareModifiablesScsiHostPorts(NISCSIHostPort nISCSIHostPort, NISCSIHostPort nISCSIHostPort2) {
        NIOlcLogger.enter(CLASS_NAME, "compareModifiablesScsiHostPorts()");
        boolean bl = true;
        if (!(nISCSIHostPort.getAddressDiscovery() == nISCSIHostPort2.getAddressDiscovery() && NICLGeneralUtils.isEqual(nISCSIHostPort.getAttachingPortTopology(), nISCSIHostPort2.getAttachingPortTopology()) && NICLGeneralUtils.isEqual(nISCSIHostPort.getHostType(), nISCSIHostPort2.getHostType()) && nISCSIHostPort.getLogicalBlockSize() == nISCSIHostPort2.getLogicalBlockSize() && nISCSIHostPort.getPortGroup() == nISCSIHostPort2.getPortGroup() && NICLResourceComparator.comparePortMasks(nISCSIHostPort.getPortMask(), nISCSIHostPort2.getPortMask()) && NICLGeneralUtils.isEqual(nISCSIHostPort.getPortProfile(), nISCSIHostPort2.getPortProfile()) && NICLGeneralUtils.isEqual(nISCSIHostPort.getUserHostName(), nISCSIHostPort2.getUserHostName()) && NICLGeneralUtils.isEqual(nISCSIHostPort.getUserHostDescription(), nISCSIHostPort2.getUserHostDescription()) && NICLGeneralUtils.getIdIntValue(nISCSIHostPort.getVolumeGroup()) == NICLGeneralUtils.getIdIntValue(nISCSIHostPort2.getVolumeGroup()))) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareModifiablesScsiHostPorts()");
        return bl;
    }

    private static boolean compareNonmodifiablesEsss(NIESS nIESS, NIESS nIESS2) {
        NIOlcLogger.enter(CLASS_NAME, "compareNonmodifiablesEsss()");
        boolean bl = true;
        NIOlcLogger.exit(CLASS_NAME, "compareNonmodifiablesEsss()");
        return bl;
    }

    private static boolean compareNonmodifiablesIoPorts(NIIOPort nIIOPort, NIIOPort nIIOPort2) {
        NIOlcLogger.enter(CLASS_NAME, "compareNonmodifiablesIoPorts()");
        boolean bl = true;
        NIOlcLogger.exit(CLASS_NAME, "compareNonmodifiablesIoPorts()");
        return bl;
    }

    private static boolean compareNonmodifiablesArrays(NIArray nIArray, NIArray nIArray2) {
        NIOlcLogger.enter(CLASS_NAME, "compareNonmodifiablesArrays()");
        boolean bl = true;
        if (nIArray.getDeviceAdapterPairID() != nIArray2.getDeviceAdapterPairID() || nIArray.getDiskCapacity() != nIArray2.getDiskCapacity() || nIArray.getDiskRPM() != nIArray2.getDiskRPM() || !NICLGeneralUtils.isEqual(nIArray.getRaidType(), nIArray2.getRaidType())) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareNonmodifiablesArrays()");
        return bl;
    }

    private static boolean compareNonmodifiablesRanks(NIRank nIRank, NIRank nIRank2) {
        NIOlcLogger.enter(CLASS_NAME, "compareNonmodifiablesRanks()");
        boolean bl = true;
        if (!NICLResourceComparator.compareArrays(nIRank.getArrayIDs(), nIRank2.getArrayIDs()) || !NICLGeneralUtils.isEqual(nIRank.getExtentType(), nIRank2.getExtentType())) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareNonmodifiablesRanks()");
        return bl;
    }

    private static boolean compareNonmodifiablesExtentPools(NIExtentPool nIExtentPool, NIExtentPool nIExtentPool2) {
        NIOlcLogger.enter(CLASS_NAME, "compareNonmodifiablesExtentPools()");
        boolean bl = true;
        if (!NICLGeneralUtils.isEqual(nIExtentPool.getExtentType(), nIExtentPool2.getExtentType()) || nIExtentPool.getRankGroup() != nIExtentPool2.getRankGroup()) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareNonmodifiablesExtentPools()");
        return bl;
    }

    private static boolean compareNonmodifiablesLsss(NILSS nILSS, NILSS nILSS2) {
        NIOlcLogger.enter(CLASS_NAME, "compareNonmodifiablesLsss()");
        boolean bl = true;
        if (!NICLGeneralUtils.isEqual(nILSS.getDeviceType(), nILSS2.getDeviceType())) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareNonmodifiablesLsss()");
        return bl;
    }

    private static boolean compareNonmodifiablesVolumes(NIVolume nIVolume, NIVolume nIVolume2) {
        NIOlcLogger.enter(CLASS_NAME, "compareNonmodifiablesVolumes()");
        boolean bl = true;
        if (!NICLGeneralUtils.isEqual(nIVolume.getDataType(), nIVolume2.getDataType()) && (!(nIVolume.getDataType() instanceof NIDataTypeBlock520Protected) && !(nIVolume.getDataType() instanceof NIDataTypeBlock520Unprotected) || !(nIVolume2.getDataType() instanceof NIDataTypeBlock520Protected) && !(nIVolume2.getDataType() instanceof NIDataTypeBlock520Unprotected)) || !NICLGeneralUtils.isEqual(nIVolume.getVolumeType(), nIVolume2.getVolumeType()) || NICLGeneralUtils.getIdIntValue(nIVolume.getAliasMapVolumeGroup()) != NICLGeneralUtils.getIdIntValue(nIVolume2.getAliasMapVolumeGroup()) || NICLGeneralUtils.getIdIntValue(nIVolume.getExtentPool()) != NICLGeneralUtils.getIdIntValue(nIVolume2.getExtentPool()) || nIVolume.getCapacity() != nIVolume2.getCapacity()) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareNonmodifiablesVolumes()");
        return bl;
    }

    private static boolean compareNonmodifiablesVolumeGroups(NIVolumeGroup nIVolumeGroup, NIVolumeGroup nIVolumeGroup2) {
        NIOlcLogger.enter(CLASS_NAME, "compareNonmodifiablesVolumeGroups()");
        boolean bl = true;
        if (!NICLGeneralUtils.isEqual(nIVolumeGroup.getType(), nIVolumeGroup2.getType()) || !NICLGeneralUtils.isEqual(nIVolumeGroup.getUserName(), nIVolumeGroup2.getUserName())) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareNonmodifiablesVolumeGroups()");
        return bl;
    }

    private static boolean compareNonmodifiablesScsiHostPorts(NISCSIHostPort nISCSIHostPort, NISCSIHostPort nISCSIHostPort2) {
        NIOlcLogger.enter(CLASS_NAME, "compareNonmodifiablesScsiHostPorts()");
        boolean bl = true;
        if (nISCSIHostPort.getWWPN() != nISCSIHostPort2.getWWPN()) {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "compareNonmodifiablesScsiHostPorts()");
        return bl;
    }

    private static boolean comparePortMasks(NIPortMask nIPortMask, NIPortMask nIPortMask2) {
        NIOlcLogger.enter(CLASS_NAME, "comparePortMasks()");
        boolean bl = nIPortMask == null && nIPortMask2 != null || nIPortMask != null && nIPortMask2 == null ? false : (nIPortMask == null && nIPortMask2 == null ? true : NICLGeneralUtils.isEqual(nIPortMask.toString(), nIPortMask2.toString()));
        NIOlcLogger.exit(CLASS_NAME, "comparePortMasks()");
        return bl;
    }

    private static boolean compareVolumeMaps(NIVolumeGroup nIVolumeGroup, NIVolumeGroup nIVolumeGroup2) {
        boolean bl;
        NIOlcLogger.enter(CLASS_NAME, "compareVolumeMaps()");
        NIVolumeGroupVolumeList nIVolumeGroupVolumeList = nIVolumeGroup.getVolumeGroupList();
        NIVolumeGroupVolumeList nIVolumeGroupVolumeList2 = nIVolumeGroup2.getVolumeGroupList();
        NIVolumeGroupType nIVolumeGroupType = nIVolumeGroup.getType();
        boolean[] blArray = new boolean[MAX_VOLS_PER_SFI];
        boolean[] blArray2 = new boolean[MAX_VOLS_PER_SFI];
        if (nIVolumeGroupVolumeList == null && nIVolumeGroupVolumeList2 == null) {
            bl = true;
        } else if (nIVolumeGroupVolumeList == null || nIVolumeGroupVolumeList2 == null) {
            bl = false;
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Map256 || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMap256) {
            bl = ((NIVolumeGroupMap)nIVolumeGroupVolumeList).getMapContents().equals(((NIVolumeGroupMap)nIVolumeGroupVolumeList2).getMapContents());
        } else {
            NIVolumeID[] nIVolumeIDArray;
            NIVolumeID[] nIVolumeIDArray2 = nIVolumeGroupVolumeList.getVolumesInVolumeGroup().toArray(new NIVolumeID[0]);
            if (nIVolumeIDArray2.length != (nIVolumeIDArray = nIVolumeGroupVolumeList2.getVolumesInVolumeGroup().toArray(new NIVolumeID[0])).length) {
                bl = false;
            } else {
                int n;
                int n2 = 0;
                while (n2 < nIVolumeIDArray2.length) {
                    n = NICLGeneralUtils.getIdIntValue(nIVolumeIDArray2[n2]);
                    blArray[n] = true;
                    ++n2;
                }
                n2 = 0;
                while (n2 < nIVolumeIDArray.length) {
                    n = NICLGeneralUtils.getIdIntValue(nIVolumeIDArray[n2]);
                    blArray2[n] = true;
                    ++n2;
                }
                bl = true;
                n2 = 0;
                while (n2 < blArray.length && bl) {
                    if (blArray[n2] != blArray2[n2]) {
                        bl = false;
                    }
                    ++n2;
                }
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "compareVolumeMaps()");
        return bl;
    }

    private static boolean compareSites(NIArraySiteID[] nIArraySiteIDArray, NIArraySiteID[] nIArraySiteIDArray2) {
        boolean bl;
        NIOlcLogger.enter(CLASS_NAME, "compareSites()");
        if (nIArraySiteIDArray.length != nIArraySiteIDArray2.length) {
            bl = false;
        } else {
            bl = true;
            int n = 0;
            while (n < nIArraySiteIDArray.length && bl) {
                bl = false;
                int n2 = nIArraySiteIDArray[n].getArraySiteNumber();
                int n3 = 0;
                while (n3 < nIArraySiteIDArray2.length) {
                    if (n2 == nIArraySiteIDArray2[n3].getArraySiteNumber()) {
                        bl = true;
                    }
                    ++n3;
                }
                ++n;
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "compareSites()");
        return bl;
    }

    private static boolean isSupported(NIResource nIResource, String string) {
        String string2 = nIResource.getClass().getName();
        boolean bl = true;
        List list = (List)((NIResourceImpl)((Object)nIResource)).getSupportedMethods().get(string2);
        bl = list.contains(string);
        if (!bl) {
            NIOlcLogger.info("WARNING: " + string2 + "." + string + " not supported");
        }
        return bl;
    }

    private static boolean mergeEsss(NIESS nIESS, NIESS nIESS2) {
        NIOlcLogger.enter(CLASS_NAME, "mergeEsss()");
        boolean bl = true;
        if (!NICLGeneralUtils.isEqual(nIESS.getUserDescription(), nIESS2.getUserDescription()) && NICLResourceComparator.isSupported(nIESS2, "setUserDescription")) {
            nIESS2.setUserDescription(nIESS.getUserDescription());
        }
        if (!NICLGeneralUtils.isEqual(nIESS.getUserName(), nIESS2.getUserName()) && NICLResourceComparator.isSupported(nIESS2, "setUserName")) {
            nIESS2.setUserName(nIESS.getUserName());
        }
        NIOlcLogger.exit(CLASS_NAME, "mergeEsss()");
        return bl;
    }

    private static boolean mergeIoPorts(NIIOPort nIIOPort, NIIOPort nIIOPort2) {
        NIOlcLogger.enter(CLASS_NAME, "mergeIoPorts()");
        boolean bl = true;
        if (nIIOPort instanceof NIESCONPort && nIIOPort2 instanceof NIESCONPort) {
            NIESCONPort nIESCONPort = (NIESCONPort)nIIOPort;
            NIESCONPort nIESCONPort2 = (NIESCONPort)nIIOPort2;
            if (nIESCONPort.getESCONPortGroup() != nIESCONPort2.getESCONPortGroup() && nIESCONPort.getESCONPortGroup() >= 0 && NICLResourceComparator.isSupported(nIESCONPort2, "setESCONPortGroup")) {
                nIESCONPort2.setESCONPortGroup(nIESCONPort.getESCONPortGroup());
            }
        } else if (nIIOPort instanceof NIFibreChannelPort && nIIOPort2 instanceof NIFibreChannelPort) {
            NIFibreChannelPort nIFibreChannelPort = (NIFibreChannelPort)nIIOPort;
            NIFibreChannelPort nIFibreChannelPort2 = (NIFibreChannelPort)nIIOPort2;
            if (nIFibreChannelPort.getAnonymousFICONPortGroup() != nIFibreChannelPort2.getAnonymousFICONPortGroup() && nIFibreChannelPort.getAnonymousFICONPortGroup() >= 0 && NICLResourceComparator.isSupported(nIFibreChannelPort2, "setAnonymousFICONPortGroup")) {
                nIFibreChannelPort2.setAnonymousFICONPortGroup(nIFibreChannelPort.getAnonymousFICONPortGroup());
            }
            if (!NICLGeneralUtils.isEqual(nIFibreChannelPort.getTopology(), nIFibreChannelPort2.getTopology()) && nIFibreChannelPort.getTopology() != null && NICLResourceComparator.isSupported(nIFibreChannelPort2, "setTopology")) {
                nIFibreChannelPort2.setTopology(nIFibreChannelPort.getTopology());
            }
            if (nIFibreChannelPort.getWWPN() != nIFibreChannelPort2.getWWPN() && nIFibreChannelPort.getWWPN() >= 0L && NICLResourceComparator.isSupported(nIFibreChannelPort2, "setWWPN")) {
                nIFibreChannelPort2.setWWPN(nIFibreChannelPort.getWWPN());
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "mergeIoPorts()");
        return bl;
    }

    private static boolean mergeArrays(NIArray nIArray, NIArray nIArray2) {
        NIOlcLogger.enter(CLASS_NAME, "mergeArrays()");
        boolean bl = false;
        NIOlcLogger.exit(CLASS_NAME, "mergeArrays()");
        return bl;
    }

    private static boolean mergeRanks(NIRank nIRank, NIRank nIRank2) {
        NIOlcLogger.enter(CLASS_NAME, "mergeRanks()");
        boolean bl = true;
        int n = NICLGeneralUtils.getIdIntValue(nIRank.getExtentPoolID());
        int n2 = NICLGeneralUtils.getIdIntValue(nIRank2.getExtentPoolID());
        if (n == -1 && n2 != -1 && NICLResourceComparator.isSupported(nIRank2, "setExtentPoolID")) {
            ((NIRankImpl)nIRank2).setExtentPoolID(null);
        } else if (n != -1 && n2 == -1 && NICLResourceComparator.isSupported(nIRank2, "setExtentPoolID")) {
            ((NIRankImpl)nIRank2).setExtentPoolID(new NIExtentPoolID(nIRank2.getID().getESS(), n));
        }
        NIOlcLogger.exit(CLASS_NAME, "mergeRanks()");
        return bl;
    }

    private static boolean mergeExtentPools(NIExtentPool nIExtentPool, NIExtentPool nIExtentPool2) {
        NIOlcLogger.enter(CLASS_NAME, "mergeExtentPools()");
        boolean bl = true;
        if (nIExtentPool.getExtentLimit() != nIExtentPool2.getExtentLimit() && NICLResourceComparator.isSupported(nIExtentPool2, "setExtentLimit")) {
            nIExtentPool2.setExtentLimit(nIExtentPool.getExtentLimit());
        }
        if (nIExtentPool.isExtentLimitEnabled() != nIExtentPool2.isExtentLimitEnabled() && NICLResourceComparator.isSupported(nIExtentPool2, "setExtentLimitEnabled")) {
            nIExtentPool2.setExtentLimitEnabled(nIExtentPool.isExtentLimitEnabled());
        }
        if (nIExtentPool.getExtentThreshold() != nIExtentPool2.getExtentThreshold() && NICLResourceComparator.isSupported(nIExtentPool2, "setExtentThreshold")) {
            nIExtentPool2.setExtentThreshold(nIExtentPool.getExtentThreshold());
        }
        if (!NICLGeneralUtils.isEqual(nIExtentPool.getUserName(), nIExtentPool2.getUserName()) && NICLResourceComparator.isSupported(nIExtentPool2, "setUserName")) {
            nIExtentPool2.setUserName(nIExtentPool.getUserName());
        }
        NIOlcLogger.exit(CLASS_NAME, "mergeExtentPools()");
        return bl;
    }

    private static boolean mergeLsss(NILSS nILSS, NILSS nILSS2) {
        NIOlcLogger.enter(CLASS_NAME, "mergeLsss()");
        boolean bl = true;
        if (nILSS.isCriticalModeEnabled() != nILSS2.isCriticalModeEnabled() && NICLResourceComparator.isSupported(nILSS2, "setCriticalModeEnabled")) {
            nILSS2.setCriticalModeEnabled(nILSS.isCriticalModeEnabled());
        }
        if (nILSS.isELBEnabled() != nILSS2.isELBEnabled() && NICLResourceComparator.isSupported(nILSS2, "setELBEnabled")) {
            nILSS2.setELBEnabled(nILSS.isELBEnabled());
        }
        if (nILSS.getCCTimeout() != nILSS2.getCCTimeout() && NICLResourceComparator.isSupported(nILSS2, "setCCTimeout")) {
            nILSS2.setCCTimeout(nILSS.getCCTimeout());
        }
        if (!NICLGeneralUtils.isEqual(nILSS.getCUBaseType(), nILSS2.getCUBaseType()) && NICLResourceComparator.isSupported(nILSS2, "setCUBaseType")) {
            nILSS2.setCUBaseType(nILSS.getCUBaseType());
        }
        if (nILSS.getELBActiveTime() != nILSS2.getELBActiveTime() && NICLResourceComparator.isSupported(nILSS2, "setELBActiveTime")) {
            nILSS2.setELBActiveTime(nILSS.getELBActiveTime());
        }
        if (nILSS.getSSID() != nILSS2.getSSID() && nILSS2.getDeviceType() instanceof NIDeviceTypeCKD && NICLResourceComparator.isSupported(nILSS2, "setSSID")) {
            nILSS2.setSSID(nILSS.getSSID());
        }
        if (NICLGeneralUtils.isReef(nILSS2) && nILSS.getXRCTimeout() != nILSS2.getXRCTimeout() && NICLResourceComparator.isSupported(nILSS2, "setXRCTimeout")) {
            nILSS2.setXRCTimeout(nILSS.getXRCTimeout());
        }
        NIOlcLogger.exit(CLASS_NAME, "mergeLsss()");
        return bl;
    }

    private static boolean mergeVolumes(NIVolume nIVolume, NIVolume nIVolume2) {
        NIOlcLogger.enter(CLASS_NAME, "mergeVolumes()");
        boolean bl = true;
        if ((nIVolume.getDataType() instanceof NIDataTypeBlock520Protected && nIVolume2.getDataType() instanceof NIDataTypeBlock520Unprotected || nIVolume.getDataType() instanceof NIDataTypeBlock520Unprotected && nIVolume2.getDataType() instanceof NIDataTypeBlock520Protected) && NICLResourceComparator.isSupported(nIVolume2, "setDataType")) {
            nIVolume2.setDataType(nIVolume.getDataType());
        }
        if (NICLGeneralUtils.getIdIntValue(nIVolume.getOriginalBaseVolumeID()) != NICLGeneralUtils.getIdIntValue(nIVolume2.getOriginalBaseVolumeID()) && NICLResourceComparator.isSupported(nIVolume2, "setOriginalBaseVolumeID")) {
            if (NICLGeneralUtils.getIdIntValue(nIVolume.getOriginalBaseVolumeID()) == -1) {
                nIVolume2.setOriginalBaseVolumeID(null);
            } else {
                NILSSID nILSSID = new NILSSID(nIVolume2.getID().getESS(), nIVolume.getOriginalBaseVolumeID().getLSS().getLSSNumber());
                nIVolume2.setOriginalBaseVolumeID(new NIVolumeID(nILSSID, nIVolume.getOriginalBaseVolumeID().getVolNumber()));
            }
        }
        if (!NICLGeneralUtils.isEqual(nIVolume.getUserName(), nIVolume2.getUserName()) && NICLResourceComparator.isSupported(nIVolume2, "setUserName")) {
            nIVolume2.setUserName(nIVolume.getUserName());
        }
        if (NICLGeneralUtils.isReef(nIVolume2) && nIVolume.getWriteCacheMode() != nIVolume2.getWriteCacheMode() && NICLResourceComparator.isSupported(nIVolume2, "setWriteCacheMode")) {
            nIVolume2.setWriteCacheMode(nIVolume.getWriteCacheMode());
        }
        NIOlcLogger.exit(CLASS_NAME, "mergeVolumes()");
        return bl;
    }

    private static boolean mergeVolumeGroups(NIVolumeGroup nIVolumeGroup, NIVolumeGroup nIVolumeGroup2) {
        NIOlcLogger.enter(CLASS_NAME, "mergeVolumeGroups()");
        boolean bl = true;
        if (!NICLGeneralUtils.isEqual(nIVolumeGroup.getUserName(), nIVolumeGroup2.getUserName()) && NICLResourceComparator.isSupported(nIVolumeGroup2, "setUserName")) {
            nIVolumeGroup2.setUserName(nIVolumeGroup.getUserName());
        }
        if (!NICLResourceComparator.compareVolumeMaps(nIVolumeGroup, nIVolumeGroup2)) {
            NICLResourceComparator.mergeVolumeMaps(nIVolumeGroup, nIVolumeGroup2, ((NIVolumeGroupID)nIVolumeGroup2.getID()).getESS());
        }
        NIOlcLogger.exit(CLASS_NAME, "mergeVolumeGroups()");
        return bl;
    }

    private static boolean mergeScsiHostPorts(NISCSIHostPort nISCSIHostPort, NISCSIHostPort nISCSIHostPort2) {
        NIOlcLogger.enter(CLASS_NAME, "mergeScsiHostPorts()");
        boolean bl = true;
        if (nISCSIHostPort.getAddressDiscovery() != nISCSIHostPort2.getAddressDiscovery() && NICLResourceComparator.isSupported(nISCSIHostPort2, "setAddressDiscovery")) {
            nISCSIHostPort2.setAddressDiscovery(nISCSIHostPort.getAddressDiscovery());
        }
        if (!NICLGeneralUtils.isEqual(nISCSIHostPort.getAttachingPortTopology(), nISCSIHostPort2.getAttachingPortTopology()) && NICLResourceComparator.isSupported(nISCSIHostPort2, "setAttachingPortTopology")) {
            nISCSIHostPort2.setAttachingPortTopology(nISCSIHostPort.getAttachingPortTopology());
        }
        if (!NICLGeneralUtils.isEqual(nISCSIHostPort.getHostType(), nISCSIHostPort2.getHostType()) && NICLResourceComparator.isSupported(nISCSIHostPort2, "setHostType")) {
            nISCSIHostPort2.setHostType(nISCSIHostPort.getHostType());
        }
        if (nISCSIHostPort.getLogicalBlockSize() != nISCSIHostPort2.getLogicalBlockSize() && NICLResourceComparator.isSupported(nISCSIHostPort2, "setLogicalBlockSize")) {
            nISCSIHostPort2.setLogicalBlockSize(nISCSIHostPort.getLogicalBlockSize());
        }
        if (nISCSIHostPort.getPortGroup() != nISCSIHostPort2.getPortGroup() && NICLResourceComparator.isSupported(nISCSIHostPort2, "setPortGroup")) {
            nISCSIHostPort2.setPortGroup(nISCSIHostPort.getPortGroup());
        }
        if (!NICLResourceComparator.comparePortMasks(nISCSIHostPort.getPortMask(), nISCSIHostPort2.getPortMask()) && NICLResourceComparator.isSupported(nISCSIHostPort2, "setPortMask")) {
            nISCSIHostPort2.setPortMask(nISCSIHostPort.getPortMask());
        }
        if (!NICLGeneralUtils.isEqual(nISCSIHostPort.getPortProfile(), nISCSIHostPort2.getPortProfile()) && NICLResourceComparator.isSupported(nISCSIHostPort2, "setPortProfile")) {
            nISCSIHostPort2.setPortProfile(nISCSIHostPort.getPortProfile());
        }
        if (!NICLGeneralUtils.isEqual(nISCSIHostPort.getUserHostName(), nISCSIHostPort2.getUserHostName()) && NICLResourceComparator.isSupported(nISCSIHostPort2, "setUserHostName")) {
            nISCSIHostPort2.setUserHostName(nISCSIHostPort.getUserHostName());
        }
        if (!NICLGeneralUtils.isEqual(nISCSIHostPort.getUserHostDescription(), nISCSIHostPort2.getUserHostDescription()) && NICLResourceComparator.isSupported(nISCSIHostPort2, "setUserHostDescription")) {
            nISCSIHostPort2.setUserHostDescription(nISCSIHostPort.getUserHostDescription());
        }
        if (NICLGeneralUtils.getIdIntValue(nISCSIHostPort.getVolumeGroup()) != NICLGeneralUtils.getIdIntValue(nISCSIHostPort2.getVolumeGroup()) && NICLResourceComparator.isSupported(nISCSIHostPort2, "setVolumeGroup")) {
            if (NICLGeneralUtils.getIdIntValue(nISCSIHostPort.getVolumeGroup()) == -1) {
                nISCSIHostPort2.setVolumeGroup(null);
            } else {
                nISCSIHostPort2.setVolumeGroup(new NIVolumeGroupID(nISCSIHostPort2.getID().getESS(), nISCSIHostPort.getVolumeGroup().getVolumeGroupNumber()));
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "mergeScsiHostPorts()");
        return bl;
    }

    private static boolean mergeVolumeMaps(NIVolumeGroup nIVolumeGroup, NIVolumeGroup nIVolumeGroup2, NIESSID nIESSID) {
        NIOlcLogger.enter(CLASS_NAME, "mergeVolumeMaps()");
        boolean bl = true;
        if (NICLResourceComparator.isSupported(nIVolumeGroup2, "setVolumeGroupList")) {
            NIVolumeGroupVolumeList nIVolumeGroupVolumeList;
            NIVolumeID[] nIVolumeIDArray;
            NIVolumeGroupVolumeList nIVolumeGroupVolumeList2 = nIVolumeGroup.getVolumeGroupList();
            NIVolumeGroupType nIVolumeGroupType = nIVolumeGroup.getType();
            if (nIVolumeGroupVolumeList2 == null) {
                nIVolumeGroupVolumeList2 = NIResourceFactory.newVolumeGroupVolumeList(nIVolumeGroupType);
                nIVolumeGroup.setVolumeGroupList(nIVolumeGroupVolumeList2);
            }
            if ((nIVolumeIDArray = nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Map256 || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMap256 ? ((NIVolumeGroupMap)nIVolumeGroupVolumeList2).getMapContents().toArray(new NIVolumeID[0]) : nIVolumeGroupVolumeList2.getVolumesInVolumeGroup().toArray(new NIVolumeID[0])) != null) {
                int n = 0;
                while (n < nIVolumeIDArray.length) {
                    if (nIVolumeIDArray[n] != null) {
                        NILSSID nILSSID = new NILSSID(nIESSID, nIVolumeIDArray[n].getLSS().getLSSNumber());
                        nIVolumeIDArray[n] = new NIVolumeID(nILSSID, nIVolumeIDArray[n].getVolNumber());
                    }
                    ++n;
                }
            }
            try {
                nIVolumeGroupVolumeList = NIResourceFactory.newVolumeGroupVolumeList(nIVolumeIDArray, nIVolumeGroupType);
            }
            catch (NIParameterInvalidServerException nIParameterInvalidServerException) {
                nIVolumeGroupVolumeList = NIResourceFactory.newVolumeGroupVolumeList(nIVolumeGroupType);
                NIOlcLogger.severe("Failed to create target volume group", nIParameterInvalidServerException);
            }
            nIVolumeGroup2.setVolumeGroupList(nIVolumeGroupVolumeList);
        }
        NIOlcLogger.exit(CLASS_NAME, "mergeVolumeMaps()");
        return bl;
    }
}

