/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.client.extensions.services;

import com.ibm.storage.ess.ni.client.extensions.services.NIAddressInfo;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceIDPair;
import com.ibm.storage.ess.ni.identifiers.NISessionID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.option.NIFlashCopyEstablishFastReverseRestore;
import com.ibm.storage.ess.ni.option.NIFlashCopyEstablishReverseRestore;
import com.ibm.storage.ess.ni.option.NIFlashCopyWithdrawResetTargetWriteInhibit;
import com.ibm.storage.ess.ni.option.NIFlashCopyWithdrawTargetIssue;
import com.ibm.storage.ess.ni.option.NIOption;
import com.ibm.storage.ess.ni.option.NIPPRCSuspendIssueTarget;
import com.ibm.storage.ess.ni.option.NIPPRCTerminateIssueTarget;
import java.util.HashSet;

public class NICSAddresser {
    private static final NIOption[] TARGET_OPTIONS = new NIOption[]{NIFlashCopyEstablishFastReverseRestore.Option, NIFlashCopyEstablishReverseRestore.Option, NIFlashCopyWithdrawTargetIssue.Option, NIPPRCSuspendIssueTarget.Option, NIPPRCTerminateIssueTarget.Option, NIFlashCopyWithdrawResetTargetWriteInhibit.Option};
    private static final HashSet TARGET_OPTION_SET = new HashSet();
    private static final Class OPTION_ARRAY_TYPE = TARGET_OPTIONS.getClass();

    public static NIAddressInfo findAddressInfo(Object[] objectArray) throws NIParameterInvalidServerException {
        NIAddressInfo nIAddressInfo = null;
        if (objectArray == null || objectArray.length < 1) {
            throw new NIParameterInvalidServerException(2, (Object)null);
        }
        nIAddressInfo = objectArray[0].getClass().isArray() ? NICSAddresser.findInfoForArray(objectArray) : NICSAddresser.findInfoForSingle(objectArray);
        return nIAddressInfo;
    }

    private static NIAddressInfo findInfoForSingle(Object[] objectArray) throws NIParameterInvalidServerException {
        NIAddressInfo nIAddressInfo = new NIAddressInfo();
        if (objectArray.length == 2 && objectArray[0] instanceof NIVolumeID && objectArray[1] instanceof NIVolumeID) {
            nIAddressInfo.elementNumber = -2;
            nIAddressInfo.list = false;
            nIAddressInfo.target = false;
            nIAddressInfo.pair = false;
        } else if (objectArray[0] instanceof NIVolumeID || objectArray[0] instanceof NILSSID) {
            nIAddressInfo.elementNumber = 0;
            nIAddressInfo.list = false;
            nIAddressInfo.target = false;
            nIAddressInfo.pair = false;
        } else if (objectArray[0] instanceof NISessionID) {
            int n = 1;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof NILSSID) break;
                ++n;
            }
            if (n >= objectArray.length) {
                throw new NIParameterInvalidServerException(2, (Object)null);
            }
            nIAddressInfo.elementNumber = n;
            nIAddressInfo.list = false;
            nIAddressInfo.target = false;
            nIAddressInfo.pair = false;
        } else {
            nIAddressInfo.elementNumber = 0;
            nIAddressInfo.list = false;
            nIAddressInfo.target = false;
            nIAddressInfo.pair = false;
        }
        return nIAddressInfo;
    }

    private static NIAddressInfo findInfoForArray(Object[] objectArray) {
        NIAddressInfo nIAddressInfo = new NIAddressInfo();
        if (((Object[])objectArray[0])[0] instanceof NIResourceIDPair) {
            if (objectArray.length == 1 || !NICSAddresser.containsTargetOption(objectArray)) {
                nIAddressInfo.elementNumber = 0;
                nIAddressInfo.list = true;
                nIAddressInfo.target = false;
                nIAddressInfo.pair = true;
            } else {
                nIAddressInfo.elementNumber = 0;
                nIAddressInfo.list = true;
                nIAddressInfo.target = true;
                nIAddressInfo.pair = true;
            }
        } else if (((Object[])objectArray[0])[0] instanceof NIVolumeID || ((Object[])objectArray[0])[0] instanceof NILSSID) {
            nIAddressInfo.elementNumber = 0;
            nIAddressInfo.list = true;
            nIAddressInfo.target = false;
            nIAddressInfo.pair = false;
        } else {
            nIAddressInfo.elementNumber = 0;
            nIAddressInfo.list = true;
            nIAddressInfo.target = false;
            nIAddressInfo.pair = false;
        }
        return nIAddressInfo;
    }

    private static boolean containsTargetOption(Object[] objectArray) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (!bl2 && n < objectArray.length) {
            if (OPTION_ARRAY_TYPE.isAssignableFrom(objectArray[n].getClass())) {
                bl2 = true;
                NIOption[] nIOptionArray = (NIOption[])objectArray[n];
                int n2 = 0;
                while (!bl && n2 < nIOptionArray.length) {
                    bl = TARGET_OPTION_SET.contains(nIOptionArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return bl;
    }

    static {
        int n = 0;
        while (n < TARGET_OPTIONS.length) {
            TARGET_OPTION_SET.add(TARGET_OPTIONS[n]);
            ++n;
        }
    }
}

