/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.client.extensions.services.event;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.event.NIEvent;
import com.ibm.storage.ess.ni.application.event.NIEventListener;
import com.ibm.storage.ess.ni.client.extensions.services.event.NIEventDistributor;
import com.ibm.storage.ess.ni.client.extensions.services.event.NIEventListenerThread;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.util.Iterator;
import java.util.Vector;

public class NIEventListenerThreadPool {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$client$extensions$services$event$NIEventListenerThreadPool == null ? (class$com$ibm$storage$ess$ni$client$extensions$services$event$NIEventListenerThreadPool = NIEventListenerThreadPool.class$("com.ibm.storage.ess.ni.client.extensions.services.event.NIEventListenerThreadPool")) : class$com$ibm$storage$ess$ni$client$extensions$services$event$NIEventListenerThreadPool);
    private Vector freeThreads;
    private Vector usedThreads;
    private int maximumSize;
    private boolean killed;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$client$extensions$services$event$NIEventListenerThreadPool;

    public NIEventListenerThreadPool(int n, int n2) throws OutOfMemoryError {
        this.maximumSize = n2;
        this.killed = false;
        this.freeThreads = new Vector();
        this.usedThreads = new Vector();
        int n3 = 0;
        while (n3 < n) {
            NIEventListenerThreadImpl nIEventListenerThreadImpl = new NIEventListenerThreadImpl(n3);
            nIEventListenerThreadImpl.start();
            this.freeThreads.add(nIEventListenerThreadImpl);
            ++n3;
        }
    }

    public synchronized void free(NIEventListenerThreadImpl nIEventListenerThreadImpl) {
        this.usedThreads.remove(nIEventListenerThreadImpl);
        this.freeThreads.add(nIEventListenerThreadImpl);
        this.notifyAll();
    }

    public synchronized NIEventListenerThread getFreeThread() {
        NIEventListenerThread nIEventListenerThread = null;
        while (nIEventListenerThread == null && !this.killed) {
            try {
                nIEventListenerThread = (NIEventListenerThread)this.freeThreads.remove(0);
                this.usedThreads.add(nIEventListenerThread);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.usedThreads.size() < this.maximumSize) {
                    nIEventListenerThread = new NIEventListenerThreadImpl(this.usedThreads.size());
                    ((NIEventListenerThreadImpl)nIEventListenerThread).start();
                    this.usedThreads.add(nIEventListenerThread);
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    logger.throwable((Throwable)interruptedException);
                    logger.error("EventListenerThreadPool interrupted while waiting for a free thread");
                }
            }
        }
        return nIEventListenerThread;
    }

    public synchronized void shutdown() {
        NIEventListenerThreadImpl nIEventListenerThreadImpl;
        this.killed = true;
        this.notify();
        Iterator iterator = this.freeThreads.iterator();
        while (iterator.hasNext()) {
            nIEventListenerThreadImpl = (NIEventListenerThreadImpl)iterator.next();
            nIEventListenerThreadImpl.shutdown();
        }
        iterator = this.usedThreads.iterator();
        while (iterator.hasNext()) {
            nIEventListenerThreadImpl = (NIEventListenerThreadImpl)iterator.next();
            nIEventListenerThreadImpl.shutdown();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NIEventListenerThreadImpl
    extends Thread
    implements NIEventListenerThread {
        private NIEventListener listener;
        private NIEvent event;
        private NIEventDistributor distributor;
        private boolean killed;
        private boolean eventReady;
        private int number;

        public NIEventListenerThreadImpl(int n) {
            super("NIEventListenerThread_" + n);
            this.listener = null;
            this.event = null;
            this.eventReady = false;
            this.killed = false;
            this.number = n;
        }

        public synchronized void callback(NIEventListener nIEventListener, NIEvent nIEvent, NIEventDistributor nIEventDistributor) {
            if (!this.eventReady) {
                this.listener = nIEventListener;
                this.event = nIEvent;
                this.distributor = nIEventDistributor;
                this.eventReady = true;
                this.notify();
            } else {
                logger.error("callback called when already processing an event");
            }
        }

        public void shutdown() {
            this.killed = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.killed) {
                NIEventListenerThreadImpl nIEventListenerThreadImpl = this;
                synchronized (nIEventListenerThreadImpl) {
                    try {
                        if (!this.eventReady) {
                            this.wait();
                        }
                        if (this.listener != null && this.event != null) {
                            logger.debug_detailed("NIEventListenerThread_" + this.number + ":  calling process for event " + this.event);
                            this.listener.process(this.event);
                            logger.debug_detailed("NIEventListenerThread_" + this.number + ":  process returned for event " + this.event);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.killed) {
                            interruptedException.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {
                        logger.error("NIEventListenerThread_" + this.number + " caught " + throwable + " from NIEventListenerThreadImpl.run()");
                    }
                    finally {
                        if (this.distributor != null) {
                            this.distributor.eventProcessed();
                        }
                        this.eventReady = false;
                        NIEventListenerThreadPool.this.free(this);
                    }
                }
            }
        }
    }
}

