/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.client.extensions.services.event;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.event.NIEventListener;
import com.ibm.storage.ess.ni.client.extensions.services.NIEventServiceInvocationHandler;
import com.ibm.storage.ess.ni.client.extensions.services.event.NIEventDistributor;
import com.ibm.storage.ess.ni.client.extensions.services.event.NIEventTypeMap;
import com.ibm.storage.ess.ni.communication.extensions.client.NICommunicationClient;
import com.ibm.storage.ess.ni.communication.extensions.client.NICommunicationClientStatusListener;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIReliableCommunicationsClient;
import com.ibm.storage.ess.ni.event.NIEventImpl;
import com.ibm.storage.ess.ni.eventManager.client.NIEventServer;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Vector;

public class NIEventServiceImpl
implements NICommunicationClientStatusListener {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$client$extensions$services$event$NIEventServiceImpl == null ? (class$com$ibm$storage$ess$ni$client$extensions$services$event$NIEventServiceImpl = NIEventServiceImpl.class$("com.ibm.storage.ess.ni.client.extensions.services.event.NIEventServiceImpl")) : class$com$ibm$storage$ess$ni$client$extensions$services$event$NIEventServiceImpl);
    private NIEventDistributor distributor;
    private NICommunicationClient[] channels;
    private int[] channelStatuses;
    private int numChannels;
    private Vector registeredEvents;
    private NIEventServer eventServer;
    private NIClientConnectionToken token;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$client$extensions$services$event$NIEventServiceImpl;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$eventManager$client$NIEventServer;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$event$NIEventListener;

    public NIEventServiceImpl(NIReliableCommunicationsClient nIReliableCommunicationsClient, NIEventDistributor nIEventDistributor, NICommunicationClient[] nICommunicationClientArray, NIClientConnectionToken nIClientConnectionToken) {
        this.distributor = nIEventDistributor;
        this.channels = nICommunicationClientArray;
        this.numChannels = nICommunicationClientArray.length;
        this.token = nIClientConnectionToken;
        NIEventServiceInvocationHandler nIEventServiceInvocationHandler = new NIEventServiceInvocationHandler(nIReliableCommunicationsClient);
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.eventServer = (NIEventServer)Proxy.newProxyInstance(classLoader, new Class[]{class$com$ibm$storage$ess$ni$eventManager$client$NIEventServer == null ? (class$com$ibm$storage$ess$ni$eventManager$client$NIEventServer = NIEventServiceImpl.class$("com.ibm.storage.ess.ni.eventManager.client.NIEventServer")) : class$com$ibm$storage$ess$ni$eventManager$client$NIEventServer}, (InvocationHandler)nIEventServiceInvocationHandler);
        this.channelStatuses = new int[this.numChannels];
        int n = 0;
        while (n < this.numChannels) {
            this.channelStatuses[n] = 1;
            nICommunicationClientArray[n].registerListener(this);
            ++n;
        }
        this.registeredEvents = new Vector();
    }

    public void update(NICommunicationClient[] nICommunicationClientArray, NIClientConnectionToken nIClientConnectionToken) {
        this.token = nIClientConnectionToken;
        this.channels = nICommunicationClientArray;
        this.numChannels = nICommunicationClientArray.length;
        this.channelStatuses = new int[this.numChannels];
        int n = 0;
        while (n < this.numChannels) {
            this.channelStatuses[n] = 1;
            nICommunicationClientArray[n].registerListener(this);
            ++n;
        }
        try {
            this.sendRegistration(this.eventServer);
        }
        catch (NIServerException nIServerException) {
            logger.error("server exception when trying to send event registration");
            logger.throwable((Throwable)nIServerException);
        }
    }

    public synchronized boolean addListener(int n, NIEventListener nIEventListener, NIEventServer nIEventServer) throws NIUnsupportedException, NIServerException, NIUnauthorizedServerException, NIUnavailableServerException {
        logger.enter("NIEventServiceImpl", "addListener");
        boolean bl = true;
        boolean bl2 = false;
        Class<?>[] classArray = nIEventListener.getClass().getInterfaces();
        int n2 = 0;
        while (n2 < classArray.length) {
            logger.debug_detailed("listener implements interface " + classArray[n2]);
            if ((class$com$ibm$storage$ess$ni$application$event$NIEventListener == null ? NIEventServiceImpl.class$("com.ibm.storage.ess.ni.application.event.NIEventListener") : class$com$ibm$storage$ess$ni$application$event$NIEventListener).isAssignableFrom(classArray[n2])) {
                logger.debug_detailed("calling distributor");
                this.distributor.addListener(n, nIEventListener, classArray[n2]);
                logger.debug_detailed("returned from distributor, getting event");
                logger.debug_general("Adding listener interface " + classArray[n2].getName() + " for listener " + nIEventListener);
                NIEventImpl nIEventImpl = NIEventTypeMap.EVENT_TYPE_MAP.getEvent(classArray[n2]);
                if (!this.registeredEvents.contains(nIEventImpl)) {
                    this.registeredEvents.add(nIEventImpl);
                    bl2 = true;
                }
            }
            ++n2;
        }
        if (bl2) {
            logger.debug_detailed("sending to server using the given event server instance");
            bl = this.sendRegistration(nIEventServer);
        } else {
            logger.debug_detailed("not sending to server");
            logger.debug_detailed("adding a listener, but all of its interfaces are covered... not sending command");
        }
        logger.exit("NIEventServiceImpl", "addListener");
        return bl;
    }

    public synchronized boolean removeListener(int n, NIEventListener nIEventListener, NIEventServer nIEventServer) throws NIUnsupportedException, NIServerException, NIUnauthorizedServerException, NIUnavailableServerException {
        logger.enter("NIEventServiceImpl", "removeListener");
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        Class<?>[] classArray = nIEventListener.getClass().getInterfaces();
        int n2 = 0;
        while (n2 < classArray.length) {
            if ((class$com$ibm$storage$ess$ni$application$event$NIEventListener == null ? NIEventServiceImpl.class$("com.ibm.storage.ess.ni.application.event.NIEventListener") : class$com$ibm$storage$ess$ni$application$event$NIEventListener).isAssignableFrom(classArray[n2])) {
                NIEventImpl nIEventImpl;
                bl3 = this.distributor.removeListener(n, nIEventListener, classArray[n2]);
                logger.debug_general("Removing listener interface " + classArray[n2].getName() + " for listener " + nIEventListener);
                if (bl3 && this.registeredEvents.remove(nIEventImpl = NIEventTypeMap.EVENT_TYPE_MAP.getEvent(classArray[n2]))) {
                    bl2 = true;
                }
            }
            ++n2;
        }
        if (bl2) {
            bl = this.sendRegistration(nIEventServer);
        }
        logger.exit("NIEventServiceImpl", "removeListener");
        return bl;
    }

    public synchronized boolean removeAllListeners(int n, NIEventServer nIEventServer) throws NIUnsupportedException, NIServerException, NIUnauthorizedServerException, NIUnavailableServerException {
        logger.enter("NIEventServiceImpl", "removeAllListeners");
        boolean bl = true;
        boolean bl2 = false;
        if (!this.registeredEvents.isEmpty()) {
            Iterator iterator;
            Vector vector = this.distributor.removeAllListeners(n);
            logger.debug_general("Removing all Listeners (ignore NIPeer* events).");
            Iterator iterator2 = this.registeredEvents.iterator();
            while (iterator2.hasNext()) {
                iterator = iterator2.next();
                System.out.println("   Event = " + iterator);
                logger.debug_general("(Remove all Listeners) Removing lister for event: " + iterator);
            }
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                NIEventImpl nIEventImpl = NIEventTypeMap.EVENT_TYPE_MAP.getEvent((Class)iterator.next());
                if (!this.registeredEvents.remove(nIEventImpl)) continue;
                bl2 = true;
            }
            if (bl2) {
                bl = this.sendRegistration(nIEventServer);
            }
        }
        logger.exit("NIEventServiceImpl", "removeAllListeners");
        return bl;
    }

    private synchronized boolean sendRegistration(NIEventServer nIEventServer) throws NIUnsupportedException, NIServerException, NIUnauthorizedServerException, NIUnavailableServerException {
        logger.enter("NIEventServiceImpl", "sendRegistration");
        logger.debug_detailed("creating event array");
        NIEventImpl[] nIEventImplArray = this.registeredEvents.toArray(new NIEventImpl[0]);
        logger.debug_detailed("calling setSubscriber");
        boolean bl = nIEventServer.setSubscriber(this.token, nIEventImplArray);
        logger.debug_detailed("setSubsriber returned");
        logger.exit("NIEventServiceImpl", "sendRegistration");
        return bl;
    }

    public void commClientStatusChanged(NICommunicationClient nICommunicationClient, int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.numChannels) {
            if (this.channels[n3] == nICommunicationClient) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 >= 0) {
            this.channelStatuses[n2] = n;
            if (n == 1) {
                try {
                    NIEventRegistrationThread nIEventRegistrationThread = new NIEventRegistrationThread();
                    nIEventRegistrationThread.start();
                }
                catch (Exception exception) {
                    logger.error("unable to send event registration:");
                    logger.throwable((Throwable)exception);
                }
            }
        } else {
            logger.error("event service received a comm client status change for a client we dont know about");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NIEventRegistrationThread
    extends Thread {
        public NIEventRegistrationThread() {
            super("NIEventRegistrationThread");
        }

        public void run() {
            try {
                NIEventServiceImpl.this.sendRegistration(NIEventServiceImpl.this.eventServer);
            }
            catch (Throwable throwable) {
                logger.error("caught throwable when trying to send event registration");
                logger.throwable(throwable);
            }
        }
    }
}

