/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.connection;

import com.ibm.jsse.IBMJSSEProvider;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.communication.connection.NIConnectionFactory;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public final class NISSLConnectionFactory
extends NIConnectionFactory {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$connection$NISSLConnectionFactory == null ? (class$com$ibm$storage$ess$ni$communication$connection$NISSLConnectionFactory = NISSLConnectionFactory.class$("com.ibm.storage.ess.ni.communication.connection.NISSLConnectionFactory")) : class$com$ibm$storage$ess$ni$communication$connection$NISSLConnectionFactory);
    private static final String KEYSTORE_FILE = "essnikeys.jks";
    private static final char[] KEYSTORE_PASS = "essnikeys.jks".toCharArray();
    private static NISSLConnectionFactory connectionFactory = null;
    private SSLSocketFactory socketFactory = null;
    private SSLServerSocketFactory serverSocketFactory = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$connection$NISSLConnectionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NISSLConnectionFactory() {
        logger.enter("NISSLConnectionFactory", "<init>");
        Security.addProvider((Provider)new IBMJSSEProvider());
        InputStream inputStream = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            inputStream = this.getClass().getResourceAsStream(KEYSTORE_FILE);
            keyStore.load(inputStream, KEYSTORE_PASS);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("IbmX509");
            keyManagerFactory.init(keyStore, KEYSTORE_PASS);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("IbmX509");
            trustManagerFactory.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            this.socketFactory = sSLContext.getSocketFactory();
            this.serverSocketFactory = sSLContext.getServerSocketFactory();
        }
        catch (Exception exception) {
            logger.error("Could not load keystore properly.  Cannot continue.", "NISSLConnectionFactory", "<init>", null);
            logger.throwable((Throwable)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                }
            }
        }
        logger.exit("NISSLConnectionFactory", "<init>");
    }

    static NISSLConnectionFactory getSSLConnectionFactory() {
        if (connectionFactory == null) {
            connectionFactory = new NISSLConnectionFactory();
        }
        return connectionFactory;
    }

    public Socket createNewSocket(InetAddress inetAddress, int n) throws IOException {
        return this.socketFactory.createSocket(inetAddress, n);
    }

    public Socket createNewSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return this.socketFactory.createSocket(inetAddress, n, inetAddress2, n2);
    }

    public ServerSocket createNewServerSocket(int n) throws IOException {
        return this.serverSocketFactory.createServerSocket(n);
    }

    public ServerSocket createNewServerSocket(int n, InetAddress inetAddress) throws IOException {
        return this.serverSocketFactory.createServerSocket(n, 0, inetAddress);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

