/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.connection;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.communication.connection.NIConnectionFactory;
import com.ibm.storage.ess.ni.communication.connection.NISocketConnectionThread;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class NITimedConnectionFactory
extends NIConnectionFactory {
    private Object socketLock = new Object();
    private Socket socket = null;
    private ServerSocket serverSocket = null;
    private IOException exception = null;
    private boolean processed = false;
    private NIConnectionFactory factory;
    private static final long DEFAULT_CLIENT_CONNECTION_TIMEOUT = 20000L;
    private long clientConnectionTimeout = 20000L;
    private static final long DEFAULT_SERVER_CONNECTION_TIMEOUT = 0L;
    private long serverConnectionTimeout = 0L;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$connection$NITimedConnectionFactory == null ? (class$com$ibm$storage$ess$ni$communication$connection$NITimedConnectionFactory = NITimedConnectionFactory.class$("com.ibm.storage.ess.ni.communication.connection.NITimedConnectionFactory")) : class$com$ibm$storage$ess$ni$communication$connection$NITimedConnectionFactory);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$connection$NITimedConnectionFactory;

    public NITimedConnectionFactory(NIConnectionFactory nIConnectionFactory) {
        this.factory = nIConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(Socket socket, IOException iOException) {
        Object object = this.socketLock;
        synchronized (object) {
            this.socket = socket;
            this.exception = iOException;
            this.processed = true;
            this.socketLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(ServerSocket serverSocket, IOException iOException) {
        Object object = this.socketLock;
        synchronized (object) {
            this.serverSocket = serverSocket;
            this.exception = iOException;
            this.processed = true;
            this.socketLock.notify();
        }
    }

    public synchronized Socket createNewSocket(InetAddress inetAddress, int n) throws IOException {
        this.reinitialize();
        if (this.clientConnectionTimeout > 0L) {
            Object object = this.socketLock;
            synchronized (object) {
                NISocketConnectionThread nISocketConnectionThread = new NISocketConnectionThread(this.factory, this, inetAddress, n);
                nISocketConnectionThread.start();
                try {
                    this.socketLock.wait(this.clientConnectionTimeout);
                    if (!this.processed) {
                        nISocketConnectionThread.abandon();
                        throw new IOException("connection took too long");
                    }
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    return this.socket;
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("connection interrupted");
                }
            }
        }
        return this.factory.createNewSocket(inetAddress, n);
    }

    public synchronized Socket createNewSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this.reinitialize();
        if (this.clientConnectionTimeout > 0L) {
            Object object = this.socketLock;
            synchronized (object) {
                NISocketConnectionThread nISocketConnectionThread = new NISocketConnectionThread(this.factory, this, inetAddress, n, inetAddress2, n2);
                nISocketConnectionThread.start();
                try {
                    this.socketLock.wait(this.clientConnectionTimeout);
                    if (!this.processed) {
                        nISocketConnectionThread.abandon();
                        throw new IOException("connection took too long");
                    }
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    return this.socket;
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("connection interrupted");
                }
            }
        }
        return this.factory.createNewSocket(inetAddress, n, inetAddress2, n2);
    }

    public synchronized ServerSocket createNewServerSocket(int n) throws IOException {
        this.reinitialize();
        if (this.serverConnectionTimeout > 0L) {
            Object object = this.socketLock;
            synchronized (object) {
                NISocketConnectionThread nISocketConnectionThread = new NISocketConnectionThread(this.factory, this, n);
                nISocketConnectionThread.start();
                try {
                    this.socketLock.wait(this.clientConnectionTimeout);
                    if (!this.processed) {
                        nISocketConnectionThread.abandon();
                        throw new IOException("connection took too long");
                    }
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    return this.serverSocket;
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("connection interrupted");
                }
            }
        }
        return this.factory.createNewServerSocket(n);
    }

    public synchronized ServerSocket createNewServerSocket(int n, InetAddress inetAddress) throws IOException {
        this.reinitialize();
        if (this.serverConnectionTimeout > 0L) {
            Object object = this.socketLock;
            synchronized (object) {
                NISocketConnectionThread nISocketConnectionThread = new NISocketConnectionThread(this.factory, this, n, inetAddress);
                nISocketConnectionThread.start();
                try {
                    this.socketLock.wait(this.clientConnectionTimeout);
                    if (!this.processed) {
                        nISocketConnectionThread.abandon();
                        throw new IOException("connection took too long");
                    }
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    return this.serverSocket;
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("connection interrupted");
                }
            }
        }
        return this.factory.createNewServerSocket(n, inetAddress);
    }

    private void reinitialize() {
        this.processed = false;
        this.socket = null;
        this.serverSocket = null;
        this.exception = null;
    }

    public long getSocketConnectionTimeout() {
        return this.clientConnectionTimeout;
    }

    public void setSocketConnectionTimeout(long l) {
        logger.debug_general("setting socket connection timeout to " + l);
        this.clientConnectionTimeout = l;
    }

    public long getServerSocketConnectionTimeout() {
        return this.serverConnectionTimeout;
    }

    public void setServerSocketConnectionTimeout(long l) {
        logger.debug_general("setting server socket connection timeout to " + l);
        this.serverConnectionTimeout = l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

