/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.extensions.server;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.communication.NICommunication;
import com.ibm.storage.ess.ni.communication.NICommunicationExecutor;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NIQueue;
import com.ibm.storage.ess.ni.util.NIQueueFullException;

public class NIClientCommunicationExecutor
extends NICommunicationExecutor
implements Runnable {
    private NIQueue queue = new NIQueue(256, 0.1);
    private static final int QUEUE_SIZE = 256;
    private static final double REDUCTION_PERCENT = 0.1;
    private Thread executionThread;
    private NIClientConnectionToken token;
    private String label;
    private boolean running;
    private NICommunicationExecutor executor;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$server$NICommunicationServer == null ? (class$com$ibm$storage$ess$ni$communication$extensions$server$NICommunicationServer = NIClientCommunicationExecutor.class$("com.ibm.storage.ess.ni.communication.extensions.server.NICommunicationServer")) : class$com$ibm$storage$ess$ni$communication$extensions$server$NICommunicationServer);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$server$NICommunicationServer;

    public NIClientCommunicationExecutor(NIClientConnectionToken nIClientConnectionToken, NICommunicationExecutor nICommunicationExecutor) {
        this.token = nIClientConnectionToken;
        this.executor = nICommunicationExecutor;
        this.label = "<client #" + nIClientConnectionToken + "> ";
        this.running = true;
        this.executionThread = new Thread((Runnable)this, "NIClientCommunicationExecutor_" + nIClientConnectionToken);
        this.executionThread.start();
    }

    protected NICommunication executeImpl(NICommunication nICommunication) {
        try {
            this.queue.enqueue(nICommunication);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error(this.label + "IllegalArgumentException when enqueueing " + nICommunication + " dropping it");
            logger.throwable((Throwable)illegalArgumentException);
        }
        catch (NIQueueFullException nIQueueFullException) {
            logger.error(this.label + "queue full exception when enqueueing " + nICommunication + " dropping it");
            logger.throwable((Throwable)nIQueueFullException);
        }
        return nICommunication;
    }

    public void run() {
        while (this.running) {
            try {
                NICommunication nICommunication = (NICommunication)this.queue.dequeue();
                this.executor.execute(nICommunication);
            }
            catch (InterruptedException interruptedException) {
                if (!this.running) continue;
                logger.error(this.label + "Interrupted while dequeueing, but running is still true");
                logger.throwable((Throwable)interruptedException);
            }
        }
        this.queue.clear();
        this.queue = null;
    }

    public void shutdown() {
        this.running = false;
        this.executionThread.interrupt();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

