/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.extensions.server;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.event.NIEvent;
import com.ibm.storage.ess.ni.application.results.NIClientDescriptor;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogEntryImpl;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogFileHandler;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogTable;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogUtil;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.communication.NICommunication;
import com.ibm.storage.ess.ni.communication.connection.NIConnectionFactory;
import com.ibm.storage.ess.ni.communication.extensions.NIHandler;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientUnavailableException;
import com.ibm.storage.ess.ni.communication.extensions.common.NICommunicationConstants;
import com.ibm.storage.ess.ni.communication.extensions.common.NIConnectionManager;
import com.ibm.storage.ess.ni.communication.extensions.server.NIClientCommunicationExecutor;
import com.ibm.storage.ess.ni.communication.extensions.server.NIClientConnection;
import com.ibm.storage.ess.ni.communication.extensions.server.NIConnectionServer;
import com.ibm.storage.ess.ni.communication.extensions.server.NIResponseACKManager;
import com.ibm.storage.ess.ni.event.NIEventImpl;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.security.NIClientAuthenticator;
import com.ibm.storage.ess.ni.security.NICommandAuthorizer;
import com.ibm.storage.ess.ni.server.common.NIServer;
import com.ibm.storage.ess.ni.util.NIQueue;
import com.ibm.storage.ess.ni.util.NIQueueFullException;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;

public class NICommunicationServer
implements NIConnectionManager,
NICommunicationConstants {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$server$NICommunicationServer == null ? (class$com$ibm$storage$ess$ni$communication$extensions$server$NICommunicationServer = NICommunicationServer.class$("com.ibm.storage.ess.ni.communication.extensions.server.NICommunicationServer")) : class$com$ibm$storage$ess$ni$communication$extensions$server$NICommunicationServer);
    private NIClientTable clients;
    private Random rng = new Random();
    private NIConnectionServer connectionServer;
    private Vector connectionStatusListenerList;
    private boolean acceptConnections = false;
    private NIServer essniServer = null;
    private NIConnectionFactory connectionFactory = NIConnectionFactory.getConnectionFactory();
    private static NICommunicationServer singleton = null;
    private NIResponseACKManager responseACKManager = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$server$NICommunicationServer;

    private NICommunicationServer() throws IOException {
        this.connectionStatusListenerList = new Vector();
        ServerSocket serverSocket = this.connectionFactory.createNewServerSocket(1750);
        this.connectionServer = new NIConnectionServer(serverSocket, this);
        this.clients = new NIClientTable(new TreeMap(NIClientConnectionToken.getComparator()));
        this.responseACKManager = NIResponseACKManager.createResponseACKManager(this);
    }

    public void setESSNIServer(NIServer nIServer) {
        this.essniServer = nIServer;
    }

    public static NICommunicationServer getInstanceOf() throws IOException {
        if (singleton == null) {
            singleton = new NICommunicationServer();
        }
        return singleton;
    }

    public void startup() {
        this.acceptConnections = true;
        this.connectionServer.start();
    }

    public void shutdown() {
        this.acceptConnections = false;
        this.connectionServer.shutdown();
        this.disconnectAll();
    }

    private String label(NIClientConnectionToken nIClientConnectionToken) {
        return "<client #" + (nIClientConnectionToken != null ? nIClientConnectionToken.toString() : "?") + "> ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectClient(NIClientConnectionToken nIClientConnectionToken, boolean bl) {
        NICCB nICCB;
        logger.enter("NICommunicationServer", "disconnectClient", (Object)nIClientConnectionToken);
        if (nIClientConnectionToken != null && this.clients.containsKey(nIClientConnectionToken) && (nICCB = (NICCB)this.clients.get(nIClientConnectionToken)) != null) {
            NICCB nICCB2 = nICCB;
            synchronized (nICCB2) {
                logger.debug_general(this.label(nIClientConnectionToken) + "disconnectClient called, with state: " + nICCB.getStateString());
                switch (nICCB.state) {
                    case 0: 
                    case 1: {
                        nICCB.clientConnection.disconnect();
                        if (bl) {
                            logger.debug_general(this.label(nIClientConnectionToken) + "client disconnected gracefully");
                            if (nICCB.executor != null) {
                                nICCB.executor.shutdown();
                            }
                            this.clients.remove(nIClientConnectionToken);
                            nICCB.clientConnection = null;
                            try {
                                this.essniServer.getEventServer().setSubscriber(nIClientConnectionToken, new NIEventImpl[0]);
                            }
                            catch (NIUnavailableServerException nIUnavailableServerException) {
                                logger.error(this.label(nIClientConnectionToken) + "unavailable server exception received when unregistering client");
                                logger.throwable((Throwable)nIUnavailableServerException);
                            }
                            catch (NIServerException nIServerException) {
                                logger.error(this.label(nIClientConnectionToken) + "server exception received when unregistering client");
                                logger.throwable((Throwable)nIServerException);
                            }
                            break;
                        }
                        logger.debug_general(this.label(nIClientConnectionToken) + "client disconnected");
                        nICCB.clientDisconnection = new NIClientDisconnection(nICCB);
                        nICCB.state = 2;
                        break;
                    }
                    default: {
                        nICCB.state = 2;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectAll() {
        NIClientTable nIClientTable = this.clients;
        synchronized (nIClientTable) {
            Iterator iterator = this.clients.keySet().iterator();
            while (iterator.hasNext()) {
                this.disconnectClient((NIClientConnectionToken)iterator.next(), false);
            }
        }
    }

    public NIClientConnection getClient(NIClientConnectionToken nIClientConnectionToken) {
        NIClientConnection nIClientConnection = null;
        NICCB nICCB = (NICCB)this.clients.get(nIClientConnectionToken);
        if (nICCB != null) {
            nIClientConnection = nICCB.clientConnection;
        }
        return nIClientConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfConnectedClients() {
        int n = 0;
        NIClientTable nIClientTable = this.clients;
        synchronized (nIClientTable) {
            Enumeration enumeration = this.clients.elements();
            while (enumeration.hasMoreElements()) {
                NICCB nICCB = (NICCB)enumeration.nextElement();
                if (nICCB.state != 1) continue;
                ++n;
            }
        }
        return n;
    }

    public NIClientAuthenticator getClientAuthenticator() {
        return this.essniServer.getClientAuthenticator();
    }

    public NICommandAuthorizer getCommandAuthorizer() {
        return this.essniServer.getCommandAuthorizer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectingClient(NIClientConnection nIClientConnection, NIClientConnectionToken nIClientConnectionToken, NIHandler nIHandler) {
        if (this.clients.containsKey(nIClientConnectionToken)) {
            NICCB nICCB;
            NICCB nICCB2 = nICCB = (NICCB)this.clients.get(nIClientConnectionToken);
            synchronized (nICCB2) {
                nICCB.clientConnection = nIClientConnection;
                nICCB.state = 3;
                nIHandler.setExecutor(nICCB.executor);
            }
        } else {
            NICCB nICCB = new NICCB(nIClientConnectionToken, nIClientConnection);
            nICCB.executor = new NIClientCommunicationExecutor(nIClientConnectionToken, this.essniServer.getDefaultCommunicationExecutor(this));
            this.clients.put(nIClientConnectionToken, nICCB);
            nIHandler.setExecutor(nICCB.executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeClientConnection(NIClientConnection nIClientConnection) {
        NICCB nICCB;
        NICCB nICCB2 = nICCB = (NICCB)this.clients.get(nIClientConnection.getToken());
        synchronized (nICCB2) {
            if (nICCB.state == 3) {
                logger.debug_general(this.label(nICCB.token) + "client reconnected");
                nICCB.state = 4;
                nICCB.clientDisconnection.flush();
            } else {
                logger.debug_general(this.label(nICCB.token) + "client connected");
                nICCB.state = 1;
            }
        }
    }

    public NIClientConnectionToken getNewToken() throws NIUnavailableServerException {
        NIClientConnectionToken nIClientConnectionToken = null;
        if (!this.acceptConnections) {
            logger.debug_general("Connection refused", "NICommunicationServer", "connectionReceived", null);
            throw new NIUnavailableServerException(2);
        }
        if (this.getNumberOfConnectedClients() >= 256) {
            logger.debug_general("Connection refused, too many connections", "NICommunicationServer", "connectionReceived", null);
            logger.debug_general("connections: " + this.getNumberOfConnectedClients(), "NICommunicationServer", "connectionReceived", null);
            throw new NIUnavailableServerException(2);
        }
        while (this.clients.containsKey(nIClientConnectionToken = new NIClientConnectionToken(this.rng.nextInt()))) {
        }
        logger.debug_general("found free token: " + nIClientConnectionToken);
        return nIClientConnectionToken;
    }

    public boolean isNewToken(NIClientConnectionToken nIClientConnectionToken) {
        return !this.clients.containsKey(nIClientConnectionToken);
    }

    public NIClientConnectionToken testOldToken(NIClientConnectionToken nIClientConnectionToken) throws NIUnavailableServerException {
        NIClientConnectionToken nIClientConnectionToken2 = null;
        if (!this.acceptConnections) {
            logger.debug_general("Connection refused", "NICommunicationServer", "connectionReceived", null);
            throw new NIUnavailableServerException(2);
        }
        if (this.getNumberOfConnectedClients() >= 256) {
            logger.debug_general("Connection refused, too many connections", "NICommunicationServer", "connectionReceived", null);
            logger.debug_general("connections: " + this.getNumberOfConnectedClients(), "NICommunicationServer", "connectionReceived", null);
            throw new NIUnavailableServerException(2);
        }
        if (this.clients.containsKey(nIClientConnectionToken)) {
            NIClientConnection nIClientConnection = this.getClient(nIClientConnectionToken);
            if (nIClientConnection == null || !nIClientConnection.testConnection()) {
                nIClientConnectionToken2 = nIClientConnectionToken;
                logger.debug_general("token is in use, but connection is not active... OK!: " + nIClientConnectionToken);
            } else {
                logger.debug_general("token is in use, and connection is active... fail:" + nIClientConnectionToken);
            }
        } else {
            logger.debug_general("token is not in use... OK!: " + nIClientConnectionToken);
            nIClientConnectionToken2 = nIClientConnectionToken;
        }
        return nIClientConnectionToken2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleConnectionProblem(NIConnectionServer nIConnectionServer) {
        try {
            nIConnectionServer.restart();
            return;
        }
        catch (IOException iOException) {
            logger.warning("Exception during server restart", "NICommunicationServer", "handleConnectionProblem", null);
            logger.throwable((Throwable)iOException);
            try {
                try {
                    NIConnectionServer nIConnectionServer2 = nIConnectionServer;
                    synchronized (nIConnectionServer2) {
                        logger.warning("Waiting to restart server", "NICommunicationServer", "handleConnectionProblem", null);
                        this.wait(10000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    logger.warning("exception during waiting", "NICommunicationServer", "handleConnectionProblem", null);
                    logger.throwable((Throwable)interruptedException);
                    Object var6_6 = null;
                    logger.warning("Restarting server", "NICommunicationServer", "handleConnectionProblem", null);
                    this.handleConnectionProblem(nIConnectionServer);
                    return;
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                logger.warning("Restarting server", "NICommunicationServer", "handleConnectionProblem", null);
                this.handleConnectionProblem(nIConnectionServer);
                throw throwable;
            }
            logger.warning("Restarting server", "NICommunicationServer", "handleConnectionProblem", null);
            this.handleConnectionProblem(nIConnectionServer);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIClientDescriptor[] getConnectedClients() {
        NIClientDescriptor[] nIClientDescriptorArray;
        NIClientTable nIClientTable = this.clients;
        synchronized (nIClientTable) {
            nIClientDescriptorArray = new NIClientDescriptor[this.getNumberOfConnectedClients()];
            int n = 0;
            Enumeration enumeration = this.clients.elements();
            while (enumeration.hasMoreElements()) {
                NICCB nICCB;
                NICCB nICCB2 = nICCB = (NICCB)enumeration.nextElement();
                synchronized (nICCB2) {
                    if (nICCB.state == 1) {
                        nIClientDescriptorArray[n++] = nICCB.clientConnection.getNIClientDescriptor();
                    }
                }
            }
        }
        return nIClientDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientsAuthorization(String string) {
        Enumeration enumeration = this.clients.elements();
        while (enumeration.hasMoreElements()) {
            NICCB nICCB;
            NICCB nICCB2 = nICCB = (NICCB)enumeration.nextElement();
            synchronized (nICCB2) {
                if (nICCB.clientConnection != null) {
                    nICCB.clientConnection.updateAuthorizations(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void send(NIClientConnectionToken nIClientConnectionToken, NICommand nICommand) throws NIClientUnavailableException, NIUnsupportedException {
        int n = 2;
        boolean bl = false;
        NIClientConnection nIClientConnection = null;
        NICCB nICCB = (NICCB)this.clients.get(nIClientConnectionToken);
        if (nICCB == null) throw new NIClientUnavailableException();
        NICCB nICCB2 = nICCB;
        synchronized (nICCB2) {
            n = nICCB.state;
            nIClientConnection = nICCB.clientConnection;
            bl = nIClientConnection.doesResponseACKs();
        }
        if (n == 1 || n == 0) {
            try {
                if (bl) {
                    this.responseACKManager.prepareForSend(nICommand);
                }
                nIClientConnection.send(nICommand);
                if (!bl) return;
                this.responseACKManager.responseSent(nICommand);
                return;
            }
            catch (NIClientUnavailableException nIClientUnavailableException) {
                if (bl) {
                    this.responseACKManager.responseNotSent(nICommand);
                }
                logger.error(this.label(nIClientConnectionToken) + "got client unavailable exception when trying to send response: " + nICommand);
                logger.throwable((Throwable)nIClientUnavailableException);
                NICCB nICCB3 = nICCB;
                synchronized (nICCB3) {
                    if (nICCB.clientDisconnection != null) {
                        nICCB.clientDisconnection.enqueue(nICommand);
                    } else {
                        logger.error(this.label(nIClientConnectionToken) + "this shouldn't happen... tried to send response, failed, then still didn't have a disconnection queue");
                    }
                    return;
                }
            }
        }
        NICCB nICCB4 = nICCB;
        synchronized (nICCB4) {
            if (nICCB.clientDisconnection != null) {
                nICCB.clientDisconnection.enqueue(nICommand);
            } else {
                logger.error(this.label(nIClientConnectionToken) + "don't know what to do... don't have a clientDisconnection, and state is: " + nICCB.getStateString());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(NIClientConnectionToken nIClientConnectionToken, NIEventImpl nIEventImpl) throws NIClientUnavailableException, NIUnsupportedException {
        NICCB nICCB = (NICCB)this.clients.get(nIClientConnectionToken);
        if (nICCB != null) {
            NICCB nICCB2 = nICCB;
            synchronized (nICCB2) {
                block11: {
                    if (nICCB.state == 1) {
                        try {
                            nICCB.clientConnection.send(nIEventImpl);
                        }
                        catch (NIClientUnavailableException nIClientUnavailableException) {
                            logger.error(this.label(nIClientConnectionToken) + "got client unavailable exception when trying to send event: " + nIEventImpl);
                            logger.throwable((Throwable)nIClientUnavailableException);
                            if (nICCB.clientDisconnection != null) {
                                nICCB.clientDisconnection.enqueue(nIEventImpl);
                                break block11;
                            }
                            logger.error(this.label(nIClientConnectionToken) + "this shouldn't happen... tried to send event, failed, then still didn't have a disconnection queue");
                        }
                    } else if (nICCB.clientDisconnection != null) {
                        nICCB.clientDisconnection.enqueue(nIEventImpl);
                    } else {
                        logger.error(this.label(nIClientConnectionToken) + "don't know what to do... don't have a clientDisconnection, and state is: " + nICCB.getStateString());
                    }
                }
            }
        }
        throw new NIClientUnavailableException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NIClientTable {
        private Hashtable clients;
        private NIAuditLogFileHandler auditLogFileHandler = NIAuditLogFileHandler.getInstance();
        private NIAuditLogTable auditLogTable = NIAuditLogTable.getInstance();

        public NIClientTable(Map map) {
            this.clients = new Hashtable(map);
        }

        public Object get(Object object) {
            return this.clients.get(object);
        }

        public Object remove(Object object) {
            NICCB nICCB = (NICCB)this.clients.get(object);
            if (nICCB != null) {
                this.writeAuditLogEntry(nICCB.getClientConnection());
            }
            return this.clients.remove(object);
        }

        public Object put(Object object, Object object2) {
            return this.clients.put(object, object2);
        }

        public boolean containsKey(Object object) {
            return this.clients.containsKey(object);
        }

        public Set keySet() {
            return this.clients.keySet();
        }

        public Enumeration elements() {
            return this.clients.elements();
        }

        private void writeAuditLogEntry(NIClientConnection nIClientConnection) {
            try {
                NIAuditLogEntryImpl nIAuditLogEntryImpl = new NIAuditLogEntryImpl();
                nIAuditLogEntryImpl.setLogLocation(NIAuditLogUtil.getLogLocation());
                nIAuditLogEntryImpl.setStaticFields(this.auditLogTable.getEntry("1010"));
                nIAuditLogEntryImpl.setUserName(nIClientConnection.getAuthenticationInfo().getUsername());
                nIAuditLogEntryImpl.setExitCode(Integer.toHexString(0));
                this.auditLogFileHandler.output(nIAuditLogEntryImpl);
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
            }
        }
    }

    private class NIClientDisconnection
    extends TimerTask {
        private NICCB ccb;
        private NIQueue queue;
        private static final int QUEUE_SIZE = 50;
        private static final double REDUCTION_PERCENT = 0.1;
        private Timer suicideTimer;

        public NIClientDisconnection(NICCB nICCB) {
            this.ccb = nICCB;
            this.queue = new NIQueue(50, 0.1);
            this.suicideTimer = new Timer();
            this.suicideTimer.schedule((TimerTask)this, 900000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.suicideTimer.cancel();
            NICCB nICCB = this.ccb;
            synchronized (nICCB) {
                if (this.ccb.state != 4) {
                    logger.debug_general(NICommunicationServer.this.label(this.ccb.token) + "Cleaning up the queues of disconnected client");
                    NIClientTable nIClientTable = NICommunicationServer.this.clients;
                    synchronized (nIClientTable) {
                        if (this.ccb.executor != null) {
                            this.ccb.executor.shutdown();
                        }
                        NICommunicationServer.this.clients.remove(this.ccb.token);
                        this.ccb.clientConnection = null;
                        try {
                            NICommunicationServer.this.essniServer.getEventServer().setSubscriber(this.ccb.token, new NIEventImpl[0]);
                        }
                        catch (NIUnavailableServerException nIUnavailableServerException) {
                            logger.error(NICommunicationServer.this.label(this.ccb.token) + "unavailable server exception received when unregistering client");
                            logger.throwable((Throwable)nIUnavailableServerException);
                        }
                        catch (NIServerException nIServerException) {
                            logger.error(NICommunicationServer.this.label(this.ccb.token) + "server exception received when unregistering client");
                            logger.throwable((Throwable)nIServerException);
                        }
                    }
                }
                logger.debug_general(NICommunicationServer.this.label(this.ccb.token) + "cleanup timer popped, but we are flushing... allow that to finish");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void flush() {
            this.suicideTimer.cancel();
            logger.debug_general(NICommunicationServer.this.label(this.ccb.token) + "sending all the queued events and responses for client");
            try {
                while (true) {
                    if (this.queue.isEmpty()) {
                        this.ccb.clientDisconnection = null;
                        this.ccb.state = 1;
                        return;
                    }
                    NICommunication nICommunication = (NICommunication)this.queue.dequeue();
                    try {
                        if (nICommunication instanceof NIEvent) {
                            logger.debug_general(NICommunicationServer.this.label(this.ccb.token) + "sending event: " + nICommunication);
                            this.ccb.clientConnection.send((NIEvent)((Object)nICommunication));
                            continue;
                        }
                        if (nICommunication instanceof NICommand) {
                            logger.debug_general(NICommunicationServer.this.label(this.ccb.token) + "sending response: " + nICommunication);
                            this.ccb.clientConnection.send((NICommand)nICommunication);
                            continue;
                        }
                        logger.error(NICommunicationServer.this.label(this.ccb.token) + "communication in queue that is neither an event or a command.... shouldn't happen");
                    }
                    catch (NIUnsupportedException nIUnsupportedException) {
                        logger.error(NICommunicationServer.this.label(this.ccb.token) + "unsupported exception while flushing queue... skipping this one");
                        logger.throwable((Throwable)nIUnsupportedException);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                logger.error(NICommunicationServer.this.label(this.ccb.token) + "interrupted while flushing queue.... aborting");
                logger.throwable((Throwable)interruptedException);
                return;
            }
            catch (NIClientUnavailableException nIClientUnavailableException) {
                logger.error(NICommunicationServer.this.label(this.ccb.token) + "client unavailable exception while flushing queue.... aborting");
                logger.throwable((Throwable)nIClientUnavailableException);
                return;
            }
            catch (Exception exception) {
                logger.error(NICommunicationServer.this.label(this.ccb.token) + "caught unexpected exception while flushing the queue.... aborting");
                logger.throwable((Throwable)exception);
                return;
            }
        }

        public synchronized void enqueue(NICommunication nICommunication) {
            block10: {
                if (this.ccb.state == 1) {
                    try {
                        if (nICommunication instanceof NIEvent) {
                            logger.debug_general(NICommunicationServer.this.label(this.ccb.token) + "sending event right away... queue has been flushed: " + nICommunication);
                            this.ccb.clientConnection.send((NIEvent)((Object)nICommunication));
                            break block10;
                        }
                        if (nICommunication instanceof NICommand) {
                            logger.debug_general(NICommunicationServer.this.label(this.ccb.token) + "sending response right away... queue has been flushed: " + nICommunication);
                            this.ccb.clientConnection.send((NICommand)nICommunication);
                            break block10;
                        }
                        logger.error(NICommunicationServer.this.label(this.ccb.token) + "communication in queue that is neither an event or a command.... shouldn't happen");
                    }
                    catch (NIUnsupportedException nIUnsupportedException) {
                        logger.error(NICommunicationServer.this.label(this.ccb.token) + "unsupported exception while sending in enqueue... skipping this one");
                        logger.throwable((Throwable)nIUnsupportedException);
                    }
                    catch (NIClientUnavailableException nIClientUnavailableException) {
                        logger.error(NICommunicationServer.this.label(this.ccb.token) + "client unavailable exception while sending in enqueue.... aborting");
                        logger.throwable((Throwable)nIClientUnavailableException);
                    }
                } else {
                    try {
                        logger.debug_general(NICommunicationServer.this.label(this.ccb.token) + "saving event/response in case the client reconnects soon: " + nICommunication);
                        this.queue.enqueue(nICommunication);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logger.error(NICommunicationServer.this.label(this.ccb.token) + "enqueue was passed a null communication... ignoring");
                    }
                    catch (NIQueueFullException nIQueueFullException) {
                        logger.error(NICommunicationServer.this.label(this.ccb.token) + "disconnected client queue is full.... dropping " + nICommunication + " on the floor");
                    }
                }
            }
        }
    }

    private class NICCB {
        public static final int CONNECTING = 0;
        public static final int CONNECTED = 1;
        public static final int DISCONNECTED = 2;
        public static final int RECONNECTING = 3;
        public static final int FLUSHING = 4;
        NIClientConnectionToken token;
        NIClientConnection clientConnection;
        NIClientDisconnection clientDisconnection;
        NIClientCommunicationExecutor executor;
        int state;

        public NICCB(NIClientConnectionToken nIClientConnectionToken, NIClientConnection nIClientConnection) {
            this.token = nIClientConnectionToken;
            this.clientConnection = nIClientConnection;
            this.state = 0;
        }

        public NIClientConnection getClientConnection() {
            return this.clientConnection;
        }

        public String getStateString() {
            String string = null;
            switch (this.state) {
                case 0: {
                    string = "CONNECTING";
                    break;
                }
                case 1: {
                    string = "CONNECTED";
                    break;
                }
                case 2: {
                    string = "DISCONNECTED";
                    break;
                }
                case 3: {
                    string = "RECONNECTING";
                    break;
                }
                case 4: {
                    string = "FLUSHING";
                    break;
                }
                default: {
                    string = "INVALID STATE";
                }
            }
            return string;
        }
    }
}

