/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.extensions.server;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.command.extensions.NICommandID;
import com.ibm.storage.ess.ni.communication.extensions.common.NIACKCommunication;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientUnavailableException;
import com.ibm.storage.ess.ni.communication.extensions.server.NICommunicationServer;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NITimedList;
import java.util.TreeMap;

public class NIResponseACKManager
implements Runnable {
    private Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$server$NIResponseACKManager == null ? (class$com$ibm$storage$ess$ni$communication$extensions$server$NIResponseACKManager = NIResponseACKManager.class$("com.ibm.storage.ess.ni.communication.extensions.server.NIResponseACKManager")) : class$com$ibm$storage$ess$ni$communication$extensions$server$NIResponseACKManager);
    private static final long FLOATING_ACK_TIMEOUT = 600000L;
    private TreeMap deadlineQueue;
    private TreeMap idTree;
    private Object lock = new Object();
    private boolean updated = false;
    private Thread executionThread;
    private NITimedList floatingAcks;
    private NICommunicationServer commServer;
    private static NIResponseACKManager singleton = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$server$NIResponseACKManager;

    public static NIResponseACKManager createResponseACKManager(NICommunicationServer nICommunicationServer) {
        singleton = new NIResponseACKManager(nICommunicationServer);
        return singleton;
    }

    public static NIResponseACKManager getSingleton() {
        return singleton;
    }

    private NIResponseACKManager(NICommunicationServer nICommunicationServer) {
        this.deadlineQueue = new TreeMap();
        this.idTree = new TreeMap();
        this.floatingAcks = new NITimedList();
        this.commServer = nICommunicationServer;
        this.executionThread = new Thread((Runnable)this, "NIResponseACKManager");
        this.executionThread.setDaemon(true);
        this.executionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForSend(NICommand nICommand) {
        Object object = this.lock;
        synchronized (object) {
            NICommandID nICommandID = nICommand.getID();
            long l = 0L;
            if (this.idTree.containsKey(nICommandID)) {
                NIResponseACKTask nIResponseACKTask = (NIResponseACKTask)this.idTree.get(nICommandID);
                l = nIResponseACKTask.deadline;
                if (l != 0L && this.deadlineQueue.containsKey(new Long(l))) {
                    this.deadlineQueue.remove(new Long(l));
                }
            } else {
                NIResponseACKTask nIResponseACKTask = new NIResponseACKTask(nICommand);
                this.idTree.put(nICommandID, nIResponseACKTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseSent(NICommand nICommand) {
        Object object = this.lock;
        synchronized (object) {
            NICommandID nICommandID = nICommand.getID();
            if (this.floatingAcks.contains(nICommandID)) {
                this.floatingAcks.remove(nICommandID);
                return;
            }
            long l = System.currentTimeMillis() + 25000L;
            if (this.idTree.containsKey(nICommandID)) {
                NIResponseACKTask nIResponseACKTask = (NIResponseACKTask)this.idTree.get(nICommandID);
                if (!nIResponseACKTask.acked) {
                    nIResponseACKTask.deadline = l;
                    this.deadlineQueue.put(new Long(l), nIResponseACKTask);
                    this.updated = true;
                    this.lock.notify();
                } else {
                    this.logger.debug_general("task was acked before responseSent called... doing nothing:" + nICommandID);
                }
            } else {
                this.logger.error("task was not in ID tree when responseSent called... should never happen: " + nICommandID);
            }
        }
    }

    public void responseNotSent(NICommand nICommand) {
        if (this.idTree.containsKey(nICommand.getID())) {
            this.logger.warning("cancelling task for command: " + nICommand.getID());
            this.idTree.remove(nICommand.getID());
        } else {
            this.logger.warning("trying to cancel non-existant task for: " + nICommand.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackReceived(NIACKCommunication nIACKCommunication) {
        Object object = this.lock;
        synchronized (object) {
            if (this.idTree.containsKey(nIACKCommunication.getID())) {
                NIResponseACKTask nIResponseACKTask = (NIResponseACKTask)this.idTree.remove(nIACKCommunication.getID());
                nIResponseACKTask.acked = true;
                Long l = new Long(nIResponseACKTask.deadline);
                if (this.deadlineQueue.containsKey(l)) {
                    this.deadlineQueue.remove(l);
                } else {
                    this.floatingAcks.add(nIACKCommunication.getID(), 600000L);
                }
            } else {
                this.logger.debug_general("no task for " + nIACKCommunication.getID() + " must have already been acked");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                while (!this.deadlineQueue.isEmpty()) {
                    Long l = (Long)this.deadlineQueue.firstKey();
                    NIResponseACKTask nIResponseACKTask = (NIResponseACKTask)this.deadlineQueue.get(l);
                    long l2 = l - System.currentTimeMillis();
                    try {
                        if (l2 > 0L) {
                            this.lock.wait(l2);
                        }
                        if (this.updated) {
                            this.updated = false;
                            continue;
                        }
                        if (!nIResponseACKTask.acked) {
                            this.logger.debug_general("no ack received for " + nIResponseACKTask.response + "... resending");
                            try {
                                this.deadlineQueue.remove(l);
                                this.commServer.send(nIResponseACKTask.id.getClientID(), nIResponseACKTask.response);
                            }
                            catch (NIUnsupportedException nIUnsupportedException) {
                                this.logger.error("unsupported exception when trying to redrive response: " + nIResponseACKTask.response);
                                this.logger.throwable((Throwable)nIUnsupportedException);
                            }
                            catch (NIClientUnavailableException nIClientUnavailableException) {
                                this.logger.error("client unavailable exception when trying to redrive response: " + nIResponseACKTask.response);
                                this.logger.throwable((Throwable)nIClientUnavailableException);
                            }
                            continue;
                        }
                        if (!this.deadlineQueue.containsKey(l)) continue;
                        this.deadlineQueue.remove(l);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.error("interrupted exception caught");
                        this.logger.throwable((Throwable)interruptedException);
                    }
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.logger.error("interrupted while waiting for tasks... ignoring");
                    this.logger.throwable((Throwable)interruptedException);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NIResponseACKTask {
        private boolean acked;
        private NICommand response;
        private NICommandID id;
        private long deadline;

        private NIResponseACKTask(NICommand nICommand) {
            this.response = nICommand;
            this.id = this.response.getID();
            this.acked = false;
        }
    }
}

