/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.csa;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.results.NICandidateConnectionResult;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NICopyServicesQueryResult;
import com.ibm.storage.ess.ni.application.results.NIFCPCandidateConnection;
import com.ibm.storage.ess.ni.application.results.NIFlashCopyAttribute;
import com.ibm.storage.ess.ni.application.results.NILogicalPPRCPath;
import com.ibm.storage.ess.ni.application.results.NILogicalPPRCPathData;
import com.ibm.storage.ess.ni.application.results.NILogicalPathQueryResult;
import com.ibm.storage.ess.ni.application.results.NIPPRCAttribute;
import com.ibm.storage.ess.ni.application.results.NIPPRCCandidateConnection;
import com.ibm.storage.ess.ni.application.results.NIRelationship;
import com.ibm.storage.ess.ni.application.results.NIXDCSessionInfo;
import com.ibm.storage.ess.ni.application.results.NIXDCSessionStatus;
import com.ibm.storage.ess.ni.csa.NIOptionsValidator;
import com.ibm.storage.ess.ni.csa.NIValidateResult;
import com.ibm.storage.ess.ni.exception.NIConnectionCSAException;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCSAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCSAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCSAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIFCPPortID;
import com.ibm.storage.ess.ni.identifiers.NIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIResourceIDPair;
import com.ibm.storage.ess.ni.identifiers.NISessionID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.NIFlashCopyEstablish;
import com.ibm.storage.ess.ni.option.NIFlashCopyWithdraw;
import com.ibm.storage.ess.ni.option.NIOption;
import com.ibm.storage.ess.ni.option.NIPPRCEstablish;
import com.ibm.storage.ess.ni.option.NIPPRCEstablishPath;
import com.ibm.storage.ess.ni.option.NIPPRCRemovePath;
import com.ibm.storage.ess.ni.option.NIPPRCSuspend;
import com.ibm.storage.ess.ni.option.NIPPRCTerminate;
import com.ibm.storage.ess.ni.option.NIXDCQuerySession;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.results.NIFCPCandidateConnectionImpl;
import com.ibm.storage.ess.ni.services.NIAsyncPPRCService;
import com.ibm.storage.ess.ni.services.NIDomainService;
import com.ibm.storage.ess.ni.services.NIFlashCopyService;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import com.ibm.storage.ess.ni.services.NIPPRCService;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;

public class NICopyServicesAdvisor
implements NIOptionsValidator {
    private static final String CLASS_NAME = "NICopyServicesAdvisor";
    private static final String CONNECTION_PROBLEM = "Cannot get the needed services";
    private static final String NULL_PARAMETER = "Null Parameter";
    private static final String NULL_ELEMENT_IN_ARRAY = "Null Element in Options Array";
    private static final String INVALID_VOLUME = "Invalid Volume";
    private static final String LOCAL_PORT_NOT_FCP = "Local Port is not a FCP Port";
    private static final short FLASHCOPY_SOURCE_MAX = 12;
    private static final int PPRC_PATH_MAX_AVAILABLE_CONNECTION_2107 = 8;
    private static final int PPRC_PATH_MAX_AVAILABLE_TARGET_LSS_2107 = 4;
    private static final int MIN_SESSION_NUM = 1;
    private static final int MAX_SESSION_NUM = 255;
    private NIServices services = null;
    private NIDomainService domainService = null;
    private NILogicalConfigurationService logicalService = null;
    private NIFlashCopyService flashCopyService = null;
    private NIPPRCService pprcService = null;
    private NIAsyncPPRCService asyncPprcService = null;
    private NIPhysicalConfigurationService physicalConfigService = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$csa$NICopyServicesAdvisor == null ? (class$com$ibm$storage$ess$ni$csa$NICopyServicesAdvisor = NICopyServicesAdvisor.class$("com.ibm.storage.ess.ni.csa.NICopyServicesAdvisor")) : class$com$ibm$storage$ess$ni$csa$NICopyServicesAdvisor);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$csa$NICopyServicesAdvisor;

    public NICopyServicesAdvisor(NIServices nIServices) throws NIParameterInvalidCSAException, NIConnectionCSAException {
        this.services = nIServices;
        if (this.services == null) {
            throw new NIParameterInvalidCSAException(this.services, NULL_PARAMETER);
        }
        this.logicalService = this.services.getLogicalConfigurationService();
        this.flashCopyService = this.services.getFlashCopyService();
        this.pprcService = this.services.getPPRCService();
        this.asyncPprcService = this.services.getAsyncPPRCService();
        this.physicalConfigService = this.services.getPhysicalConfigurationService();
        if (this.logicalService == null || this.flashCopyService == null || this.pprcService == null || this.asyncPprcService == null || this.physicalConfigService == null) {
            throw new NIConnectionCSAException(this.services, CONNECTION_PROBLEM);
        }
    }

    public List getFlashCopyCandidateSourceVolumes(List list) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        NIVolumeID nIVolumeID = null;
        NIVolumeID nIVolumeID2 = null;
        NIVolume nIVolume = null;
        NIVolume nIVolume2 = null;
        Object var6_6 = null;
        NICopyServicesQueryResult nICopyServicesQueryResult = null;
        Object var13_8 = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector<NIResourceID> vector3 = new Vector<NIResourceID>();
        List list2 = new Vector();
        int n = 0;
        this.flashCopyService = this.services.getFlashCopyService();
        if (this.flashCopyService == null) {
            logger.error("Flash Copy Service is null.");
            throw new NIConnectionCSAException(this.services, CONNECTION_PROBLEM);
        }
        if (list == null) {
            logger.error("volList is null.");
            throw new NIParameterInvalidCSAException(list, NULL_PARAMETER);
        }
        vector2 = (Vector)((Vector)list).clone();
        this.filterAliasVolumes(vector2);
        this.sortVolList(vector2);
        nIVolume = (NIVolume)vector2.get(0);
        int n2 = 1;
        while (n2 < vector2.size()) {
            nIVolume2 = (NIVolume)vector2.get(vector2.indexOf(nIVolume) + 1);
            NILSSID nILSSID = ((NIVolumeID)nIVolume.getID()).getLSS();
            while (nILSSID.equals(((NIVolumeID)nIVolume2.getID()).getLSS()) && n2 < vector2.size()) {
                nIVolume2 = (NIVolume)vector2.get(n2++);
            }
            list2 = n2 == vector2.size() ? vector2.subList(vector2.indexOf(nIVolume), vector2.indexOf(nIVolume2) + 1) : vector2.subList(vector2.indexOf(nIVolume), vector2.indexOf(nIVolume2));
            try {
                int n3 = list2.size() - 1;
                nIVolumeID = (NIVolumeID)((NIVolume)list2.get(0)).getID();
                if (!nIVolumeID.isValid()) {
                    throw new NIParameterInvalidCSAException(nIVolume, INVALID_VOLUME);
                }
                nIVolumeID2 = (NIVolumeID)((NIVolume)list2.get(n3)).getID();
                if (!nIVolumeID2.isValid()) {
                    throw new NIParameterInvalidCSAException(nIVolume2, INVALID_VOLUME);
                }
                nICopyServicesQueryResult = this.flashCopyService.queryRelationship(nIVolumeID, nIVolumeID2);
                if (!nICopyServicesQueryResult.isSuccessful()) {
                    logger.error("Flash Copy Query Failure: rc= 0x" + Integer.toHexString(nICopyServicesQueryResult.getCode()));
                }
                vector = nICopyServicesQueryResult.getRelationshipList();
            }
            catch (Exception exception) {
                logger.error("Flash Copy Query Exception " + exception);
                throw new NIQueryFailureCSAException("Flash Copy Query Failure ");
            }
            vector3 = new Vector();
            Iterator iterator = list2.iterator();
            block8: while (iterator.hasNext()) {
                NIResourceID nIResourceID;
                Object object;
                NIResourceID nIResourceID2 = ((NIVolume)iterator.next()).getID();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (NIRelationship)enumeration.nextElement();
                    nIResourceID = object.getResourcePair().getSource();
                    NIResourceID nIResourceID3 = object.getResourcePair().getTarget();
                    n = 0;
                    if (!nIResourceID2.equals(nIResourceID3) || vector3.contains(nIResourceID2) || !((NIFlashCopyAttribute)object.getAttributes()).isSource()) continue;
                    try {
                        iterator.remove();
                        vector3.add(nIResourceID2);
                    }
                    catch (Exception exception) {
                        logger.error("error removing vol from list. (target) " + exception);
                    }
                }
                if (vector.size() < 12) continue;
                n = 0;
                object = vector.elements();
                while (object.hasMoreElements()) {
                    NIRelationship nIRelationship = (NIRelationship)object.nextElement();
                    nIResourceID = nIRelationship.getResourcePair().getSource();
                    if (!nIResourceID2.equals(nIResourceID) || vector3.contains(nIResourceID2) || ++n != 12) continue;
                    try {
                        iterator.remove();
                        vector3.add(nIResourceID2);
                        continue block8;
                    }
                    catch (Exception exception) {
                        logger.error("error removing vol from list. (source) " + exception);
                    }
                }
            }
            nIVolume = nIVolume2;
            int n4 = vector2.indexOf(nIVolume);
            if (n4 != -1) {
                n2 = n4;
            }
            ++n2;
        }
        return vector2;
    }

    public List getFlashCopyCandidateTargetVolumes(List list) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        NICopyServicesQueryResult nICopyServicesQueryResult = null;
        NICopyServicesQueryResult nICopyServicesQueryResult2 = null;
        Object var4_4 = null;
        NIVolumeID nIVolumeID = null;
        NIVolumeID nIVolumeID2 = null;
        NIVolume nIVolume = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Object var15_10 = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.flashCopyService = this.services.getFlashCopyService();
        this.pprcService = this.services.getPPRCService();
        if (this.flashCopyService == null || this.pprcService == null) {
            throw new NIConnectionCSAException(this.services, CONNECTION_PROBLEM);
        }
        if (list == null || list.size() == 0) {
            logger.error("volList is null.");
            throw new NIParameterInvalidCSAException(list, NULL_PARAMETER);
        }
        this.filterAliasVolumes(list);
        this.sortVolList(list);
        int n = 0;
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        while (n < list.size()) {
            nIVolume = (NIVolume)list.get(n);
            NILSSID nILSSID = ((NIVolumeID)nIVolume.getID()).getLSS();
            int n2 = n;
            while (n2 < list.size()) {
                if (!((NIVolumeID)((NIVolume)list.get(n2)).getID()).getLSS().equals(nILSSID)) break;
                vector4.add(list.get(n2));
                ++n;
                ++n2;
            }
            if (!(nIVolumeID = (NIVolumeID)nIVolume.getID()).isValid()) {
                throw new NIParameterInvalidCSAException(nIVolume, INVALID_VOLUME);
            }
            nIVolumeID2 = (NIVolumeID)((NIVolume)list.get(n - 1)).getID();
            if (!nIVolumeID2.isValid()) {
                throw new NIParameterInvalidCSAException(var8_8, INVALID_VOLUME);
            }
            try {
                nICopyServicesQueryResult = this.flashCopyService.queryRelationship(nIVolumeID, nIVolumeID2);
                nICopyServicesQueryResult2 = this.pprcService.queryRelationship(nIVolumeID, nIVolumeID2);
                if (!nICopyServicesQueryResult.isSuccessful()) {
                    logger.error("Flash Copy Query Failure: rc= 0x" + Integer.toHexString(nICopyServicesQueryResult.getCode()));
                }
                if (!nICopyServicesQueryResult2.isSuccessful()) {
                    logger.error("PPRC Query Failure: rc= 0x" + Integer.toHexString(nICopyServicesQueryResult2.getCode()));
                }
                vector = nICopyServicesQueryResult2.getRelationshipList();
                vector2 = nICopyServicesQueryResult.getRelationshipList();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.error("Flash Copy/PPRC Query Exception " + exception);
                throw new NIQueryFailureCSAException("Flash Copy/PPRC Query Failure ");
            }
            int n3 = 0;
            while (n3 < vector4.size()) {
                NIResourceID nIResourceID;
                NIResourceID nIResourceID2;
                NIResourceID nIResourceID3 = ((NIVolume)vector4.get(n3)).getID();
                boolean bl = true;
                int n4 = 0;
                while (n4 < vector.size()) {
                    NIRelationship nIRelationship = (NIRelationship)vector.get(n4);
                    nIResourceID2 = nIRelationship.getResourcePair().getSource();
                    nIResourceID = nIRelationship.getResourcePair().getTarget();
                    if (nIResourceID3.equals(nIResourceID)) {
                        bl = false;
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < vector2.size()) {
                    NIRelationship nIRelationship = (NIRelationship)vector2.get(n5);
                    nIResourceID2 = nIRelationship.getResourcePair().getSource();
                    nIResourceID = nIRelationship.getResourcePair().getTarget();
                    if (nIResourceID3.equals(nIResourceID2) || nIResourceID3.equals(nIResourceID)) {
                        bl = false;
                    }
                    ++n5;
                }
                if (bl && !vector5.contains(vector4.get(n3))) {
                    vector5.add(vector4.get(n3));
                }
                ++n3;
            }
            vector4.removeAllElements();
        }
        return vector5;
    }

    public NIValidateResult[] validateFlashCopyEstablish(NIResourceIDPair[] nIResourceIDPairArray, NIFlashCopyEstablish[] nIFlashCopyEstablishArray) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (nIResourceIDPairArray == null) {
            throw new NIParameterInvalidCSAException(nIResourceIDPairArray, NULL_PARAMETER);
        }
        if (nIFlashCopyEstablishArray == null) {
            throw new NIParameterInvalidCSAException(nIFlashCopyEstablishArray, NULL_PARAMETER);
        }
        if (this.containsNullElement(nIFlashCopyEstablishArray)) {
            throw new NIParameterInvalidCSAException(nIFlashCopyEstablishArray, NULL_ELEMENT_IN_ARRAY);
        }
        NIValidateResult[] nIValidateResultArray = new NIValidateResult[nIResourceIDPairArray.length];
        NIResourceIDPair nIResourceIDPair = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nIResourceIDPairArray.length) {
            nIResourceIDPair = nIResourceIDPairArray[n4];
            n = 0;
            n2 = 0;
            n3 = 0;
            int n5 = 0;
            while (n5 < nIFlashCopyEstablishArray.length) {
                n |= nIFlashCopyEstablishArray[n5].getValue();
                n2 |= nIFlashCopyEstablishArray[n5].getRequired();
                n3 |= nIFlashCopyEstablishArray[n5].getDisallowed();
                ++n5;
            }
            nIValidateResultArray[n4] = (n & n2) == n2 && (n & n3) == 0 ? new NIValidateResult(NIValidateResult.VALID_COMBINATION) : new NIValidateResult(NIValidateResult.INVALID_OPTIONS);
            ++n4;
        }
        return nIValidateResultArray;
    }

    public NIValidateResult[] validateFlashCopyEstablishOverPPRCLink(NILSSID nILSSID, NIResourceIDPair[] nIResourceIDPairArray, NIFlashCopyEstablish[] nIFlashCopyEstablishArray, int n) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (nIResourceIDPairArray == null) {
            throw new NIParameterInvalidCSAException(nIResourceIDPairArray, NULL_PARAMETER);
        }
        if (nIFlashCopyEstablishArray == null) {
            throw new NIParameterInvalidCSAException(nIFlashCopyEstablishArray, NULL_PARAMETER);
        }
        if (this.containsNullElement(nIFlashCopyEstablishArray)) {
            throw new NIParameterInvalidCSAException(nIFlashCopyEstablishArray, NULL_ELEMENT_IN_ARRAY);
        }
        if (nILSSID == null) {
            throw new NIParameterInvalidCSAException(nILSSID, NULL_PARAMETER);
        }
        NIValidateResult[] nIValidateResultArray = new NIValidateResult[nIResourceIDPairArray.length];
        NIResourceIDPair nIResourceIDPair = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < nIResourceIDPairArray.length) {
            nIResourceIDPair = nIResourceIDPairArray[n5];
            n2 = 0;
            n3 = 0;
            n4 = 0;
            int n6 = 0;
            while (n6 < nIFlashCopyEstablishArray.length) {
                n2 |= nIFlashCopyEstablishArray[n6].getValue();
                n3 |= nIFlashCopyEstablishArray[n6].getRequired();
                n4 |= nIFlashCopyEstablishArray[n6].getDisallowed();
                ++n6;
            }
            nIValidateResultArray[n5] = (n2 & n3) == n3 && (n2 & n4) == 0 ? new NIValidateResult(NIValidateResult.VALID_COMBINATION) : new NIValidateResult(NIValidateResult.INVALID_OPTIONS);
            ++n5;
        }
        return nIValidateResultArray;
    }

    public NIValidateResult[] validateFlashCopyWithdraw(NIResourceIDPair[] nIResourceIDPairArray, NIFlashCopyWithdraw[] nIFlashCopyWithdrawArray, int n) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (nIResourceIDPairArray == null) {
            throw new NIParameterInvalidCSAException(nIResourceIDPairArray, NULL_PARAMETER);
        }
        if (nIFlashCopyWithdrawArray == null) {
            throw new NIParameterInvalidCSAException(nIFlashCopyWithdrawArray, NULL_PARAMETER);
        }
        if (this.containsNullElement(nIFlashCopyWithdrawArray)) {
            throw new NIParameterInvalidCSAException(nIFlashCopyWithdrawArray, NULL_ELEMENT_IN_ARRAY);
        }
        NIValidateResult[] nIValidateResultArray = new NIValidateResult[nIResourceIDPairArray.length];
        NIResourceIDPair nIResourceIDPair = null;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nIFlashCopyWithdrawArray.length) {
            n2 |= nIFlashCopyWithdrawArray[n3].getValue();
            ++n3;
        }
        int n4 = 0;
        while (n4 < NIOptionsValidator.validFlashCopyWithdrawOptions.length) {
            if (n2 == NIOptionsValidator.validFlashCopyWithdrawOptions[n4]) {
                bl = true;
            }
            ++n4;
        }
        if (bl) {
            int n5 = 0;
            while (n5 < nIResourceIDPairArray.length) {
                nIResourceIDPair = nIResourceIDPairArray[n5];
                nIValidateResultArray[n5] = new NIValidateResult(NIValidateResult.VALID_COMBINATION);
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < nIValidateResultArray.length) {
                nIValidateResultArray[n6] = new NIValidateResult(NIValidateResult.INVALID_OPTIONS);
                ++n6;
            }
        }
        return nIValidateResultArray;
    }

    public NIValidateResult[] validateFlashCopyWithdrawOverPPRCLink(NILSSID nILSSID, NIResourceIDPair[] nIResourceIDPairArray, NIFlashCopyWithdraw[] nIFlashCopyWithdrawArray, int n) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (nIResourceIDPairArray == null) {
            throw new NIParameterInvalidCSAException(nIResourceIDPairArray, NULL_PARAMETER);
        }
        if (nIFlashCopyWithdrawArray == null) {
            throw new NIParameterInvalidCSAException(nIFlashCopyWithdrawArray, NULL_PARAMETER);
        }
        if (this.containsNullElement(nIFlashCopyWithdrawArray)) {
            throw new NIParameterInvalidCSAException(nIFlashCopyWithdrawArray, NULL_ELEMENT_IN_ARRAY);
        }
        if (nILSSID == null) {
            throw new NIParameterInvalidCSAException(nILSSID, NULL_PARAMETER);
        }
        NIValidateResult[] nIValidateResultArray = new NIValidateResult[nIResourceIDPairArray.length];
        NIResourceIDPair nIResourceIDPair = null;
        Object var7_7 = null;
        Object var8_8 = null;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nIFlashCopyWithdrawArray.length) {
            n2 |= nIFlashCopyWithdrawArray[n3].getValue();
            ++n3;
        }
        int n4 = 0;
        while (n4 < NIOptionsValidator.validFlashCopyWithdrawOptions.length) {
            if (n2 == NIOptionsValidator.validFlashCopyWithdrawOptions[n4]) {
                bl = true;
            }
            ++n4;
        }
        if (bl) {
            int n5 = 0;
            while (n5 < nIResourceIDPairArray.length) {
                nIResourceIDPair = nIResourceIDPairArray[n5];
                nIValidateResultArray[n5] = new NIValidateResult(NIValidateResult.VALID_COMBINATION);
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < nIValidateResultArray.length) {
                nIValidateResultArray[n6] = new NIValidateResult(NIValidateResult.INVALID_OPTIONS);
                ++n6;
            }
        }
        return nIValidateResultArray;
    }

    public List getPPRCCandidateSourceLSSs(List list) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (list == null) {
            logger.error("lssIdList is null.");
            throw new NIParameterInvalidCSAException(list, NULL_PARAMETER);
        }
        NILSSID[] nILSSIDArray = new NILSSID[list.size()];
        int n = 0;
        while (n < list.size()) {
            nILSSIDArray[n] = (NILSSID)list.get(n);
            ++n;
        }
        Vector vector = null;
        Vector vector2 = new Vector();
        vector2 = (Vector)((Vector)list).clone();
        try {
            NILogicalPathQueryResult nILogicalPathQueryResult = this.pprcService.queryPPRCPath(nILSSIDArray);
            if (!nILogicalPathQueryResult.isSuccessful()) {
                logger.error("PPRC Path Query Failure: rc= 0x" + Integer.toHexString(nILogicalPathQueryResult.getCode()));
            }
            vector = nILogicalPathQueryResult.getLogicalPPRCPaths();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error("PPRC Query Exception " + exception);
            throw new NIQueryFailureCSAException("PPRC Query Failure ");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NILSSID nILSSID = (NILSSID)iterator.next();
            boolean bl = false;
            boolean bl2 = false;
            int n2 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                NILogicalPPRCPath nILogicalPPRCPath = (NILogicalPPRCPath)enumeration.nextElement();
                NILSSID nILSSID2 = (NILSSID)nILogicalPPRCPath.getResourcePair().getSource();
                NILSSID nILSSID3 = (NILSSID)nILogicalPPRCPath.getResourcePair().getTarget();
                NIDeviceType nIDeviceType = this.getLSSType(nILSSID3);
                NIDeviceType nIDeviceType2 = this.getLSSType(nILSSID2);
                if (nILSSID.equals(nILSSID2)) {
                    bl = true;
                }
                if (!nILSSID.equals(nILSSID3)) continue;
                ++n2;
                if (nIDeviceType.equals(nIDeviceType2)) continue;
                --n2;
                bl2 = true;
            }
            if (!bl && (!bl2 || n2 != 0)) continue;
            vector2.remove(nILSSID);
        }
        return vector2;
    }

    public List getPPRCCandidateSourceVolumes(List list) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (list == null) {
            logger.error("volList is null.");
            throw new NIParameterInvalidCSAException(list, NULL_PARAMETER);
        }
        NICopyServicesQueryResult nICopyServicesQueryResult = null;
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = new Vector();
        vector3 = (Vector)((Vector)list).clone();
        this.filterAliasVolumes(vector3);
        Vector vector4 = this.getLSSsublists(vector3);
        int n = 0;
        while (n < vector4.size()) {
            vector2 = (Vector)vector4.elementAt(n);
            NIVolumeID nIVolumeID = (NIVolumeID)((NIVolume)vector2.firstElement()).getID();
            NIVolumeID nIVolumeID2 = (NIVolumeID)((NIVolume)vector2.lastElement()).getID();
            try {
                nICopyServicesQueryResult = this.pprcService.queryRelationship(nIVolumeID, nIVolumeID2);
                if (!nICopyServicesQueryResult.isSuccessful()) {
                    logger.error("PPRC Query Failure: rc= 0x" + Integer.toHexString(nICopyServicesQueryResult.getCode()));
                }
                vector = nICopyServicesQueryResult.getRelationshipList();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.error("PPRC Query Exception " + exception);
                throw new NIQueryFailureCSAException("PPRC Query Failure ");
            }
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                NIVolume nIVolume = (NIVolume)enumeration.nextElement();
                NIVolumeID nIVolumeID3 = (NIVolumeID)nIVolume.getID();
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    NIRelationship nIRelationship = (NIRelationship)enumeration2.nextElement();
                    NIVolumeID nIVolumeID4 = (NIVolumeID)nIRelationship.getResourcePair().getTarget();
                    NIVolumeID nIVolumeID5 = (NIVolumeID)nIRelationship.getResourcePair().getSource();
                    if (!nIVolumeID3.equals(nIVolumeID4) && !nIVolumeID3.equals(nIVolumeID5)) continue;
                    vector3.remove(nIVolume);
                }
            }
            ++n;
        }
        return vector3;
    }

    public List getPPRCCandidateTargetLSSs(List list, NILSSID nILSSID) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (list == null) {
            logger.error("lssIdList is null.");
            throw new NIParameterInvalidCSAException(list, NULL_PARAMETER);
        }
        if (nILSSID == null) {
            logger.error("sourceLss is null.");
            throw new NIParameterInvalidCSAException(nILSSID, NULL_PARAMETER);
        }
        NILSSID[] nILSSIDArray = new NILSSID[1];
        Vector vector = null;
        Vector<NILSSID> vector2 = new Vector<NILSSID>();
        nILSSIDArray[0] = nILSSID;
        try {
            NILogicalPathQueryResult nILogicalPathQueryResult = this.pprcService.queryPPRCPath(nILSSIDArray);
            if (!nILogicalPathQueryResult.isSuccessful()) {
                logger.error("PPRC Path Query Failure: rc= 0x" + Integer.toHexString(nILogicalPathQueryResult.getCode()));
            }
            vector = nILogicalPathQueryResult.getLogicalPPRCPaths();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error("PPRC Query Exception " + exception);
            throw new NIQueryFailureCSAException("PPRC Query Failure ");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NILSSID nILSSID2 = (NILSSID)iterator.next();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                NILogicalPPRCPath nILogicalPPRCPath = (NILogicalPPRCPath)enumeration.nextElement();
                NILSSID nILSSID3 = (NILSSID)nILogicalPPRCPath.getResourcePair().getTarget();
                NIDeviceType nIDeviceType = this.getLSSType(nILSSID3);
                NIDeviceType nIDeviceType2 = this.getLSSType(nILSSID);
                if (nILSSID3.getLSSNumber() != nILSSID2.getLSSNumber() || !nIDeviceType.equals(nIDeviceType2)) continue;
                vector2.add(nILSSID2);
            }
        }
        return vector2;
    }

    public List getPPRCCandidateTargetVolumes(List list) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (list == null) {
            logger.error("volList is null.");
            throw new NIParameterInvalidCSAException(list, NULL_PARAMETER);
        }
        NIVolume nIVolume = null;
        NICopyServicesQueryResult nICopyServicesQueryResult = null;
        NICopyServicesQueryResult nICopyServicesQueryResult2 = null;
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = new Vector();
        vector4 = (Vector)((Vector)list).clone();
        this.filterAliasVolumes(vector4);
        Vector vector5 = this.getLSSsublists(vector4);
        int n = 0;
        while (n < vector5.size()) {
            vector3 = (Vector)vector5.elementAt(n);
            NIVolumeID nIVolumeID = (NIVolumeID)((NIVolume)vector3.firstElement()).getID();
            NIVolumeID nIVolumeID2 = (NIVolumeID)((NIVolume)vector3.lastElement()).getID();
            try {
                nICopyServicesQueryResult = this.pprcService.queryRelationship(nIVolumeID, nIVolumeID2);
                if (!nICopyServicesQueryResult.isSuccessful()) {
                    logger.error("PPRC Query Failure: rc= 0x" + Integer.toHexString(nICopyServicesQueryResult.getCode()));
                }
                if (!(nICopyServicesQueryResult2 = this.flashCopyService.queryRelationship(nIVolumeID, nIVolumeID2)).isSuccessful()) {
                    logger.error("FLC Query Failure: rc= 0x" + Integer.toHexString(nICopyServicesQueryResult2.getCode()));
                }
                vector = nICopyServicesQueryResult.getRelationshipList();
                vector2 = nICopyServicesQueryResult2.getRelationshipList();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.error("PPRC/FLC Query Exception " + exception);
                throw new NIQueryFailureCSAException("PPRC/FLC Query Failure ");
            }
            Enumeration enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                NIResourceID nIResourceID;
                Object object;
                nIVolume = (NIVolume)enumeration.nextElement();
                NIResourceID nIResourceID2 = nIVolume.getID();
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    object = (NIRelationship)enumeration2.nextElement();
                    nIResourceID = object.getResourcePair().getTarget();
                    NIResourceID nIResourceID3 = object.getResourcePair().getSource();
                    int n2 = ((NIPPRCAttribute)object.getAttributes()).isSourceCascadingEnabled();
                    if (nIResourceID2.equals(nIResourceID)) {
                        vector4.remove(nIVolume);
                    }
                    if (!nIResourceID2.equals(nIResourceID3) || n2 == 1) continue;
                    vector4.remove(nIVolume);
                }
                object = vector2.elements();
                while (object.hasMoreElements()) {
                    NIRelationship nIRelationship = (NIRelationship)object.nextElement();
                    nIResourceID = nIRelationship.getResourcePair().getTarget();
                    if (!nIResourceID2.equals(nIResourceID)) continue;
                    vector4.remove(nIVolume);
                }
            }
            ++n;
        }
        return vector4;
    }

    public NIValidateResult[] validatePPRCEstablish(NIResourceIDPair[] nIResourceIDPairArray, NIPPRCEstablish[] nIPPRCEstablishArray) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (nIResourceIDPairArray == null) {
            throw new NIParameterInvalidCSAException(nIResourceIDPairArray, NULL_PARAMETER);
        }
        if (nIPPRCEstablishArray == null) {
            throw new NIParameterInvalidCSAException(nIPPRCEstablishArray, NULL_PARAMETER);
        }
        if (this.containsNullElement(nIPPRCEstablishArray)) {
            throw new NIParameterInvalidCSAException(nIPPRCEstablishArray, NULL_ELEMENT_IN_ARRAY);
        }
        NIValidateResult[] nIValidateResultArray = new NIValidateResult[nIResourceIDPairArray.length];
        Object var4_4 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < nIPPRCEstablishArray.length) {
            n |= nIPPRCEstablishArray[n2].getValue();
            ++n2;
        }
        if (this.validateOptions(n, NIOptionsValidator.validPPRCEstablishOptions)) {
            int n3 = 0;
            while (n3 < nIValidateResultArray.length) {
                nIValidateResultArray[n3] = new NIValidateResult(NIValidateResult.VALID_COMBINATION);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < nIValidateResultArray.length) {
                nIValidateResultArray[n4] = new NIValidateResult(NIValidateResult.INVALID_OPTIONS);
                ++n4;
            }
        }
        return nIValidateResultArray;
    }

    public NIValidateResult[] validatePPRCSuspend(NIResourceIDPair[] nIResourceIDPairArray, NIPPRCSuspend[] nIPPRCSuspendArray) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (nIResourceIDPairArray == null) {
            throw new NIParameterInvalidCSAException(nIResourceIDPairArray, NULL_PARAMETER);
        }
        if (nIPPRCSuspendArray == null) {
            throw new NIParameterInvalidCSAException(nIPPRCSuspendArray, NULL_PARAMETER);
        }
        if (this.containsNullElement(nIPPRCSuspendArray)) {
            throw new NIParameterInvalidCSAException(nIPPRCSuspendArray, NULL_ELEMENT_IN_ARRAY);
        }
        NIValidateResult[] nIValidateResultArray = new NIValidateResult[nIResourceIDPairArray.length];
        Object var4_4 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < nIPPRCSuspendArray.length) {
            n |= nIPPRCSuspendArray[n2].getValue();
            ++n2;
        }
        if (this.validateOptions(n, NIOptionsValidator.validPPRCSuspendOptions)) {
            int n3 = 0;
            while (n3 < nIValidateResultArray.length) {
                nIValidateResultArray[n3] = new NIValidateResult(NIValidateResult.VALID_COMBINATION);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < nIValidateResultArray.length) {
                nIValidateResultArray[n4] = new NIValidateResult(NIValidateResult.INVALID_OPTIONS);
                ++n4;
            }
        }
        return nIValidateResultArray;
    }

    public NIValidateResult[] validatePPRCTerminate(NIResourceIDPair[] nIResourceIDPairArray, NIPPRCTerminate[] nIPPRCTerminateArray) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (nIResourceIDPairArray == null) {
            throw new NIParameterInvalidCSAException(nIResourceIDPairArray, NULL_PARAMETER);
        }
        if (nIPPRCTerminateArray == null) {
            throw new NIParameterInvalidCSAException(nIPPRCTerminateArray, NULL_PARAMETER);
        }
        if (this.containsNullElement(nIPPRCTerminateArray)) {
            throw new NIParameterInvalidCSAException(nIPPRCTerminateArray, NULL_ELEMENT_IN_ARRAY);
        }
        NIValidateResult[] nIValidateResultArray = new NIValidateResult[nIResourceIDPairArray.length];
        Object var4_4 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < nIPPRCTerminateArray.length) {
            n |= nIPPRCTerminateArray[n2].getValue();
            ++n2;
        }
        if (this.validateOptions(n, NIOptionsValidator.validPPRCTerminateOptions)) {
            int n3 = 0;
            while (n3 < nIValidateResultArray.length) {
                nIValidateResultArray[n3] = new NIValidateResult(NIValidateResult.VALID_COMBINATION);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < nIValidateResultArray.length) {
                nIValidateResultArray[n4] = new NIValidateResult(NIValidateResult.INVALID_OPTIONS);
                ++n4;
            }
        }
        return nIValidateResultArray;
    }

    public int getPPRCPathMaxAvailableConnections(NILSSID nILSSID, NILSSID nILSSID2) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        Object object;
        if (nILSSID == null || !nILSSID.isValid()) {
            throw new NIParameterInvalidCSAException(nILSSID, NULL_PARAMETER);
        }
        if (nILSSID2 == null || !nILSSID2.isValid()) {
            throw new NIParameterInvalidCSAException(nILSSID2, NULL_PARAMETER);
        }
        NILSSID[] nILSSIDArray = new NILSSID[]{nILSSID};
        int n = 0;
        int n2 = 0;
        NICandidateConnectionResult nICandidateConnectionResult = this.pprcService.queryFCPAvailableForPPRC(nILSSID, nILSSID2);
        if (nICandidateConnectionResult.isSuccessful()) {
            object = nICandidateConnectionResult.getFCPCandidates();
            n = object != null ? ((NIFCPCandidateConnection[])object).length : 0;
        } else {
            logger.error("PPRC FCP Query Failure: rc= " + nICandidateConnectionResult.getCode(), CLASS_NAME, "getPPRCPathMaxAvailableConnections", null);
            throw new NIQueryFailureCSAException("PPRC FCP Query Failure: rc= " + nICandidateConnectionResult.getCode());
        }
        if (n > 0) {
            object = this.pprcService.queryPPRCPath(nILSSIDArray);
            if (!object.isSuccessful()) {
                logger.error("PPRC Path Query Failure: rc= 0x" + Integer.toHexString(object.getCode()));
            }
            Vector vector = object.getLogicalPPRCPaths();
            int n3 = 0;
            while (n3 < vector.size()) {
                NILogicalPPRCPath nILogicalPPRCPath = (NILogicalPPRCPath)vector.elementAt(n3);
                NILSSID nILSSID3 = (NILSSID)nILogicalPPRCPath.getResourcePair().getTarget();
                String string = nILSSID3.getESS().getSequence();
                if (nILSSID3.getLSSNumber() == nILSSID2.getLSSNumber() && string.equals(nILSSID2.getESS().getSequence())) {
                    ++n2;
                }
                ++n3;
            }
        } else {
            return 0;
        }
        if (n > 8) {
            n = 8;
        }
        return n - n2;
    }

    public int getPPRCPathMaxAvailableTargetLSSs(NILSSID nILSSID) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (nILSSID == null || !nILSSID.isValid()) {
            throw new NIParameterInvalidCSAException(nILSSID, NULL_PARAMETER);
        }
        Vector<String> vector = new Vector<String>();
        NILSSID[] nILSSIDArray = new NILSSID[]{nILSSID};
        NILogicalPathQueryResult nILogicalPathQueryResult = this.pprcService.queryPPRCPath(nILSSIDArray);
        Vector vector2 = nILogicalPathQueryResult.getLogicalPPRCPaths();
        if (!nILogicalPathQueryResult.isSuccessful()) {
            logger.error("PPRC Query Failure: rc= 0x" + Integer.toHexString(nILogicalPathQueryResult.getCode()));
        }
        vector2 = nILogicalPathQueryResult.getLogicalPPRCPaths();
        int n = 0;
        while (n < vector2.size()) {
            NILogicalPPRCPath nILogicalPPRCPath = (NILogicalPPRCPath)vector2.elementAt(n);
            NILSSID nILSSID2 = (NILSSID)nILogicalPPRCPath.getResourcePair().getTarget();
            String string = nILSSID2.getESS().getSequence() + "." + nILSSID2.getLSSNumber();
            if (!vector.contains(string)) {
                vector.add(string);
            }
            ++n;
        }
        return 4 - vector.size();
    }

    public boolean validatePPRCEstablishPath(NILSSID nILSSID, NILSSID nILSSID2, NIPPRCEstablishPath[] nIPPRCEstablishPathArray, NIPPRCCandidateConnection[] nIPPRCCandidateConnectionArray) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        boolean bl = false;
        int n = 0;
        if (nIPPRCEstablishPathArray == null) {
            throw new NIParameterInvalidCSAException(nIPPRCEstablishPathArray, NULL_PARAMETER);
        }
        if (this.containsNullElement(nIPPRCEstablishPathArray)) {
            throw new NIParameterInvalidCSAException(nIPPRCEstablishPathArray, NULL_ELEMENT_IN_ARRAY);
        }
        int n2 = 0;
        while (n2 < nIPPRCEstablishPathArray.length) {
            n |= nIPPRCEstablishPathArray[n2].getValue();
            ++n2;
        }
        bl = this.validateOptions(n, NIOptionsValidator.validEstablishPathOptions);
        return bl;
    }

    public boolean validatePPRCRemovePath(NILSSID nILSSID, NILSSID nILSSID2, NIPPRCRemovePath[] nIPPRCRemovePathArray) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        boolean bl = false;
        int n = 0;
        if (nIPPRCRemovePathArray == null) {
            throw new NIParameterInvalidCSAException(nIPPRCRemovePathArray, NULL_PARAMETER);
        }
        if (this.containsNullElement(nIPPRCRemovePathArray)) {
            throw new NIParameterInvalidCSAException(nIPPRCRemovePathArray, NULL_ELEMENT_IN_ARRAY);
        }
        int n2 = 0;
        while (n2 < nIPPRCRemovePathArray.length) {
            n |= nIPPRCRemovePathArray[n2].getValue();
            ++n2;
        }
        int n3 = 0;
        while (n3 < NIOptionsValidator.validRemovePathOptions.length) {
            if (n == NIOptionsValidator.validRemovePathOptions[n3]) {
                bl = true;
            }
            ++n3;
        }
        if (bl) {
            NICandidateConnectionResult nICandidateConnectionResult = this.pprcService.queryFCPAvailableForPPRC(nILSSID, nILSSID2);
            NIFCPCandidateConnection[] nIFCPCandidateConnectionArray = nICandidateConnectionResult.getFCPCandidates();
            bl = true;
        }
        return bl;
    }

    public String mapFCPPortID(NIFCPPortID nIFCPPortID) throws NIParameterInvalidCSAException, NIUnknownCSAException {
        if (nIFCPPortID == null) {
            logger.error("fcpPort is null.");
            throw new NIParameterInvalidCSAException(nIFCPPortID, NULL_PARAMETER);
        }
        String string = null;
        int n = nIFCPPortID.getInterfaceIdentifier();
        int n2 = n & 0xF;
        int n3 = (n & 0xF0) >> 4;
        int n4 = (n & 0x1F00) >> 8;
        int n5 = n4 % 4 + 1;
        int n6 = n4 / 4 + 1;
        int n7 = n3 + 1;
        int n8 = n2 + 1;
        string = "R[" + n6 + "] " + "E[" + n5 + "] " + "C[" + n7 + "] " + "P[" + n8 + "]";
        return string;
    }

    public NIPPRCCandidateConnection[] getExistingCandidateConnections(NILSSID nILSSID, NILSSID nILSSID2) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException, NIUnsupportedException {
        NILSSID nILSSID3 = null;
        NIHostPortID nIHostPortID = null;
        NIResourceID nIResourceID = null;
        NILogicalPathQueryResult nILogicalPathQueryResult = null;
        NILogicalPPRCPath nILogicalPPRCPath = null;
        NIFCPCandidateConnectionImpl nIFCPCandidateConnectionImpl = null;
        NILogicalPPRCPathData[] nILogicalPPRCPathDataArray = new NILogicalPPRCPathData[]{};
        Vector vector = new Vector();
        Vector<NIFCPCandidateConnectionImpl> vector2 = new Vector<NIFCPCandidateConnectionImpl>();
        NILSSID[] nILSSIDArray = new NILSSID[]{nILSSID};
        nILogicalPathQueryResult = this.pprcService.queryPPRCPath(nILSSIDArray);
        if (!nILogicalPathQueryResult.isSuccessful()) {
            logger.error("PPRC Path Query Failure: rc= 0x" + Integer.toHexString(nILogicalPathQueryResult.getCode()));
        }
        vector = nILogicalPathQueryResult.getLogicalPPRCPaths();
        int n = 0;
        while (n < vector.size()) {
            nILogicalPPRCPath = (NILogicalPPRCPath)vector.elementAt(n);
            nILSSID3 = (NILSSID)nILogicalPPRCPath.getResourcePair().getTarget();
            if (nILSSID3.equals(nILSSID2)) {
                nILogicalPPRCPathDataArray = ((NILogicalPPRCPath)vector.elementAt(n)).getPPRCPathData();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < nILogicalPPRCPathDataArray.length) {
            nIHostPortID = nILogicalPPRCPathDataArray[n2].getPrimaryPortID();
            nIResourceID = nILogicalPPRCPathDataArray[n2].getSecondaryPortID();
            if (nIHostPortID instanceof NIFCPPortID && nIResourceID instanceof NIFCPPortID) {
                nIFCPCandidateConnectionImpl = new NIFCPCandidateConnectionImpl((NIFCPPortID)nIHostPortID, (NIFCPPortID)nIResourceID);
                vector2.add(nIFCPCandidateConnectionImpl);
            } else {
                logger.warning("not FCP Port - local " + nIHostPortID.getClass().getName() + ":: target " + nIResourceID.getClass().getName());
            }
            ++n2;
        }
        NIPPRCCandidateConnection[] nIPPRCCandidateConnectionArray = new NIPPRCCandidateConnection[vector2.size()];
        int n3 = 0;
        while (n3 < vector2.size()) {
            nIPPRCCandidateConnectionArray[n3] = (NIPPRCCandidateConnection)vector2.elementAt(n3);
            ++n3;
        }
        return nIPPRCCandidateConnectionArray;
    }

    public List getPathCandidateTargetLSSs(NILSSID nILSSID, NIESSID nIESSID, boolean bl) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        Serializable serializable;
        Object object;
        if (nILSSID == null || !nILSSID.isValid()) {
            throw new NIParameterInvalidCSAException(nILSSID, NULL_PARAMETER);
        }
        if (nIESSID == null) {
            throw new NIParameterInvalidCSAException(nIESSID, NULL_PARAMETER);
        }
        NILSSID[] nILSSIDArray = new NILSSID[]{nILSSID};
        NIConfigQueryResult nIConfigQueryResult = null;
        if (bl) {
            object = (NILSS)this.logicalService.getLogicalSubsystems(nILSSIDArray).getResourceList().get(0);
            serializable = object.getDeviceType();
            nIConfigQueryResult = this.logicalService.getLogicalSubsystems(nIESSID, (NIDeviceType)serializable);
        } else {
            nIConfigQueryResult = this.logicalService.getLogicalSubsystems(nIESSID);
        }
        if (!nIConfigQueryResult.isSuccessful()) {
            logger.error("get LSS Failure: rc= 0x" + Integer.toHexString(nIConfigQueryResult.getCode()));
        }
        object = nIConfigQueryResult.getResourceList();
        serializable = null;
        Vector<NIResourceID> vector = new Vector<NIResourceID>();
        int n = 0;
        while (n < object.size()) {
            serializable = (NILSS)object.get(n);
            if (serializable.getConfiguredDevices() > 0) {
                vector.add(serializable.getID());
            }
            ++n;
        }
        if (vector.size() > 0) {
            Object object2;
            int n2 = 0;
            NICandidateConnectionResult nICandidateConnectionResult = this.pprcService.queryFCPAvailableForPPRC(nILSSID, (NILSSID)vector.get(0));
            if (nICandidateConnectionResult.isSuccessful()) {
                object2 = nICandidateConnectionResult.getFCPCandidates();
                if (object2 != null) {
                    n2 = ((NIFCPCandidateConnection[])object2).length;
                    if (n2 > 8) {
                        n2 = 8;
                    }
                } else {
                    n2 = 0;
                    vector = new Vector();
                }
            } else {
                logger.error("PPRC FCP Query Failure: rc= 0x" + Integer.toHexString(nICandidateConnectionResult.getCode()));
                throw new NIQueryFailureCSAException("PPRC FCP Query Failure: rc= 0x" + Integer.toHexString(nICandidateConnectionResult.getCode()));
            }
            if (n2 > 0) {
                NILogicalPathQueryResult nILogicalPathQueryResult = this.pprcService.queryPPRCPath(nILSSIDArray);
                object2 = nILogicalPathQueryResult.getLogicalPPRCPaths();
                if (!nILogicalPathQueryResult.isSuccessful()) {
                    logger.error("PPRC Query Failure: rc= 0x" + Integer.toHexString(nILogicalPathQueryResult.getCode()));
                }
                object2 = nILogicalPathQueryResult.getLogicalPPRCPaths();
                NILSSID nILSSID2 = null;
                LinkedList linkedList = null;
                TreeMap treeMap = new TreeMap();
                int n3 = 0;
                while (n3 < ((Vector)object2).size()) {
                    NILogicalPPRCPath nILogicalPPRCPath = (NILogicalPPRCPath)((Vector)object2).elementAt(n3);
                    nILSSID2 = (NILSSID)nILogicalPPRCPath.getResourcePair().getTarget();
                    if (!treeMap.containsKey(nILSSID2)) {
                        treeMap.put(nILSSID2, new LinkedList());
                    }
                    linkedList = (LinkedList)treeMap.get(nILSSID2);
                    linkedList.add(nILogicalPPRCPath);
                    ++n3;
                }
                int n4 = vector.size() - 1;
                while (n4 >= 0) {
                    nILSSID2 = (NILSSID)vector.get(n4);
                    linkedList = (LinkedList)treeMap.get(nILSSID2);
                    if (linkedList != null && n2 - linkedList.size() <= 0) {
                        vector.remove(n4);
                    }
                    --n4;
                }
            } else {
                logger.warning("No FCP connection.");
            }
        }
        return vector;
    }

    public List getPathCandidateTargetLSSs(NILSSID nILSSID, NILSS[] nILSSArray, boolean bl) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        Object object;
        if (nILSSID == null || !nILSSID.isValid()) {
            throw new NIParameterInvalidCSAException(nILSSID, NULL_PARAMETER);
        }
        if (nILSSArray == null) {
            throw new NIParameterInvalidCSAException(nILSSArray, NULL_PARAMETER);
        }
        NILSSID[] nILSSIDArray = new NILSSID[]{nILSSID};
        Vector<NILSS> vector = new Vector<NILSS>();
        NILSS nILSS = null;
        NIESSID nIESSID = nILSSArray[0].getID().getESS();
        if (bl) {
            NILSS nILSS2 = (NILSS)this.logicalService.getLogicalSubsystems(nILSSIDArray).getResourceList().get(0);
            object = nILSS2.getDeviceType();
            int n = 0;
            while (n < nILSSArray.length) {
                nILSS = nILSSArray[n];
                if (nILSSArray[n].getID().getESS().equals(nIESSID)) {
                    if (nILSS.getConfiguredDevices() > 0 && nILSS.getDeviceType().equals(object)) {
                        vector.add(nILSS);
                    }
                } else {
                    throw new NIParameterInvalidCSAException(nILSS, "Not all LSSs on the same ESS.");
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < nILSSArray.length) {
                nILSS = nILSSArray[n];
                if (nILSSArray[n].getID().getESS().equals(nIESSID)) {
                    if (nILSS.getConfiguredDevices() > 0) {
                        vector.add(nILSS);
                    }
                } else {
                    throw new NIParameterInvalidCSAException(nILSS, "Not all LSSs on the same ESS.");
                }
                ++n;
            }
        }
        if (vector.size() > 0) {
            Object object2;
            int n = 0;
            object = this.pprcService.queryFCPAvailableForPPRC(nILSSID, (NILSSID)((NILSS)vector.get(0)).getID());
            if (object.isSuccessful()) {
                object2 = object.getFCPCandidates();
                if (object2 != null) {
                    n = ((NIFCPCandidateConnection[])object2).length;
                    if (n > 8) {
                        n = 8;
                    }
                } else {
                    n = 0;
                    vector = new Vector();
                }
            } else {
                logger.error("PPRC FCP Query Failure: rc= 0x" + Integer.toHexString(object.getCode()));
                throw new NIQueryFailureCSAException("PPRC FCP Query Failure: rc= 0x" + Integer.toHexString(object.getCode()));
            }
            if (n > 0) {
                NILogicalPathQueryResult nILogicalPathQueryResult = this.pprcService.queryPPRCPath(nILSSIDArray);
                object2 = nILogicalPathQueryResult.getLogicalPPRCPaths();
                if (!nILogicalPathQueryResult.isSuccessful()) {
                    logger.error("PPRC Query Failure: rc= 0x" + Integer.toHexString(nILogicalPathQueryResult.getCode()));
                }
                object2 = nILogicalPathQueryResult.getLogicalPPRCPaths();
                LinkedList linkedList = null;
                TreeMap treeMap = new TreeMap();
                NILSSID nILSSID2 = null;
                int n2 = 0;
                while (n2 < ((Vector)object2).size()) {
                    NILogicalPPRCPath nILogicalPPRCPath = (NILogicalPPRCPath)((Vector)object2).elementAt(n2);
                    nILSSID2 = (NILSSID)nILogicalPPRCPath.getResourcePair().getTarget();
                    if (!treeMap.containsKey(nILSSID2)) {
                        treeMap.put(nILSSID2, new LinkedList());
                    }
                    linkedList = (LinkedList)treeMap.get(nILSSID2);
                    linkedList.add(nILogicalPPRCPath);
                    ++n2;
                }
                int n3 = vector.size() - 1;
                while (n3 >= 0) {
                    nILSSID2 = (NILSSID)((NILSS)vector.get(n3)).getID();
                    linkedList = (LinkedList)treeMap.get(nILSSID2);
                    if (linkedList != null && n - linkedList.size() <= 0) {
                        vector.remove(n3);
                    }
                    --n3;
                }
            } else {
                logger.warning("No FCP connection.");
            }
        }
        return vector;
    }

    public NIValidateResult[] validateAsyncPPRC(NIResourceIDPair[] nIResourceIDPairArray, NIPPRCEstablish[] nIPPRCEstablishArray) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (nIResourceIDPairArray == null) {
            throw new NIParameterInvalidCSAException(nIResourceIDPairArray, NULL_PARAMETER);
        }
        if (nIPPRCEstablishArray == null) {
            throw new NIParameterInvalidCSAException(nIPPRCEstablishArray, NULL_PARAMETER);
        }
        if (this.containsNullElement(nIPPRCEstablishArray)) {
            throw new NIParameterInvalidCSAException(nIPPRCEstablishArray, NULL_ELEMENT_IN_ARRAY);
        }
        NIValidateResult[] nIValidateResultArray = new NIValidateResult[nIResourceIDPairArray.length];
        Object var4_4 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < nIPPRCEstablishArray.length) {
            n |= nIPPRCEstablishArray[n2].getValue();
            ++n2;
        }
        if (this.validateOptions(n, NIOptionsValidator.validAsyncPPRCOptions)) {
            int n3 = 0;
            while (n3 < nIValidateResultArray.length) {
                nIValidateResultArray[n3] = new NIValidateResult(NIValidateResult.VALID_COMBINATION);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < nIValidateResultArray.length) {
                nIValidateResultArray[n4] = new NIValidateResult(NIValidateResult.INVALID_OPTIONS);
                ++n4;
            }
        }
        return nIValidateResultArray;
    }

    public boolean isCandidateMaster(NIESSID nIESSID, List list, List list2) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        NIConfigQueryResult nIConfigQueryResult;
        boolean[] blArray;
        boolean bl;
        NILSSID[] nILSSIDArray;
        List list3;
        Vector vector;
        block19: {
            List list4 = null;
            vector = null;
            list3 = null;
            nILSSIDArray = null;
            bl = true;
            blArray = null;
            nIConfigQueryResult = null;
            if (nIESSID == null) {
                throw new NIParameterInvalidCSAException(nIESSID, NULL_PARAMETER);
            }
            if (list == null) {
                throw new NIParameterInvalidCSAException(list, NULL_PARAMETER);
            }
            try {
                nIConfigQueryResult = this.logicalService.getLogicalSubsystems(nIESSID);
                if (nIConfigQueryResult.isSuccessful()) {
                    list4 = nIConfigQueryResult.getResourceList();
                    nILSSIDArray = new NILSSID[list4.size()];
                    int n = 0;
                    while (n < list4.size()) {
                        nILSSIDArray[n] = (NILSSID)((NILSS)list4.get(n)).getID();
                        ++n;
                    }
                    break block19;
                }
                logger.error("getLogicalSubsystems query failed rc = " + nIConfigQueryResult.getCode());
                throw new NIQueryFailureCSAException("PPRC Query Failure: rc= " + nIConfigQueryResult.getCode());
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
                logger.error("query failure; " + exception.getMessage());
                throw new NIQueryFailureCSAException("PPRC query failure");
            }
        }
        try {
            NILogicalPathQueryResult nILogicalPathQueryResult = this.pprcService.queryPPRCPath(nILSSIDArray);
            if (!nILogicalPathQueryResult.isSuccessful()) {
                list2 = null;
                logger.error("PPRC Path Query Failure: rc= 0x" + Integer.toHexString(nILogicalPathQueryResult.getCode()));
            }
            vector = nILogicalPathQueryResult.getLogicalPPRCPaths();
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            logger.error("query failure; " + exception.getMessage());
            throw new NIQueryFailureCSAException("Path Query Failure");
        }
        blArray = new boolean[list.size()];
        Arrays.fill(blArray, false);
        int n = 0;
        while (n < list.size()) {
            NIESSID nIESSID2 = (NIESSID)list.get(n);
            if (nIESSID2.equals(nIESSID)) {
                blArray[n] = true;
            } else {
                block20: {
                    try {
                        nIConfigQueryResult = this.logicalService.getLogicalSubsystems(nIESSID2);
                        if (nIConfigQueryResult.isSuccessful()) {
                            list3 = nIConfigQueryResult.getResourceList();
                            break block20;
                        }
                        logger.debug_general("getLogicalSubsystems query failed rc = " + nIConfigQueryResult.getCode());
                        throw new NIQueryFailureCSAException("PPRC Query Failure: rc= " + nIConfigQueryResult.getCode());
                    }
                    catch (Exception exception) {
                        logger.throwable((Throwable)exception);
                        logger.error("query failure; " + exception.getMessage());
                        throw new NIQueryFailureCSAException("PPRC Query Failure");
                    }
                }
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    NILogicalPPRCPath nILogicalPPRCPath = (NILogicalPPRCPath)iterator.next();
                    NILSSID nILSSID = (NILSSID)nILogicalPPRCPath.getResourcePair().getTarget();
                    NILSSID nILSSID2 = (NILSSID)nILogicalPPRCPath.getResourcePair().getSource();
                    boolean bl2 = false;
                    Iterator iterator2 = list3.iterator();
                    while (iterator2.hasNext()) {
                        NILSSID nILSSID3 = (NILSSID)((NILSS)iterator2.next()).getID();
                        if (!nILSSID.equals(nILSSID3)) continue;
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    blArray[n] = true;
                    list2.add(nILogicalPPRCPath);
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < blArray.length) {
            if (!blArray[n2]) {
                bl = false;
                list2 = null;
            }
            ++n2;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int[] getAllAvailableSessionNumbers(NIESSID[] nIESSIDArray) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        Object object;
        if (nIESSIDArray == null) {
            logger.error("images array is null.");
            throw new NIParameterInvalidCSAException(nIESSIDArray, NULL_PARAMETER);
        }
        Object var2_2 = null;
        Object var3_3 = null;
        NIESSID nIESSID = null;
        NILSS nILSS = null;
        NIConfigQueryResult nIConfigQueryResult = null;
        List list = null;
        NIXDCSessionStatus nIXDCSessionStatus = null;
        NIXDCQuerySession[] nIXDCQuerySessionArray = new NIXDCQuerySession[]{};
        boolean[] blArray = new boolean[256];
        Arrays.fill(blArray, false);
        int n = 0;
        while (n < nIESSIDArray.length) {
            nIESSID = nIESSIDArray[n];
            nIConfigQueryResult = this.logicalService.getLogicalSubsystems(nIESSID);
            if (!nIConfigQueryResult.isSuccessful()) {
                logger.error("getLogicalSubsystems Query Failure: rc= " + nIConfigQueryResult.getCode());
                throw new NIQueryFailureCSAException("getLogicalSubsystems Query Failure: rc= " + nIConfigQueryResult.getCode());
            }
            list = nIConfigQueryResult.getResourceList();
            if (list == null) {
                logger.error("getLogicalSubsystems returns null list");
                throw new NIQueryFailureCSAException("getLogicalSubsystems returns null list");
            }
            int n2 = 0;
            while (n2 < list.size()) {
                nILSS = (NILSS)list.get(n2);
                nIXDCSessionStatus = this.asyncPprcService.queryXDCSession((NILSSID)nILSS.getID(), nIXDCQuerySessionArray);
                if (!nIXDCSessionStatus.isSuccessful()) {
                    logger.error("queryXDCSession Query Failure: rc= " + nIXDCSessionStatus.getCode());
                    throw new NIQueryFailureCSAException("queryXDCSession Query Failure: rc= " + nIXDCSessionStatus.getCode());
                }
                Enumeration enumeration = nIXDCSessionStatus.getSessionIDs();
                while (enumeration.hasMoreElements()) {
                    object = (NISessionID)enumeration.nextElement();
                    blArray[((NISessionID)object).getSessionNumber()] = true;
                }
                ++n2;
            }
            ++n;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = 1;
        while (n3 < blArray.length) {
            if (!blArray[n3]) {
                arrayList.add(new Integer(n3));
            }
            ++n3;
        }
        object = new int[arrayList.size()];
        int n4 = 0;
        while (n4 < arrayList.size()) {
            object[n4] = (Integer)arrayList.get(n4);
            ++n4;
        }
        return object;
    }

    public List filterAsyncVolumes(List vector, NISessionID nISessionID, NIServices nIServices) throws NIUnavailableServerException, NIServerException, NIParameterInvalidCSAException, NIConnectionCSAException, NIQueryFailureCSAException, NIUnknownCSAException {
        if (vector == null) {
            logger.error("volList is null.");
            throw new NIParameterInvalidCSAException(vector, NULL_PARAMETER);
        }
        NIFlashCopyService nIFlashCopyService = nIServices.getFlashCopyService();
        NICopyServicesQueryResult nICopyServicesQueryResult = null;
        NICopyServicesQueryResult nICopyServicesQueryResult2 = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector<NIVolume> vector4 = new Vector<NIVolume>();
        NIRelationship nIRelationship = null;
        NIRelationship nIRelationship2 = null;
        NIPPRCAttribute nIPPRCAttribute = null;
        NIFlashCopyAttribute nIFlashCopyAttribute = null;
        NIXDCSessionStatus nIXDCSessionStatus = null;
        NIXDCSessionInfo nIXDCSessionInfo = null;
        Object var22_16 = null;
        NIXDCQuerySession[] nIXDCQuerySessionArray = new NIXDCQuerySession[]{};
        this.filterAliasVolumes(vector);
        this.sortVolList(vector);
        NIVolume nIVolume = (NIVolume)vector.get(0);
        NIVolumeID nIVolumeID = (NIVolumeID)nIVolume.getID();
        NIVolumeID nIVolumeID2 = (NIVolumeID)((NIVolume)vector.get(vector.size() - 1)).getID();
        try {
            nICopyServicesQueryResult = this.pprcService.queryRelationship(nIVolumeID, nIVolumeID2);
            if (!nICopyServicesQueryResult.isSuccessful()) {
                logger.error("PPRC Query Failure: rc= 0x" + Integer.toHexString(nICopyServicesQueryResult.getCode()));
            }
            vector2 = nICopyServicesQueryResult.getRelationshipList();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error("PPRC Query Exception " + exception);
            throw new NIQueryFailureCSAException("PPRC Query Failure ");
        }
        nIXDCSessionStatus = this.asyncPprcService.queryXDCSession(nIVolumeID.getLSS(), nIXDCQuerySessionArray);
        Vector vector5 = new Vector();
        NISessionID nISessionID2 = null;
        if (nIXDCSessionStatus.isSuccessful()) {
            Enumeration enumeration = nIXDCSessionStatus.getXDCSessionInfoEnumeration();
            while (enumeration.hasMoreElements()) {
                nIXDCSessionInfo = (NIXDCSessionInfo)enumeration.nextElement();
                nISessionID2 = nIXDCSessionInfo.getSessionID();
                if (nISessionID2.equals(nISessionID)) continue;
                vector = new Vector();
            }
        } else {
            logger.error("queryXDCSession Query Failure: rc= " + nIXDCSessionStatus.getCode());
            throw new NIQueryFailureCSAException("queryXDCSession Query Failure: rc= " + nIXDCSessionStatus.getCode());
        }
        int n = 0;
        while (n < vector.size()) {
            nIVolume = (NIVolume)vector.get(n);
            NIVolumeID nIVolumeID3 = (NIVolumeID)nIVolume.getID();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                NIVolumeID nIVolumeID4;
                nIRelationship = (NIRelationship)enumeration.nextElement();
                nIPPRCAttribute = (NIPPRCAttribute)nIRelationship.getAttributes();
                if (!nIPPRCAttribute.isExtendedDistance() || !nIVolumeID3.equals(nIVolumeID4 = (NIVolumeID)nIRelationship.getResourcePair().getSource()) || vector5.contains(nIVolumeID3)) continue;
                NIVolumeID nIVolumeID5 = (NIVolumeID)nIRelationship.getResourcePair().getTarget();
                nICopyServicesQueryResult2 = nIFlashCopyService.queryRelationship(nIVolumeID5);
                if (!nICopyServicesQueryResult2.isSuccessful()) {
                    logger.error("Flash Copy Query Failure: rc= 0x" + Integer.toHexString(nICopyServicesQueryResult2.getCode()));
                    throw new NIQueryFailureCSAException("Flash Copy Query Failure: rc= 0x" + Integer.toHexString(nICopyServicesQueryResult2.getCode()));
                }
                vector3 = nICopyServicesQueryResult2.getRelationshipList();
                int n2 = vector3.size();
                int n3 = 0;
                while (n3 < n2) {
                    nIRelationship2 = (NIRelationship)vector3.elementAt(n3);
                    nIFlashCopyAttribute = (NIFlashCopyAttribute)nIRelationship2.getAttributes();
                    if (nIFlashCopyAttribute.isPersistent() && nIFlashCopyAttribute.isChangeRecordingEnabled() && nIFlashCopyAttribute.isTargetWriteInhibited()) {
                        vector4.add(nIVolume);
                    }
                    ++n3;
                }
            }
            ++n;
        }
        if (vector4.size() == 0) {
            logger.debug_general("candidateSourceVolumes list is empty. ");
        }
        vector.retainAll(vector4);
        return vector;
    }

    private void sortVolList(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 0;
                NIVolume nIVolume = (NIVolume)object;
                NIVolume nIVolume2 = (NIVolume)object2;
                NIVolumeID nIVolumeID = (NIVolumeID)nIVolume.getID();
                NIVolumeID nIVolumeID2 = (NIVolumeID)nIVolume2.getID();
                n = nIVolumeID.compareTo(nIVolumeID2);
                return n;
            }
        });
    }

    private boolean containsNullElement(NIOption[] nIOptionArray) {
        boolean bl = false;
        int n = 0;
        while (n < nIOptionArray.length) {
            if (nIOptionArray[n] == null) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean validateOptions(int n, int[] nArray) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    private Vector getLSSsublists(Vector vector) throws NIParameterInvalidCSAException {
        if (vector.size() == 0) {
            return vector;
        }
        Vector vector2 = new Vector();
        int n = 0;
        this.sortVolList(vector);
        NIVolumeID nIVolumeID = (NIVolumeID)((NIVolume)vector.get(0)).getID();
        int n2 = 0;
        while (n2 < vector.size()) {
            NIVolumeID nIVolumeID2 = (NIVolumeID)((NIVolume)vector.get(n2)).getID();
            if (!nIVolumeID2.isValid()) {
                throw new NIParameterInvalidCSAException(nIVolumeID2, INVALID_VOLUME);
            }
            NILSSID nILSSID = nIVolumeID.getLSS();
            Vector<NIVolume> vector3 = new Vector<NIVolume>();
            while (nILSSID.equals(nIVolumeID2.getLSS()) && n2 < vector.size()) {
                NIVolume nIVolume = (NIVolume)vector.get(n2++);
                vector3.add(nIVolume);
                if (n2 >= vector.size()) continue;
                nIVolumeID2 = (NIVolumeID)((NIVolume)vector.get(n2)).getID();
            }
            vector2.add(vector3);
            ++n;
            nIVolumeID = nIVolumeID2;
        }
        return vector2;
    }

    private NIDeviceType getLSSType(NILSSID nILSSID) throws NIQueryFailureCSAException, NIUnauthorizedServerException, NIUnsupportedException, NIServerException {
        NILSSID[] nILSSIDArray = new NILSSID[]{nILSSID};
        NIConfigQueryResult nIConfigQueryResult = this.logicalService.getLogicalSubsystems(nILSSIDArray);
        if (nIConfigQueryResult.isSuccessful()) {
            List list = nIConfigQueryResult.getResourceList();
            NILSS nILSS = (NILSS)list.get(0);
            return nILSS.getDeviceType();
        }
        throw new NIQueryFailureCSAException("LogicalConfigService Error: cannot find LSS " + nILSSID);
    }

    private void filterAliasVolumes(List list) {
        NIVolume nIVolume = null;
        int n = list.size() - 1;
        while (n >= 0) {
            nIVolume = (NIVolume)list.get(n);
            if (nIVolume.isAlias()) {
                list.remove(n);
            }
            --n;
        }
        if (list.size() == 0) {
            logger.warning("filtered volList is empty.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

