/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.emailer;

import com.ibm.hwmca.fw.eventmon.email.Emailer;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.application.resource.NISMTPSettings;
import com.ibm.storage.ess.ni.application.resource.NIStoragePlex;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.services.NIDomainService;
import java.util.List;

public class NIEmailerClient {
    private String[] emailAddress;
    private String smtpAddress;
    private String subject;
    private String body;
    private boolean emailEnabled;
    private int smtpPort;
    private static NIEmailerClient emailInstance;
    private NIDomainService domainService;
    private static final Logger logger;
    private boolean isMM = NIAgentProperties.getAgentType() == 3;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$emailer$NIEmailerClient;

    private NIEmailerClient() {
    }

    public static NIEmailerClient getInstance() {
        if (emailInstance == null) {
            logger.debug_general("Instatation of EmailerClient");
            emailInstance = new NIEmailerClient();
        }
        return emailInstance;
    }

    public void send(String string, String string2) {
        if (this.isMM) {
            Emailer emailer = null;
            this.setSmtpContactInformation();
            if (this.emailEnabled && this.emailAddress.length > 0) {
                try {
                    emailer = new Emailer(this.smtpAddress, this.smtpPort);
                    emailer.send(this.emailAddress[0], "DS8000-Notification@IBM.com", string, string2);
                    logger.debug_general("Email Sent OK!");
                }
                catch (Exception exception) {
                    logger.debug_detailed("Emailer could not instantiate, or Email Send failed");
                }
            } else {
                logger.debug_general("NIEmailerClient: email is Disabled or  No emailAddress object to send to");
            }
        } else {
            logger.debug_general("NIEmailerClient: trying to send on non MM machine ");
        }
    }

    public void setDomainService(NIDomainService nIDomainService) {
        if (nIDomainService == null) {
            logger.debug_general("NIEmailerClient: DomainService is null");
        }
        this.domainService = nIDomainService;
        this.emailEnabled = false;
        this.emailAddress = new String[10];
    }

    private String[] setSmtpContactInformation() {
        NIStoragePlex nIStoragePlex = null;
        String[] stringArray = null;
        if (this.domainService != null) {
            try {
                logger.debug_general("Performing domainServices query");
                NIConfigQueryResult nIConfigQueryResult = this.domainService.getStoragePlex();
                if (nIConfigQueryResult.isSuccessful()) {
                    List list = nIConfigQueryResult.getResourceList();
                    nIStoragePlex = (NIStoragePlex)list.get(0);
                }
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
            }
            if (nIStoragePlex != null) {
                stringArray = nIStoragePlex.getSNMPAddresses();
                if (stringArray == null) {
                    logger.debug_general("Do not have any configured hosts to send emails");
                } else {
                    int n = 0;
                    while (n < stringArray.length) {
                        logger.debug_general("configuredHosts[" + n + "] = " + stringArray[n]);
                        ++n;
                    }
                    this.emailEnabled = nIStoragePlex.isEmailNotifyEnabled();
                    this.emailAddress = nIStoragePlex.getEmailAddresses();
                    NISMTPSettings nISMTPSettings = nIStoragePlex.getSMTPSettings();
                    if (nISMTPSettings == null) {
                        logger.debug_general("NULL SMTP Settings");
                    } else {
                        this.smtpPort = nISMTPSettings.getSMTPPort();
                        this.smtpAddress = nISMTPSettings.getSMTPServer().getHostAddress();
                        logger.debug_general("emailAddress: " + this.emailAddress[0] + " SMTP: " + this.smtpAddress + "SMTP Port:" + this.smtpPort);
                    }
                }
            }
        } else {
            logger.error("DomainServices not set in NIEmailerClient");
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$emailer$NIEmailerClient == null ? (class$com$ibm$storage$ess$ni$emailer$NIEmailerClient = NIEmailerClient.class$("com.ibm.storage.ess.ni.emailer.NIEmailerClient")) : class$com$ibm$storage$ess$ni$emailer$NIEmailerClient);
    }
}

