/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.eventManager.agent;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.eventManager.agent.NIEventAgentNative;
import com.ibm.storage.ess.ni.eventManager.agent.NIEventAgentProcessThread;
import com.ibm.storage.ess.ni.eventManager.agent.NIEventProcessor;
import com.ibm.storage.ess.ni.eventManager.agent.NIMegaMouthEventProcessorImpl;
import com.ibm.storage.ess.ni.eventManager.agent.NIReefEventProcessorImpl;
import com.ibm.storage.ess.ni.eventManager.agent.NIServerSocketThread;
import com.ibm.storage.ess.ni.eventManager.common.NIEventFactory;
import com.ibm.storage.ess.ni.eventManager.common.NIEventFactoryBuilder;
import com.ibm.storage.ess.ni.eventManager.common.NIEventQueue;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.services.NIDomainService;

public class NIEventAgent {
    private static NIEventAgent ea = null;
    private NIEventFactory eventFactory;
    private NIServerSocketThread serverSocketThread;
    private NIEventAgentProcessThread eventAgentProcessThread;
    private NIEventAgentNative nativeInterface;
    private NIEventProcessor eventProcessor;
    private NIDomainService domainServices = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$eventManager$agent$NIEventAgent == null ? (class$com$ibm$storage$ess$ni$eventManager$agent$NIEventAgent = NIEventAgent.class$("com.ibm.storage.ess.ni.eventManager.agent.NIEventAgent")) : class$com$ibm$storage$ess$ni$eventManager$agent$NIEventAgent);
    private boolean isAlive = false;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$eventManager$agent$NIEventAgent;

    private NIEventAgent(boolean bl, NIDomainService nIDomainService) {
        this.domainServices = nIDomainService;
        int n = NIAgentProperties.getAgentType();
        this.eventProcessor = n == 4 || n == 1 ? new NIReefEventProcessorImpl(nIDomainService) : new NIMegaMouthEventProcessorImpl();
        try {
            this.eventFactory = NIEventFactoryBuilder.create();
        }
        catch (Exception exception) {
            logger.debug_general("NIEventAgent:   Error creating the Event Factory");
            logger.throwable((Throwable)exception);
        }
        if (bl) {
            this.serverSocketThread = n == 4 ? new NIServerSocketThread(this.eventFactory, this.eventProcessor, true) : new NIServerSocketThread(this.eventFactory, this.eventProcessor, false);
            this.serverSocketThread.start();
        }
        this.eventAgentProcessThread = new NIEventAgentProcessThread(this.eventProcessor.getEventQueue());
        this.eventAgentProcessThread.start();
        if (n == 4 || n == 2) {
            if (this.eventFactory != null) {
                this.nativeInterface = new NIEventAgentNative(this.eventProcessor.getEventQueue(), this.eventFactory, this.eventProcessor);
            } else {
                logger.error("The Event Agent Native interface failed.");
            }
        }
        this.isAlive = true;
    }

    public static NIEventAgent getEventAgent() {
        return ea;
    }

    public static NIEventAgent getEventAgent(boolean bl) {
        if (ea == null) {
            ea = new NIEventAgent(bl, null);
        }
        return ea;
    }

    public static NIEventAgent getEventAgent(boolean bl, NIDomainService nIDomainService) {
        if (ea == null) {
            ea = new NIEventAgent(bl, nIDomainService);
        }
        return ea;
    }

    public void shutdown() {
        try {
            if (this.serverSocketThread != null) {
                this.serverSocketThread.shutDown();
            }
            if (this.eventAgentProcessThread != null) {
                this.eventAgentProcessThread.shutDown();
            }
        }
        catch (RuntimeException runtimeException) {
            logger.throwable((Throwable)runtimeException);
        }
        this.isAlive = false;
    }

    public NIEventQueue getFastCCWQueue() {
        return this.eventProcessor.getFastCCWQueue();
    }

    public boolean isAlive() {
        boolean bl;
        boolean bl2 = bl = this.isAlive && this.serverSocketThread.isAlive() && this.eventAgentProcessThread.isAlive();
        if (!bl) {
            logger.debug_general("isAlive() returning false: isAlive = " + this.isAlive + ", serverSocketThread.isAlive() = " + this.serverSocketThread.isAlive() + ", eventAgentProcessThread.isAlive() = " + this.eventAgentProcessThread.isAlive());
        }
        return bl;
    }

    public void dump() {
        if (logger != null) {
            logger.dump();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

