/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.eventManager.agent;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.event.NIEventImpl;
import com.ibm.storage.ess.ni.eventManager.agent.NIEventProcessor;
import com.ibm.storage.ess.ni.eventManager.snmp.NISNMPManager;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.jni.ci.NICIConnectionException;
import com.ibm.storage.ess.ni.jni.mr.NIMRClientInt;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.services.NIDomainService;
import java.util.Enumeration;
import java.util.Vector;

public class NIReefEventProcessorImpl
extends NIEventProcessor {
    private NISNMPManager snmpManager = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$eventManager$agent$NIReefEventProcessorImpl == null ? (class$com$ibm$storage$ess$ni$eventManager$agent$NIReefEventProcessorImpl = NIReefEventProcessorImpl.class$("com.ibm.storage.ess.ni.eventManager.agent.NIReefEventProcessorImpl")) : class$com$ibm$storage$ess$ni$eventManager$agent$NIReefEventProcessorImpl);
    private String[] mtmsArray = new String[6];
    private NIESSID ess;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$eventManager$agent$NIReefEventProcessorImpl;

    public NIReefEventProcessorImpl(NIDomainService nIDomainService) {
        NIMRClientInt nIMRClientInt = new NIMRClientInt();
        try {
            nIMRClientInt.niMRStartServer();
            nIMRClientInt.niMRGetEssServerEntries(this.mtmsArray);
            String string = "IBM." + this.mtmsArray[1] + "." + this.mtmsArray[0] + this.mtmsArray[3];
            this.ess = new NIESSID(string);
            logger.debug_general("Creating SNMPManager with ESSID; " + this.ess);
            this.snmpManager = NISNMPManager.getReefSNMPManager();
            this.snmpManager.setDomainService(nIDomainService);
            this.snmpManager.setESSID(this.ess);
            this.snmpManager.populateSNMPsettings();
        }
        catch (NICIConnectionException nICIConnectionException) {
            logger.error("niMRGetEssServerEntries() failed, SNMP Manager not built");
            logger.throwable((Throwable)nICIConnectionException);
        }
    }

    public void processEvent(NIEventImpl nIEventImpl) {
        Vector vector = null;
        this.setSubEvents(nIEventImpl);
        int n = 0;
        while (n < this.subEvents.length) {
            logger.debug_general("Extracting traps from event; " + this.subEvents[n].getClass());
            vector = this.subEvents[n].getSnmpTraps();
            if (vector != null) {
                logger.debug_general(vector.size() + " snmp traps were generated");
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    NISnmpTrap nISnmpTrap = (NISnmpTrap)enumeration.nextElement();
                    logger.debug_general("sending SnmpTrap: " + nISnmpTrap.getTrapName());
                    if (this.snmpManager != null) {
                        this.snmpManager.sendNISnmpTrap(nISnmpTrap);
                        logger.debug_general("Sent NISnmpTrap: " + nISnmpTrap.getTrapName() + " to registered hosts");
                        continue;
                    }
                    logger.debug_general("SnmpTrap: " + nISnmpTrap.getTrapName() + " was not sent");
                }
                vector.clear();
            }
            logger.debug_general("Constructed event: " + this.subEvents[n].getClass());
            this.enqueueEvent(this.subEvents[n]);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

