/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.eventManager.snmp;

import com.ibm.hwmca.api.SNMPTrap;
import com.ibm.hwmca.api.SNMPTrapSender;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIPortInetAddress;
import com.ibm.storage.ess.ni.application.resource.NISNMPSettings;
import com.ibm.storage.ess.ni.application.resource.NIStoragePlex;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.eventManager.snmp.NISendableTrap;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap202;
import com.ibm.storage.ess.ni.eventManager.snmp.NITrapAccumulationTable;
import com.ibm.storage.ess.ni.eventManager.snmp.NITrapSenderThread;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.jni.mr.NIMRClientInt;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.services.NIDomainService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.StringTokenizer;

public class NISNMPManager {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$eventManager$snmp$NISNMPManager == null ? (class$com$ibm$storage$ess$ni$eventManager$snmp$NISNMPManager = NISNMPManager.class$("com.ibm.storage.ess.ni.eventManager.snmp.NISNMPManager")) : class$com$ibm$storage$ess$ni$eventManager$snmp$NISNMPManager);
    private static final int NUMBER_OF_IPS = 2;
    private static final String DEFAULT_COMMUNITY = "public";
    private NIDomainService domainServices = null;
    private boolean reef;
    private boolean enabled = false;
    private NITrapAccumulationTable trapAccumulationTable;
    private NIESSID ess;
    private NITrapSenderThread trapSenderThread;
    private NIMRClientInt clientInt;
    private String community;
    private String[] configuredHosts;
    private boolean retrievedTrapSettings;
    private final String DELIMITER = ":";
    private static NISNMPManager singletonRef;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$eventManager$snmp$NISNMPManager;

    private NISNMPManager() {
        this.trapAccumulationTable = new NITrapAccumulationTable();
        this.trapSenderThread = new NITrapSenderThread(this.trapAccumulationTable, this);
        this.reef = false;
        this.retrievedTrapSettings = false;
    }

    private NISNMPManager(NIDomainService nIDomainService, NIESSID nIESSID) {
        this.domainServices = nIDomainService;
        this.trapAccumulationTable = new NITrapAccumulationTable();
        this.trapSenderThread = new NITrapSenderThread(this.trapAccumulationTable, this);
        this.clientInt = new NIMRClientInt();
        this.ess = nIESSID;
        this.reef = true;
        this.retrievedTrapSettings = false;
    }

    public static synchronized NISNMPManager getMMSNMPManager() {
        if (singletonRef == null) {
            singletonRef = new NISNMPManager();
        }
        return singletonRef;
    }

    public static synchronized NISNMPManager getReefSNMPManager() {
        if (singletonRef == null) {
            singletonRef = new NISNMPManager(null, null);
        }
        return singletonRef;
    }

    public synchronized void sendNISnmpTrap(NISnmpTrap nISnmpTrap) {
        String[] stringArray = new String[2];
        this.populateSNMPsettings();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(null);
        }
        catch (UnknownHostException unknownHostException) {
            logger.throwable((Throwable)unknownHostException);
        }
        if (this.enabled) {
            String string = nISnmpTrap.getTrapName();
            if (string == "Trap202" && !nISnmpTrap.isAccumulated()) {
                int n = ((NISnmpTrap202)nISnmpTrap).getLssNumber();
                int n2 = ((NISnmpTrap202)nISnmpTrap).getVolumeID();
                logger.debug_general("Acumulating 202 data for 0x" + Integer.toHexString(n << 8 | n2));
                this.accumulateTrap202data((NISnmpTrap202)nISnmpTrap);
            } else {
                logger.debug_general("NISNMPManager: Sending trap: " + string);
                logger.debug_detailed("Trap Data....");
                logger.debug_detailed(nISnmpTrap.toString());
                if (this.reef) {
                    try {
                        this.clientInt.niMRGetEssServerIps(stringArray);
                        inetAddress = InetAddress.getByName(stringArray[0]);
                    }
                    catch (Exception exception) {
                        logger.error("Failed to construct source IP for trap");
                        logger.throwable((Throwable)exception);
                    }
                }
                if (this.configuredHosts != null) {
                    NISendableTrap nISendableTrap = new NISendableTrap(nISnmpTrap);
                    int n = 0;
                    while (n < this.configuredHosts.length) {
                        try {
                            if (this.reef) {
                                StringTokenizer stringTokenizer = new StringTokenizer(this.configuredHosts[n], ":");
                                InetAddress inetAddress2 = InetAddress.getByName((String)stringTokenizer.nextElement());
                                int n3 = Integer.parseInt((String)stringTokenizer.nextElement());
                                SNMPTrapSender.sendTrap((SNMPTrap)nISendableTrap, (InetAddress)inetAddress2, (int)n3, (InetAddress)inetAddress, (String)this.community);
                            } else {
                                SNMPTrapSender.sendTrap((SNMPTrap)nISendableTrap, (String)this.configuredHosts[n]);
                            }
                        }
                        catch (Exception exception) {
                            logger.error("SnmpTrap; " + nISnmpTrap.getTrapName() + " not sent to address; " + this.configuredHosts[n]);
                            logger.throwable((Throwable)exception);
                        }
                        ++n;
                    }
                } else {
                    logger.debug_general("Error retrieving IPAddresses from StoragePlex, " + nISnmpTrap.getTrapName() + " was not sent");
                }
            }
        } else {
            logger.debug_general("SNMPTraps are disabled in the StoragePlex object, " + nISnmpTrap.getTrapName() + " was not delivered");
        }
    }

    public synchronized void populateSNMPsettings() {
        NIStoragePlex nIStoragePlex = null;
        if (!this.retrievedTrapSettings) {
            if (this.domainServices != null) {
                try {
                    logger.debug_general("Performing domainServices query");
                    NIConfigQueryResult nIConfigQueryResult = this.reef ? this.domainServices.getStoragePlex(this.ess) : this.domainServices.getStoragePlex();
                    if (nIConfigQueryResult.isSuccessful()) {
                        List list = nIConfigQueryResult.getResourceList();
                        nIStoragePlex = (NIStoragePlex)list.get(0);
                    }
                }
                catch (Exception exception) {
                    logger.throwable((Throwable)exception);
                }
                this.setTrapInformation(nIStoragePlex);
            } else {
                logger.error("DomainServices not set in EventManager or EventAgent");
            }
        }
    }

    private void extractInfoForReef(NIStoragePlex nIStoragePlex) {
        NISNMPSettings nISNMPSettings = nIStoragePlex.getSNMPSettings();
        if (nISNMPSettings != null) {
            NIPortInetAddress[] nIPortInetAddressArray = nISNMPSettings.getSNMPPortIP();
            if (nIPortInetAddressArray != null) {
                this.configuredHosts = new String[nIPortInetAddressArray.length];
                int n = 0;
                while (n < nIPortInetAddressArray.length) {
                    this.configuredHosts[n] = new String(nIPortInetAddressArray[n].getIP().getHostAddress() + ":" + nIPortInetAddressArray[n].getPort());
                    ++n;
                }
                this.community = nISNMPSettings.getSNMPCommunityName();
                if (this.community == null) {
                    this.community = DEFAULT_COMMUNITY;
                }
            } else {
                logger.error("NIPortInetAddress[] in NISNMPSettings is null");
            }
        } else {
            logger.error("NISNMPSettings not set in StoragePex object");
        }
    }

    public synchronized void setDomainService(NIDomainService nIDomainService) {
        this.domainServices = nIDomainService;
    }

    public synchronized void setESSID(NIESSID nIESSID) {
        this.ess = nIESSID;
    }

    public synchronized void setTrapInformation(NIStoragePlex nIStoragePlex) {
        if (nIStoragePlex != null) {
            this.retrievedTrapSettings = true;
            if (this.reef) {
                this.extractInfoForReef(nIStoragePlex);
            } else {
                this.configuredHosts = nIStoragePlex.getSNMPAddresses();
            }
            this.enabled = nIStoragePlex.isSNMPEnabled();
            logger.debug_general("SNMP enabled = " + this.enabled);
            if (this.configuredHosts == null) {
                logger.debug_general("Do not have any configured hosts to send traps");
            } else {
                int n = 0;
                while (n < this.configuredHosts.length) {
                    logger.debug_general("configuredHosts[" + n + "] = " + this.configuredHosts[n]);
                    ++n;
                }
            }
        }
    }

    private void accumulateTrap202data(NISnmpTrap202 nISnmpTrap202) {
        if (!this.trapSenderThread.isAlive()) {
            this.trapSenderThread.start();
        }
        this.trapAccumulationTable.addTrapData(nISnmpTrap202);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

