/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.eventManager.snmp;

import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap;
import com.ibm.storage.ess.ni.util.NIMtmsParser;
import java.util.Date;

public class NISnmpTrap202
extends NISnmpTrap {
    private static short CODE = (short)202;
    private static String TRAP_NAME = "Trap202";
    private String eventDescr = null;
    private Date startTime;
    private Date endTime = null;
    private String primaryMTMS;
    private String secondaryMTMS;
    private int primaryLssID;
    private int secondaryLssID;
    private int primaryVolumeID;
    private int secondaryVolumeID;
    private int suspendReason;
    private byte[] volumeBitMap;
    private static final long serialVersionUID = 1L;

    public NISnmpTrap202(String string, String string2, int n, int n2, int n3, int n4, int n5) {
        this.primaryMTMS = string;
        this.secondaryMTMS = string2;
        this.primaryLssID = n;
        this.secondaryLssID = n2;
        this.primaryVolumeID = n3;
        this.secondaryVolumeID = n4;
        this.suspendReason = n5;
        this.volumeBitMap = new byte[32];
        int n6 = 0;
        while (n6 < this.volumeBitMap.length) {
            this.volumeBitMap[n6] = 0;
            ++n6;
        }
    }

    public String getTrapName() {
        return TRAP_NAME;
    }

    public short getTrapCode() {
        return CODE;
    }

    public int getLssNumber() {
        return this.primaryLssID;
    }

    public int getVolumeID() {
        return this.primaryVolumeID;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public void setVolumeBit(int n) {
        if (n < 256 && n >= 0) {
            int n2 = n / 8;
            int n3 = 7 - n % 8;
            byte by = this.volumeBitMap[n2];
            byte by2 = (byte)(1 << n3 & 0xFF);
            this.volumeBitMap[n2] = (byte)(by2 | by);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.volumeBitMap.length) {
            stringBuffer.append(this.leftPadZeros(Integer.toHexString(this.volumeBitMap[n] & 0xFF).toUpperCase(), 2));
            ++n;
        }
        NIMtmsParser nIMtmsParser = new NIMtmsParser(this.primaryMTMS);
        String string = "PRI:  IBM " + nIMtmsParser.getType() + "-" + nIMtmsParser.getModel() + " " + nIMtmsParser.getManufacturePlant() + "-" + nIMtmsParser.getSequence() + " " + this.leftPadZeros(Integer.toHexString(this.primaryLssID).toUpperCase(), 2) + " " + this.leftPadZeros(Integer.toHexString(this.primaryVolumeID).toUpperCase(), 2) + " " + this.leftPadZeros(Integer.toHexString(this.suspendReason).toUpperCase(), 2) + "\n";
        NIMtmsParser nIMtmsParser2 = new NIMtmsParser(this.secondaryMTMS);
        String string2 = "SEC:  IBM " + nIMtmsParser2.getType() + "-" + nIMtmsParser2.getModel() + " " + nIMtmsParser2.getManufacturePlant() + "-" + nIMtmsParser2.getSequence() + " " + this.leftPadZeros(Integer.toHexString(this.secondaryLssID).toUpperCase(), 2) + " " + this.leftPadZeros(Integer.toHexString(this.secondaryVolumeID).toUpperCase(), 2) + "\n";
        return this.formatDate(this.endTime) + "\n" + "Primary PPRC Devices on LSS Suspended Due to Error\n" + "UNIT: Mnf Type-Mod SerialNm LS LD SR\n" + string + string2 + "Start: " + this.formatDate(this.startTime) + "\n" + "PRI Dev Flags (1 bit/Dev, 1=Suspended):\n" + stringBuffer;
    }
}

