/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.identifiers;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NIMtmsParser;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NIESSID
extends NIResourceID {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$identifiers$NIESSID == null ? (class$com$ibm$storage$ess$ni$identifiers$NIESSID = NIESSID.class$("com.ibm.storage.ess.ni.identifiers.NIESSID")) : class$com$ibm$storage$ess$ni$identifiers$NIESSID);
    private static final long serialVersionUID = 1L;
    public static final String TYPE_2105 = "2105";
    public static final String TYPE_2107 = "2107";
    public static final String TYPE_1750 = "1750";
    public static final String TYPE_UNKNOWN = "Unknown";
    public static final String POM_UNKNOWN = "Unknown";
    public static final long WWNN_UNKNOWN = 0L;
    public static String SEQUENCE_UNKNOWN = "Unknown";
    public static final int IMAGE_UNKNOWN = -1;
    private String type;
    private static final int SIZEOF_TYPE = 4;
    private String model = null;
    private static final int SIZEOF_MODEL = 3;
    private String manufactureplant;
    private static final int SIZEOF_MFG_PLANT = 2;
    private String sequence;
    private static final int SIZEOF_SEQUENCE = 5;
    private long wwnn;
    private NIStorageFacilityID storageFacility;
    private int imageNumber;
    private static final int OS_PPRC_WWNN_RANGE_REEF_UPPER_HIGH = 1342506851;
    private static final int OS_PPRC_WWNN_RANGE_REEF_UPPER_LOW = 0xDFFFFFF;
    private static final int OS_PPRC_WWNN_RANGE_REEF_LOWER_HIGH = 1342506851;
    private static final int OS_PPRC_WWNN_RANGE_REEF_LOWER_LOW = 0xC000000;
    private static final int OS_PPRC_WWNN_RANGE_MEGAMOUTH_UPPER_HIGH = 1342506851;
    private static final int OS_PPRC_WWNN_RANGE_MEGAMOUTH_UPPER_LOW = 0xBFFFFFF;
    private static final int OS_PPRC_WWNN_RANGE_MEGAMOUTH_LOWER_HIGH = 1342506851;
    private static final int OS_PPRC_WWNN_RANGE_MEGAMOUTH_LOWER_LOW = 0x3000000;
    private static final int OS_PPRC_WWNN_RANGE_SILVERTIP_UPPER_HIGH = 1342506851;
    private static final int OS_PPRC_WWNN_RANGE_SILVERTIP_UPPER_LOW = 12632063;
    private static final int OS_PPRC_WWNN_RANGE_SILVERTIP_LOWER_HIGH = 1342506851;
    private static final int OS_PPRC_WWNN_RANGE_SILVERTIP_LOWER_LOW = 0xC00000;
    private static final long UPPER_MASK = -4294967296L;
    private static final long LOWER_MASK = 0xFFFFFFFFL;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$identifiers$NIESSID;

    public NIESSID(String string, String string2, String string3, String string4, long l) {
        this(string, string2, string3, l);
        this.model = string4;
    }

    public NIESSID(String string, String string2, String string3, long l) {
        this.type = string;
        this.manufactureplant = string2;
        this.sequence = string3;
        this.wwnn = l;
        this.convertData();
    }

    public NIESSID(NIStorageFacilityID nIStorageFacilityID, int n) {
        this.type = nIStorageFacilityID.getType();
        this.manufactureplant = nIStorageFacilityID.getManufacturePlant();
        this.sequence = nIStorageFacilityID.getSequence();
        this.wwnn = nIStorageFacilityID.getWWNN();
        this.storageFacility = nIStorageFacilityID;
        this.imageNumber = n;
        this.sequence = this.getSequence();
    }

    public NIESSID(String string) {
        this(string, 0L);
    }

    public NIESSID(String string, long l) {
        NIMtmsParser nIMtmsParser = new NIMtmsParser(string);
        this.type = nIMtmsParser.getType();
        this.manufactureplant = nIMtmsParser.getManufacturePlant();
        this.sequence = nIMtmsParser.getSequence();
        this.wwnn = l;
        this.convertData();
    }

    public NIStorageFacilityID getStorageFacility() {
        return this.storageFacility;
    }

    public int getImageNumber() {
        return this.imageNumber;
    }

    public String getType() {
        return this.type;
    }

    public String getModel() {
        return this.model;
    }

    public String getManufacturePlant() {
        return this.manufactureplant;
    }

    public String getSequence() {
        if (this.type.equalsIgnoreCase(TYPE_2107) && this.imageNumber != -1) {
            return NIMtmsParser.convertSFSequenceToEssSequence(this.sequence, this.imageNumber);
        }
        return this.sequence;
    }

    public long getWWNN() {
        return this.wwnn;
    }

    public String toString() {
        return "IBM." + this.type + "-" + this.manufactureplant + this.getSequence();
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object == null || this.getClass() != object.getClass()) {
            return n;
        }
        NIESSID nIESSID = (NIESSID)object;
        if (this.type.equals(TYPE_2107) && nIESSID.type.equals(TYPE_2107)) {
            n = this.storageFacility.compareTo(nIESSID.storageFacility);
        } else {
            if (this.sequence != null && nIESSID.sequence != null) {
                n = nIESSID.getSequence().compareTo(this.getSequence());
            } else if (this.sequence != null) {
                n = -1;
            } else if (nIESSID.sequence != null) {
                n = 1;
            }
            if (n == 0) {
                if (this.type != null && nIESSID.type != null) {
                    n = nIESSID.type.compareTo(this.type);
                } else if (this.type != null) {
                    n = -1;
                } else if (nIESSID.type != null) {
                    n = 1;
                }
            }
        }
        if (n == 0) {
            n = this.imageNumber - nIESSID.imageNumber;
        }
        return n;
    }

    public int hashCode() {
        int n = this.type.equals(TYPE_2107) ? this.storageFacility.hashCode() : this.sequence.hashCode() + this.type.hashCode();
        return n + this.imageNumber + this.getClass().hashCode();
    }

    public boolean isValid() {
        return this.sequence != null || this.sequence.equals(SEQUENCE_UNKNOWN);
    }

    public NIESSID getESS() {
        return this;
    }

    public boolean isOffline() {
        boolean bl = false;
        if (this.storageFacility != null) {
            bl = this.storageFacility.isOffline();
        }
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.storageFacility == null) {
            this.convertData();
        }
    }

    public void convertTypeBasedOnWWNN() {
        if ((this.type.equalsIgnoreCase(TYPE_2105) || this.type.equalsIgnoreCase("Unknown")) && this.wwnn != 0L) {
            int n = (int)(this.wwnn & 0xFFFFFFFFL);
            int n2 = (int)((this.wwnn & 0xFFFFFFFF00000000L) >> 32);
            logger.debug_detailed("wwnnLower = " + n + " wwnnUpper " + n2);
            if (n >= 0xC000000 && n <= 1342506851 && n2 >= 0xDFFFFFF && n2 <= 1342506851) {
                logger.debug_general("Is a 1750....");
                this.type = TYPE_1750;
            } else if (n >= 0x3000000 && n <= 1342506851 && n2 >= 0xBFFFFFF && n2 <= 1342506851) {
                logger.debug_detailed("Is a 2107....");
                this.type = TYPE_2107;
            } else if (n >= 0xC00000 && n <= 1342506851 && n2 >= 12632063 && n2 <= 1342506851) {
                logger.debug_detailed("Is a 2105....");
                this.type = TYPE_2105;
            }
        }
    }

    private void convertData() {
        this.convertTypeBasedOnWWNN();
        if (this.type == null || this.type.length() != 4) {
            this.type = "Unknown";
        }
        if (this.manufactureplant == null || this.manufactureplant.length() != 2) {
            this.manufactureplant = "Unknown";
        }
        int n = this.sequence.length();
        int n2 = 0;
        while (n2 < 5 - n) {
            this.sequence = "0" + this.sequence;
            ++n2;
        }
        if (this.sequence == null || this.sequence.length() > 5) {
            this.sequence = SEQUENCE_UNKNOWN;
            this.imageNumber = -1;
        } else {
            this.imageNumber = this.type.equalsIgnoreCase(TYPE_2107) ? Integer.parseInt(this.sequence.substring(4), 16) : 1;
        }
        this.sequence = this.getSequence();
        if (this.type.equalsIgnoreCase(TYPE_2107)) {
            String string = NIMtmsParser.convertEssSequenceToSFSequence(this.sequence);
            this.storageFacility = new NIStorageFacilityID(this.type, this.manufactureplant, string, this.wwnn);
        } else {
            this.storageFacility = new NIStorageFacilityID(this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

