/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.jni.ci;

import com.ibm.storage.ess.ni.jni.ci.NICIStatus;

public class NICIBuffer {
    private int requestID;
    private NICIStatus status;
    private byte[] response;
    private byte[] request;

    public NICIBuffer() {
        this.requestID = -1;
        this.status = new NICIStatus(-1);
        this.response = null;
        this.request = null;
    }

    public NICIBuffer(int n, int n2, byte[] byArray, byte[] byArray2) {
        this.requestID = n;
        this.status = new NICIStatus(n2);
        this.response = byArray;
        this.request = byArray2;
    }

    public NICIStatus getRequestStatus() {
        return this.status;
    }

    public int getRequestSize() {
        return this.getRequest().length;
    }

    public byte[] getRequest() {
        if (this.request == null) {
            this.request = new byte[0];
        }
        return this.request;
    }

    public int getResponseSize() {
        return this.getResponse().length;
    }

    public byte[] getResponse() {
        if (this.response == null) {
            this.response = new byte[0];
        }
        return this.response;
    }

    public int getRequestID() {
        return this.requestID;
    }

    public void print() {
        System.out.println("NICIBuffer (rId=" + this.getRequestID() + ", rSts=" + this.status.getCode() + ", resS=" + this.getResponseSize() + ", reqS=" + this.getRequestSize() + ")");
        System.out.print("response = [");
        int n = 0;
        while (n < this.getResponse().length) {
            System.out.print(" " + new Byte(this.getResponse()[n]).intValue());
            ++n;
        }
        System.out.println("]");
        System.out.print("request = [");
        int n2 = 0;
        while (n2 < this.getRequest().length) {
            System.out.print(" " + new Byte(this.getRequest()[n2]).intValue());
            ++n2;
        }
        System.out.println("]");
    }

    private void setRequest(byte[] byArray) {
        this.request = byArray;
    }

    private void setRequestID(int n) {
        this.requestID = n;
    }

    private void setResponse(byte[] byArray) {
        this.response = byArray;
    }

    private void setStatus(int n) {
        this.status = new NICIStatus(n);
    }
}

