/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.logging;

import com.ibm.storage.ess.logging.FormattedLogEntry;
import com.ibm.storage.ess.logging.Handler;
import com.ibm.storage.ess.ni.logging.NIStringFormattedLogEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Vector;

public class NIFileHandler
extends Handler {
    private static final int DEFAULT_SIZE = 0x300000;
    private long maxFileSize = 0x300000L;
    private long fileSize;
    private static Vector handlers = new Vector();
    private PrintStream out = null;
    private boolean configured = false;
    private String fullFileName = null;
    private String fileName = null;
    private File outputFile = null;
    private static final double TRIM_FACTOR = 0.1;
    private static final int TRIM_BUFFER_SIZE = 1024;

    public static Vector getHandlers() {
        return handlers;
    }

    public NIFileHandler() {
        handlers.add(this);
    }

    public void setFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("com.ibm.storage.ess.ni.logging.LogDir");
        if (string2 != null) {
            if (string2.endsWith("\"")) {
                stringBuffer.append(string2.substring(2, string2.length() - 1).replaceAll("\\\\\\\\", "/"));
            } else {
                stringBuffer.append(string2.replaceAll("\\\\", "/"));
            }
            if (!stringBuffer.toString().endsWith("/")) {
                stringBuffer.append("/");
            }
        }
        stringBuffer.append(string);
        this.fullFileName = stringBuffer.toString();
        this.fileName = stringBuffer.toString().substring(stringBuffer.toString().lastIndexOf("/") + 1);
        if ("".equals(this.fileName)) {
            System.out.println("==> fileName = null string");
            this.fileName = new String(this.fullFileName);
        }
    }

    public void trim() {
        this.trim(false);
    }

    private void writeTime() {
        this.out.println("[" + Calendar.getInstance().getTime() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim(boolean bl) {
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        byte[] byArray = new byte[1024];
        if (!this.configured) {
            this.configure();
        }
        File file = this.outputFile;
        synchronized (file) {
            this.fileSize = this.outputFile.length();
            if (bl || this.fileSize > this.maxFileSize) {
                this.writeTime();
                this.out.println("Trimming file " + this.fileName + ", size was " + this.fileSize + " bytes");
                this.fileSize = this.outputFile.length();
                long l = (long)((double)(this.fileSize - this.maxFileSize) + 0.1 * (double)this.maxFileSize);
                try {
                    randomAccessFile = new RandomAccessFile(this.outputFile, "r");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (this.out != null) {
                        this.out.close();
                    }
                    this.configure();
                    fileNotFoundException.printStackTrace(this.out);
                    this.out.println("Error: file not found when trying to open " + this.fileName + " for reading, close old stream and recreate file");
                    return;
                }
                try {
                    randomAccessFile2 = new RandomAccessFile(this.outputFile, "rw");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.out.println("Error: file not found when trying to open " + this.fileName + " for reading");
                    this.out.println("Error: this should never happen since we were just able to find it for reading");
                    fileNotFoundException.printStackTrace(this.out);
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                        this.out.println("Error: exception caught when closing the reader for " + this.fileName + " while aborting");
                        iOException.printStackTrace(this.out);
                    }
                    this.fileSize = this.outputFile.length();
                    return;
                }
                try {
                    randomAccessFile.seek(l);
                    int n = randomAccessFile.read(byArray, 0, 1024);
                    while (n > 0) {
                        randomAccessFile2.write(byArray, 0, n);
                        n = randomAccessFile.read(byArray, 0, 1024);
                    }
                }
                catch (IOException iOException) {
                    this.out.println("Error: IOException while trimming.... file " + this.fileName + " may be inconsistent");
                    iOException.printStackTrace(this.out);
                }
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    this.out.println("Error: IOException when closing the reader for " + this.fileName);
                    iOException.printStackTrace(this.out);
                }
                try {
                    this.fileSize = randomAccessFile2.getFilePointer();
                    randomAccessFile2.setLength(this.fileSize);
                }
                catch (IOException iOException) {
                    this.out.println("Error: IOException while truncating the file " + this.fileName);
                    iOException.printStackTrace(this.out);
                }
                try {
                    randomAccessFile2.close();
                }
                catch (IOException iOException) {
                    this.out.println("Error: IOException when closing the writer for " + this.fileName);
                    iOException.printStackTrace(this.out);
                }
                randomAccessFile = null;
                randomAccessFile2 = null;
            }
            this.out.println("Trimming file " + this.fileName + " completed, size reduced to " + this.fileSize + "bytes");
            this.fileSize = this.outputFile.length();
        }
    }

    private void configure() {
        if (this.fullFileName == null) {
            return;
        }
        try {
            this.outputFile = new File(this.fullFileName).getAbsoluteFile();
            this.fileSize = this.outputFile.length();
            File file = this.outputFile.getParentFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            this.out = new PrintStream(new FileOutputStream(this.fullFileName, true));
            this.configured = true;
        }
        catch (IOException iOException) {
            this.configured = false;
        }
    }

    public void setMaxlines(String string) {
    }

    public void setMaxsize(String string) {
        block3: {
            try {
                int n = Integer.parseInt(string);
                if (n < 0) {
                    this.maxFileSize = 0x300000L;
                    break block3;
                }
                this.maxFileSize = (long)n * 1024L;
            }
            catch (NumberFormatException numberFormatException) {
                this.maxFileSize = 0x300000L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void output(FormattedLogEntry formattedLogEntry) {
        if (!this.configured) {
            this.configure();
        }
        File file = this.outputFile;
        synchronized (file) {
            try {
                long l = ((NIStringFormattedLogEntry)formattedLogEntry).getSize();
                if (this.fileSize + l > this.maxFileSize) {
                    this.trim(true);
                }
                formattedLogEntry.writeEntry((OutputStream)this.out);
                this.fileSize += l;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void stop() {
        if (this.out != null) {
            this.out.close();
        }
    }

    public String getFilename() {
        return this.fullFileName;
    }
}

