/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMessageTypes;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import java.io.Serializable;

public class NIMessageHeader
extends NIMessageRouterMessageTypes
implements Serializable {
    public static final int NO_RESPONSE = 0;
    public static final int RESPONSE = 1;
    private static final long serialVersionUID = 1L;
    private Integer version;
    private Integer messageType;
    private Integer messageID;
    private Integer messageLength;
    private NIMessageRouterAddress source;
    private NIMessageRouterAddress destination;

    protected NIMessageHeader(NIMessageRouterAddress nIMessageRouterAddress, NIMessageRouterAddress nIMessageRouterAddress2) {
        this(nIMessageRouterAddress, nIMessageRouterAddress2, 0);
    }

    protected NIMessageHeader(NIMessageRouterAddress nIMessageRouterAddress, NIMessageRouterAddress nIMessageRouterAddress2, int n) {
        this(nIMessageRouterAddress, nIMessageRouterAddress2, n, 0, 1);
    }

    protected NIMessageHeader(NIMessageRouterAddress nIMessageRouterAddress, NIMessageRouterAddress nIMessageRouterAddress2, int n, int n2) {
        this(nIMessageRouterAddress, nIMessageRouterAddress2, n, n2, 1);
    }

    protected NIMessageHeader(NIMessageRouterAddress nIMessageRouterAddress, NIMessageRouterAddress nIMessageRouterAddress2, int n, int n2, int n3) {
        this.messageType = new Integer(n);
        this.messageID = new Integer(n2);
        this.messageLength = new Integer(n3);
        this.source = nIMessageRouterAddress;
        this.destination = nIMessageRouterAddress2;
        this.version = new Integer(0);
    }

    public boolean validVersion() {
        return true;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getMessageID() {
        return this.messageID;
    }

    protected void setMessageID(int n) {
        this.messageID = new Integer(n);
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public NIMessageRouterAddress getSourceAddress() {
        return this.source;
    }

    public NIMessageRouterAddress getDestinationAddress() {
        return this.destination;
    }

    private boolean validMessageType(int n) {
        return n == 0 || n == 1 || n == -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(140);
        stringBuffer.append("Message Header:  ");
        stringBuffer.append("  Version = ");
        stringBuffer.append(this.version.toString());
        stringBuffer.append("  ");
        stringBuffer.append("  Message Type = ");
        stringBuffer.append(this.messageType.toString());
        stringBuffer.append("  ");
        stringBuffer.append("  Message ID = ");
        stringBuffer.append(this.messageID.toString());
        stringBuffer.append("  ");
        stringBuffer.append("  Message Length = ");
        stringBuffer.append(this.messageLength.toString());
        stringBuffer.append("  ");
        stringBuffer.append("  Source Address:  ");
        stringBuffer.append(this.source.toString());
        stringBuffer.append("  Destination Address:  ");
        stringBuffer.append(this.destination.toString());
        return stringBuffer.toString();
    }

    public void setDestinationAddress(String string) {
        NIMessageRouterAddress nIMessageRouterAddress;
        this.destination = nIMessageRouterAddress = new NIMessageRouterAddress(this.destination.getProcessChannelID(), string);
    }
}

