/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessage;
import com.ibm.storage.ess.ni.messageRouter.NIMessageHeader;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEstablishConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterInputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterOutputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterSocketConnection;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class NIMessageRouterHeartbeatThread
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterHeartbeatThread == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterHeartbeatThread = NIMessageRouterHeartbeatThread.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageRouterHeartbeatThread")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterHeartbeatThread);
    public static final int SLEEPTIME = 5000;
    private static final int NODE_TIMEOUT = 32000;
    private static final int LOG_HEARTBEAT = 600000;
    private NIMessageRouterAddress myAddress;
    private static NIMessageRouterChannel myChannel;
    private static NIMessageRouter myMRInterface;
    private static NIMessageRouterOutputStream myOutputStream;
    private static NIMessageRouterInputStream myInputStream;
    private static NIReceiveHeartbeatThread myHeartbeatReceiverThread;
    private boolean isRunning;
    private Map timeoutTable;
    private int counter = 1;
    private static final Logger mrLogger;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterHeartbeatThread;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterThread;

    public NIMessageRouterHeartbeatThread() {
        super("NIMessageRouterHeartbeatThread");
        myMRInterface = NIMessageRouterFactory.getInstanceOf();
        this.isRunning = false;
        this.timeoutTable = Collections.synchronizedMap(new Hashtable());
        this.counter = 0;
    }

    public void run() {
        logger.debug_general("Starting NIMessageRouterHeartbeat sender thread");
        try {
            myChannel = myMRInterface.createNIMessageRouterChannel(9);
        }
        catch (NIMessageRouterException nIMessageRouterException) {
            logger.error("Unable to create Message Router channel");
            logger.throwable((Throwable)nIMessageRouterException);
            return;
        }
        myInputStream = myChannel.getNIMessageRouterInputStream();
        myInputStream.open();
        myOutputStream = myChannel.getNIMessageRouterOutputStream();
        myHeartbeatReceiverThread = new NIReceiveHeartbeatThread();
        myHeartbeatReceiverThread.start();
        this.isRunning = true;
        while (this.isRunning) {
            long l = System.currentTimeMillis();
            this.sendHeartbeat();
            long l2 = 5000L - System.currentTimeMillis() + l;
            try {
                if (l2 <= 0L) continue;
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                this.isRunning = false;
                logger.warning("NIMessageRouterHeartbeat sender interrupted.");
            }
        }
    }

    public void shutdown() {
        logger.debug_general("Stopping the NIMessageRouterHeartbeat sender thread");
        this.isRunning = false;
        this.interrupt();
        try {
            if (myOutputStream != null) {
                myOutputStream.close();
            }
        }
        catch (IOException iOException) {
            logger.error("Failed to close NIMessageRouterHeartbeat output stream. ");
            logger.throwable((Throwable)iOException);
        }
        if (myInputStream != null) {
            myInputStream.close();
        }
        if (myHeartbeatReceiverThread != null) {
            myHeartbeatReceiverThread.shutdown();
        }
        myMRInterface.destroyNIMessageRouterChannel(myChannel);
    }

    private void sendHeartbeat() {
        String string = NIMessageRouterMetaData.getEssServerName();
        NIRoutingTable nIRoutingTable = NIRoutingTable.getRoutingTable();
        NIRoutingTableEntry nIRoutingTableEntry = nIRoutingTable.get(string);
        this.myAddress = new NIMessageRouterAddress(9, string);
        ArrayList<NIRoutingTableEntry> arrayList = new ArrayList<NIRoutingTableEntry>();
        Iterator iterator = NIRoutingTable.getRoutingTable().iterator();
        while (iterator.hasNext()) {
            NIRoutingTableEntry nIRoutingTableEntry2 = (NIRoutingTableEntry)iterator.next();
            String string2 = nIRoutingTableEntry2.getEssServerName();
            if (string.equals(string2)) continue;
            NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
            NIMessageRouterAddress nIMessageRouterAddress = new NIMessageRouterAddress(9, string2);
            NIMessageHeader nIMessageHeader = new NIMessageHeader(this.myAddress, nIMessageRouterAddress, 99, this.counter);
            long l = System.currentTimeMillis();
            try {
                nIMessageRouterReturnStatus = myOutputStream.send(nIMessageRouterAddress, 99, new NIMessage(nIMessageHeader, nIRoutingTableEntry));
            }
            catch (IOException iOException) {
                logger.error("IOException sending heartbeat message to " + string2 + " " + iOException.getMessage());
            }
            long l2 = System.currentTimeMillis() - l;
            if (nIMessageRouterReturnStatus.getStatus() == 9) {
                logger.debug_general("Send S HB: " + string2 + " - " + l2 + " id = " + this.counter);
                if (l2 > 6000L) {
                    mrLogger.warning("Send S HB: " + string2 + " - " + l2 + " id = " + this.counter);
                }
            } else {
                logger.debug_general("Send F HB: " + string2 + " - " + l2 + " id = " + this.counter);
                arrayList.add(nIRoutingTableEntry2);
            }
            nIMessageRouterReturnStatus = null;
            nIMessageRouterAddress = null;
            nIMessageHeader = null;
            ++this.counter;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.checkForNodeTimeOut((NIRoutingTableEntry)iterator.next());
        }
    }

    private boolean isNodeTimedOut(NIRoutingTableEntry nIRoutingTableEntry) {
        boolean bl;
        Date date = new Date();
        long l = date.getTime();
        long l2 = 0L;
        l2 = nIRoutingTableEntry.getTimeStamp();
        long l3 = l - l2;
        boolean bl2 = bl = l3 > 6000L;
        if (bl) {
            logger.warning("Node: " + nIRoutingTableEntry.getEssServerName() + " to: " + l3);
            mrLogger.warning("Node: " + nIRoutingTableEntry.getEssServerName() + " to: " + l3);
        }
        return l3 > 32000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForNodeTimeOut(NIRoutingTableEntry nIRoutingTableEntry) {
        NIRoutingTableEntry nIRoutingTableEntry2 = nIRoutingTableEntry;
        synchronized (nIRoutingTableEntry2) {
            if (this.timeoutTable.get(nIRoutingTableEntry.getKey()) != null && this.isNodeTimedOut(nIRoutingTableEntry)) {
                NIMessageRouterSocketConnection nIMessageRouterSocketConnection = NIMessageRouterEstablishConnectionMonitor.getConnectionTable().get(nIRoutingTableEntry.getEssServerName());
                this.timeoutTable.remove(nIRoutingTableEntry.getEssServerName());
                mrLogger.warning("Node  " + nIRoutingTableEntry.getEssServerName() + " Primary Network Interface OFFLINE");
                if (nIMessageRouterSocketConnection == null || nIMessageRouterSocketConnection != null && !nIMessageRouterSocketConnection.isConnecting()) {
                    mrLogger.warning("Removing connection for - " + nIRoutingTableEntry.getEssServerName());
                    NIMessageRouterConnectionMonitor.getConnectionMonitor().remove(nIRoutingTableEntry.getEssServerName());
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        mrLogger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterThread == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterThread = NIMessageRouterHeartbeatThread.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageRouterThread")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterThread);
    }

    private class NIReceiveHeartbeatThread
    extends Thread {
        private boolean receiving;

        public NIReceiveHeartbeatThread() {
            super("NIReceiveHeartbeatThread");
            this.receiving = false;
        }

        public void run() {
            NIMessage nIMessage = null;
            NIRoutingTable nIRoutingTable = NIRoutingTable.getRoutingTable();
            logger.debug_general("Starting the NIMessageRouterHeartbeat receiver thread");
            this.receiving = true;
            while (this.receiving) {
                try {
                    nIMessage = (NIMessage)myInputStream.readObject();
                }
                catch (InterruptedException interruptedException) {
                    this.receiving = false;
                    logger.warning("NIMessageRouterHeartbeat receiver interrupted.");
                }
                catch (NIMessageRouterException nIMessageRouterException) {
                    this.receiving = false;
                    logger.error("NIMessageRouterHeartbeat receiver threw NIMessageRouterException " + nIMessageRouterException.getMRErrorMessage());
                }
                if (nIMessage != null && nIMessage.getMessageHeader().getMessageType() == 99) {
                    NIRoutingTableEntry nIRoutingTableEntry;
                    String string = nIMessage.getMessageHeader().getSourceAddress().getEssServerName();
                    int n = nIMessage.getMessageHeader().getMessageID();
                    logger.debug_general("Recv HB: " + string + " id = " + n);
                    if (NIMessageRouterHeartbeatThread.this.timeoutTable.get(string) == null) {
                        NIMessageRouterHeartbeatThread.this.timeoutTable.put(string, new Boolean(true));
                        logger.warning("Node  " + string + " Primary Network Interface ONLINE ");
                    }
                    if ((nIRoutingTableEntry = (NIRoutingTableEntry)nIMessage.getMessage()) != null && nIRoutingTable.contains(string)) {
                        NIRoutingTableEntry nIRoutingTableEntry2 = nIRoutingTable.get(string);
                        nIRoutingTableEntry2.updateTimeStamp();
                    }
                } else {
                    logger.debug_general("Received message type " + nIMessage.getMessageHeader().getMessageType() + "from heartbeat channel");
                }
                nIMessage = null;
            }
        }

        public void shutdown() {
            logger.debug_general("Stopping the NIMessageRouterHeartbeat receiver thread");
            this.receiving = false;
            this.interrupt();
        }
    }
}

