/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NILocalPortManager;
import com.ibm.storage.ess.ni.messageRouter.NIMessage;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnection;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEstablishConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableFile;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;

public class NIMessageRouterSocketConnection
extends NIMessageRouterConnection {
    private InetAddress essServerIP;
    private int essServerPort;
    private Socket essServerSocket;
    private int localPort;
    private ObjectOutputStream oos = null;
    private NIMessageRouterReturnStatus status = null;
    private Object socketLock = new Object();
    private Object stateLock = new Object();
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterSocketConnection == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterSocketConnection = NIMessageRouterSocketConnection.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageRouterSocketConnection")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterSocketConnection);
    public static final int POLL_INTERVAL = 250;
    private volatile boolean isHeartbeat = false;
    private long launchTime = 0L;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterSocketConnection;

    public NIMessageRouterSocketConnection(String string, InetAddress inetAddress, int n, boolean bl) {
        this(string, inetAddress, n, bl, null);
    }

    public NIMessageRouterSocketConnection(String string, InetAddress inetAddress, int n, boolean bl, Socket socket) {
        super(string, bl);
        this.setEssServerIP(inetAddress);
        this.setEssServerPort(n);
        this.setEssServerSocket(socket);
        this.freeLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NIMessageRouterReturnStatus writeMessage(NIMessage nIMessage) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        try {
            Object object = this.socketLock;
            synchronized (object) {
                ObjectOutputStream objectOutputStream = this.getOutputStream();
                objectOutputStream.reset();
                objectOutputStream.writeUnshared(nIMessage);
                objectOutputStream.flush();
            }
        }
        catch (SocketException socketException) {
            return new NIMessageRouterReturnStatus(-14);
        }
        catch (NotSerializableException notSerializableException) {
            return new NIMessageRouterReturnStatus(-8);
        }
        catch (InvalidClassException invalidClassException) {
            return new NIMessageRouterReturnStatus(-8);
        }
        catch (IOException iOException) {
            return new NIMessageRouterReturnStatus(-9);
        }
        catch (NIMessageRouterException nIMessageRouterException) {
            return new NIMessageRouterReturnStatus(nIMessageRouterException.getMRErrorValue());
        }
        return nIMessageRouterReturnStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIMessageRouterReturnStatus close() {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        logger.debug_general("Closing socket " + this.getName());
        Object object = this.socketLock;
        synchronized (object) {
            try {
                this.closeOutputStream();
                logger.debug_general("OStream closed " + this.getName());
            }
            catch (Exception exception) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-10);
            }
            try {
                if (this.essServerSocket != null) {
                    logger.debug_general("Sock closing " + this.getName());
                    this.essServerSocket.close();
                    logger.debug_general("Sock closed " + this.getName());
                    logger.throwable(new Throwable());
                }
            }
            catch (IOException iOException) {
                logger.throwable((Throwable)iOException);
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-9);
            }
            catch (NullPointerException nullPointerException) {
                logger.throwable((Throwable)nullPointerException);
            }
            this.setEssServerSocket(null);
            this.freeLocalPort();
        }
        return nIMessageRouterReturnStatus;
    }

    protected NIMessageRouterReturnStatus getLastStatus() {
        return this.status;
    }

    private void setEssServerIP(InetAddress inetAddress) {
        this.essServerIP = inetAddress;
    }

    protected InetAddress getEssServerIP() {
        return this.essServerIP;
    }

    private void setEssServerPort(int n) {
        this.essServerPort = n;
    }

    protected int getEssServerPort() {
        return this.essServerPort;
    }

    public Socket getPrimarySocket() {
        return this.essServerSocket;
    }

    public Socket getEssServerSocket() {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-6);
        if (this.essServerSocket == null) {
            if (this.isUsingPrimaryConnection()) {
                nIMessageRouterReturnStatus = this.checkForInvalidLocalIP(NIMessageRouterMetaData.getPrimaryInetAddress(), true);
                if (nIMessageRouterReturnStatus.getStatus() == 9) {
                    nIMessageRouterReturnStatus = this.createEssServerSocket(this.getEssServerIP(), this.getEssServerPort(), NIMessageRouterMetaData.getPrimaryInetAddress());
                }
            } else {
                nIMessageRouterReturnStatus = this.checkForInvalidLocalIP(NIMessageRouterMetaData.getSecondaryInetAddress(), false);
                if (nIMessageRouterReturnStatus.getStatus() == 9) {
                    nIMessageRouterReturnStatus = this.createEssServerSocket(this.getEssServerIP(), this.getEssServerPort(), NIMessageRouterMetaData.getSecondaryInetAddress());
                }
            }
        }
        this.setLastStatus(nIMessageRouterReturnStatus);
        return this.essServerSocket;
    }

    private NIMessageRouterReturnStatus checkForInvalidLocalIP(InetAddress inetAddress, boolean bl) {
        InetAddress inetAddress2 = null;
        try {
            inetAddress2 = NIAgentProperties.is1750() ? new NIRoutingTableFile(null).getLocalIP() : null;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (inetAddress.isLoopbackAddress() || inetAddress2 != null && !inetAddress2.equals(inetAddress)) {
            if (inetAddress2 == null || inetAddress2.isLoopbackAddress()) {
                logger.error("Local address is loop back address. " + inetAddress2);
                return new NIMessageRouterReturnStatus(-20);
            }
            NIRoutingTableEntry nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get(NIMessageRouterMetaData.getEssServerName());
            if (bl) {
                nIRoutingTableEntry.setPrimaryIP(inetAddress2);
                NIMessageRouterMetaData.setPrimaryInetAddress(inetAddress2);
                logger.debug_general("Local IP Address updated (" + inetAddress + " -> " + inetAddress2);
                if (NIAgentProperties.is1750()) {
                    nIRoutingTableEntry.setSecondaryIP(inetAddress2);
                    NIMessageRouterMetaData.setSecondaryInetAddress(inetAddress2);
                }
            } else {
                nIRoutingTableEntry.setSecondaryIP(inetAddress2);
                NIMessageRouterMetaData.setSecondaryInetAddress(inetAddress2);
            }
            if (NIAgentProperties.is1750()) {
                new NIRoutingTableFile(NIMessageRouterMetaData.getFileNamePath()).writeRoutingTableFile(null);
            }
        }
        return new NIMessageRouterReturnStatus(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEssServerSocket(Socket socket) {
        Object object = this.stateLock;
        synchronized (object) {
            this.essServerSocket = socket;
            if (socket != null) {
                this.setConnecting(false);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private NIMessageRouterReturnStatus createEssServerSocket(InetAddress var1_1, int var2_2, InetAddress var3_3) {
        var4_4 = new NIMessageRouterReturnStatus(9);
        var5_5 = null;
        var6_6 = 0;
        var7_7 = 0;
        while (true) {
            try {
                if (NIAgentProperties.getAgentType() == 4 && var2_2 == 1759) {
                    NIMessageRouterSocketConnection.logger.debug_general("Connecting to PCIX " + this.getName());
                    var5_5 = NIMessageRouterMetaData.getSocketConnectionFactory().createNewSocket(var1_1, var2_2);
                    this.oos = new ObjectOutputStream(var5_5.getOutputStream());
                } else {
                    var6_6 = this.getLocalPort();
                    if (var6_6 == 0) {
                        NIMessageRouterSocketConnection.logger.warning("Unable to find local port from interface: " + var3_3 + " To IP: " + var1_1);
                        NIMessageRouterSocketConnection.logger.throwable((Throwable)new NIMessageRouterException(-11, "Trying to connect to IP " + this.getEssServerIP()));
                        return new NIMessageRouterReturnStatus(-11);
                    }
                    var5_5 = NIMessageRouterMetaData.areSSLConnectionsActive() != false ? NIMessageRouterMetaData.getSocketConnectionFactory().createNewSocket(var1_1, var2_2, var3_3, var6_6) : new Socket(var1_1, var2_2, var3_3, var6_6);
                    this.oos = new ObjectOutputStream(var5_5.getOutputStream());
                }
                this.setEssServerSocket(var5_5);
                return var4_4;
            }
            catch (BindException var8_8) {
                NIMessageRouterSocketConnection.logger.trace("Bind Exception.  Port = " + var6_6 + "  IP = " + var1_1);
                this.discardLocalPort();
                if (++var7_7 <= 35) continue;
                NIMessageRouterSocketConnection.logger.throwable((Throwable)new NIMessageRouterException(-11, "Too many retries.  Trying to connect to IP " + this.getEssServerIP()));
                return new NIMessageRouterReturnStatus(-11);
            }
            catch (ConnectException var9_10) {
                NIMessageRouterSocketConnection.logger.debug_general("Unable to connect from interface: " + var3_3 + "  port: " + var2_2 + " To IP: " + var1_1 + " msg = " + var9_10.getMessage());
                return new NIMessageRouterReturnStatus(-6);
            }
            catch (NoRouteToHostException var10_11) {
                NIMessageRouterSocketConnection.logger.debug_general("No route to host from interface: " + var3_3 + " To IP: " + var1_1);
                return new NIMessageRouterReturnStatus(-6);
            }
            catch (PortUnreachableException var11_12) {
                NIMessageRouterSocketConnection.logger.debug_general("Port unreachable from interface: " + var3_3 + " To IP: " + var1_1);
                return new NIMessageRouterReturnStatus(-6);
            }
            catch (SocketException var12_9) {
                NIMessageRouterSocketConnection.logger.debug_general("Socket Exception.  Port = " + var6_6 + "  IP = " + var1_1 + " msg = " + var12_9.getMessage());
                this.discardLocalPort();
                if (var12_9.getMessage().indexOf("Operation timed out") >= 0 || ++var7_7 > 1) ** break;
                continue;
                NIMessageRouterSocketConnection.logger.debug_general("Unable to create connection from interface: " + var3_3 + " To IP: " + var1_1);
                return new NIMessageRouterReturnStatus(-18);
            }
            catch (SSLHandshakeException var13_13) {
                NIMessageRouterSocketConnection.logger.debug_general("SSL failed when establishing connection from interface: " + var3_3 + " To IP: " + var1_1 + " msg = " + var13_13.getMessage());
                NIMessageRouterSocketConnection.logger.throwable((Throwable)var13_13);
                return new NIMessageRouterReturnStatus(-13);
            }
            catch (IOException var14_14) {
                try {
                    NIMessageRouterSocketConnection.logger.warning("I/O Exception. Closing socket");
                    this.close();
                    if (var5_5 != null) {
                        var5_5.close();
                        var5_5 = null;
                    }
                }
                catch (Exception var15_15) {
                    NIMessageRouterSocketConnection.logger.warning("Problems closing socket: " + var15_15.getMessage());
                }
                NIMessageRouterSocketConnection.logger.debug_general("I/O error in establishing connection from interface: " + var3_3 + " To IP: " + var1_1 + " msg = " + var14_14.getMessage());
                return new NIMessageRouterReturnStatus(-6);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConnecting() {
        int n;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.essServerSocket != null) {
                return;
            }
            if (this.isConnecting()) {
                int n2 = n = System.currentTimeMillis() - this.launchTime < 10000L ? 1 : 0;
                if (n == 0) {
                    return;
                }
            } else {
                logger.debug_general("Launching background thread " + this.getName() + " isHB = " + this.isHeartbeat);
                NIMessageRouterEstablishConnectionMonitor.getConnectionTable().add(this);
                this.launchTime = System.currentTimeMillis();
            }
        }
        try {
            if (!this.isHeartbeat) {
                n = 5000;
                if (this.getEssServerPort() == 1759) {
                    n = 20000;
                    logger.debug_general("Waiting for PCIX connection " + this.getName());
                }
                int n3 = 0;
                while (n3 < 5000 && this.essServerSocket == null) {
                    Thread.sleep(250L);
                    n3 += 250;
                }
            }
            if (this.essServerSocket != null) {
                NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop(this.getKey());
            }
            logger.warning("socket connected ? = " + (this.essServerSocket != null) + " " + this.getName());
        }
        catch (InterruptedException interruptedException) {}
    }

    public ObjectOutputStream getOutputStream() throws NIMessageRouterException {
        if (NIAgentProperties.is1750()) {
            this.startConnecting();
        } else {
            this.getEssServerSocket();
        }
        if (this.essServerSocket == null) {
            throw new NIMessageRouterException(-6, "Trying to connect to IP " + this.getEssServerIP());
        }
        try {
            if (this.oos == null) {
                this.oos = new ObjectOutputStream(this.essServerSocket.getOutputStream());
            }
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
            throw new NIMessageRouterException(-15, " " + iOException.getMessage() + " " + "Unable to create output stream to IP " + this.getEssServerIP());
        }
        return this.oos;
    }

    private void closeOutputStream() throws NIMessageRouterException {
        block2: {
            if (this.oos == null) break block2;
            try {
                this.oos.flush();
                this.oos.reset();
                this.oos.close();
                this.oos = null;
            }
            catch (IOException iOException) {
                this.oos = null;
            }
        }
    }

    private void discardLocalPort() {
        if (this.localPort != 0) {
            NILocalPortManager.getPortManager().discardLocalPort(this.localPort);
        }
        this.localPort = 0;
    }

    private void freeLocalPort() {
        if (this.localPort != 0) {
            NILocalPortManager.getPortManager().freeLocalPort(this.localPort);
        }
        this.localPort = 0;
    }

    private int getLocalPort() {
        if (this.localPort == 0) {
            this.localPort = NILocalPortManager.getPortManager().getLocalPort();
        }
        return this.localPort;
    }

    private void setLastStatus(NIMessageRouterReturnStatus nIMessageRouterReturnStatus) {
        this.status = nIMessageRouterReturnStatus;
    }

    public ObjectInputStream getInputStream() {
        ObjectInputStream objectInputStream;
        block2: {
            objectInputStream = null;
            if (this.essServerSocket == null) break block2;
            try {
                objectInputStream = new ObjectInputStream(this.essServerSocket.getInputStream());
            }
            catch (IOException iOException) {
                logger.error("Unable to create input stream " + this.getKey() + " IP " + this.essServerIP);
            }
        }
        return objectInputStream;
    }

    public void connect() {
        this.connect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(boolean bl) {
        try {
            Object object = this.socketLock;
            synchronized (object) {
                this.isHeartbeat = bl;
                this.getOutputStream();
            }
        }
        catch (NIMessageRouterException nIMessageRouterException) {}
    }

    public String getName() {
        return "[" + this.getKey() + ":" + this.essServerIP + ":" + this.localPort + "]";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Connection Table Entry = ");
        stringBuffer.append("\n");
        stringBuffer.append("  ESS Server Name = ");
        stringBuffer.append(this.getKey());
        stringBuffer.append("\n");
        stringBuffer.append("  ESS IP = ");
        stringBuffer.append(this.essServerIP);
        stringBuffer.append("\n");
        stringBuffer.append("  ESS Server Port = ");
        stringBuffer.append(this.essServerPort);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

