/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.jni.mr.NIMRClientInt;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIDomainGroupTable;
import com.ibm.storage.ess.ni.messageRouter.NILocalPortManager;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.StringTokenizer;

public class NIRoutingTableFile {
    private static final int TOKENS_PER_RECORD = 5;
    private static final int TOKENS_PER_TEST_RECORD = 6;
    private static final int NUMBER_OF_IPS = 2;
    private static final int NUMBER_OF_REEF_ATTRIBUTES = 6;
    private static final int MODEL_INDEX = 2;
    private static final int TYPE_INDEX = 1;
    private static final int SERIAL_INDEX = 3;
    private static final int MANUFACTURE_INDEX = 0;
    private static final int CLUSTER_ID_INDEX = 4;
    private static final int WWNN_INDEX = 5;
    private static final String COMMENT_LINE = "# Server Name, Primary IP, Secondary IP, Domain Group ID, Port";
    private static final String TEST_COMMENT_LINE = "# Server Name, Primary IP, Secondary IP, Domain Group ID, Port Outbound Port, Host Machine [true|false]";
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableFile == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableFile = NIRoutingTableFile.class$("com.ibm.storage.ess.ni.messageRouter.NIRoutingTableFile")) : class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableFile);
    private String fileName = null;
    private String nodeServerName = null;
    private String altNodeServerName = null;
    private InetAddress nodeIP = null;
    private InetAddress altNodeIP = null;
    private String domainGroupID = null;
    private boolean thisServerIdentified = false;
    private boolean thisServerChanged = false;
    private static Object fileLock = new Object();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableFile;

    public NIRoutingTableFile(String string) {
        this.setFileName(string);
    }

    public void reinitializeRoutingInformation() {
        File file = null;
        try {
            file = new File(this.getFileName());
            if (file.exists()) {
                if (!file.delete()) {
                    logger.error("Unable to delete Routing Table File for reinitialization");
                } else {
                    logger.trace("Routing Table File Deleted for reinitialization");
                }
            }
        }
        catch (Exception exception) {
            logger.error("Unable to create Routing Table File for reinitialization" + this.getFileName());
        }
        this.readRoutingTableFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRoutingTableFile(File file) {
        Object object = fileLock;
        synchronized (object) {
            File file2 = null;
            file2 = file == null ? this.createTmpFile() : file;
            BufferedWriter bufferedWriter = this.getOutputStream(file2);
            try {
                bufferedWriter.write(COMMENT_LINE, 0, COMMENT_LINE.length());
                bufferedWriter.newLine();
                Iterator iterator = NIRoutingTable.getRoutingTable().iterator();
                while (iterator.hasNext()) {
                    NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
                    String string = this.createFileRecord(nIRoutingTableEntry);
                    bufferedWriter.write(string, 0, string.length());
                    bufferedWriter.newLine();
                }
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                logger.throwable((Throwable)iOException);
            }
            if (file == null) {
                this.renameFile(file2);
            }
            return;
        }
    }

    public void readRoutingTableFile() {
        BufferedReader bufferedReader = this.getInputStream();
        if (bufferedReader != null) {
            try {
                Object object;
                try {
                    object = bufferedReader.readLine();
                    while (object != null) {
                        this.readFileRecord((String)object);
                        object = bufferedReader.readLine();
                    }
                }
                catch (NIMessageRouterException nIMessageRouterException) {
                    logger.throwable((Throwable)nIMessageRouterException);
                }
                catch (Exception exception) {
                    logger.warning("Error reading file");
                    logger.throwable((Throwable)exception);
                }
                if (!this.isThisServerIdentified()) {
                    logger.error("Invalid Routing Table:  host server not identified.  Creating new routing table.");
                    try {
                        object = new File(this.getFileName());
                        if (((File)object).exists()) {
                            bufferedReader.close();
                            if (!((File)object).delete()) {
                                logger.error("Unable to delete Routing Table File");
                            } else {
                                logger.trace("Routing Table File Deleted");
                            }
                        }
                        if (!((File)object).createNewFile()) {
                            logger.error("Unable to create routing file.");
                        } else {
                            this.setThisServerChanged(true);
                            logger.trace("Routing Table File Recreated");
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Unable to create Routing Table File" + this.getFileName());
                    }
                }
                bufferedReader.close();
                if (this.isThisServerChanged()) {
                    this.initializeRoutingTable(false);
                    this.writeRoutingTableFile(new File(this.getFileName()));
                }
            }
            catch (IOException iOException) {
                logger.throwable((Throwable)iOException);
            }
        }
        try {
            if (NIAgentProperties.getAgentType() == 4) {
                Runtime.getRuntime().exec("chmod 777 " + this.getFileName());
            }
        }
        catch (Exception exception) {
            logger.error("Exception when trying to change file permissions");
        }
    }

    private String createFileRecord(NIRoutingTableEntry nIRoutingTableEntry) {
        Object var2_2 = null;
        String string = new String();
        string = nIRoutingTableEntry.getEssServerName() + " ";
        string = string + nIRoutingTableEntry.getPrimaryIP().getHostAddress() + " ";
        string = string + nIRoutingTableEntry.getSecondaryIP().getHostAddress() + " ";
        string = string + nIRoutingTableEntry.getDomainGroupID() + " ";
        string = string + Integer.toString(nIRoutingTableEntry.getEssServerPort()) + " ";
        if (NIMessageRouterMetaData.isNodeThisServer(nIRoutingTableEntry)) {
            string = string + Integer.toString(NILocalPortManager.getBasePortValue()) + " ";
        }
        return string;
    }

    private void readFileRecord(String string) throws NIMessageRouterException {
        if (string.charAt(0) == '#') {
            return;
        }
        NIRoutingTableEntry nIRoutingTableEntry = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() == 6) {
            nIRoutingTableEntry = this.parseLocalRecord(stringTokenizer);
        } else if (stringTokenizer.countTokens() == 5) {
            nIRoutingTableEntry = this.parseRemoteRecord(stringTokenizer);
        } else {
            throw new NIMessageRouterException("MR Routing Table File Exception:  incorrect number of tokens per line");
        }
        NIDomainGroupTable.getDomainGroupTable().add(nIRoutingTableEntry.getDomainGroupID(), nIRoutingTableEntry.getEssServerName());
        NIRoutingTable.getRoutingTable().add(nIRoutingTableEntry);
    }

    private NIRoutingTableEntry parseLocalRecord(StringTokenizer stringTokenizer) {
        NIRoutingTableEntry nIRoutingTableEntry = null;
        try {
            String string = stringTokenizer.nextToken();
            InetAddress inetAddress = InetAddress.getByName(stringTokenizer.nextToken());
            InetAddress inetAddress2 = InetAddress.getByName(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            nIRoutingTableEntry = new NIRoutingTableEntry(string, inetAddress, inetAddress2, n, n, string2);
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            NILocalPortManager.setBasePortValue(n2);
            NIMessageRouterMetaData.setNodeData(string, inetAddress, inetAddress2, n, string2);
            if (NIAgentProperties.getAgentType() != 2 && NIAgentProperties.getAgentType() != 3) {
                try {
                    InetAddress inetAddress3 = null;
                    InetAddress inetAddress4 = null;
                    if (NIAgentProperties.getAgentType() == 4) {
                        this.getDomainInformation();
                        inetAddress3 = this.getNodeIP();
                        inetAddress4 = this.getAltNodeIP();
                        string = this.getNodeServerName();
                        string2 = this.getDomainGroupID();
                        n = NIMessageRouterMetaData.getEssServerPort();
                    } else {
                        inetAddress3 = this.getLocalIP();
                    }
                    if (!inetAddress3.equals(inetAddress)) {
                        logger.warning("IP address for " + string + " has changed.  " + inetAddress3);
                        nIRoutingTableEntry = new NIRoutingTableEntry(string, inetAddress3, inetAddress3, n, n, string2);
                        NIMessageRouterMetaData.setNodeData(string, inetAddress3, inetAddress3, n, string2);
                        this.setThisServerChanged(true);
                    }
                }
                catch (Exception exception) {
                    logger.error("Unable to verify IP for " + nIRoutingTableEntry.getEssServerName());
                }
            }
            this.setThisServerIdentified(true);
        }
        catch (UnknownHostException unknownHostException) {
            logger.throwable((Throwable)unknownHostException);
        }
        return nIRoutingTableEntry;
    }

    public InetAddress getLocalIP() throws UnknownHostException {
        InetAddress inetAddress;
        block4: {
            String string = System.getProperty("com.ibm.storage.ess.ni.server.LocalAddress");
            try {
                if (string != null && !string.equals("")) {
                    inetAddress = InetAddress.getByName(string);
                    break block4;
                }
                if (NIAgentProperties.is1750() && !NIAgentProperties.isMC()) {
                    this.getDomainInformation();
                    inetAddress = this.getNodeIP();
                    break block4;
                }
                inetAddress = InetAddress.getLocalHost();
            }
            catch (Exception exception) {
                inetAddress = InetAddress.getLocalHost();
            }
        }
        return inetAddress;
    }

    private NIRoutingTableEntry parseRemoteRecord(StringTokenizer stringTokenizer) {
        NIRoutingTableEntry nIRoutingTableEntry;
        block7: {
            nIRoutingTableEntry = null;
            try {
                String string = stringTokenizer.nextToken();
                InetAddress inetAddress = InetAddress.getByName(stringTokenizer.nextToken());
                InetAddress inetAddress2 = InetAddress.getByName(stringTokenizer.nextToken());
                String string2 = stringTokenizer.nextToken();
                int n = Integer.parseInt(stringTokenizer.nextToken());
                nIRoutingTableEntry = new NIRoutingTableEntry(string, inetAddress, inetAddress2, n, n, string2);
                if (NIAgentProperties.getAgentType() == 2 || NIAgentProperties.getAgentType() == 3) break block7;
                try {
                    InetAddress inetAddress3 = null;
                    Object var9_12 = null;
                    if (NIAgentProperties.getAgentType() == 4 && string2.compareTo("HMC") != 0) {
                        this.getDomainInformation();
                        inetAddress3 = this.getAltNodeIP();
                        string = this.getAltNodeServerName();
                        string2 = this.getDomainGroupID();
                        if (!inetAddress3.equals(inetAddress)) {
                            logger.warning("IP address for alternate node " + string + " has changed.  " + inetAddress3);
                            nIRoutingTableEntry = new NIRoutingTableEntry(string, inetAddress3, inetAddress3, n, n, string2);
                            this.setThisServerChanged(true);
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error("Unable to verify IP for " + nIRoutingTableEntry.getEssServerName());
                }
            }
            catch (UnknownHostException unknownHostException) {
                logger.throwable((Throwable)unknownHostException);
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
            }
        }
        return nIRoutingTableEntry;
    }

    private BufferedReader getInputStream() {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.getFileName())));
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.debug_general("Creating empty routing table file" + this.getFileName());
            try {
                File file = new File(this.getFileName());
                if (!file.createNewFile()) {
                    logger.error("Unable to create routing file.");
                } else {
                    this.initializeRoutingTable(true);
                    this.writeRoutingTableFile(file);
                }
            }
            catch (IOException iOException) {
                logger.error("Unable to create Routing Table File" + this.getFileName());
            }
        }
        return bufferedReader;
    }

    private void initializeRoutingTable(boolean bl) {
        NIRoutingTableEntry nIRoutingTableEntry = null;
        String string = null;
        String string2 = new String();
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        if (NIAgentProperties.getAgentType() == 4) {
            try {
                this.getDomainInformation();
                inetAddress2 = inetAddress = this.getNodeIP();
                string2 = this.getNodeServerName();
                string = this.getDomainGroupID();
            }
            catch (Exception exception) {
                logger.error("Unable to initialize Routing Table File for " + string2);
            }
        } else {
            try {
                string2 = NIMessageRouterMetaData.getEssServerName();
                if (bl || string2 == null || string2.compareTo("") == 0) {
                    string2 = "HMC1";
                }
                inetAddress = inetAddress2 = this.getLocalIP();
                string = "HMC";
            }
            catch (Exception exception) {
                logger.error("Unable to initialize Routing Table File for " + string2);
            }
        }
        int n = NIMessageRouterMetaData.getEssServerPort();
        nIRoutingTableEntry = new NIRoutingTableEntry(string2, inetAddress, inetAddress2, n, n, string);
        NIMessageRouterMetaData.setNodeData(string2, inetAddress, inetAddress2, n, string);
        NIDomainGroupTable.getDomainGroupTable().add(nIRoutingTableEntry.getDomainGroupID(), nIRoutingTableEntry.getEssServerName());
        NIRoutingTable.getRoutingTable().add(nIRoutingTableEntry);
        this.setThisServerIdentified(true);
        if (NIAgentProperties.getAgentType() == 4) {
            inetAddress2 = inetAddress = this.getAltNodeIP();
            string2 = this.getAltNodeServerName();
            nIRoutingTableEntry = new NIRoutingTableEntry(string2, inetAddress, inetAddress2, n, n, string);
            NIDomainGroupTable.getDomainGroupTable().add(nIRoutingTableEntry.getDomainGroupID(), nIRoutingTableEntry.getEssServerName());
            NIRoutingTable.getRoutingTable().add(nIRoutingTableEntry);
        }
    }

    private File createTmpFile() {
        File file = null;
        try {
            file = new File(this.getFileName() + "-TMP");
            if (file.exists()) {
                file.delete();
                logger.trace("TMP-Routing Table File Deleted");
            }
            if (!file.createNewFile()) {
                logger.error("Unable to create tmp routing file.");
            }
            logger.trace("TMP-Routing Table File Recreated");
        }
        catch (IOException iOException) {
            logger.error("Unable to create Routing Table File for writing" + this.getFileName());
        }
        return file;
    }

    private BufferedWriter getOutputStream(File file) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error("Unable to open Routing Table File for writing" + this.getFileName());
        }
        return bufferedWriter;
    }

    private void renameFile(File file) {
        File file2 = new File(this.getFileName());
        if (!file2.delete()) {
            logger.error("Unable to delete original routing file.");
        }
        logger.trace("Routing Table File Deleted for renaming");
        if (!file.renameTo(file2)) {
            logger.error("Unable to rename tmp routing file.");
        }
        logger.trace("Routing Table File Renamed");
    }

    private void getDomainInformation() {
        try {
            NIMRClientInt nIMRClientInt = new NIMRClientInt();
            String[] stringArray = new String[6];
            String[] stringArray2 = new String[2];
            nIMRClientInt.niMRGetEssServerEntries(stringArray);
            nIMRClientInt.niMRGetEssServerIps(stringArray2);
            String string = stringArray[4];
            NIESSID nIESSID = new NIESSID(stringArray[1], stringArray[0], stringArray[3], 0L);
            this.setNodeServerName(nIESSID.toString() + string);
            this.setNodeIP(InetAddress.getByName(stringArray2[0]));
            this.setDomainGroupID(nIESSID.toString());
            if (string.compareTo("0") == 0) {
                this.setAltNodeServerName(nIESSID.toString() + "1");
            } else if (string.compareTo("1") == 0) {
                this.setAltNodeServerName(nIESSID.toString() + "0");
            } else {
                logger.error("Invalid cluster ID " + string);
            }
            this.setAltNodeIP(InetAddress.getByName(stringArray2[1]));
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
    }

    public boolean checkDomainIP(InetAddress inetAddress, InetAddress inetAddress2) {
        try {
            NIMRClientInt nIMRClientInt = new NIMRClientInt();
            String[] stringArray = new String[2];
            nIMRClientInt.niMRGetEssServerIps(stringArray);
            if (inetAddress != null && inetAddress.getHostAddress().compareTo(stringArray[0]) == 0 && (inetAddress2 == null || inetAddress2.getHostAddress().compareTo(stringArray[1]) == 0)) {
                return true;
            }
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
        return false;
    }

    private void setFileName(String string) {
        this.fileName = string;
    }

    private String getFileName() {
        return this.fileName;
    }

    private void setThisServerIdentified(boolean bl) {
        this.thisServerIdentified = bl;
    }

    private boolean isThisServerIdentified() {
        return this.thisServerIdentified;
    }

    private void setThisServerChanged(boolean bl) {
        this.thisServerChanged = bl;
    }

    private boolean isThisServerChanged() {
        return this.thisServerChanged;
    }

    private void setDomainGroupID(String string) {
        this.domainGroupID = string;
    }

    private String getDomainGroupID() {
        return this.domainGroupID;
    }

    private void setNodeIP(InetAddress inetAddress) {
        this.nodeIP = inetAddress;
    }

    private InetAddress getNodeIP() {
        return this.nodeIP;
    }

    private void setAltNodeIP(InetAddress inetAddress) {
        this.altNodeIP = inetAddress;
    }

    private InetAddress getAltNodeIP() {
        return this.altNodeIP;
    }

    private void setNodeServerName(String string) {
        this.nodeServerName = string;
    }

    private String getNodeServerName() {
        return this.nodeServerName;
    }

    private void setAltNodeServerName(String string) {
        this.altNodeServerName = string;
    }

    private String getAltNodeServerName() {
        return this.altNodeServerName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

