/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.olc;

import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.olc.NIOlcCommon;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseHelper;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseMasterHelper;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseSchemaHelper;
import com.ibm.storage.ess.ni.olc.NIOlcEventProcessor;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class NIOlcDatabaseManager
extends Thread {
    private static final boolean EVENTS_ENABLED = true;
    private static final String DSN = "";
    private static final String USERNAME = "";
    private static final String PASSWORD = "";
    private static final String MASTER_DATABASE = "$_MASTER_DB_$";
    private static final short TYPE_MASTER = 0;
    private static final short TYPE_REGULAR = 1;
    private static final long SLEEP_TIME = 120000L;
    private static final String DATABASE_DRIVER = "com.ibm.db2j.jdbc.DB2jDriver";
    private static final String DATABASE_URL = "jdbc:db2j:";
    public static final String DATABASE_NOT_FOUND = "XJ004";
    public static final String CANNOT_DROP_TABLE = "42Y55";
    private static NIOlcDatabaseMasterHelper masterHelper = null;
    private static Map dbHelperPool = Collections.synchronizedMap(new HashMap());
    private static ArrayList alPermanentDatabases = new ArrayList();
    private static boolean isDatabaseLoading = true;
    private static Object databaseLock = new Object();
    private static Object masterLock = new Object();

    public NIOlcDatabaseManager() throws Exception {
        super("NIOlcDatabaseManager");
        Class.forName(DATABASE_DRIVER).newInstance();
    }

    public static boolean workingDatabaseExists(String string) {
        return dbHelperPool.containsKey(string);
    }

    public static boolean databaseExists(String string) {
        return alPermanentDatabases.contains(string);
    }

    public static void addDatabase(String string) {
        if (!alPermanentDatabases.contains(string)) {
            alPermanentDatabases.add(string);
        }
    }

    public static void removeDatabase(String string) {
        if (alPermanentDatabases.contains(string)) {
            alPermanentDatabases.remove(string);
        }
    }

    public static NIOlcDatabaseHelper getDatabaseHelper(String string) {
        if (string.indexOf("User") >= 0) {
            System.out.println("USER database is being accessed");
            new Exception().printStackTrace();
        }
        if (!dbHelperPool.containsKey(string)) {
            NIOlcDatabaseManager.initConnection(string);
        }
        return ((NIOlcDatabaseHelper)dbHelperPool.get(string)).getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NIOlcDatabaseMasterHelper getMasterDatabaseHelper() {
        Object object = masterLock;
        synchronized (object) {
            return masterHelper;
        }
    }

    public static boolean backupDatabase(String string, String string2) {
        boolean bl = true;
        try {
            NIOlcDatabaseManager.xcopy(string, string2);
        }
        catch (IOException iOException) {
            bl = false;
            NIOlcLogger.severe("Could not backup database", iOException);
        }
        return bl;
    }

    public static boolean dropDatabase(String string) {
        return NIOlcDatabaseManager.dropDatabase(string, false);
    }

    public static boolean dropDatabase(String string, boolean bl) {
        if (dbHelperPool.containsKey(string)) {
            ((NIOlcDatabaseHelper)dbHelperPool.get(string)).close();
            dbHelperPool.remove(string);
        }
        NIOlcDatabaseManager.shutdownDatabase(string);
        boolean bl2 = true;
        if (!bl) {
            bl2 = NIOlcDatabaseManager.deleteDir(new File(System.getProperty("db2j.system.home") + string));
        }
        return bl2;
    }

    private void cleanDBHome() throws Exception {
        NIOlcLogger.info("Beginning to clean DB Home");
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        String string = System.getProperty("db2j.system.home");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = true;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            String string2 = fileArray[n].getName();
            if (string2.substring(0, 1).equals("$") && !string2.endsWith("$")) {
                arrayList.add(string2);
            } else {
                arrayList2.add(string2);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            String string3 = ((String)arrayList.get(n2)).substring(1);
            if (!arrayList2.contains(string3)) {
                File file2 = new File(string + (String)arrayList.get(n2));
                if (NIOlcDatabaseManager.deleteDir(file2)) {
                    NIOlcLogger.info("Temporary DB:" + file2.getName() + " deleted.");
                    NIOlcLogger.info("DB:" + file2.getName() + " removed from master->" + (bl &= nIOlcDatabaseMasterHelper.deleteEnterpriseByDatabase(string3)));
                    alPermanentDatabases.remove(string3);
                } else {
                    NIOlcLogger.info("Unable to delete temporary DB:" + file2.getName());
                }
            }
            ++n2;
        }
        NIOlcLogger.info("Finished cleaning DB Home");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnections() throws Exception {
        Object object = masterLock;
        synchronized (object) {
            dbHelperPool.clear();
            masterHelper = (NIOlcDatabaseMasterHelper)NIOlcDatabaseManager.openDatabase(MASTER_DATABASE, (short)0);
        }
        if (masterHelper == null) {
            throw new Exception("OLC is unable to start");
        }
        Object object2 = databaseLock;
        synchronized (object2) {
            ArrayList arrayList = masterHelper.getDatabaseNames();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                alPermanentDatabases.add(string);
            }
        }
        NIOlcEventProcessor.startOlcEventProcessor();
    }

    public static void initConnection(String string) {
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper;
        if (dbHelperPool.containsKey(string)) {
            dbHelperPool.remove(string);
        }
        if ((nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.openDatabase(string, (short)1)) != null) {
            dbHelperPool.put(string, nIOlcDatabaseSchemaHelper);
        }
    }

    private void checkConnections() {
        try {
            if (masterHelper == null) {
                this.initConnections();
            } else if (masterHelper.getConnection() == null || masterHelper.getConnection().isClosed()) {
                this.initConnections();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Iterator iterator = dbHelperPool.values().iterator();
        while (iterator.hasNext()) {
            NIOlcDatabaseHelper nIOlcDatabaseHelper = (NIOlcDatabaseHelper)iterator.next();
            String string = nIOlcDatabaseHelper.getDatabaseName();
            try {
                if (!nIOlcDatabaseHelper.getConnection().isClosed()) continue;
                NIOlcLogger.info("Connection broken for database: " + string);
                nIOlcDatabaseHelper.close();
                iterator.remove();
                NIOlcDatabaseManager.initConnection(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static NIOlcDatabaseHelper openDatabase(String var0, short var1_1) {
        block12: {
            var2_2 = new Properties();
            var2_2.put("databaseName", var0);
            var3_3 = System.getProperty("db2j.system.home");
            var4_4 = false;
            var5_5 = null;
            var6_6 = null;
            try {
                var5_5 = DriverManager.getConnection("jdbc:db2j:", var2_2);
                break block12;
            }
            catch (SQLException var7_7) {
                NIOlcLogger.sql("", var7_7);
                if (var7_7.getSQLState().equals("XJ004")) {
                    if (NIOlcDatabaseManager.alPermanentDatabases.contains(NIOlcCommon.getRealDatabaseName(var0))) {
                        if (NIOlcDatabaseManager.backupDatabase(var3_3 + NIOlcCommon.getRealDatabaseName(var0), var3_3 + var0)) {
                            try {
                                var5_5 = DriverManager.getConnection("jdbc:db2j:", var2_2);
                            }
                            catch (SQLException var8_9) {
                                NIOlcLogger.info("Permanent found in master table, able to create temp but coneection failed");
                                NIOlcLogger.sql("", var8_9);
                            }
                        } else {
                            NIOlcLogger.info("Permanent found in master table, but database not found");
                        }
                    } else {
                        var5_5 = NIOlcDatabaseManager.createDatabase(var0);
                        var4_4 = true;
                    }
                }
                ** while ((var7_8 = var7_8.getNextException()) != null)
            }
lbl-1000:
            // 1 sources

            {
                NIOlcLogger.sql("", var7_8);
                continue;
            }
        }
        if (var5_5 != null) {
            var6_6 = var1_1 == 0 ? new NIOlcDatabaseMasterHelper(var5_5, var0) : new NIOlcDatabaseSchemaHelper(var5_5, var0);
            if (var4_4) {
                var6_6.generateSchema();
            }
            var6_6.prepareAllStatements();
        }
        return var6_6;
    }

    private static Connection createDatabase(String string) {
        Properties properties = new Properties();
        properties.put("databaseName", string);
        properties.put("create", "true");
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(DATABASE_URL, properties);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return connection;
    }

    private static void shutdownDatabase(String string) {
        block2: {
            if (string == null || string.length() <= 0) break block2;
            Properties properties = new Properties();
            properties.put("databaseName", string);
            properties.put("shutdown", "true");
            try {
                DriverManager.getConnection(DATABASE_URL, properties);
            }
            catch (Exception exception) {
                NIOlcLogger.severe(null, exception);
            }
        }
    }

    private void shutdownSystem() {
        Properties properties = new Properties();
        properties.put("shutdown", "true");
        try {
            DriverManager.getConnection(DATABASE_URL, properties);
        }
        catch (Exception exception) {
            NIOlcLogger.severe(null, exception);
        }
    }

    public void run() {
        try {
            this.initConnections();
        }
        catch (Exception exception) {
            NIOlcLogger.severe(null, exception);
        }
        if (NIAgentProperties.getAgentType() != 11) {
            try {
                this.cleanDBHome();
            }
            catch (Exception exception) {
                NIOlcLogger.info("Exception caught cleaning database home");
                NIOlcLogger.severe(null, exception);
            }
        }
        System.out.println(" ** Database initialized **");
        while (true) {
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkConnections();
        }
    }

    public static boolean deleteDir(File file) {
        if (file == null) {
            return false;
        }
        boolean bl = true;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (!(bl &= NIOlcDatabaseManager.deleteDir(fileArray[n]))) {
                    return false;
                }
                ++n;
            }
        }
        if (!file.delete()) {
            NIOlcLogger.info("Could not delete file: " + file);
            bl = false;
        }
        return bl;
    }

    private static void copy(File file, File file2) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        while ((n = fileInputStream.read()) != -1) {
            fileOutputStream.write(n);
            fileOutputStream.flush();
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    private static void xcopy(String string, String string2) throws IOException {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            NIOlcDatabaseManager.createDirectory(string2 + File.separator);
            int n = 0;
            while (n < stringArray.length) {
                NIOlcDatabaseManager.xcopy(string + File.separator + stringArray[n], string2 + File.separator + stringArray[n]);
                ++n;
            }
        } else {
            NIOlcDatabaseManager.copy(new File(string), new File(string2));
        }
    }

    private static void createDirectory(String string) {
        File file = new File(string);
        if (file.exists()) {
            return;
        }
        if (file.mkdirs()) {
            return;
        }
        throw new SecurityException();
    }
}

