/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.olc;

import com.ibm.storage.ess.ni.event.NIEventImpl;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterOutputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.common.NIESSNIConstants;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import com.ibm.storage.ess.ni.util.NIQueue;
import com.ibm.storage.ess.ni.util.NIQueueFullException;
import java.util.List;

public class NIOlcEventProcessor
extends Thread
implements NIESSNIConstants {
    NIEventImpl eventToSend;
    private NIMessageRouterChannel mrChannel;
    private NIMessageRouterOutputStream mrOutputStream;
    private NIMessageRouterAddress[] mrAddress;
    private static final boolean EVENTS_ENABLED = true;
    private static final int CHANNEL_ID = 1510;
    private static final int DEST_CHANNEL_ID = 1710;
    private static final int NUMBER_OF_SERVERS = 2;
    private static final String ESS_SERVER = "HMC1";
    private static final String ALT_ESS = "HMC2";
    private static final int EVENT_DELAY = 50;
    private static final String CLASS_NAME = "NIOlcEventProcessor";
    boolean bShutdown;
    private static NIQueue eventQueue;

    public NIOlcEventProcessor() {
        super(CLASS_NAME);
        NIMessageRouter nIMessageRouter = NIMessageRouterFactory.getInstanceOf();
        try {
            this.mrChannel = nIMessageRouter.createNIMessageRouterChannel(1510);
        }
        catch (NIMessageRouterException nIMessageRouterException) {
            NIOlcLogger.info(" Exception thrown when creating a message router channel: " + nIMessageRouterException.getMessage());
        }
        this.mrOutputStream = this.mrChannel.getNIMessageRouterOutputStream();
        this.mrAddress = new NIMessageRouterAddress[2];
        this.mrAddress[0] = new NIMessageRouterAddress(1710, ESS_SERVER);
        this.mrAddress[1] = new NIMessageRouterAddress(1710, ALT_ESS);
        this.bShutdown = false;
    }

    protected static void startOlcEventProcessor() {
        eventQueue = new NIQueue(500, 5.0);
        NIOlcEventProcessor nIOlcEventProcessor = new NIOlcEventProcessor();
        nIOlcEventProcessor.start();
    }

    public void run() {
        int n = 0;
        NIOlcLogger.info("olc event processor started");
        while (!this.bShutdown) {
            try {
                this.eventToSend = (NIEventImpl)eventQueue.dequeue();
                NIOlcLogger.info("NIOlcEventProcessor: Dequeued Event: " + this.eventToSend.getClass().getName());
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                NIOlcLogger.info("Interrupted Exception");
            }
            this.sendEvent(this.eventToSend, n);
            if (n != 2) continue;
            n = 0;
        }
        NIOlcLogger.info("NIEventOlcProcessor: Done processing events");
    }

    private void sendEvent(NIEventImpl nIEventImpl, int n) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = null;
        try {
            nIMessageRouterReturnStatus = this.mrOutputStream.send(this.mrAddress[n], nIEventImpl);
            NIOlcLogger.info("Sent event to " + this.mrAddress[n].getEssServerName());
        }
        catch (Exception exception) {
            NIOlcLogger.severe("Error during event send to message router", exception);
        }
        if (nIMessageRouterReturnStatus.getStatus() == 9) {
            NIOlcLogger.info(" Event: " + nIEventImpl.toString() + " Sent to EventManager on " + this.mrAddress[n].getEssServerName());
        } else {
            NIOlcLogger.info(" send failed for: " + nIEventImpl.toString() + " MessageRouterReturnStatus; " + nIMessageRouterReturnStatus.getStatus());
        }
    }

    public void shutDown() {
        this.bShutdown = true;
        this.interrupt();
        NIOlcLogger.info("NIOlcEventProcessor: shutting down");
    }

    public static void enqueueEvent(NIEventImpl nIEventImpl) {
        try {
            eventQueue.enqueue(nIEventImpl);
        }
        catch (NIQueueFullException nIQueueFullException) {
            NIOlcLogger.info("OLC Event queue full, event discarded: " + nIEventImpl);
        }
        catch (Exception exception) {
            NIOlcLogger.severe("Event queue null, cannot send event: " + nIEventImpl, exception);
        }
    }

    public static void processEvents(List list) {
        NIOlcLogger.enter(CLASS_NAME, "processEvents");
        NIOlcLogger.info("Processing Events");
        int n = 0;
        while (n < list.size()) {
            try {
                NIOlcEventProcessor.enqueueEvent((NIEventImpl)list.get(n));
            }
            catch (Exception exception) {
                NIOlcLogger.info("Error enqueueing event -- most likely null event");
            }
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, "processEvents");
    }
}

