/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.olc.services;

import com.ibm.storage.ess.ni.application.resource.NIAddressGroup;
import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIArraySite;
import com.ibm.storage.ess.ni.application.resource.NIArraySiteConfiguration;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIOfflineLicensedFunction;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroup;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupVolumeList;
import com.ibm.storage.ess.ni.application.resource.NIVolumeMap;
import com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIConfigResult;
import com.ibm.storage.ess.ni.application.results.NIExtentAvailabilityResult;
import com.ibm.storage.ess.ni.application.results.NIExtentSummaryResult;
import com.ibm.storage.ess.ni.application.results.NIExtentUsageResult;
import com.ibm.storage.ess.ni.application.results.NIPinnedTrackDataResult;
import com.ibm.storage.ess.ni.application.results.NIQueryLICFeatureKeysResult;
import com.ibm.storage.ess.ni.application.results.NIQueryRankExtentsResult;
import com.ibm.storage.ess.ni.application.results.NIQueryVolumeSerialResult;
import com.ibm.storage.ess.ni.application.results.NIVolumeGroupUsageResult;
import com.ibm.storage.ess.ni.application.results.NIVolumeMapQueryResult;
import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.event.extensions.NIAddressGroupChangedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIAddressGroupCreatedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIAddressGroupDeletedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIArrayChangedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIArrayCreatedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIArrayDeletedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIExtentPoolChangedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIExtentPoolCreatedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIExtentPoolDeletedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NILSSChangedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NILSSCreatedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NILSSDeletedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIRankChangedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIRankCreatedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIRankDeletedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIVolumeGroupChangedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIVolumeGroupCreatedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIVolumeGroupDeletedEventImpl;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.iou.NIEscrow;
import com.ibm.storage.ess.ni.iou.NIEscrowFactory;
import com.ibm.storage.ess.ni.olc.NIOlcCommon;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseSchemaHelper;
import com.ibm.storage.ess.ni.olc.NIOlcEventProcessor;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model6;
import com.ibm.storage.ess.ni.option.config.NIDataType;
import com.ibm.storage.ess.ni.option.config.NIDataType3380;
import com.ibm.storage.ess.ni.option.config.NIDataType3390;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock512;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Protected;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Unprotected;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.option.config.NILICFeature;
import com.ibm.storage.ess.ni.option.config.NILICFeatureBaseCapacity;
import com.ibm.storage.ess.ni.option.config.NILICFeatureStorage;
import com.ibm.storage.ess.ni.option.config.NILICFeatureStorageCKDOnly;
import com.ibm.storage.ess.ni.option.config.NILICFeatureStorageFBCKD;
import com.ibm.storage.ess.ni.option.config.NILICFeatureStorageFBOnly;
import com.ibm.storage.ess.ni.option.config.NIRaidType5;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupType;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconMixedMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520All;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Map256;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Mask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMap256;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMixedMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeType;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDBase;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDCrossCUAlias;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDMap;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDSingleCuAlias;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockBase;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockMap;
import com.ibm.storage.ess.ni.resource.NIAddressGroupImpl;
import com.ibm.storage.ess.ni.resource.NIArrayImpl;
import com.ibm.storage.ess.ni.resource.NIArraySiteImpl;
import com.ibm.storage.ess.ni.resource.NIESSImpl;
import com.ibm.storage.ess.ni.resource.NIExtentPoolImpl;
import com.ibm.storage.ess.ni.resource.NILSSImpl;
import com.ibm.storage.ess.ni.resource.NILSSVolumeSetImpl;
import com.ibm.storage.ess.ni.resource.NIRankImpl;
import com.ibm.storage.ess.ni.resource.NIResourceImpl;
import com.ibm.storage.ess.ni.resource.NIVolumeGroupImpl;
import com.ibm.storage.ess.ni.resource.NIVolumeImpl;
import com.ibm.storage.ess.ni.results.NIConfigResultImpl;
import com.ibm.storage.ess.ni.results.NIExtentAvailabilityResultImpl;
import com.ibm.storage.ess.ni.results.NIExtentSummaryResultImpl;
import com.ibm.storage.ess.ni.results.NIExtentUsageResultImpl;
import com.ibm.storage.ess.ni.results.NIQueryLICFeatureKeysResultImpl;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class NIOlcLogicalConfigurationService
implements NILogicalConfigurationService {
    private static final int LOGICAL_VOLUMES_PER_LSS = 4096;
    public static final int FIRST_AVAIL_VOL_GROUP_NUM_2107 = 0;
    public static final int FIRST_AVAIL_VOL_GROUP_NUM_1750 = 11;
    public static final int VOLUME_GROUP_ALLCKD = 10;
    public static final int VOLUME_GROUP_ALLFB512 = 20;
    public static final int VOLUME_GROUP_ALLFB520 = 30;
    private static final NIOlcCommon c = NIOlcCommon.c;
    private static final String CLASS_NAME = "NIOlcLogicalConfigurationService";
    private ArrayList alEventsHolder = new ArrayList();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIConfigResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIExtentUsageResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIExtentAvailabilityResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIExtentSummaryResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIQueryLICFeatureKeysResult;

    private int _generateArrayNumber(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NIESSID nIESSID) {
        int n = 0;
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getArraysByESS(nIESSID);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(arrayList.size());
        int n2 = 0;
        while (n2 < arrayList.size()) {
            arrayList2.add(new Integer(((NIArrayID)((NIArray)arrayList.get(n2)).getID()).getArrayNumber()));
            ++n2;
        }
        while (arrayList2.contains(new Integer(n))) {
            ++n;
        }
        return n;
    }

    private int _generateRankNumber(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NIESSID nIESSID) {
        int n = 0;
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getRanksByESS(nIESSID);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            arrayList2.add(new Integer(((NIRankID)((NIRank)arrayList.get(n2)).getID()).getRankNumber()));
            ++n2;
        }
        while (arrayList2.contains(new Integer(n))) {
            ++n;
        }
        return n < 80 ? n : -1;
    }

    private int _generateExtentPoolNumber(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NIESSID nIESSID, NIExtentPool nIExtentPool) {
        int n = 0;
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getExtentPoolsByESS(nIESSID);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)((NIExtentPool)arrayList.get(n2)).getID();
            arrayList2.add(new Integer(nIExtentPoolID.getExtentPoolNumber()));
            ++n2;
        }
        if (nIExtentPool.getRankGroup() == 0) {
            while (arrayList2.contains(new Integer(n))) {
                n += 2;
            }
        } else if (nIExtentPool.getRankGroup() == 1) {
            n = 1;
            while (arrayList2.contains(new Integer(n))) {
                n += 2;
            }
        } else {
            n = -1;
        }
        return n < 80 ? n : -1;
    }

    private int _generateVolumeGroupNumber(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NIESSID nIESSID) {
        int n = nIESSID.getType().equals("1750") ? 11 : 0;
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getVolumeGroupsByESS(nIESSID);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            arrayList2.add(new Integer(((NIVolumeGroupID)((NIVolumeGroup)arrayList.get(n2)).getID()).getVolumeGroupNumber()));
            ++n2;
        }
        while (arrayList2.contains(new Integer(n))) {
            ++n;
        }
        return n;
    }

    private boolean _deleteLSS(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NILSS nILSS) {
        boolean bl = true;
        if (nILSS.getConfiguredDevices() > 0) {
            return false;
        }
        bl &= nIOlcDatabaseSchemaHelper.deleteLSS(nILSS);
        this.alEventsHolder.add(new NILSSDeletedEventImpl(nILSS));
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getAddressGroupsByID(new NIAddressGroupID[]{nILSS.getAddressGroupID()});
        if (arrayList.size() > 0) {
            NIAddressGroupImpl nIAddressGroupImpl = (NIAddressGroupImpl)arrayList.get(0);
            NIAddressGroupImpl nIAddressGroupImpl2 = (NIAddressGroupImpl)nIAddressGroupImpl.clone();
            if (nIAddressGroupImpl2.getNumLogicalSubsystem() - 1 == 0) {
                bl &= nIOlcDatabaseSchemaHelper.deleteAddressGroup(nIAddressGroupImpl2);
                this.alEventsHolder.add(new NIAddressGroupDeletedEventImpl(nIAddressGroupImpl2));
            } else {
                nIAddressGroupImpl2.setNumLogicalSubsystem(nIAddressGroupImpl2.getNumLogicalSubsystem() - 1);
                bl &= nIOlcDatabaseSchemaHelper.modifyAddressGroup(nIAddressGroupImpl2);
                this.alEventsHolder.add(new NIAddressGroupChangedEventImpl(nIAddressGroupImpl, nIAddressGroupImpl2));
            }
        } else {
            NIOlcLogger.info("Warning: No address group for this lss:" + nILSS + "addr. group ID:" + nILSS.getAddressGroupID());
        }
        return bl;
    }

    private int _getAddressGroupNumber(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 1 || string.length() == 3) {
            string = "0" + string;
        }
        return Integer.parseInt(string.substring(0, 1), 16);
    }

    private int _getLSSNumber(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 3) {
            string = "0" + string;
        }
        return Integer.parseInt(string.substring(0, 2), 16);
    }

    private ArrayList _getRaid5ArrayOnDAPair(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NIArraySiteImpl nIArraySiteImpl) {
        int n = nIArraySiteImpl.getDeviceAdapterPair();
        int n2 = nIArraySiteImpl.getDiskCapacity();
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getArraysByESS(((NIArraySiteID)nIArraySiteImpl.getID()).getESS());
        ArrayList<NIArray> arrayList2 = new ArrayList<NIArray>();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            NIArray nIArray = (NIArray)arrayList.get(n3);
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < nIArray.getArraySiteConfiguration().length) {
                NIArraySiteConfiguration nIArraySiteConfiguration = nIArray.getArraySiteConfiguration()[n6];
                n4 += nIArraySiteConfiguration.getNumParity();
                n5 += nIArraySiteConfiguration.getNumSpares();
                ++n6;
            }
            if (n4 == 1 && n5 == 1 && nIArray.getDeviceAdapterPairID() == n && nIArray.getDiskCapacity() == n2) {
                arrayList2.add(nIArray);
            }
            ++n3;
        }
        return arrayList2;
    }

    private ArrayList _getArraySitesOnDAPair(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NIArraySiteImpl nIArraySiteImpl) {
        int n = nIArraySiteImpl.getDeviceAdapterPair();
        int n2 = nIArraySiteImpl.getDiskCapacity();
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getArraySitesByESS(((NIArraySiteID)nIArraySiteImpl.getID()).getESS());
        ArrayList<NIArraySite> arrayList2 = new ArrayList<NIArraySite>();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            NIArraySite nIArraySite = (NIArraySite)arrayList.get(n3);
            if (nIArraySite.getDeviceAdapterPair() == n && nIArraySite.getDiskCapacity() == n2) {
                arrayList2.add(nIArraySite);
            }
            ++n3;
        }
        return arrayList2;
    }

    private ArrayList _getArraySitesOnDualLoop(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NIArraySiteImpl nIArraySiteImpl, List list) {
        int n = nIArraySiteImpl.getDualLoop();
        ArrayList<NIArraySite> arrayList = new ArrayList<NIArraySite>();
        int n2 = 0;
        while (n2 < list.size()) {
            NIArraySite nIArraySite = (NIArraySite)list.get(n2);
            if (nIArraySite.getDualLoop() == n) {
                arrayList.add(nIArraySite);
            }
            ++n2;
        }
        return arrayList;
    }

    private int _getAvailableExtents(NIExtentPoolImpl nIExtentPoolImpl, Map map) {
        List list = this._getRanksInExtentPool((NIExtentPoolID)nIExtentPoolImpl.getID(), map);
        long l = 0L;
        int n = 0;
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            NIRankImpl nIRankImpl = (NIRankImpl)list.get(n3);
            l += nIRankImpl.getNumExtents();
            n = (int)((long)n + nIRankImpl.getNumUsedExtents());
            ++n3;
        }
        if (l != nIExtentPoolImpl.getNumExtents()) {
            NIOlcLogger.info("Extents on Extent Pool and Rank don't match");
        }
        return (int)l - n;
    }

    private List _getRanksInExtentPool(NIExtentPoolID nIExtentPoolID, Map map) {
        ArrayList<NIRankImpl> arrayList = new ArrayList<NIRankImpl>();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            NIRankImpl nIRankImpl = (NIRankImpl)iterator.next();
            if (!nIRankImpl.getExtentPoolID().equals(nIExtentPoolID)) continue;
            arrayList.add(nIRankImpl);
        }
        return arrayList;
    }

    private int _blocksToExtents(long l) {
        long l2 = (l + 128L - 1L) / 128L;
        long l3 = (l2 + 16384L - 1L) / 16384L;
        if (l3 < 0L) {
            l3 = 0L;
        }
        return (int)l3;
    }

    private boolean _checkLICFeatureLimits(NIRankImpl nIRankImpl, NIESSID nIESSID, NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper) {
        long l = 0L;
        long l2 = -1L;
        long l3 = -1L;
        long l4 = 0L;
        long l5 = 0L;
        boolean bl = true;
        boolean bl2 = false;
        NIESSImpl nIESSImpl = (NIESSImpl)nIOlcDatabaseSchemaHelper.getEssByID(new NIESSID[]{nIESSID}).get(0);
        NIOfflineLicensedFunction[] nIOfflineLicensedFunctionArray = nIESSImpl.getLicensedFunction();
        if (nIOfflineLicensedFunctionArray == null || nIOfflineLicensedFunctionArray.length == 0) {
            return true;
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getArraysByID(nIRankImpl.getArrayIDs());
        int n = 0;
        while (n < arrayList.size()) {
            NIArrayImpl nIArrayImpl = (NIArrayImpl)arrayList.get(n);
            int n2 = nIArrayImpl.getArraySiteConfiguration()[0].getNumDDMs();
            l += (long)(nIArrayImpl.getDiskCapacity() * n2);
            ++n;
        }
        int n3 = 0;
        while (n3 < nIOfflineLicensedFunctionArray.length) {
            NILICFeatureStorage nILICFeatureStorage;
            NILICFeature nILICFeature = nIOfflineLicensedFunctionArray[n3].getLICFeatureCapacityType();
            if (nILICFeature instanceof NILICFeatureBaseCapacity) {
                bl2 = true;
            }
            if (((nILICFeatureStorage = nIOfflineLicensedFunctionArray[n3].getLICFeatureStorageType()) instanceof NILICFeatureStorageFBOnly || nILICFeatureStorage instanceof NILICFeatureStorageFBCKD) && (l2 == -1L || nIOfflineLicensedFunctionArray[n3].getCapacity() < l2 && nIOfflineLicensedFunctionArray[n3].getCapacity() != 0L)) {
                l2 = nIOfflineLicensedFunctionArray[n3].getCapacity();
            }
            if ((nILICFeatureStorage instanceof NILICFeatureStorageCKDOnly || nILICFeatureStorage instanceof NILICFeatureStorageFBCKD) && (l3 == -1L || nIOfflineLicensedFunctionArray[n3].getCapacity() < l3 && nIOfflineLicensedFunctionArray[n3].getCapacity() != 0L)) {
                l3 = nIOfflineLicensedFunctionArray[n3].getCapacity();
            }
            ++n3;
        }
        if (l3 == -1L && l2 == -1L) {
            NIOlcLogger.info("No nonzero lic featrues installed, returning true");
            return true;
        }
        ArrayList arrayList2 = (ArrayList)nIOlcDatabaseSchemaHelper.getRanksByESS(nIESSID);
        int n4 = 0;
        while (n4 < arrayList2.size()) {
            int n5;
            NIArrayImpl nIArrayImpl;
            int n6;
            NIRank nIRank = (NIRank)arrayList2.get(n4);
            ArrayList arrayList3 = (ArrayList)nIOlcDatabaseSchemaHelper.getArraysByID(nIRank.getArrayIDs());
            if (nIRank.getExtentType() instanceof NIExtentTypeFB) {
                n6 = 0;
                while (n6 < arrayList3.size()) {
                    nIArrayImpl = (NIArrayImpl)arrayList3.get(n6);
                    n5 = nIArrayImpl.getArraySiteConfiguration()[0].getNumDDMs();
                    l4 += (long)(nIArrayImpl.getDiskCapacity() * n5);
                    ++n6;
                }
            } else if (nIRank.getExtentType() instanceof NIExtentTypeCKD) {
                n6 = 0;
                while (n6 < arrayList3.size()) {
                    nIArrayImpl = (NIArrayImpl)arrayList3.get(n6);
                    n5 = nIArrayImpl.getArraySiteConfiguration()[0].getNumDDMs();
                    l5 += (long)(nIArrayImpl.getDiskCapacity() * n5);
                    ++n6;
                }
            }
            ++n4;
        }
        if (nIRankImpl.getExtentType() instanceof NIExtentTypeFB) {
            if (l2 == -1L) {
                bl &= false;
            } else {
                long l6 = l + l4;
                if (l6 > (l2 *= 1000000L)) {
                    bl &= false;
                }
            }
        } else if (nIRankImpl.getExtentType() instanceof NIExtentTypeCKD) {
            if (l3 == -1L) {
                bl &= false;
            } else {
                long l7 = l + l5;
                if (l7 > (l3 *= 1000000L)) {
                    bl &= false;
                }
            }
        }
        NIOlcLogger.info("checkLicCapacites completed success=" + (bl &= bl2) + " baseCapacityInstalled=" + bl2);
        return bl;
    }

    private int _cylindersToExtents(long l) {
        long l2 = (l + 1113L - 1L) / 1113L;
        if (l2 < 0L) {
            l2 = 0L;
        }
        return (int)l2;
    }

    private int _extentsInArray(NIArray nIArray, NIExtentType nIExtentType) {
        NIArraySiteConfiguration[] nIArraySiteConfigurationArray = nIArray.getArraySiteConfiguration();
        int n = 0;
        int n2 = nIArray.getDiskCapacity();
        int n3 = 0;
        int n4 = 0;
        int n5 = nIArraySiteConfigurationArray[0].getNumDDMs();
        int n6 = 0;
        while (n6 < nIArraySiteConfigurationArray.length) {
            n3 += nIArraySiteConfigurationArray[n6].getNumParity();
            n4 += nIArraySiteConfigurationArray[n6].getNumSpares();
            ++n6;
        }
        int n7 = Math.abs(n2 - 73000) < 20000 ? 0 : (Math.abs(n2 - 146000) < 20000 ? 1 : (Math.abs(n2 - 300000) < 20000 ? 2 : (Math.abs(n2 - 500000) < 20000 ? 3 : -1)));
        NIESSID nIESSID = nIArray.getID().getESS();
        boolean bl = nIESSID.getType().equals("1750") ? n5 != 8 : false;
        if (n7 != -1) {
            int n8 = n3 == 1 ? (n4 == 1 && !bl ? 2 : (n4 == 1 && bl ? 4 : (n4 == 0 && bl ? 5 : 3))) : (n4 == 2 && !bl ? 0 : (n4 == 0 && bl ? 6 : (n4 == 2 && bl ? 7 : 1)));
            n = nIExtentType instanceof NIExtentTypeCKD ? (nIESSID.getType().equals("2107") ? NIConfigurationConstants.EXTENTS_IN_CKD_ARRAY_2107[n7][n8] : NIConfigurationConstants.EXTENTS_IN_CKD_ARRAY_1750[n7][n8]) : (nIESSID.getType().equals("2107") ? NIConfigurationConstants.EXTENTS_IN_FB_ARRAY_2107[n7][n8] : NIConfigurationConstants.EXTENTS_IN_FB_ARRAY_1750[n7][n8]);
        }
        return n;
    }

    private void _deleteVolumeFromVolumeGroups(NIVolumeID nIVolumeID, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NIVolumeGroupImpl nIVolumeGroupImpl = (NIVolumeGroupImpl)iterator.next();
            NIVolumeMap nIVolumeMap = nIVolumeGroupImpl.getVolumeMap();
            if (!nIVolumeMap.contains(nIVolumeID)) continue;
            nIVolumeMap.remove(nIVolumeID);
        }
    }

    private boolean _createLSS(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NILSSImpl nILSSImpl) {
        boolean bl = true;
        NILSSID nILSSID = (NILSSID)nILSSImpl.getID();
        NIESSID nIESSID = nILSSID.getESS();
        NIAddressGroupID nIAddressGroupID = new NIAddressGroupID(nIESSID, this._getAddressGroupNumber(nILSSID.getLSSNumber()));
        List list = nIOlcDatabaseSchemaHelper.getAddressGroupsByID(new NIAddressGroupID[]{nIAddressGroupID});
        List list2 = nIOlcDatabaseSchemaHelper.getLogicalSubsystemsByID(new NILSSID[]{(NILSSID)nILSSImpl.getID()});
        if (list2.size() > 0 || nILSSID.getLSSNumber() < 0 || nILSSID.getLSSNumber() > 255) {
            bl = false;
        } else {
            if (list.size() == 0) {
                NIAddressGroupImpl nIAddressGroupImpl = new NIAddressGroupImpl(nIAddressGroupID, nILSSImpl.getDeviceType(), 0, 4096, 1, 0);
                bl &= nIOlcDatabaseSchemaHelper.insertAddressGroup(nIAddressGroupImpl);
                this.alEventsHolder.add(new NIAddressGroupCreatedEventImpl(nIAddressGroupImpl));
                nILSSImpl.setAddressGroupID((NIAddressGroupID)nIAddressGroupImpl.getID());
            } else {
                NIAddressGroupImpl nIAddressGroupImpl = (NIAddressGroupImpl)list.get(0);
                if (!nILSSImpl.getDeviceType().equals(nIAddressGroupImpl.getDeviceType())) {
                    bl = false;
                } else {
                    nILSSImpl.setAddressGroupID((NIAddressGroupID)nIAddressGroupImpl.getID());
                    nIAddressGroupImpl.setNumLogicalSubsystem(nIAddressGroupImpl.getNumLogicalSubsystem() + 1);
                    bl &= nIOlcDatabaseSchemaHelper.modifyAddressGroup(nIAddressGroupImpl);
                }
            }
            if (bl) {
                bl &= nIOlcDatabaseSchemaHelper.insertLSS(nILSSImpl, new NILSSVolumeSetImpl());
            }
            this.alEventsHolder.add(new NILSSCreatedEventImpl(nILSSImpl));
        }
        return bl;
    }

    private boolean _create2107Array(NIArrayImpl nIArrayImpl, NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper) {
        int n;
        int n2;
        Serializable serializable;
        boolean bl = true;
        NIArraySiteImpl nIArraySiteImpl = (NIArraySiteImpl)nIOlcDatabaseSchemaHelper.getArraySitesByID(nIArrayImpl.getArraySites()).get(0);
        int n3 = nIArraySiteImpl.getRequiredSpares();
        int n4 = 0;
        ArrayList arrayList = this._getArraySitesOnDAPair(nIOlcDatabaseSchemaHelper, nIArraySiteImpl);
        int n5 = 0;
        while (n5 < arrayList.size()) {
            serializable = (NIArraySite)arrayList.get(n5);
            if (serializable.getArraySiteStatus() == 1) {
                n4 += serializable.getRequiredSpares();
            }
            ++n5;
        }
        if (nIArrayImpl.getRaidType() instanceof NIRaidType5) {
            n2 = 1;
            if (n4 == 0) {
                n = 0;
            } else {
                NIArraySiteImpl nIArraySiteImpl2;
                n = 1;
                if (n3 == 0) {
                    int n6 = 0;
                    while (n6 < arrayList.size()) {
                        nIArraySiteImpl2 = (NIArraySiteImpl)arrayList.get(n6);
                        if (nIArraySiteImpl2.getRequiredSpares() > 0 && nIArraySiteImpl2.getArraySiteStatus() == 1) {
                            nIArraySiteImpl2.setRequiredSpares(nIArraySiteImpl2.getRequiredSpares() - 1);
                            ++n3;
                            bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl2);
                            break;
                        }
                        ++n6;
                    }
                }
                int n7 = 0;
                while (n3 > 1) {
                    nIArraySiteImpl2 = (NIArraySiteImpl)arrayList.get(n7);
                    nIArraySiteImpl2.setRequiredSpares(nIArraySiteImpl2.getRequiredSpares() + 1);
                    --n3;
                    bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl2);
                    ++n7;
                    n7 %= arrayList.size();
                }
            }
            nIArraySiteImpl.setRequiredSpares(n);
        } else {
            n2 = 0;
            if (n4 == 0) {
                n = 0;
            } else if (n4 == 1) {
                serializable = this._getRaid5ArrayOnDAPair(nIOlcDatabaseSchemaHelper, nIArraySiteImpl);
                NIArrayImpl nIArrayImpl2 = (NIArrayImpl)((ArrayList)serializable).get(0);
                NIArrayImpl nIArrayImpl3 = (NIArrayImpl)nIArrayImpl2.clone();
                NIArraySiteImpl nIArraySiteImpl3 = (NIArraySiteImpl)nIOlcDatabaseSchemaHelper.getArraySitesByID(new NIArraySiteID[]{nIArrayImpl3.getArraySites()[0]}).get(0);
                nIArraySiteImpl3.setRequiredSpares(0);
                NIArraySiteConfiguration[] nIArraySiteConfigurationArray = new NIArraySiteConfiguration[]{new NIArraySiteConfiguration(8, 0, 1)};
                nIArrayImpl3.setArraySiteConfiguration(nIArraySiteConfigurationArray);
                bl &= nIOlcDatabaseSchemaHelper.modifyArray(nIArrayImpl3);
                bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl3);
                this.alEventsHolder.add(new NIArrayChangedEventImpl(nIArrayImpl2, nIArrayImpl3));
                n = 2;
            } else {
                NIArraySiteImpl nIArraySiteImpl4;
                n = 2;
                int n8 = 0;
                while (n3 < n) {
                    nIArraySiteImpl4 = (NIArraySiteImpl)arrayList.get(n8);
                    if (nIArraySiteImpl4.getRequiredSpares() > 0) {
                        nIArraySiteImpl4.setRequiredSpares(nIArraySiteImpl4.getRequiredSpares() - 1);
                        ++n3;
                        bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl4);
                    }
                    ++n8;
                    n8 %= arrayList.size();
                }
                n8 = 0;
                while (n3 > n) {
                    nIArraySiteImpl4 = (NIArraySiteImpl)arrayList.get(n8);
                    nIArraySiteImpl4.setRequiredSpares(nIArraySiteImpl4.getRequiredSpares() + 1);
                    --n3;
                    bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl4);
                    ++n8;
                    n8 %= arrayList.size();
                }
            }
            nIArraySiteImpl.setRequiredSpares(n);
        }
        serializable = new NIArraySiteConfiguration[]{new NIArraySiteConfiguration(8, n, n2)};
        nIArrayImpl.setArraySiteConfiguration((NIArraySiteConfiguration[])serializable);
        nIArrayImpl.setDataState(0);
        nIArrayImpl.setArrayStatus(1);
        nIArrayImpl.setDeviceAdapterPairID(nIArraySiteImpl.getDeviceAdapterPair());
        nIArrayImpl.setDiskCapacity(nIArraySiteImpl.getDiskCapacity());
        nIArrayImpl.setDiskClass(nIArraySiteImpl.getDiskClass());
        nIArrayImpl.setDiskInterfaceRate((int)nIArraySiteImpl.getDiskInterfaceRate());
        nIArrayImpl.setDiskInterfaceType(nIArraySiteImpl.getDiskInterfaceType());
        nIArrayImpl.setDiskRPM(nIArraySiteImpl.getDiskRPM());
        nIArraySiteImpl.setArrayPosition(1);
        nIArraySiteImpl.setArraySiteStatus(0);
        nIArraySiteImpl.setArrayID((NIArrayID)nIArrayImpl.getID());
        bl &= nIOlcDatabaseSchemaHelper.insertArray(nIArrayImpl);
        return bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl);
    }

    private boolean _create1750Array(NIArrayImpl nIArrayImpl, NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper) {
        int n;
        int n2;
        NIArraySiteImpl nIArraySiteImpl = null;
        NIArraySiteImpl nIArraySiteImpl2 = null;
        boolean bl = true;
        NIArraySiteID[] nIArraySiteIDArray = nIArrayImpl.getArraySites();
        List list = nIOlcDatabaseSchemaHelper.getArraySitesByID(nIArraySiteIDArray);
        nIArraySiteImpl = (NIArraySiteImpl)list.get(0);
        if (list.size() == 2) {
            nIArraySiteImpl2 = (NIArraySiteImpl)list.get(1);
            n2 = 2;
        } else {
            n2 = 1;
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = -1;
        int n6 = nIArraySiteImpl.getRequiredSpares();
        if (n2 == 2) {
            n6 += nIArraySiteImpl2.getRequiredSpares();
        }
        ArrayList arrayList = this._getArraySitesOnDAPair(nIOlcDatabaseSchemaHelper, nIArraySiteImpl);
        ArrayList arrayList2 = this._getArraySitesOnDualLoop(nIOlcDatabaseSchemaHelper, nIArraySiteImpl, arrayList);
        if (nIArrayImpl.getRaidType() instanceof NIRaidType5) {
            n3 = 1;
            if (n6 == 0) {
                n4 = 0;
            } else if (n6 == 1) {
                n4 = 1;
            } else if (n6 > 1) {
                n4 = 1;
                n = 0;
                while (n6 > 1 && n < arrayList2.size()) {
                    NIArraySiteImpl nIArraySiteImpl3 = (NIArraySiteImpl)arrayList2.get(n);
                    NIArraySiteID nIArraySiteID = (NIArraySiteID)nIArraySiteImpl3.getID();
                    if (!(nIArraySiteID.equals(nIArraySiteImpl.getID()) || nIArraySiteImpl2 != null && nIArraySiteID.equals(nIArraySiteImpl2.getID()) || nIArraySiteImpl3.getArraySiteStatus() != 1 || nIArraySiteImpl3.getRequiredSpares() != 0)) {
                        nIArraySiteImpl3.setRequiredSpares(nIArraySiteImpl3.getRequiredSpares() + 1);
                        --n6;
                        if (nIArraySiteImpl2 != null && nIArraySiteImpl2.getRequiredSpares() >= nIArraySiteImpl.getRequiredSpares()) {
                            nIArraySiteImpl2.setRequiredSpares(nIArraySiteImpl2.getRequiredSpares() - 1);
                            bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl2);
                        } else {
                            nIArraySiteImpl.setRequiredSpares(nIArraySiteImpl.getRequiredSpares() - 1);
                            bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl);
                        }
                        bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl3);
                    }
                    ++n;
                }
                if (n6 > 1) {
                    return false;
                }
            }
        } else {
            NIArraySiteID nIArraySiteID;
            NIArraySiteImpl nIArraySiteImpl4;
            n3 = 0;
            if (n6 == 0) {
                n4 = 0;
            } else if (n6 == 2) {
                n4 = 2;
            } else if (n6 == 1) {
                n4 = 2;
                n = 0;
                while (n < arrayList2.size()) {
                    nIArraySiteImpl4 = (NIArraySiteImpl)arrayList2.get(n);
                    nIArraySiteID = (NIArraySiteID)nIArraySiteImpl4.getID();
                    if (!(nIArraySiteID.equals(nIArraySiteImpl.getID()) || nIArraySiteImpl2 != null && nIArraySiteID.equals(nIArraySiteImpl2.getID()) || nIArraySiteImpl4.getRequiredSpares() <= 0 || nIArraySiteImpl4.getArraySiteStatus() != 1)) {
                        nIArraySiteImpl4.setRequiredSpares(nIArraySiteImpl4.getRequiredSpares() - 1);
                        ++n6;
                        if (nIArraySiteImpl2 != null && nIArraySiteImpl2.getRequiredSpares() < nIArraySiteImpl.getRequiredSpares()) {
                            nIArraySiteImpl2.setRequiredSpares(nIArraySiteImpl2.getRequiredSpares() + 1);
                            bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl2);
                        } else {
                            nIArraySiteImpl.setRequiredSpares(nIArraySiteImpl.getRequiredSpares() + 1);
                            bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl);
                        }
                        bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl4);
                        break;
                    }
                    ++n;
                }
            }
            if (n6 > 2) {
                n = 0;
                while (n6 > 2 && n < arrayList2.size()) {
                    nIArraySiteImpl4 = (NIArraySiteImpl)arrayList2.get(n);
                    nIArraySiteID = (NIArraySiteID)nIArraySiteImpl4.getID();
                    if (!(nIArraySiteID.equals(nIArraySiteImpl.getID()) || nIArraySiteImpl2 != null && nIArraySiteID.equals(nIArraySiteImpl2.getID()) || nIArraySiteImpl4.getArraySiteStatus() != 1 || nIArraySiteImpl4.getRequiredSpares() != 0)) {
                        nIArraySiteImpl4.setRequiredSpares(nIArraySiteImpl4.getRequiredSpares() + 1);
                        --n6;
                        if (nIArraySiteImpl2 != null && nIArraySiteImpl2.getRequiredSpares() >= nIArraySiteImpl.getRequiredSpares()) {
                            nIArraySiteImpl2.setRequiredSpares(nIArraySiteImpl2.getRequiredSpares() - 1);
                            bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl2);
                        } else {
                            nIArraySiteImpl.setRequiredSpares(nIArraySiteImpl.getRequiredSpares() - 1);
                            bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl);
                        }
                        bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl4);
                    }
                    ++n;
                }
                if (n6 > 2) {
                    return false;
                }
            }
        }
        NIArraySiteConfiguration[] nIArraySiteConfigurationArray = new NIArraySiteConfiguration[]{new NIArraySiteConfiguration(4 * n2, n4, n3)};
        nIArrayImpl.setArraySiteConfiguration(nIArraySiteConfigurationArray);
        nIArrayImpl.setDataState(0);
        nIArrayImpl.setArrayStatus(1);
        nIArrayImpl.setDeviceAdapterPairID(nIArraySiteImpl.getDeviceAdapterPair());
        nIArrayImpl.setDiskCapacity(nIArraySiteImpl.getDiskCapacity());
        nIArrayImpl.setDiskClass(nIArraySiteImpl.getDiskClass());
        nIArrayImpl.setDiskInterfaceRate((int)nIArraySiteImpl.getDiskInterfaceRate());
        nIArrayImpl.setDiskInterfaceType(nIArraySiteImpl.getDiskInterfaceType());
        nIArrayImpl.setDiskRPM(nIArraySiteImpl.getDiskRPM());
        bl &= nIOlcDatabaseSchemaHelper.insertArray(nIArrayImpl);
        nIArraySiteImpl.setArrayPosition(1);
        nIArraySiteImpl.setArraySiteStatus(0);
        nIArraySiteImpl.setArrayID((NIArrayID)nIArrayImpl.getID());
        bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl);
        if (nIArraySiteImpl2 != null) {
            nIArraySiteImpl2.setArrayPosition(2);
            nIArraySiteImpl2.setArraySiteStatus(0);
            nIArraySiteImpl2.setArrayID((NIArrayID)nIArrayImpl.getID());
            bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl2);
        }
        return bl;
    }

    private boolean _checkVolumeGroup(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NIVolumeGroup nIVolumeGroup) {
        boolean bl;
        NIOlcLogger.enter(CLASS_NAME, "checkVolumeGroup");
        NIVolumeGroupID nIVolumeGroupID = (NIVolumeGroupID)nIVolumeGroup.getID();
        NIVolumeGroupType nIVolumeGroupType = nIVolumeGroup.getType();
        if (nIVolumeGroupID.getVolumeGroupNumber() == 10 || nIVolumeGroupID.getVolumeGroupNumber() == 20 || nIVolumeGroupID.getVolumeGroupNumber() == 30) {
            bl = false;
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeFiconEsconMask || nIVolumeGroupType instanceof NIVolumeGroupTypeFiconEsconAll) {
            NIVolumeType[] nIVolumeTypeArray = new NIVolumeType[]{NIVolumeTypeCKDBase.Option, NIVolumeTypeCKDCrossCUAlias.Option, NIVolumeTypeCKDSingleCuAlias.Option};
            bl = this._checkVolumeTypes(nIOlcDatabaseSchemaHelper, nIVolumeGroup, nIVolumeTypeArray);
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeFiconEsconMixedMask) {
            NIVolumeType[] nIVolumeTypeArray = new NIVolumeType[]{NIVolumeTypeCKDBase.Option, NIVolumeTypeCKDCrossCUAlias.Option, NIVolumeTypeCKDSingleCuAlias.Option, NIVolumeTypeCKDMap.Option};
            bl = this._checkVolumeTypes(nIOlcDatabaseSchemaHelper, nIVolumeGroup, nIVolumeTypeArray);
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMask || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMap256 || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Mask || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Map256) {
            NIVolumeType[] nIVolumeTypeArray = new NIVolumeType[]{NIVolumeTypeFixedBlockBase.Option, NIVolumeTypeFixedBlockMap.Option};
            bl = this._checkVolumeTypes(nIOlcDatabaseSchemaHelper, nIVolumeGroup, nIVolumeTypeArray);
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMixedMask) {
            NIVolumeType[] nIVolumeTypeArray = new NIVolumeType[]{NIVolumeTypeFixedBlockBase.Option, NIVolumeTypeFixedBlockMap.Option, NIVolumeTypeCKDBase.Option};
            bl = this._checkVolumeTypes(nIOlcDatabaseSchemaHelper, nIVolumeGroup, nIVolumeTypeArray);
        } else {
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, "checkVolumeGroup");
        return bl;
    }

    private boolean _checkVolumeTypes(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NIVolumeGroup nIVolumeGroup, NIVolumeType[] nIVolumeTypeArray) {
        NIOlcLogger.enter(CLASS_NAME, "checkVolumeTypes");
        boolean bl = true;
        NIVolumeGroupType nIVolumeGroupType = nIVolumeGroup.getType();
        NIVolumeGroupVolumeList nIVolumeGroupVolumeList = nIVolumeGroup.getVolumeGroupList();
        NIVolumeID[] nIVolumeIDArray = nIVolumeGroupVolumeList.getVolumesInVolumeGroup().toArray(new NIVolumeID[0]);
        if (nIVolumeIDArray == null || nIVolumeIDArray.length == 0) {
            return true;
        }
        List list = nIOlcDatabaseSchemaHelper.getVolumesByID(nIVolumeIDArray);
        int n = 0;
        if (list != null) {
            n = list.size();
        }
        int n2 = 0;
        while (n2 < n && bl) {
            NIVolume nIVolume = (NIVolume)list.get(n2);
            NIVolumeType nIVolumeType = nIVolume.getVolumeType();
            boolean bl2 = false;
            boolean bl3 = false;
            int n3 = 0;
            while (n3 < nIVolumeTypeArray.length && !bl3) {
                if (nIVolumeType.getClass().isInstance(nIVolumeTypeArray[n3])) {
                    if (nIVolumeGroupType instanceof NIVolumeGroupTypeFiconEsconMixedMask || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMask || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMap256 || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMixedMask) {
                        if (nIVolume.getDataType() instanceof NIDataTypeBlock512) {
                            bl2 = true;
                            bl3 = true;
                        } else {
                            bl3 = true;
                        }
                    } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Mask || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Map256) {
                        if (nIVolume.getDataType() instanceof NIDataTypeBlock520Protected || nIVolume.getDataType() instanceof NIDataTypeBlock520Unprotected) {
                            bl2 = true;
                            bl3 = true;
                        } else {
                            bl3 = true;
                        }
                    } else {
                        bl2 = true;
                        bl3 = true;
                    }
                }
                ++n3;
            }
            bl = bl2;
            ++n2;
        }
        NIOlcLogger.exit(CLASS_NAME, "checkVolumeTypes");
        return bl;
    }

    public NIConfigQueryResult getArraySites(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getArraySites");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getArraySitesByESS(nIESSID);
        NIOlcLogger.exit(CLASS_NAME, "getArraySites");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getArraySites(NIArraySiteID[] nIArraySiteIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getArraySites");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIArraySiteIDArray[0].getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getArraySitesByID(nIArraySiteIDArray);
        NIOlcLogger.exit(CLASS_NAME, "getArraySites");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getArrays(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getArrays");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getArraysByESS(nIESSID);
        NIOlcLogger.exit(CLASS_NAME, "getArrays");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getArrays(NIArrayID[] nIArrayIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getArrays");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIArrayIDArray[0].getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getArraysByID(nIArrayIDArray);
        NIOlcLogger.exit(CLASS_NAME, "getArrays");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getRanks(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getRanks");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getRanksByESS(nIESSID);
        NIOlcLogger.exit(CLASS_NAME, "getRanks");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getRanks(NIRankID[] nIRankIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getRanks");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIRankIDArray[0].getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getRanksByID(nIRankIDArray);
        NIOlcLogger.exit(CLASS_NAME, "getRanks");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getExtentPools(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getExtentPools");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getExtentPoolsByESS(nIESSID);
        NIOlcLogger.exit(CLASS_NAME, "getExtentPools");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getExtentPools(NIExtentPoolID[] nIExtentPoolIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getExtentPools");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIExtentPoolIDArray[0].getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getExtentPoolsByID(nIExtentPoolIDArray);
        NIOlcLogger.exit(CLASS_NAME, "getExtentPools");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getVolumes(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getVolumes");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getVolumesByESS(nIESSID);
        NIOlcLogger.exit(CLASS_NAME, "getVolumes");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getVolumes(NIESSID nIESSID, NIDeviceType nIDeviceType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getVolumes");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getVolumesByESSDevice(nIESSID, nIDeviceType);
        NIOlcLogger.exit(CLASS_NAME, "getVolumes");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getVolumes(NILSSID nILSSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getVolumes");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nILSSID.getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getVolumesByLSS(nILSSID);
        NIOlcLogger.exit(CLASS_NAME, "getVolumes");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getVolumes(NILSSID nILSSID, NIDeviceType nIDeviceType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        return this.getVolumes(nILSSID);
    }

    public NIConfigQueryResult getVolumes(NIVolumeID[] nIVolumeIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getVolumes");
        ArrayList arrayList = null;
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        if (nIVolumeIDArray != null && nIVolumeIDArray.length > 0) {
            NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIVolumeIDArray[0].getLSS().getESS());
            if (nIOlcDatabaseSchemaHelper == null) {
                return c.handleFailedQuery(-1099689979L, nIEscrow);
            }
            arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getVolumesByID(nIVolumeIDArray);
            nIOlcDatabaseSchemaHelper.release();
        } else {
            arrayList = new ArrayList(0);
        }
        NIOlcLogger.exit(CLASS_NAME, "getVolumes");
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getLogicalSubsystems(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getLogicalSubsystems");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getLogicalSubsystemsByESS(nIESSID);
        NIOlcLogger.exit(CLASS_NAME, "getLogicalSubsystems");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getLogicalSubsystems(NIESSID nIESSID, NIDeviceType nIDeviceType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getLogicalSubsystems");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getLogicalSubsystemsByESSDevice(nIESSID, nIDeviceType);
        NIOlcLogger.exit(CLASS_NAME, "getLogicalSubsystems");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getLogicalSubsystems(NILSSID[] nILSSIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getLogicalSubsystems");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nILSSIDArray[0].getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getLogicalSubsystemsByID(nILSSIDArray);
        NIOlcLogger.exit(CLASS_NAME, "getLogicalSubsystems");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getAddressGroups(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getAddressGroups");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getAddressGroupsByESS(nIESSID);
        NIOlcLogger.exit(CLASS_NAME, "getAddressGroups");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getAddressGroups(NIAddressGroupID[] nIAddressGroupIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getAddressGroups");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIAddressGroupIDArray[0].getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getAddressGroupsByID(nIAddressGroupIDArray);
        NIOlcLogger.exit(CLASS_NAME, "getAddressGroups");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getVolumeGroups(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getVolumeGroups");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getVolumeGroupsByESS(nIESSID);
        NIOlcLogger.exit(CLASS_NAME, "getVolumeGroups");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getVolumeGroups(NIVolumeGroupID[] nIVolumeGroupIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getVolumeGroups");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIVolumeGroupIDArray[0].getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getVolumeGroupsByID(nIVolumeGroupIDArray);
        NIOlcLogger.exit(CLASS_NAME, "getVolumeGroups");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getVolumeGroups(NIVolumeID nIVolumeID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getVolumeGroups");
        NIESSID nIESSID = nIVolumeID.getLSS().getESS();
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList<NIVolumeGroup> arrayList = new ArrayList<NIVolumeGroup>();
        ArrayList arrayList2 = (ArrayList)nIOlcDatabaseSchemaHelper.getVolumeGroupsByESS(nIESSID);
        int n = 0;
        while (n < arrayList2.size()) {
            NIVolumeGroup nIVolumeGroup = (NIVolumeGroup)arrayList2.get(n);
            if (nIVolumeGroup.getVolumeGroupList().contains(nIVolumeID)) {
                arrayList.add(nIVolumeGroup);
            }
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, "getVolumeGroups");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigCreatedResult createArray(NIArray nIArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        int n;
        Serializable serializable;
        NIArraySite nIArraySite;
        NIOlcLogger.enter(CLASS_NAME, "createArray");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        NIArrayImpl nIArrayImpl = (NIArrayImpl)nIArray;
        NIESSID nIESSID = nIArrayImpl.getArraySites()[0].getESS();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return (NIConfigCreatedResult)c.failConfig(nIArrayImpl.getID(), nIEscrow, -1099689979L);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getArraySitesByID(nIArrayImpl.getArraySites());
        int n2 = 0;
        while (n2 < arrayList.size()) {
            nIArraySite = (NIArraySite)arrayList.get(n2);
            if (nIArraySite.getArraySiteStatus() == 0) {
                nIOlcDatabaseSchemaHelper.release();
                return (NIConfigCreatedResult)c.failConfig(nIArrayImpl.getID(), nIEscrow, -1102032636L);
            }
            ++n2;
        }
        if (nIESSID.getType().equals("1750") && arrayList.size() > 1) {
            nIArraySite = (NIArraySite)arrayList.get(0);
            serializable = (NIArraySite)arrayList.get(1);
            if (nIArraySite.getDualLoop() != serializable.getDualLoop()) {
                nIOlcDatabaseSchemaHelper.release();
                return (NIConfigCreatedResult)c.failConfig(nIArrayImpl.getID(), nIEscrow, -1100939263L);
            }
        }
        if ((n = this._generateArrayNumber(nIOlcDatabaseSchemaHelper, nIESSID)) == -1) {
            nIOlcDatabaseSchemaHelper.release();
            return (NIConfigCreatedResult)c.failConfig(nIArrayImpl.getID(), nIEscrow, -1102032640L);
        }
        serializable = new NIArrayID(nIESSID, n);
        nIArrayImpl.setID((NIResourceID)serializable);
        boolean bl = true;
        nIOlcDatabaseSchemaHelper.beginXA();
        if (nIESSID.getType().equals("2107")) {
            bl &= this._create2107Array(nIArrayImpl, nIOlcDatabaseSchemaHelper);
        } else if (nIESSID.getType().equals("1750")) {
            bl &= this._create1750Array(nIArrayImpl, nIOlcDatabaseSchemaHelper);
        }
        if (!bl) {
            nIOlcDatabaseSchemaHelper.release();
            return (NIConfigCreatedResult)c.failConfig(nIArrayImpl.getID(), nIEscrow, -1100939256L);
        }
        this.alEventsHolder.add(new NIArrayCreatedEventImpl(nIArrayImpl));
        if (bl &= bl ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIOlcLogger.exit(CLASS_NAME, "createArray");
        nIOlcDatabaseSchemaHelper.release();
        return (NIConfigCreatedResult)c.handleConfig((NIResourceID)serializable, nIEscrow, bl);
    }

    public NIConfigResult deleteArray(NIArrayID nIArrayID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "deleteArray");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIESSID nIESSID = nIArrayID.getESS();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.failConfig(nIArrayID, nIEscrow, -1099689979L);
        }
        List list = nIOlcDatabaseSchemaHelper.getArraysByID(new NIArrayID[]{nIArrayID});
        if (list.size() == 0) {
            nIOlcDatabaseSchemaHelper.release();
            return c.failConfig(nIArrayID, nIEscrow, 2L);
        }
        NIArray nIArray = (NIArray)list.get(0);
        if (nIArray.getArrayStatus() == 0) {
            nIOlcDatabaseSchemaHelper.release();
            return c.failConfig(nIArrayID, nIEscrow, -1102032636L);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getArraySitesByID(nIArray.getArraySites());
        nIOlcDatabaseSchemaHelper.beginXA();
        boolean bl = nIOlcDatabaseSchemaHelper.deleteArray((NIArrayID)nIArray.getID());
        int n = 0;
        while (n < arrayList.size()) {
            NIArraySiteImpl nIArraySiteImpl = (NIArraySiteImpl)arrayList.get(n);
            nIArraySiteImpl.setArraySiteStatus(1);
            nIArraySiteImpl.setArrayID(null);
            nIArraySiteImpl.setArrayPosition(-1);
            bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl);
            ++n;
        }
        this.alEventsHolder.add(new NIArrayDeletedEventImpl(nIArray));
        if (bl &= bl ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIOlcLogger.exit(CLASS_NAME, "deleteArray");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleConfig(nIArrayID, nIEscrow, bl);
    }

    public NIConfigCreatedResult createRank(NIRank nIRank) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIResourceImpl nIResourceImpl;
        NIResourceImpl nIResourceImpl2;
        NIOlcLogger.enter(CLASS_NAME, "createRank");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        NIRankImpl nIRankImpl = (NIRankImpl)nIRank;
        NIExtentPoolID nIExtentPoolID = nIRankImpl.getExtentPoolID();
        NIESSID nIESSID = nIRankImpl.getArrayIDs()[0].getESS();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return (NIConfigCreatedResult)c.failConfig(nIRankImpl.getID(), nIEscrow, -1099689979L);
        }
        int n = 0;
        nIOlcDatabaseSchemaHelper.beginXA();
        boolean bl = true;
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getArraysByID(nIRankImpl.getArrayIDs());
        if (arrayList.size() != 1 && arrayList.size() != 2 && arrayList.size() != 4 && arrayList.size() != 8) {
            nIOlcDatabaseSchemaHelper.release();
            return (NIConfigCreatedResult)c.failConfig(nIRankImpl.getID(), nIEscrow, -1101966776L);
        }
        if (!this._checkLICFeatureLimits(nIRankImpl, nIESSID, nIOlcDatabaseSchemaHelper)) {
            nIOlcDatabaseSchemaHelper.release();
            return (NIConfigCreatedResult)c.failConfig(nIRankImpl.getID(), nIEscrow, -1100939260L);
        }
        int n2 = this._generateRankNumber(nIOlcDatabaseSchemaHelper, nIESSID);
        if (n2 == -1) {
            nIOlcDatabaseSchemaHelper.release();
            return (NIConfigCreatedResult)c.failConfig(nIRankImpl.getID(), nIEscrow, -1101966848L);
        }
        NIRankID nIRankID = new NIRankID(nIESSID, n2);
        nIRankImpl.setID(nIRankID);
        int n3 = 0;
        while (n3 < arrayList.size()) {
            nIResourceImpl2 = (NIArrayImpl)arrayList.get(n3);
            nIResourceImpl = (NIArrayImpl)nIResourceImpl2.clone();
            if (((NIArrayImpl)nIResourceImpl).getArrayStatus() == 0) {
                nIOlcDatabaseSchemaHelper.release();
                return (NIConfigCreatedResult)c.failConfig(nIRankImpl.getID(), nIEscrow, -1102032636L);
            }
            ((NIArrayImpl)nIResourceImpl).setRankPosition(n3);
            ((NIArrayImpl)nIResourceImpl).setArrayStatus(0);
            ((NIArrayImpl)nIResourceImpl).setRankID(nIRankID);
            bl &= nIOlcDatabaseSchemaHelper.modifyArray((NIArray)((Object)nIResourceImpl));
            this.alEventsHolder.add(new NIArrayChangedEventImpl((NIArray)((Object)nIResourceImpl2), (NIArray)((Object)nIResourceImpl)));
            n += this._extentsInArray((NIArray)((Object)nIResourceImpl), nIRankImpl.getExtentType());
            ++n3;
        }
        nIRankImpl.setNumExtents(n);
        nIRankImpl.setRAIDType(((NIArray)arrayList.get(0)).getRaidType());
        if (nIExtentPoolID != null) {
            nIResourceImpl2 = (NIExtentPoolImpl)nIOlcDatabaseSchemaHelper.getExtentPoolsByID(new NIExtentPoolID[]{nIExtentPoolID}).get(0);
            nIResourceImpl = (NIExtentPoolImpl)nIResourceImpl2.clone();
            if (!((NIExtentPoolImpl)nIResourceImpl).getExtentType().getClass().isInstance(nIRankImpl.getExtentType())) {
                nIOlcDatabaseSchemaHelper.release();
                return (NIConfigCreatedResult)c.failConfig(nIRankImpl.getID(), nIEscrow, -1101835259L);
            }
            ((NIExtentPoolImpl)nIResourceImpl).setNumRanks(((NIExtentPoolImpl)nIResourceImpl).getNumRanks() + 1);
            ((NIExtentPoolImpl)nIResourceImpl).setNumExtents(((NIExtentPoolImpl)nIResourceImpl).getNumExtents() + nIRankImpl.getNumExtents());
            bl &= nIOlcDatabaseSchemaHelper.modifyExtentPool((NIExtentPool)((Object)nIResourceImpl));
            this.alEventsHolder.add(new NIExtentPoolChangedEventImpl((NIExtentPool)((Object)nIResourceImpl2), (NIExtentPool)((Object)nIResourceImpl)));
            nIRankImpl.setConfigurationState(0);
            nIRankImpl.setRankGroup(((NIExtentPoolImpl)nIResourceImpl).getRankGroup());
        } else {
            nIRankImpl.setConfigurationState(2);
        }
        this.alEventsHolder.add(new NIRankCreatedEventImpl(nIRankImpl));
        if (bl &= (bl &= nIOlcDatabaseSchemaHelper.insertRank(nIRankImpl)) ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIOlcLogger.exit(CLASS_NAME, "createRank");
        nIOlcDatabaseSchemaHelper.release();
        return (NIConfigCreatedResult)c.handleConfig(nIRankID, nIEscrow, bl);
    }

    public NIConfigResult[] deleteRank(NIRankID[] nIRankIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "deleteRank");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIConfigResult[] nIConfigResultArray = new NIConfigResult[nIRankIDArray.length];
        NIESSID nIESSID = nIRankIDArray[0].getESS();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            int n = 0;
            while (n < nIConfigResultArray.length) {
                nIConfigResultArray[n] = c.failConfig(nIRankIDArray[n], -1099689979L);
                ++n;
            }
            nIEscrow.close(nIConfigResultArray);
            return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
        }
        int n = 0;
        while (n < nIRankIDArray.length) {
            boolean bl = true;
            List list = nIOlcDatabaseSchemaHelper.getRanksByID(new NIRankID[]{nIRankIDArray[n]});
            if (list.size() == 0) {
                nIConfigResultArray[n] = c.failConfig(nIRankIDArray[n], 2L);
            } else {
                nIOlcDatabaseSchemaHelper.beginXA();
                NIRankImpl nIRankImpl = (NIRankImpl)list.get(0);
                if (nIRankImpl.getNumUsedExtents() > 0L) {
                    nIOlcDatabaseSchemaHelper.cancelXA();
                    nIConfigResultArray[n] = c.failConfig(nIRankImpl.getID(), 1L);
                } else {
                    NIResourceImpl nIResourceImpl;
                    Serializable serializable;
                    ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getArraysByID(nIRankImpl.getArrayIDs());
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        serializable = (NIArrayImpl)iterator.next();
                        nIResourceImpl = (NIArrayImpl)((NIResourceImpl)serializable).clone();
                        ((NIArrayImpl)nIResourceImpl).setArrayStatus(1);
                        ((NIArrayImpl)nIResourceImpl).setRankID(null);
                        ((NIArrayImpl)nIResourceImpl).setRankPosition(-1);
                        bl &= nIOlcDatabaseSchemaHelper.modifyArray((NIArray)((Object)nIResourceImpl));
                        this.alEventsHolder.add(new NIArrayChangedEventImpl((NIArray)serializable, (NIArray)((Object)nIResourceImpl)));
                    }
                    serializable = nIRankImpl.getExtentPoolID();
                    if (serializable != null) {
                        nIResourceImpl = (NIExtentPoolImpl)((ArrayList)nIOlcDatabaseSchemaHelper.getExtentPoolsByID(new NIExtentPoolID[]{serializable})).get(0);
                        NIExtentPoolImpl nIExtentPoolImpl = (NIExtentPoolImpl)nIResourceImpl.clone();
                        nIExtentPoolImpl.setNumExtents(nIExtentPoolImpl.getNumExtents() - nIRankImpl.getNumExtents());
                        nIExtentPoolImpl.setNumRanks(nIExtentPoolImpl.getNumRanks() - 1);
                        bl &= nIOlcDatabaseSchemaHelper.modifyExtentPool(nIExtentPoolImpl);
                        this.alEventsHolder.add(new NIExtentPoolChangedEventImpl((NIExtentPool)((Object)nIResourceImpl), nIExtentPoolImpl));
                    }
                    this.alEventsHolder.add(new NIRankDeletedEventImpl(nIRankImpl));
                    if (bl &= (bl &= nIOlcDatabaseSchemaHelper.deleteRank((NIRankID)nIRankImpl.getID())) ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
                        NIOlcEventProcessor.processEvents(this.alEventsHolder);
                    }
                    this.alEventsHolder.clear();
                    nIConfigResultArray[n] = c.handleConfig(nIRankImpl.getID(), bl);
                }
            }
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, "deleteRank");
        nIEscrow.close(nIConfigResultArray);
        nIOlcDatabaseSchemaHelper.release();
        return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
    }

    public NIConfigCreatedResult createExtentPool(NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "createExtentPool");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        NIExtentPoolImpl nIExtentPoolImpl = (NIExtentPoolImpl)nIExtentPool;
        NIESSID nIESSID = ((NIExtentPoolID)nIExtentPoolImpl.getID()).getESS();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return (NIConfigCreatedResult)c.failConfig(nIExtentPoolImpl.getID(), nIEscrow, -1099689979L);
        }
        int n = this._generateExtentPoolNumber(nIOlcDatabaseSchemaHelper, nIESSID, nIExtentPoolImpl);
        if (n == -1) {
            nIOlcDatabaseSchemaHelper.release();
            return (NIConfigCreatedResult)c.failConfig(nIExtentPoolImpl.getID(), nIEscrow, -1101901056L);
        }
        NIExtentPoolID nIExtentPoolID = new NIExtentPoolID(nIESSID, n);
        nIExtentPoolImpl.setID(nIExtentPoolID);
        boolean bl = nIOlcDatabaseSchemaHelper.insertExtentPool(nIExtentPoolImpl);
        this.alEventsHolder.add(new NIExtentPoolCreatedEventImpl(nIExtentPoolImpl));
        if (bl) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIOlcLogger.exit(CLASS_NAME, "createExtentPool");
        nIOlcDatabaseSchemaHelper.release();
        return (NIConfigCreatedResult)c.handleConfig(nIExtentPoolID, nIEscrow, bl);
    }

    public NIConfigResult[] deleteExtentPool(NIExtentPoolID[] nIExtentPoolIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "deleteExtentPool");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIConfigResult[] nIConfigResultArray = new NIConfigResult[nIExtentPoolIDArray.length];
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIExtentPoolIDArray[0].getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            int n = 0;
            while (n < nIConfigResultArray.length) {
                nIConfigResultArray[n] = c.failConfig(nIExtentPoolIDArray[n], -1099689979L);
                ++n;
            }
            nIEscrow.close(nIConfigResultArray);
            return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
        }
        int n = 0;
        while (n < nIExtentPoolIDArray.length) {
            boolean bl = true;
            List list = nIOlcDatabaseSchemaHelper.getExtentPoolsByID(new NIExtentPoolID[]{nIExtentPoolIDArray[n]});
            if (list.size() == 0) {
                nIConfigResultArray[n] = c.failConfig(nIExtentPoolIDArray[n], 2L);
            } else {
                nIOlcDatabaseSchemaHelper.beginXA();
                NIExtentPool nIExtentPool = (NIExtentPool)list.get(0);
                if (nIExtentPool.getNumRanks() > 0) {
                    nIConfigResultArray[n] = c.failConfig(nIExtentPool.getID(), 2L);
                } else {
                    this.alEventsHolder.add(new NIExtentPoolDeletedEventImpl(nIExtentPool));
                    if (bl &= (bl &= nIOlcDatabaseSchemaHelper.deleteExtentPool(nIExtentPool)) ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
                        NIOlcEventProcessor.processEvents(this.alEventsHolder);
                    }
                    this.alEventsHolder.clear();
                    nIConfigResultArray[n] = c.handleConfig(nIExtentPool.getID(), bl);
                }
            }
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, "deleteExtentPool");
        nIEscrow.close(nIConfigResultArray);
        nIOlcDatabaseSchemaHelper.release();
        return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
    }

    public NIConfigResult[] modifyExtentPool(NIExtentPool[] nIExtentPoolArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "modifyExtentPool");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIConfigResult[] nIConfigResultArray = new NIConfigResult[nIExtentPoolArray.length];
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIExtentPoolArray[0].getID().getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            int n = 0;
            while (n < nIConfigResultArray.length) {
                nIConfigResultArray[n] = c.failConfig(nIExtentPoolArray[n].getID(), -1099689979L);
                ++n;
            }
            nIEscrow.close(nIConfigResultArray);
            return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
        }
        int n = 0;
        while (n < nIExtentPoolArray.length) {
            boolean bl = true;
            nIOlcDatabaseSchemaHelper.beginXA();
            NIExtentPoolImpl nIExtentPoolImpl = (NIExtentPoolImpl)nIOlcDatabaseSchemaHelper.getExtentPoolsByID(new NIExtentPoolID[]{(NIExtentPoolID)nIExtentPoolArray[n].getID()}).get(0);
            this.alEventsHolder.add(new NIExtentPoolChangedEventImpl(nIExtentPoolImpl, nIExtentPoolArray[n]));
            if (bl &= (bl &= nIOlcDatabaseSchemaHelper.modifyExtentPool(nIExtentPoolArray[n])) ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
                NIOlcEventProcessor.processEvents(this.alEventsHolder);
            }
            this.alEventsHolder.clear();
            nIConfigResultArray[n] = new NIConfigResultImpl(nIExtentPoolArray[n].getID(), bl, 0L);
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, "modifyExtentPool");
        nIEscrow.close(nIConfigResultArray);
        nIOlcDatabaseSchemaHelper.release();
        return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
    }

    public NIConfigResult[] assignRanks(NIExtentPool nIExtentPool, NIRankID[] nIRankIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "assignRanks");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIConfigResult[] nIConfigResultArray = new NIConfigResult[nIRankIDArray.length];
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIRankIDArray[0].getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            int n = 0;
            while (n < nIConfigResultArray.length) {
                nIConfigResultArray[n] = c.failConfig(nIRankIDArray[n], -1099689979L);
                ++n;
            }
            nIEscrow.close(nIConfigResultArray);
            return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
        }
        List list = nIOlcDatabaseSchemaHelper.getExtentPoolsByID(new NIExtentPoolID[]{(NIExtentPoolID)nIExtentPool.getID()});
        if (list.size() == 0) {
            int n = 0;
            while (n < nIConfigResultArray.length) {
                nIConfigResultArray[n] = c.failConfig(nIRankIDArray[n], -1099694075L);
                ++n;
            }
            nIEscrow.close(nIConfigResultArray);
            nIOlcDatabaseSchemaHelper.release();
            return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
        }
        NIExtentPoolImpl nIExtentPoolImpl = (NIExtentPoolImpl)list.get(0);
        NIExtentPoolImpl nIExtentPoolImpl2 = (NIExtentPoolImpl)nIExtentPoolImpl.clone();
        NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPoolImpl2.getID();
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getRanksByID(nIRankIDArray);
        ArrayList arrayList2 = new ArrayList();
        boolean bl = true;
        nIOlcDatabaseSchemaHelper.beginXA();
        int n = 0;
        while (n < arrayList.size()) {
            NIRankImpl nIRankImpl = (NIRankImpl)arrayList.get(n);
            NIRankImpl nIRankImpl2 = (NIRankImpl)nIRankImpl.clone();
            if (nIRankImpl2.getConfigurationState() != 2) {
                nIConfigResultArray[n] = c.failConfig(nIRankImpl2.getID(), -1102032636L);
            } else if (!nIRankImpl2.getExtentType().getClass().isInstance(nIExtentPoolImpl2.getExtentType())) {
                nIConfigResultArray[n] = c.failConfig(nIRankImpl2.getID(), 2L);
            } else {
                nIExtentPoolImpl2.setNumExtents(nIExtentPoolImpl2.getNumExtents() + nIRankImpl2.getNumExtents());
                nIExtentPoolImpl2.setNumRanks(nIExtentPoolImpl2.getNumRanks() + 1);
                nIRankImpl2.setRankGroup(nIExtentPoolImpl2.getRankGroup());
                nIRankImpl2.setExtentPoolID(nIExtentPoolID);
                nIRankImpl2.setConfigurationState(0);
                this.alEventsHolder.add(new NIRankChangedEventImpl(nIRankImpl, nIRankImpl2));
                if (bl &= nIOlcDatabaseSchemaHelper.modifyRank(nIRankImpl2)) {
                    arrayList2.addAll(this.alEventsHolder);
                }
                this.alEventsHolder.clear();
                nIConfigResultArray[n] = c.handleConfig(nIRankImpl2.getID(), bl);
            }
            ++n;
        }
        NIOlcEventProcessor.processEvents(arrayList2);
        this.alEventsHolder.add(new NIExtentPoolChangedEventImpl(nIExtentPoolImpl, nIExtentPoolImpl2));
        bl &= (bl &= nIOlcDatabaseSchemaHelper.modifyExtentPool(nIExtentPoolImpl2)) ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA();
        NIOlcLogger.exit(CLASS_NAME, "assignRanks");
        nIEscrow.close(nIConfigResultArray);
        nIOlcDatabaseSchemaHelper.release();
        return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
    }

    public NIConfigResult[] unassignRanks(NIRankID[] nIRankIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "unassignRanks");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIConfigResult[] nIConfigResultArray = new NIConfigResult[nIRankIDArray.length];
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIRankIDArray[0].getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            int n = 0;
            while (n < nIConfigResultArray.length) {
                nIConfigResultArray[n] = c.failConfig(nIRankIDArray[n], -1099689979L);
                ++n;
            }
            nIEscrow.close(nIConfigResultArray);
            return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getRanksByID(nIRankIDArray);
        boolean bl = true;
        nIOlcDatabaseSchemaHelper.beginXA();
        int n = 0;
        while (n < arrayList.size()) {
            NIRankImpl nIRankImpl = (NIRankImpl)arrayList.get(n);
            NIRankImpl nIRankImpl2 = (NIRankImpl)nIRankImpl.clone();
            NIExtentPoolImpl nIExtentPoolImpl = (NIExtentPoolImpl)nIOlcDatabaseSchemaHelper.getExtentPoolsByID(new NIExtentPoolID[]{nIRankImpl2.getExtentPoolID()}).get(0);
            NIExtentPoolImpl nIExtentPoolImpl2 = (NIExtentPoolImpl)nIExtentPoolImpl.clone();
            nIExtentPoolImpl2.setNumExtents(nIExtentPoolImpl2.getNumExtents() - nIRankImpl2.getNumExtents());
            nIExtentPoolImpl2.setNumRanks(nIExtentPoolImpl2.getNumRanks() - 1);
            nIRankImpl2.setExtentPoolID(null);
            nIRankImpl2.setConfigurationState(2);
            bl &= nIOlcDatabaseSchemaHelper.modifyRank(nIRankImpl2);
            this.alEventsHolder.add(new NIRankChangedEventImpl(nIRankImpl, nIRankImpl2));
            this.alEventsHolder.add(new NIExtentPoolChangedEventImpl(nIExtentPoolImpl, nIExtentPoolImpl2));
            nIConfigResultArray[n] = c.handleConfig(nIRankImpl2.getID(), bl &= nIOlcDatabaseSchemaHelper.modifyExtentPool(nIExtentPoolImpl2));
            ++n;
        }
        if (bl &= bl ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIOlcLogger.exit(CLASS_NAME, "unassignRanks");
        nIEscrow.close(nIConfigResultArray);
        nIOlcDatabaseSchemaHelper.release();
        return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
    }

    public NIConfigResult reserveRank(NIRankID nIRankID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "reserveRank");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIRankID.getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.failConfig(nIRankID, nIEscrow, -1099689979L);
        }
        boolean bl = true;
        NIRankImpl nIRankImpl = (NIRankImpl)nIOlcDatabaseSchemaHelper.getRanksByID(new NIRankID[]{nIRankID}).get(0);
        NIRankImpl nIRankImpl2 = (NIRankImpl)nIRankImpl.clone();
        nIRankImpl2.setConfigurationState(3);
        this.alEventsHolder.add(new NIRankChangedEventImpl(nIRankImpl, nIRankImpl2));
        if (bl &= nIOlcDatabaseSchemaHelper.modifyRank(nIRankImpl2)) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIOlcLogger.exit(CLASS_NAME, "reserveRank");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleConfig(nIRankID, nIEscrow, bl);
    }

    public NIConfigCreatedResult[] createVolumes(NIVolume[] nIVolumeArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        Iterator iterator;
        boolean bl;
        Object object;
        Integer n;
        NIOlcLogger.enter(CLASS_NAME, "createVolumes");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        NIConfigCreatedResult[] nIConfigCreatedResultArray = new NIConfigCreatedResult[nIVolumeArray.length];
        NIESSID nIESSID = nIVolumeArray[0].getExtentPool().getESS();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            int n2 = 0;
            while (n2 < nIConfigCreatedResultArray.length) {
                nIConfigCreatedResultArray[n2] = (NIConfigCreatedResult)c.failConfig(nIVolumeArray[n2].getID(), -1099689979L);
                ++n2;
            }
            nIEscrow.close(nIConfigCreatedResultArray);
            return new NIConfigCreatedResult[]{(NIConfigCreatedResult)((Object)nIEscrow.issueIou())};
        }
        nIOlcDatabaseSchemaHelper.setConstraints("SET CONSTRAINTS ALL DISABLED");
        HashMap<NILSSID, NILSSImpl> hashMap = new HashMap<NILSSID, NILSSImpl>();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap<NIVolumeID, String> hashMap4 = new HashMap<NIVolumeID, String>();
        HashMap hashMap5 = new HashMap();
        HashMap<NIVolumeID, Integer> hashMap6 = new HashMap<NIVolumeID, Integer>();
        HashMap<NIRankID, NIRankImpl> hashMap7 = new HashMap<NIRankID, NIRankImpl>();
        HashMap<NILSSID, NILSSVolumeSetImpl> hashMap8 = new HashMap<NILSSID, NILSSVolumeSetImpl>();
        List list = new ArrayList();
        Object var19_16 = null;
        NIVolumeImpl nIVolumeImpl = null;
        NIVolumeID nIVolumeID = null;
        NILSSImpl nILSSImpl = null;
        NILSSID nILSSID = null;
        NILSSImpl nILSSImpl2 = null;
        NIRankImpl nIRankImpl = null;
        NIRankImpl nIRankImpl2 = null;
        NIExtentPoolImpl nIExtentPoolImpl = null;
        NIExtentPoolImpl nIExtentPoolImpl2 = null;
        NIDataType nIDataType = null;
        NIVolumeGroupImpl nIVolumeGroupImpl = null;
        NIVolumeGroupImpl nIVolumeGroupImpl2 = null;
        NIAddressGroupImpl nIAddressGroupImpl = null;
        NIAddressGroupImpl nIAddressGroupImpl2 = null;
        NIVolumeMap nIVolumeMap = null;
        NILSSVolumeSetImpl nILSSVolumeSetImpl = null;
        int n3 = 0;
        while (n3 < nIVolumeArray.length) {
            boolean bl2;
            nIVolumeImpl = (NIVolumeImpl)nIVolumeArray[n3];
            nIVolumeID = (NIVolumeID)nIVolumeImpl.getID();
            nIDataType = nIVolumeImpl.getDataType();
            boolean bl3 = bl2 = nIDataType instanceof NIDataTypeBlock512 || nIDataType instanceof NIDataTypeBlock520Protected || nIDataType instanceof NIDataTypeBlock520Unprotected;
            n = new Integer(bl2 ? (nIDataType instanceof NIDataTypeBlock512 ? 20 : 30) : 10);
            hashMap6.put(nIVolumeID, n);
            if (!hashMap5.containsKey(n)) {
                list = nIOlcDatabaseSchemaHelper.getVolumeGroupsByID(new NIVolumeGroupID[]{new NIVolumeGroupID(nIESSID, n)});
                hashMap5.put(n, list.get(0));
            }
            if (hashMap.containsKey(nILSSID = nIVolumeID.getLSS())) {
                nILSSImpl = (NILSSImpl)hashMap.get(nILSSID);
                nILSSVolumeSetImpl = (NILSSVolumeSetImpl)hashMap8.get(nILSSID);
            } else {
                list = nIOlcDatabaseSchemaHelper.getLogicalSubsystemsByID(new NILSSID[]{nILSSID});
                if (list.size() != 0) {
                    nILSSImpl = (NILSSImpl)list.get(0);
                    nILSSVolumeSetImpl = nIOlcDatabaseSchemaHelper.getLSSVolumeSet(nILSSID);
                    hashMap.put(nILSSID, nILSSImpl);
                    hashMap8.put(nILSSID, nILSSVolumeSetImpl);
                    object = nILSSImpl.getAddressGroupID();
                    if (!hashMap3.containsKey(object)) {
                        list = nIOlcDatabaseSchemaHelper.getAddressGroupsByID(new NIAddressGroupID[]{object});
                        if (list.size() != 0) {
                            hashMap3.put(object, list.get(0));
                        } else {
                            nIConfigCreatedResultArray[n3] = (NIConfigCreatedResult)c.failConfig(nIVolumeID, 2L);
                        }
                    }
                } else if (n == 20 || n == 30) {
                    nILSSImpl = (NILSSImpl)NIResourceFactory.newLSS(nIESSID, nILSSID.getLSSNumber(), 0, NIDeviceTypeFB.Option, NICKDBaseCUType3990Model6.Option);
                    bl = this._createLSS(nIOlcDatabaseSchemaHelper, nILSSImpl);
                    if (bl) {
                        nILSSVolumeSetImpl = new NILSSVolumeSetImpl();
                        hashMap.put(nILSSID, nILSSImpl);
                        hashMap8.put(nILSSID, nILSSVolumeSetImpl);
                        object = nILSSImpl.getAddressGroupID();
                        if (!hashMap3.containsKey(object)) {
                            list = nIOlcDatabaseSchemaHelper.getAddressGroupsByID(new NIAddressGroupID[]{object});
                            if (list.size() != 0) {
                                hashMap3.put(object, list.get(0));
                            } else {
                                nIConfigCreatedResultArray[n3] = (NIConfigCreatedResult)c.failConfig(nIVolumeID, 2L);
                            }
                        }
                    } else {
                        nIConfigCreatedResultArray[n3] = (NIConfigCreatedResult)c.failConfig(nIVolumeID, -1101769448L);
                    }
                } else {
                    nIConfigCreatedResultArray[n3] = (NIConfigCreatedResult)c.failConfig(nIVolumeID, -1101769471L);
                }
            }
            object = nIVolumeImpl.getExtentPool();
            if (!hashMap2.containsKey(object)) {
                list = nIOlcDatabaseSchemaHelper.getExtentPoolsByID(new NIExtentPoolID[]{object});
                if (list.size() == 0) {
                    nIConfigCreatedResultArray[n3] = (NIConfigCreatedResult)c.failConfig(nIVolumeID, 2L);
                } else {
                    hashMap2.put(object, list.get(0));
                    list = nIOlcDatabaseSchemaHelper.getRanksByExtentPool((NIExtentPoolID)object);
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        nIRankImpl2 = (NIRankImpl)iterator.next();
                        hashMap7.put((NIRankID)nIRankImpl2.getID(), nIRankImpl2);
                    }
                }
            }
            if (hashMap8.containsKey(nILSSID) && ((NILSSVolumeSetImpl)hashMap8.get(nILSSID)).getVolumes().contains(nIVolumeImpl)) {
                hashMap4.put(nIVolumeID, "");
            }
            nILSSVolumeSetImpl.addVolume(nIVolumeImpl, n3, true);
            ++n3;
        }
        list.clear();
        list = null;
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            nILSSID = (NILSSID)object.next();
            nILSSImpl = (NILSSImpl)hashMap.get(nILSSID);
            nILSSImpl2 = (NILSSImpl)nILSSImpl.clone();
            nILSSVolumeSetImpl = (NILSSVolumeSetImpl)hashMap8.get(nILSSID);
            iterator = nILSSVolumeSetImpl.getNewVolumesIterator();
            while (iterator.hasNext()) {
                nIVolumeImpl = (NIVolumeImpl)iterator.next();
                nIVolumeID = (NIVolumeID)nIVolumeImpl.getID();
                int n4 = nILSSVolumeSetImpl.getVolumeIndex(nIVolumeImpl);
                if (nIConfigCreatedResultArray[n4] != null) {
                    nILSSVolumeSetImpl.removeVolume(nIVolumeImpl);
                    continue;
                }
                nIExtentPoolImpl2 = (NIExtentPoolImpl)hashMap2.get(nIVolumeImpl.getExtentPool());
                nIExtentPoolImpl = (NIExtentPoolImpl)nIExtentPoolImpl2.clone();
                n = (Integer)hashMap6.get(nIVolumeID);
                nIVolumeGroupImpl2 = (NIVolumeGroupImpl)hashMap5.get(n);
                nIVolumeGroupImpl = (NIVolumeGroupImpl)nIVolumeGroupImpl2.clone();
                nIAddressGroupImpl2 = (NIAddressGroupImpl)hashMap3.get(nILSSImpl.getAddressGroupID());
                nIAddressGroupImpl = (NIAddressGroupImpl)nIAddressGroupImpl2.clone();
                if (hashMap4.containsKey(nIVolumeID)) {
                    nIConfigCreatedResultArray[n4] = (NIConfigCreatedResult)c.failConfig(nIVolumeID, -1102032636L);
                    nILSSVolumeSetImpl.removeVolume(nIVolumeImpl);
                    continue;
                }
                if (nILSSImpl.getConfiguredDevices() >= 256) {
                    nIConfigCreatedResultArray[n4] = (NIConfigCreatedResult)c.failConfig(nIVolumeID, -1099689967L);
                    nILSSVolumeSetImpl.removeVolume(nIVolumeImpl);
                    continue;
                }
                if (!(nIAddressGroupImpl2.getDeviceType() instanceof NIDeviceTypeFB && (nIDataType instanceof NIDataTypeBlock512 || nIDataType instanceof NIDataTypeBlock520Protected || nIDataType instanceof NIDataTypeBlock520Unprotected) || nIAddressGroupImpl2.getDeviceType() instanceof NIDeviceTypeCKD && (nIDataType instanceof NIDataType3380 || nIDataType instanceof NIDataType3390))) {
                    nIConfigCreatedResultArray[n4] = (NIConfigCreatedResult)c.failConfig(nIVolumeID, -1101835256L);
                    nILSSVolumeSetImpl.removeVolume(nIVolumeImpl);
                    continue;
                }
                if (!(nIExtentPoolImpl2.getExtentType() instanceof NIExtentTypeFB && (nIDataType instanceof NIDataTypeBlock512 || nIDataType instanceof NIDataTypeBlock520Protected || nIDataType instanceof NIDataTypeBlock520Unprotected) || nIExtentPoolImpl2.getExtentType() instanceof NIExtentTypeCKD && (nIDataType instanceof NIDataType3380 || nIDataType instanceof NIDataType3390))) {
                    nIConfigCreatedResultArray[n4] = (NIConfigCreatedResult)c.failConfig(nIVolumeID, -1101835259L);
                    nILSSVolumeSetImpl.removeVolume(nIVolumeImpl);
                    continue;
                }
                if (nIExtentPoolImpl2.getRankGroup() != ((NILSSID)nILSSImpl.getID()).getLSSGroupID()) {
                    nIConfigCreatedResultArray[n4] = (NIConfigCreatedResult)c.failConfig(nIVolumeID, -1101835260L);
                    nILSSVolumeSetImpl.removeVolume(nIVolumeImpl);
                    continue;
                }
                long l = nIVolumeImpl.getCapacity();
                int n5 = this._getAvailableExtents(nIExtentPoolImpl2, hashMap7);
                int n6 = 0;
                if (nIAddressGroupImpl2.getDeviceType() instanceof NIDeviceTypeFB) {
                    n6 = this._blocksToExtents(l);
                } else if (nIAddressGroupImpl2.getDeviceType() instanceof NIDeviceTypeCKD) {
                    n6 = this._cylindersToExtents(l);
                }
                if (n5 < n6) {
                    nIConfigCreatedResultArray[n4] = (NIConfigCreatedResult)c.failConfig(nIVolumeID, -1101839271L);
                    nILSSVolumeSetImpl.removeVolume(nIVolumeImpl);
                    continue;
                }
                nIVolumeImpl.setAddressGroup(nILSSImpl.getAddressGroupID());
                nIVolumeImpl.setCapacity(l);
                nIVolumeImpl.setAccessState(0);
                nIVolumeImpl.setConfigState(0);
                nIVolumeImpl.setDataState(0);
                nIVolumeMap = nIVolumeGroupImpl2.getVolumeMap();
                nIVolumeMap.add(nIVolumeID);
                int n7 = n6;
                List list2 = this._getRanksInExtentPool((NIExtentPoolID)nIExtentPoolImpl2.getID(), hashMap7);
                int n8 = 0;
                while (n7 > 0) {
                    nIRankImpl2 = (NIRankImpl)list2.get(n8);
                    nIRankImpl = (NIRankImpl)nIRankImpl2.clone();
                    long l2 = nIRankImpl2.getNumExtents() - nIRankImpl2.getNumUsedExtents();
                    if (l2 > 0L) {
                        long l3 = l2 > (long)n7 ? (long)n7 : l2;
                        n7 = (int)((long)n7 - l3);
                        nIRankImpl2.setNumUsedExtents(nIRankImpl2.getNumUsedExtents() + l3);
                        nIRankImpl2.getVolumeMap().put(nIVolumeID, new Integer((int)l3));
                    }
                    ++n8;
                    n8 %= list2.size();
                }
                nIExtentPoolImpl2.setNumVolumes(nIExtentPoolImpl2.getNumVolumes() + 1);
                nILSSImpl.setConfiguredDevices(nILSSImpl.getConfiguredDevices() + 1);
                nIAddressGroupImpl2.setNumConfiguredVolumes(nIAddressGroupImpl2.getNumConfiguredVolumes() + 1);
                hashMap4.put(nIVolumeID, "");
                nIConfigCreatedResultArray[n4] = (NIConfigCreatedResult)c.handleConfig(nIVolumeID, true);
            }
            if (!nILSSVolumeSetImpl.isEmpty() || !(nILSSImpl.getDeviceType() instanceof NIDeviceTypeFB) || !nIOlcDatabaseSchemaHelper.deleteLSS(nILSSImpl)) continue;
            this.alEventsHolder.add(new NILSSDeletedEventImpl(nILSSImpl));
            object.remove();
            hashMap8.remove(nILSSID);
        }
        nIOlcDatabaseSchemaHelper.beginXA();
        bl = true;
        iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            nIOlcDatabaseSchemaHelper.modifyLSS((NILSS)iterator.next());
        }
        Iterator iterator2 = hashMap8.keySet().iterator();
        while (iterator2.hasNext()) {
            nILSSID = (NILSSID)iterator2.next();
            nIOlcDatabaseSchemaHelper.modifyLSSVolumeSet(nILSSID, (NILSSVolumeSetImpl)hashMap8.get(nILSSID));
        }
        Iterator iterator3 = hashMap2.values().iterator();
        while (iterator3.hasNext()) {
            nIOlcDatabaseSchemaHelper.modifyExtentPool((NIExtentPool)iterator3.next());
        }
        Iterator iterator4 = hashMap3.values().iterator();
        while (iterator4.hasNext()) {
            nIOlcDatabaseSchemaHelper.modifyAddressGroup((NIAddressGroup)iterator4.next());
        }
        Iterator iterator5 = hashMap5.values().iterator();
        while (iterator5.hasNext()) {
            nIOlcDatabaseSchemaHelper.modifyVolumeGroup((NIVolumeGroup)iterator5.next());
        }
        Iterator iterator6 = hashMap7.values().iterator();
        while (iterator6.hasNext()) {
            nIOlcDatabaseSchemaHelper.modifyRank((NIRank)iterator6.next());
        }
        if (bl &= bl ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        nIOlcDatabaseSchemaHelper.setConstraints("SET CONSTRAINTS ALL ENABLED");
        hashMap.clear();
        hashMap = null;
        hashMap8.clear();
        hashMap8 = null;
        hashMap2.clear();
        hashMap2 = null;
        hashMap3.clear();
        hashMap3 = null;
        hashMap5.clear();
        hashMap5 = null;
        hashMap7.clear();
        hashMap7 = null;
        NIOlcLogger.exit(CLASS_NAME, "createVolumes");
        nIEscrow.close(nIConfigCreatedResultArray);
        nIOlcDatabaseSchemaHelper.release();
        return new NIConfigCreatedResult[]{(NIConfigCreatedResult)((Object)nIEscrow.issueIou())};
    }

    /*
     * Unable to fully structure code
     */
    public NIConfigCreatedResult[] createAliasVolumes(NIVolume[] var1_1) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter("NIOlcLogicalConfigurationService", "createAliasVolumes");
        var2_2 = NIEscrowFactory.getRealIouEscrow(NIOlcLogicalConfigurationService.class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (NIOlcLogicalConfigurationService.class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : NIOlcLogicalConfigurationService.class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        var3_3 = new NIConfigCreatedResult[var1_1.length];
        var4_4 = ((NIVolumeID)var1_1[0].getID()).getLSS().getESS();
        var5_5 = NIOlcCommon.getDatabaseHelper(var4_4);
        if (var5_5 == null) {
            var6_6 = 0;
            while (var6_6 < var3_3.length) {
                var3_3[var6_6] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var1_1[var6_6].getID(), -1099689979L);
                ++var6_6;
            }
            var2_2.close(var3_3);
            return new NIConfigCreatedResult[]{(NIConfigCreatedResult)var2_2.issueIou()};
        }
        var5_5.setConstraints("SET CONSTRAINTS ALL DISABLED");
        var6_7 = new HashMap<Object, NILSSImpl>();
        var7_8 = new HashMap<Object, E>();
        var8_9 = new HashMap<Object, E>();
        var9_10 = new HashMap<NIVolumeID, String>();
        var10_11 = new HashMap<Integer, E>();
        var11_12 = new HashMap<NIVolumeID, Integer>();
        var12_13 = new HashMap<Object, NILSSVolumeSetImpl>();
        var13_14 = new HashMap<NIVolumeID, NIVolumeImpl>();
        var14_15 = new ArrayList<E>();
        var15_16 = new ArrayList<NILSSID>();
        var20_17 = null;
        var21_18 = null;
        var22_19 = null;
        var23_20 = null;
        var24_21 = null;
        var25_22 = null;
        var26_23 = null;
        var27_24 = null;
        var28_25 = null;
        var29_26 = null;
        var30_27 = null;
        var31_28 = null;
        var32_29 = null;
        var33_30 = null;
        var34_31 = null;
        var35_32 = 0;
        while (var35_32 < var1_1.length) {
            block30: {
                block29: {
                    var21_18 = (NIVolumeImpl)var1_1[var35_32];
                    var23_20 = (NIVolumeID)var21_18.getID();
                    var29_26 = var21_18.getDataType();
                    v0 = var16_33 = var29_26 instanceof NIDataTypeBlock512 != false || var29_26 instanceof NIDataTypeBlock520Protected != false || var29_26 instanceof NIDataTypeBlock520Unprotected != false;
                    var18_35 = new Integer(var16_33 ? (var29_26 instanceof NIDataTypeBlock512 ? 20 : 30) : 10);
                    var11_12.put(var23_20, var18_35);
                    if (!var10_11.containsKey(var18_35)) {
                        var14_15 = var5_5.getVolumeGroupsByID(new NIVolumeGroupID[]{new NIVolumeGroupID(var4_4, var18_35)});
                        var10_11.put(var18_35, var14_15.get(0));
                    }
                    var15_16.clear();
                    var26_23 = var23_20.getLSS();
                    var27_24 = var21_18.getOriginalBaseVolumeID().getLSS();
                    var15_16.add(var26_23);
                    if (!var27_24.equals(var26_23)) {
                        var15_16.add(var27_24);
                    }
                    var36_36 = var15_16.iterator();
                    while (var36_36.hasNext()) {
                        var37_37 = (NILSSID)var36_36.next();
                        if (var6_7.containsKey(var37_37)) {
                            var25_22 = (NILSSImpl)var6_7.get(var37_37);
                            var34_31 = (NILSSVolumeSetImpl)var12_13.get(var37_37);
                            continue;
                        }
                        var14_15 = var5_5.getLogicalSubsystemsByID(new NILSSID[]{var37_37});
                        if (var14_15.size() != 0) {
                            var25_22 = (NILSSImpl)var14_15.get(0);
                            var34_31 = var5_5.getLSSVolumeSet((NILSSID)var37_37);
                            var6_7.put(var37_37, var25_22);
                            var12_13.put(var37_37, var34_31);
                            var38_38 = var25_22.getAddressGroupID();
                            if (var8_9.containsKey(var38_38)) continue;
                            var14_15 = var5_5.getAddressGroupsByID(new NIAddressGroupID[]{var38_38});
                            if (var14_15.size() != 0) {
                                var8_9.put(var38_38, var14_15.get(0));
                                continue;
                            }
                            var3_3[var35_32] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var23_20, 2L);
                            continue;
                        }
                        if (var18_35 == 20 || var18_35 == 30) {
                            var25_22 = (NILSSImpl)NIResourceFactory.newLSS(var4_4, var37_37.getLSSNumber(), 0, NIDeviceTypeFB.Option, NICKDBaseCUType3990Model6.Option);
                            var17_34 = this._createLSS(var5_5, var25_22);
                            if (var17_34) {
                                var34_31 = new NILSSVolumeSetImpl();
                                var6_7.put(var37_37, var25_22);
                                var12_13.put(var37_37, var34_31);
                                var38_38 = var25_22.getAddressGroupID();
                                if (var8_9.containsKey(var38_38)) continue;
                                var14_15 = var5_5.getAddressGroupsByID(new NIAddressGroupID[]{var38_38});
                                if (var14_15.size() != 0) {
                                    var8_9.put(var38_38, var14_15.get(0));
                                    continue;
                                }
                                var3_3[var35_32] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var23_20, 2L);
                                continue;
                            }
                            var3_3[var35_32] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var23_20, -1101769448L);
                            continue;
                        }
                        var3_3[var35_32] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var23_20, -1101769471L);
                    }
                    if (var12_13.containsKey(var26_23) && ((NILSSVolumeSetImpl)var12_13.get(var26_23)).containsVolume(var23_20)) {
                        var9_10.put(var23_20, "");
                    }
                    if (var13_14.containsKey(var24_21 = var21_18.getOriginalBaseVolumeID())) ** GOTO lbl126
                    if (var6_7.containsKey(var27_24)) break block29;
                    var3_3[var35_32] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var23_20, 2L);
                    break block30;
                }
                var22_19 = ((NILSSVolumeSetImpl)var12_13.get(var27_24)).getVolume(var24_21);
                var13_14.put(var24_21, var22_19);
                var37_37 = var22_19.getExtentPool();
                if (var7_8.containsKey(var37_37)) ** GOTO lbl126
                var14_15 = var5_5.getExtentPoolsByID(new NIExtentPoolID[]{var37_37});
                if (var14_15.size() == 0) {
                    var3_3[var35_32] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var23_20, 2L);
                } else {
                    var7_8.put(var37_37, var14_15.get(0));
lbl126:
                    // 3 sources

                    var34_31.addVolume(var21_18, var35_32, true);
                }
            }
            ++var35_32;
        }
        var14_15.clear();
        var14_15 = null;
        var36_36 = var6_7.keySet().iterator();
        while (var36_36.hasNext()) {
            var26_23 = (NILSSID)var36_36.next();
            var25_22 = (NILSSImpl)var6_7.get(var26_23);
            var34_31 = (NILSSVolumeSetImpl)var12_13.get(var26_23);
            var37_37 = var34_31.getNewVolumesIterator();
            while (var37_37.hasNext()) {
                var21_18 = (NIVolumeImpl)var37_37.next();
                var23_20 = (NIVolumeID)var21_18.getID();
                var19_39 = var34_31.getVolumeIndex(var21_18);
                var22_19 = ((NILSSVolumeSetImpl)var12_13.get(var21_18.getOriginalBaseVolumeID().getLSS())).getVolume(var21_18.getOriginalBaseVolumeID());
                if (var3_3[var19_39] != null) {
                    var34_31.removeVolume(var21_18);
                    continue;
                }
                if (var22_19 == null) {
                    var34_31.removeVolume(var21_18);
                    var3_3[var19_39] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var23_20, 2L);
                    continue;
                }
                if (var9_10.containsKey(var23_20)) {
                    var3_3[var19_39] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var23_20, -1102032636L);
                    var34_31.removeVolume(var21_18);
                    continue;
                }
                if (var23_20.getLSS().getLSSGroupID() != ((NIVolumeID)var22_19.getID()).getLSS().getLSSGroupID()) {
                    var3_3[var19_39] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var23_20, -1099689967L);
                    var34_31.removeVolume(var21_18);
                    continue;
                }
                if (var25_22.getConfiguredDevices() >= 256) {
                    var3_3[var19_39] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var23_20, -1099689967L);
                    var34_31.removeVolume(var21_18);
                    continue;
                }
                if (var21_18.getVolumeType() instanceof NIVolumeTypeCKDCrossCUAlias && var23_20.getLSS().getLSSNumber() != ((NIVolumeID)var22_19.getID()).getLSS().getLSSNumber()) {
                    var3_3[var19_39] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var23_20, 2L);
                    var34_31.removeVolume(var21_18);
                    continue;
                }
                var21_18.setAccessState(0);
                var21_18.setConfigState(0);
                var21_18.setDataState(0);
                var21_18.setCapacity(var22_19.getCapacity());
                var21_18.setDataType(null);
                var21_18.setExtentPool(null);
                var18_35 = (Integer)var11_12.get(var23_20);
                var30_27 = (NIVolumeGroupImpl)var10_11.get(var18_35);
                var32_29 = var30_27.getVolumeMap();
                var32_29.add(var23_20);
                var28_25 = (NIExtentPoolImpl)var7_8.get(var22_19.getExtentPool());
                var28_25.setNumVolumes(var28_25.getNumVolumes() + 1);
                var31_28 = (NIAddressGroupImpl)var8_9.get(var25_22.getAddressGroupID());
                var31_28.setNumConfiguredVolumes(var31_28.getNumConfiguredVolumes() + 1);
                var25_22.setConfiguredDevices(var25_22.getConfiguredDevices() + 1);
                var9_10.put(var23_20, "");
                var3_3[var19_39] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.handleConfig(var23_20, true);
            }
            if (!var34_31.isEmpty() || !(var25_22.getDeviceType() instanceof NIDeviceTypeFB) || !var5_5.deleteLSS(var25_22)) continue;
            this.alEventsHolder.add(new NILSSDeletedEventImpl(var25_22));
            var36_36.remove();
            var12_13.remove(var26_23);
        }
        var5_5.beginXA();
        var17_34 = true;
        var37_37 = var6_7.values().iterator();
        while (var37_37.hasNext()) {
            var5_5.modifyLSS((NILSS)var37_37.next());
        }
        var38_38 = var12_13.keySet().iterator();
        while (var38_38.hasNext()) {
            var26_23 = (NILSSID)var38_38.next();
            var5_5.modifyLSSVolumeSet(var26_23, (NILSSVolumeSetImpl)var12_13.get(var26_23));
        }
        var39_40 = var7_8.values().iterator();
        while (var39_40.hasNext()) {
            var5_5.modifyExtentPool((NIExtentPool)var39_40.next());
        }
        var40_41 = var8_9.values().iterator();
        while (var40_41.hasNext()) {
            var5_5.modifyAddressGroup((NIAddressGroup)var40_41.next());
        }
        var41_42 = var10_11.values().iterator();
        while (var41_42.hasNext()) {
            var5_5.modifyVolumeGroup((NIVolumeGroup)var41_42.next());
        }
        if (var17_34 &= var17_34 != false ? var5_5.commitXA() : var5_5.cancelXA()) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        var5_5.setConstraints("SET CONSTRAINTS ALL ENABLED");
        var6_7.clear();
        var6_7 = null;
        var12_13.clear();
        var12_13 = null;
        var7_8.clear();
        var7_8 = null;
        var8_9.clear();
        var8_9 = null;
        var10_11.clear();
        var10_11 = null;
        var2_2.close(var3_3);
        NIOlcLogger.exit("NIOlcLogicalConfigurationService", "createAliasVolumes");
        var5_5.release();
        return new NIConfigCreatedResult[]{(NIConfigCreatedResult)var2_2.issueIou()};
    }

    /*
     * Unable to fully structure code
     */
    public NIConfigResult[] deleteVolumes(NIVolumeID[] var1_1) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter("NIOlcLogicalConfigurationService", "deleteVolumes");
        var2_2 = NIEscrowFactory.getRealIouEscrow(NIOlcLogicalConfigurationService.class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (NIOlcLogicalConfigurationService.class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : NIOlcLogicalConfigurationService.class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        var3_3 = new NIConfigResult[var1_1.length];
        var4_4 = var1_1[0].getLSS().getESS();
        var5_5 = NIOlcCommon.getDatabaseHelper(var4_4);
        if (var5_5 == null) {
            var6_6 = 0;
            while (var6_6 < var3_3.length) {
                var3_3[var6_6] = NIOlcLogicalConfigurationService.c.failConfig(var1_1[var6_6], -1099689979L);
                ++var6_6;
            }
            var2_2.close(var3_3);
            return new NIConfigResult[]{(NIConfigResult)var2_2.issueIou()};
        }
        var6_7 = new HashMap<NILSSID, NILSSImpl>();
        var7_8 = new HashMap<Object, E>();
        var8_9 = new HashMap<Object, E>();
        var9_10 = new HashMap<NIVolumeID, NIVolumeImpl>();
        var10_11 = new HashMap<NIRankID, NIRankImpl>();
        var11_12 = new HashMap<NILSSID, NILSSVolumeSetImpl>();
        var12_13 = new HashMap<NIVolumeID, NIVolumeImpl>();
        var13_14 = new ArrayList<E>();
        var14_15 = new ArrayList<E>();
        var19_16 = null;
        var20_17 = null;
        var21_18 = null;
        var22_19 = null;
        var23_20 = null;
        var24_21 = null;
        var25_22 = null;
        var26_23 = null;
        var27_24 = null;
        var28_25 = null;
        var29_26 = null;
        var30_27 = null;
        var31_28 = null;
        var32_29 = null;
        var33_30 = null;
        var34_31 = null;
        var35_32 = null;
        var36_33 = null;
        var37_34 = null;
        var38_35 = null;
        var14_15 = var5_5.getVolumeGroupsByESS(var4_4);
        var39_36 = 0;
        while (var39_36 < var1_1.length) {
            block31: {
                block32: {
                    block33: {
                        block29: {
                            block30: {
                                block28: {
                                    var22_19 = var1_1[var39_36];
                                    var25_22 = var22_19.getLSS();
                                    if (!var6_7.containsKey(var25_22)) break block28;
                                    var24_21 = (NILSSImpl)var6_7.get(var25_22);
                                    var38_35 = (NILSSVolumeSetImpl)var11_12.get(var25_22);
                                    break block29;
                                }
                                var13_14 = var5_5.getLogicalSubsystemsByID(new NILSSID[]{var25_22});
                                if (var13_14.size() != 0) break block30;
                                var3_3[var39_36] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var22_19, -1101769471L);
                                break block31;
                            }
                            var24_21 = (NILSSImpl)var13_14.get(0);
                            var38_35 = var5_5.getLSSVolumeSet(var25_22);
                            var6_7.put(var25_22, var24_21);
                            var11_12.put(var25_22, var38_35);
                            var40_37 = var24_21.getAddressGroupID();
                            if (!var8_9.containsKey(var40_37)) {
                                var13_14 = var5_5.getAddressGroupsByID(new NIAddressGroupID[]{var40_37});
                                if (var13_14.size() != 0) {
                                    var8_9.put(var40_37, var13_14.get(0));
                                } else {
                                    NIOlcLogger.info("Warning: No Address Group found for volume" + var22_19 + " AddrGroup:" + var40_37);
                                }
                            }
                        }
                        if (!var11_12.containsKey(var25_22)) break block32;
                        var38_35 = (NILSSVolumeSetImpl)var11_12.get(var25_22);
                        if (var38_35.containsVolume(var22_19)) break block33;
                        var3_3[var39_36] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var22_19, 2L);
                        break block31;
                    }
                    var20_17 = var38_35.getVolume(var22_19);
                    var9_10.put(var22_19, var20_17);
                }
                if (!var20_17.isAlias()) ** GOTO lbl93
                var23_20 = var20_17.getOriginalBaseVolumeID();
                var26_23 = var23_20.getLSS();
                if (var12_13.containsKey(var23_20)) ** GOTO lbl93
                if (!var6_7.containsKey(var26_23)) {
                    var3_3[var39_36] = NIOlcLogicalConfigurationService.c.failConfig(var22_19, -1101769471L);
                } else {
                    var21_18 = ((NILSSVolumeSetImpl)var11_12.get(var26_23)).getVolume(var23_20);
                    var12_13.put(var23_20, var21_18);
lbl93:
                    // 3 sources

                    v0 = var40_37 = var20_17.isAlias() != false ? var21_18.getExtentPool() : var20_17.getExtentPool();
                    if (!var7_8.containsKey(var40_37)) {
                        var13_14 = var5_5.getExtentPoolsByID(new NIExtentPoolID[]{var40_37});
                        if (var13_14.size() == 0) {
                            var3_3[var39_36] = NIOlcLogicalConfigurationService.c.failConfig(var22_19, -1101835261L);
                        } else {
                            var7_8.put(var40_37, var13_14.get(0));
                            var13_14 = var5_5.getRanksByExtentPool((NIExtentPoolID)var40_37);
                            var41_38 = var13_14.iterator();
                            while (var41_38.hasNext()) {
                                var29_26 = (NIRankImpl)var41_38.next();
                                var10_11.put((NIRankID)var29_26.getID(), var29_26);
                            }
                        }
                    }
                    var38_35.addVolume(var20_17, var39_36, false);
                }
            }
            ++var39_36;
        }
        var13_14.clear();
        var13_14 = null;
        var40_37 = var6_7.keySet().iterator();
        while (var40_37.hasNext()) {
            var25_22 = (NILSSID)var40_37.next();
            var24_21 = (NILSSImpl)var6_7.get(var25_22);
            var38_35 = (NILSSVolumeSetImpl)var11_12.get(var25_22);
            var41_38 = var38_35.getNewVolumesIterator();
            while (var41_38.hasNext()) {
                var20_17 = (NIVolumeImpl)var41_38.next();
                var22_19 = (NIVolumeID)var20_17.getID();
                var18_39 = var38_35.getVolumeIndex(var20_17);
                if (var3_3[var18_39] != null) {
                    var38_35.removeVolume(var20_17);
                    continue;
                }
                if (var20_17.isAlias()) {
                    var21_18 = (NIVolumeImpl)var12_13.get(var20_17.getOriginalBaseVolumeID());
                    var31_28 = (NIExtentPoolImpl)var7_8.get(var21_18.getExtentPool());
                } else {
                    var31_28 = (NIExtentPoolImpl)var7_8.get(var20_17.getExtentPool());
                }
                var36_33 = (NIAddressGroupImpl)var8_9.get(var24_21.getAddressGroupID());
                this._deleteVolumeFromVolumeGroups(var22_19, var14_15);
                var24_21.setConfiguredDevices(var24_21.getConfiguredDevices() - 1);
                if (var20_17.getVolumeType() instanceof NIVolumeTypeFixedBlockBase && var24_21.getConfiguredDevices() == 0 && this._deleteLSS(var5_5, var24_21) && var36_33 != null) {
                    var36_33.setNumLogicalSubsystem(var36_33.getNumLogicalSubsystem() - 1);
                }
                if (!var20_17.isAlias()) {
                    var42_40 = this._getRanksInExtentPool((NIExtentPoolID)var31_28.getID(), var10_11);
                    var43_41 = var42_40.iterator();
                    while (var43_41.hasNext()) {
                        var29_26 = (NIRankImpl)var43_41.next();
                        if (!var29_26.getVolumeMap().containsKey(var22_19)) continue;
                        var44_42 = (Integer)var29_26.getVolumeMap().get(var22_19);
                        var29_26.setNumUsedExtents(var29_26.getNumUsedExtents() - (long)var44_42);
                        var29_26.getVolumeMap().remove(var22_19);
                    }
                }
                var31_28.setNumVolumes(var31_28.getNumVolumes() - 1);
                if (var36_33 != null) {
                    var36_33.setNumConfiguredVolumes(var36_33.getNumConfiguredVolumes() - 1);
                }
                var38_35.removeVolume(var20_17);
                var3_3[var18_39] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.handleConfig(var22_19, true);
            }
            if (!var38_35.isEmpty() || !(var24_21.getDeviceType() instanceof NIDeviceTypeFB) || !var5_5.deleteLSS(var24_21)) continue;
            this.alEventsHolder.add(new NILSSDeletedEventImpl(var24_21));
            var40_37.remove();
            var11_12.remove(var25_22);
        }
        var5_5.beginXA();
        var16_44 = true;
        var41_38 = var6_7.values().iterator();
        while (var41_38.hasNext()) {
            var5_5.modifyLSS((NILSS)var41_38.next());
        }
        var42_40 = var11_12.keySet().iterator();
        while (var42_40.hasNext()) {
            var25_22 = (NILSSID)var42_40.next();
            var5_5.modifyLSSVolumeSet(var25_22, (NILSSVolumeSetImpl)var11_12.get(var25_22));
        }
        var43_41 = var7_8.values().iterator();
        while (var43_41.hasNext()) {
            var5_5.modifyExtentPool((NIExtentPool)var43_41.next());
        }
        var44_43 = var8_9.values().iterator();
        while (var44_43.hasNext()) {
            var5_5.modifyAddressGroup((NIAddressGroup)var44_43.next());
        }
        var45_45 = var14_15.iterator();
        while (var45_45.hasNext()) {
            var5_5.modifyVolumeGroup((NIVolumeGroup)var45_45.next());
        }
        var46_46 = var10_11.values().iterator();
        while (var46_46.hasNext()) {
            var5_5.modifyRank((NIRank)var46_46.next());
        }
        if (var16_44 &= var16_44 != false ? var5_5.commitXA() : var5_5.cancelXA()) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        var5_5.setConstraints("SET CONSTRAINTS ALL ENABLED");
        var6_7.clear();
        var6_7 = null;
        var11_12.clear();
        var11_12 = null;
        var7_8.clear();
        var7_8 = null;
        var8_9.clear();
        var8_9 = null;
        var10_11.clear();
        var10_11 = null;
        NIOlcLogger.exit("NIOlcLogicalConfigurationService", "deleteVolumes");
        var2_2.close(var3_3);
        var5_5.release();
        return new NIConfigResult[]{(NIConfigResult)var2_2.issueIou()};
    }

    /*
     * Unable to fully structure code
     */
    public NIConfigResult[] modifyVolumes(NIVolume[] var1_1) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter("NIOlcLogicalConfigurationService", "modifyVolumes");
        var2_2 = NIEscrowFactory.getRealIouEscrow(NIOlcLogicalConfigurationService.class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (NIOlcLogicalConfigurationService.class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : NIOlcLogicalConfigurationService.class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        var3_3 = new NIConfigResult[var1_1.length];
        var4_4 = ((NIVolumeID)var1_1[0].getID()).getESS();
        var5_5 = NIOlcCommon.getDatabaseHelper(var4_4);
        if (var5_5 == null) {
            var6_6 = 0;
            while (var6_6 < var3_3.length) {
                var3_3[var6_6] = NIOlcLogicalConfigurationService.c.failConfig(var1_1[var6_6].getID(), -1099689979L);
                ++var6_6;
            }
            var2_2.close(var3_3);
            return new NIConfigResult[]{(NIConfigResult)var2_2.issueIou()};
        }
        var5_5.setConstraints("SET CONSTRAINTS ALL DISABLED");
        var6_7 = new HashMap<NILSSID, NILSSImpl>();
        var7_8 = new HashMap<NIVolumeID, NIVolumeImpl>();
        var8_9 = new HashMap<NILSSID, NILSSVolumeSetImpl>();
        var9_10 = new ArrayList<E>();
        var14_11 = null;
        var15_12 = null;
        var16_13 = null;
        var17_14 = null;
        var18_15 = null;
        var19_16 = null;
        var20_17 = null;
        var21_18 = null;
        var22_19 = null;
        var23_20 = 0;
        while (var23_20 < var1_1.length) {
            block16: {
                block14: {
                    block15: {
                        block13: {
                            var15_12 = (NIVolumeImpl)var1_1[var23_20];
                            var17_14 = (NIVolumeID)var15_12.getID();
                            var20_17 = var17_14.getLSS();
                            if (!var6_7.containsKey(var20_17)) break block13;
                            var19_16 = (NILSSImpl)var6_7.get(var20_17);
                            var22_19 = (NILSSVolumeSetImpl)var8_9.get(var20_17);
                            break block14;
                        }
                        var9_10 = var5_5.getLogicalSubsystemsByID(new NILSSID[]{var20_17});
                        if (var9_10.size() != 0) break block15;
                        var3_3[var23_20] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var17_14, 2L);
                        break block16;
                    }
                    var19_16 = (NILSSImpl)var9_10.get(0);
                    var22_19 = var5_5.getLSSVolumeSet(var20_17);
                    var6_7.put(var20_17, var19_16);
                    var8_9.put(var20_17, var22_19);
                }
                if (!var8_9.containsKey(var20_17)) ** GOTO lbl58
                var22_19 = (NILSSVolumeSetImpl)var8_9.get(var20_17);
                if (!var22_19.containsVolume(var17_14)) {
                    var3_3[var23_20] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.failConfig(var17_14, 2L);
                } else {
                    var15_12 = var22_19.getVolume(var17_14);
                    var7_8.put(var17_14, var15_12);
lbl58:
                    // 2 sources

                    var22_19.addVolume(var15_12, var23_20, false);
                }
            }
            ++var23_20;
        }
        var9_10.clear();
        var9_10 = null;
        var24_21 = var6_7.keySet().iterator();
        while (var24_21.hasNext()) {
            var20_17 = (NILSSID)var24_21.next();
            var19_16 = (NILSSImpl)var6_7.get(var20_17);
            var22_19 = (NILSSVolumeSetImpl)var8_9.get(var20_17);
            var25_23 = var22_19.getNewVolumesIterator();
            while (var25_23.hasNext()) {
                var16_13 = (NIVolumeImpl)var25_23.next();
                var18_15 = (NIVolumeID)var16_13.getID();
                var13_22 = var22_19.getVolumeIndex(var16_13);
                var15_12 = (NIVolumeImpl)var1_1[var13_22];
                var17_14 = (NIVolumeID)var15_12.getID();
                if (var3_3[var13_22] != null) continue;
                if (var17_14.getBaseVolumeNum() != var18_15.getBaseVolumeNum()) {
                    if (var15_12.getOriginalBaseVolumeID().getLSS().getLSSGroupID() != var17_14.getLSS().getLSSGroupID()) {
                        var3_3[var13_22] = NIOlcLogicalConfigurationService.c.failConfig(var17_14, 2L);
                        continue;
                    }
                    if (var15_12.getVolumeType() instanceof NIVolumeTypeCKDSingleCuAlias && var15_12.getOriginalBaseVolumeID().getLSS() != var17_14.getLSS()) {
                        var3_3[var13_22] = NIOlcLogicalConfigurationService.c.failConfig(var17_14, 2L);
                        continue;
                    }
                    var26_24 = (ArrayList)var5_5.getVolumesByID(new NIVolumeID[]{var15_12.getOriginalBaseVolumeID()});
                    if (var26_24.isEmpty()) {
                        var3_3[var13_22] = NIOlcLogicalConfigurationService.c.failConfig(var17_14, -1101835245L);
                        continue;
                    }
                }
                var3_3[var13_22] = (NIConfigCreatedResult)NIOlcLogicalConfigurationService.c.handleConfig(var17_14, true);
                var22_19.replaceVolume(var15_12);
            }
        }
        var5_5.beginXA();
        var11_25 = true;
        var25_23 = var8_9.keySet().iterator();
        while (var25_23.hasNext()) {
            var20_17 = (NILSSID)var25_23.next();
            var5_5.modifyLSSVolumeSet(var20_17, (NILSSVolumeSetImpl)var8_9.get(var20_17));
        }
        if (var11_25 &= var11_25 != false ? var5_5.commitXA() : var5_5.cancelXA()) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        var5_5.setConstraints("SET CONSTRAINTS ALL ENABLED");
        var6_7.clear();
        var6_7 = null;
        var8_9.clear();
        var8_9 = null;
        NIOlcLogger.exit("NIOlcLogicalConfigurationService", "modifyVolumes");
        var2_2.close(var3_3);
        var5_5.release();
        return new NIConfigResult[]{(NIConfigResult)var2_2.issueIou()};
    }

    public NIConfigCreatedResult createLogicalSubsystem(NILSS nILSS) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "createLogicalSubsystem");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        NILSSImpl nILSSImpl = (NILSSImpl)nILSS;
        NILSSID nILSSID = (NILSSID)nILSSImpl.getID();
        NIESSID nIESSID = nILSSID.getESS();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return (NIConfigCreatedResult)c.failConfig(nILSSID, nIEscrow, -1099689979L);
        }
        boolean bl = true;
        nIOlcDatabaseSchemaHelper.beginXA();
        if (bl &= (bl &= this._createLSS(nIOlcDatabaseSchemaHelper, nILSSImpl)) ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIOlcLogger.exit(CLASS_NAME, "createLogicalSubsystem");
        nIOlcDatabaseSchemaHelper.release();
        return (NIConfigCreatedResult)c.handleConfig(nILSSID, nIEscrow, bl);
    }

    public NIConfigResult[] deleteLogicalSubsystems(NILSSID[] nILSSIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "deleteLogicalSubsystems");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIConfigResult[] nIConfigResultArray = new NIConfigResult[nILSSIDArray.length];
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nILSSIDArray[0].getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            int n = 0;
            while (n < nIConfigResultArray.length) {
                nIConfigResultArray[n] = c.failConfig(nILSSIDArray[n], -1099689979L);
                ++n;
            }
            nIEscrow.close(nIConfigResultArray);
            return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
        }
        int n = 0;
        while (n < nILSSIDArray.length) {
            boolean bl = true;
            List list = nIOlcDatabaseSchemaHelper.getLogicalSubsystemsByID(new NILSSID[]{nILSSIDArray[n]});
            if (list.size() == 0) {
                nIConfigResultArray[n] = c.failConfig(nILSSIDArray[n], -1101769471L);
            } else {
                NILSS nILSS = (NILSS)list.get(0);
                nIOlcDatabaseSchemaHelper.beginXA();
                if (bl &= (bl &= this._deleteLSS(nIOlcDatabaseSchemaHelper, nILSS)) ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
                    NIOlcEventProcessor.processEvents(this.alEventsHolder);
                }
                this.alEventsHolder.clear();
                nIConfigResultArray[n] = c.handleConfig(nILSS.getID(), bl);
            }
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, "deleteLogicalSubsystems");
        nIEscrow.close(nIConfigResultArray);
        nIOlcDatabaseSchemaHelper.release();
        return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
    }

    public NIConfigResult[] modifyLogicalSubsystems(NILSS[] nILSSArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "modifyLogicalSubsystems");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIConfigResult[] nIConfigResultArray = new NIConfigResult[nILSSArray.length];
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nILSSArray[0].getID().getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            int n = 0;
            while (n < nIConfigResultArray.length) {
                nIConfigResultArray[n] = c.failConfig(nILSSArray[n].getID(), -1099689979L);
                ++n;
            }
            nIEscrow.close(nIConfigResultArray);
            return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
        }
        int n = 0;
        while (n < nILSSArray.length) {
            boolean bl;
            nIOlcDatabaseSchemaHelper.beginXA();
            List list = nIOlcDatabaseSchemaHelper.getLogicalSubsystemsByID(new NILSSID[]{(NILSSID)nILSSArray[n].getID()});
            if (list.size() > 0) {
                NILSS nILSS = (NILSS)list.get(0);
                bl = nIOlcDatabaseSchemaHelper.modifyLSS(nILSSArray[n]);
                this.alEventsHolder.add(new NILSSChangedEventImpl(nILSS, nILSSArray[n]));
                bl &= bl ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA();
            } else {
                bl = false;
            }
            if (bl) {
                NIOlcEventProcessor.processEvents(this.alEventsHolder);
            }
            this.alEventsHolder.clear();
            nIConfigResultArray[n] = c.handleConfig(nILSSArray[n].getID(), bl);
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, "modifyLogicalSubsystems");
        nIEscrow.close(nIConfigResultArray);
        nIOlcDatabaseSchemaHelper.release();
        return new NIConfigResult[]{(NIConfigResult)((Object)nIEscrow.issueIou())};
    }

    public NIConfigCreatedResult createVolumeGroup(NIVolumeGroup nIVolumeGroup) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "createVolumeGroup");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        NIVolumeGroupImpl nIVolumeGroupImpl = (NIVolumeGroupImpl)nIVolumeGroup;
        NIESSID nIESSID = ((NIVolumeGroupID)nIVolumeGroupImpl.getID()).getESS();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return (NIConfigCreatedResult)c.failConfig(nIVolumeGroupImpl.getID(), nIEscrow, -1099689979L);
        }
        int n = this._generateVolumeGroupNumber(nIOlcDatabaseSchemaHelper, nIESSID);
        if (n == -1) {
            nIOlcDatabaseSchemaHelper.release();
            return (NIConfigCreatedResult)c.failConfig(nIVolumeGroupImpl.getID(), nIEscrow, 1L);
        }
        NIVolumeGroupID nIVolumeGroupID = new NIVolumeGroupID(nIESSID, n);
        nIVolumeGroupImpl.setID(nIVolumeGroupID);
        boolean bl = this._checkVolumeGroup(nIOlcDatabaseSchemaHelper, nIVolumeGroupImpl) ? nIOlcDatabaseSchemaHelper.insertVolumeGroup(nIVolumeGroupImpl) : false;
        this.alEventsHolder.add(new NIVolumeGroupCreatedEventImpl(nIVolumeGroupImpl));
        if (bl) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIOlcLogger.exit(CLASS_NAME, "createVolumeGroup");
        nIOlcDatabaseSchemaHelper.release();
        return (NIConfigCreatedResult)c.handleConfig(nIVolumeGroupID, nIEscrow, bl);
    }

    public NIConfigResult deleteVolumeGroup(NIVolumeGroupID nIVolumeGroupID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        boolean bl;
        NIOlcLogger.enter(CLASS_NAME, "deleteVolumeGroup");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        if (nIVolumeGroupID.getVolumeGroupNumber() == 10 || nIVolumeGroupID.getVolumeGroupNumber() == 20 || nIVolumeGroupID.getVolumeGroupNumber() == 30) {
            bl = false;
        } else {
            NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIVolumeGroupID.getESS());
            if (nIOlcDatabaseSchemaHelper == null) {
                return c.failConfig(nIVolumeGroupID, nIEscrow, -1099689979L);
            }
            ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getVolumeGroupsByID(new NIVolumeGroupID[]{nIVolumeGroupID});
            if (arrayList.size() == 0) {
                bl = false;
            } else {
                NIVolumeGroup nIVolumeGroup = (NIVolumeGroup)arrayList.get(0);
                bl = this._checkVolumeGroup(nIOlcDatabaseSchemaHelper, nIVolumeGroup) ? nIOlcDatabaseSchemaHelper.deleteVolumeGroup(nIVolumeGroupID) : false;
                List list = nIOlcDatabaseSchemaHelper.getScsiHostPortsByESS(nIVolumeGroup.getID().getESS());
                int n = 0;
                while (n < list.size()) {
                    NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)list.get(n);
                    if (nISCSIHostPort.getVolumeGroup() != null && nISCSIHostPort.getVolumeGroup().equals(nIVolumeGroupID)) {
                        nISCSIHostPort.setVolumeGroup(null);
                    }
                    ++n;
                }
                this.alEventsHolder.add(new NIVolumeGroupDeletedEventImpl(nIVolumeGroup));
                if (bl) {
                    NIOlcEventProcessor.processEvents(this.alEventsHolder);
                }
                this.alEventsHolder.clear();
            }
            nIOlcDatabaseSchemaHelper.release();
        }
        NIOlcLogger.exit(CLASS_NAME, "deleteVolumeGroup");
        return c.handleConfig(nIVolumeGroupID, nIEscrow, bl);
    }

    public NIConfigResult modifyVolumeGroup(NIVolumeGroup nIVolumeGroup) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "modifyVolumeGroup");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        Object var4_3 = null;
        NIVolumeGroupID nIVolumeGroupID = (NIVolumeGroupID)nIVolumeGroup.getID();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIVolumeGroupID.getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.failConfig(nIVolumeGroupID, nIEscrow, -1099689979L);
        }
        NIVolumeGroupImpl nIVolumeGroupImpl = (NIVolumeGroupImpl)nIOlcDatabaseSchemaHelper.getVolumeGroupsByID(new NIVolumeGroupID[]{(NIVolumeGroupID)nIVolumeGroup.getID()}).get(0);
        boolean bl = this._checkVolumeGroup(nIOlcDatabaseSchemaHelper, nIVolumeGroup) ? nIOlcDatabaseSchemaHelper.modifyVolumeGroup(nIVolumeGroup) : false;
        this.alEventsHolder.add(new NIVolumeGroupChangedEventImpl(nIVolumeGroupImpl, nIVolumeGroup));
        if (bl) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIOlcLogger.exit(CLASS_NAME, "modifyVolumeGroup");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleConfig(nIVolumeGroupID, nIEscrow, bl);
    }

    public NIExtentUsageResult queryExtentUsage(NIRankID nIRankID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "queryExtentUsage");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIExtentUsageResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIExtentUsageResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIExtentUsageResult")) : class$com$ibm$storage$ess$ni$application$results$NIExtentUsageResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIRankID.getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            NIExtentUsageResultImpl nIExtentUsageResultImpl = new NIExtentUsageResultImpl(false, -1099689979L, 0, 0, 0, 0, null, null, null, 0);
            nIEscrow.close(nIExtentUsageResultImpl);
            return (NIExtentUsageResult)((Object)nIEscrow.issueIou());
        }
        NIRankImpl nIRankImpl = (NIRankImpl)nIOlcDatabaseSchemaHelper.getRanksByID(new NIRankID[]{nIRankID}).get(0);
        NIExtentUsageResultImpl nIExtentUsageResultImpl = new NIExtentUsageResultImpl(true, 0L, nIRankImpl.getConfigurationState(), nIRankImpl.getDataState(), (int)nIRankImpl.getNumExtents(), (int)nIRankImpl.getNumUsedExtents(), nIRankImpl.getExtentPoolID(), nIRankID, nIRankImpl.getExtentType(), 0);
        nIEscrow.close(nIExtentUsageResultImpl);
        NIOlcLogger.exit(CLASS_NAME, "queryExtentUsage");
        nIOlcDatabaseSchemaHelper.release();
        return (NIExtentUsageResult)((Object)nIEscrow.issueIou());
    }

    public NIExtentUsageResult[] queryExtentUsage(NIRankID[] nIRankIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "queryExtentUsage(rankID[])");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIExtentUsageResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIExtentUsageResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIExtentUsageResult")) : class$com$ibm$storage$ess$ni$application$results$NIExtentUsageResult);
        NIExtentUsageResultImpl[] nIExtentUsageResultImplArray = new NIExtentUsageResultImpl[nIRankIDArray.length];
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIRankIDArray[0].getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            int n = 0;
            while (n < nIRankIDArray.length) {
                nIExtentUsageResultImplArray[n] = new NIExtentUsageResultImpl(false, -1099689979L, 0, 0, 0, 0, null, null, null, 0);
                ++n;
            }
            nIEscrow.close(nIExtentUsageResultImplArray);
            return new NIExtentUsageResult[]{(NIExtentUsageResult)((Object)nIEscrow.issueIou())};
        }
        int n = 0;
        while (n < nIRankIDArray.length) {
            NIExtentUsageResultImpl nIExtentUsageResultImpl;
            NIRankImpl nIRankImpl = (NIRankImpl)nIOlcDatabaseSchemaHelper.getRanksByID(new NIRankID[]{nIRankIDArray[n]}).get(0);
            nIExtentUsageResultImplArray[n] = nIExtentUsageResultImpl = new NIExtentUsageResultImpl(true, 0L, nIRankImpl.getConfigurationState(), nIRankImpl.getDataState(), (int)nIRankImpl.getNumExtents(), (int)nIRankImpl.getNumUsedExtents(), nIRankImpl.getExtentPoolID(), nIRankIDArray[n], nIRankImpl.getExtentType(), 0);
            ++n;
        }
        nIEscrow.close(nIExtentUsageResultImplArray);
        NIOlcLogger.exit(CLASS_NAME, "queryExtentUsage(rankID[])");
        nIOlcDatabaseSchemaHelper.release();
        return new NIExtentUsageResult[]{(NIExtentUsageResult)((Object)nIEscrow.issueIou())};
    }

    public NIExtentAvailabilityResult queryExtentAvailability(NIExtentPoolID nIExtentPoolID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "queryExtentAvailability");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIExtentAvailabilityResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIExtentAvailabilityResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIExtentAvailabilityResult")) : class$com$ibm$storage$ess$ni$application$results$NIExtentAvailabilityResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIExtentPoolID.getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            NIExtentAvailabilityResultImpl nIExtentAvailabilityResultImpl = new NIExtentAvailabilityResultImpl(false, -1099689979L, null, false, 0.0f, 0.0f, 0, 0.0f, 100.0f, 0, 0, 0, 0, 0);
            nIEscrow.close(nIExtentAvailabilityResultImpl);
            return (NIExtentAvailabilityResult)((Object)nIEscrow.issueIou());
        }
        List list = nIOlcDatabaseSchemaHelper.getExtentPoolsByID(new NIExtentPoolID[]{nIExtentPoolID});
        if (list.size() <= 0) {
            NIExtentAvailabilityResultImpl nIExtentAvailabilityResultImpl = new NIExtentAvailabilityResultImpl(false, -1101901038L, null, false, 0.0f, 0.0f, 0, 0.0f, 100.0f, 0, 0, 0, 0, 0);
            nIEscrow.close(nIExtentAvailabilityResultImpl);
            nIOlcDatabaseSchemaHelper.release();
            return (NIExtentAvailabilityResult)((Object)nIEscrow.issueIou());
        }
        NIExtentPoolImpl nIExtentPoolImpl = (NIExtentPoolImpl)list.get(0);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        List list2 = nIOlcDatabaseSchemaHelper.getRanksByExtentPool(nIExtentPoolID);
        int n4 = list2.size();
        int n5 = 0;
        while (n5 < n4) {
            NIRankImpl nIRankImpl = (NIRankImpl)list2.get(n5);
            if (nIRankImpl.getConfigurationState() == 3) {
                n2 = (int)((long)n2 + (nIRankImpl.getNumExtents() - nIRankImpl.getNumUsedExtents()));
            }
            n3 = (int)((long)n3 + nIRankImpl.getNumUsedExtents());
            ++n5;
        }
        int n6 = (int)((float)nIExtentPoolImpl.getNumExtents() * (nIExtentPoolImpl.isExtentLimitEnabled() ? nIExtentPoolImpl.getExtentLimit() : 1.0f));
        if ((long)n6 > nIExtentPoolImpl.getNumExtents() - (long)n2) {
            n6 = (int)nIExtentPoolImpl.getNumExtents() - n2;
        }
        n = n6 - n3 > 0 ? n6 - n3 : 0;
        float f = 0.0f;
        float f2 = 0.0f;
        if (nIExtentPoolImpl.getNumExtents() > 0L) {
            if (n3 > 0) {
                f2 = (float)n3 / (float)nIExtentPoolImpl.getNumExtents() * 100.0f;
            }
            if (n > 0) {
                f = (float)n / (float)nIExtentPoolImpl.getNumExtents() * 100.0f;
            }
        }
        NIExtentAvailabilityResultImpl nIExtentAvailabilityResultImpl = new NIExtentAvailabilityResultImpl(true, 0L, (NIExtentPoolID)nIExtentPoolImpl.getID(), nIExtentPoolImpl.isExtentLimitEnabled(), nIExtentPoolImpl.getExtentLimit(), nIExtentPoolImpl.getExtentThreshold(), 2, f2, f, (int)nIExtentPoolImpl.getNumExtents(), n6, n3, n2, n);
        nIEscrow.close(nIExtentAvailabilityResultImpl);
        NIOlcLogger.exit(CLASS_NAME, "queryExtentAvailability");
        nIOlcDatabaseSchemaHelper.release();
        return (NIExtentAvailabilityResult)((Object)nIEscrow.issueIou());
    }

    public NIExtentSummaryResult[] queryExtentSummary(NIVolumeID[] nIVolumeIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "queryExtentSummary");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIExtentSummaryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIExtentSummaryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIExtentSummaryResult")) : class$com$ibm$storage$ess$ni$application$results$NIExtentSummaryResult);
        NIExtentSummaryResultImpl[] nIExtentSummaryResultImplArray = new NIExtentSummaryResultImpl[nIVolumeIDArray.length];
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIVolumeIDArray[0].getLSS().getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            int n = 0;
            while (n < nIVolumeIDArray.length) {
                nIExtentSummaryResultImplArray[n] = new NIExtentSummaryResultImpl(false, -1099689979L, null, null, 0, 0, 0L, 0L, 0L);
                ++n;
            }
        } else {
            int n = 0;
            while (n < nIVolumeIDArray.length) {
                int n2;
                NIExtentType nIExtentType;
                NIVolumeID nIVolumeID = nIVolumeIDArray[n];
                NIVolumeImpl nIVolumeImpl = (NIVolumeImpl)nIOlcDatabaseSchemaHelper.getVolumesByID(new NIVolumeID[]{nIVolumeID}).get(0);
                if (nIVolumeImpl.getVolumeType() instanceof NIVolumeTypeFixedBlockBase || nIVolumeImpl.getVolumeType() instanceof NIVolumeTypeFixedBlockMap) {
                    nIExtentType = NIExtentTypeFB.Option;
                    n2 = this._blocksToExtents(nIVolumeImpl.getCapacity());
                } else {
                    nIExtentType = NIExtentTypeCKD.Option;
                    n2 = this._cylindersToExtents(nIVolumeImpl.getCapacity());
                }
                nIExtentSummaryResultImplArray[n] = new NIExtentSummaryResultImpl(true, 0L, nIVolumeID, nIExtentType, nIVolumeImpl.getDataState(), nIVolumeImpl.getConfigState(), n2, n2, 0L);
                ++n;
            }
            nIOlcDatabaseSchemaHelper.release();
        }
        nIEscrow.close(nIExtentSummaryResultImplArray);
        NIOlcLogger.exit(CLASS_NAME, "queryExtentSummary");
        return new NIExtentSummaryResult[]{(NIExtentSummaryResult)((Object)nIEscrow.issueIou())};
    }

    public NIConfigQueryResult queryVolumes(NIRankID nIRankID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "queryVolumes");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIRankID.getESS());
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList<Object> arrayList = new ArrayList();
        List list = nIOlcDatabaseSchemaHelper.getRanksByID(new NIRankID[]{nIRankID});
        if (list.size() != 0) {
            NIRankImpl nIRankImpl = (NIRankImpl)list.get(0);
            arrayList = new ArrayList(nIRankImpl.getVolumeMap().keySet());
        }
        NIOlcLogger.exit(CLASS_NAME, "queryVolumes");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIQueryLICFeatureKeysResult queryFeatureKeys(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "queryFeatureKeys");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIQueryLICFeatureKeysResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIQueryLICFeatureKeysResult = NIOlcLogicalConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIQueryLICFeatureKeysResult")) : class$com$ibm$storage$ess$ni$application$results$NIQueryLICFeatureKeysResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            NIQueryLICFeatureKeysResultImpl nIQueryLICFeatureKeysResultImpl = new NIQueryLICFeatureKeysResultImpl(null, null, false, -1099689979);
            nIEscrow.close(nIQueryLICFeatureKeysResultImpl);
            return (NIQueryLICFeatureKeysResult)((Object)nIEscrow.issueIou());
        }
        NIESSImpl nIESSImpl = (NIESSImpl)nIOlcDatabaseSchemaHelper.getEssByID(new NIESSID[]{nIESSID}).get(0);
        String string = nIESSImpl.getMachineSignature();
        NIQueryLICFeatureKeysResultImpl nIQueryLICFeatureKeysResultImpl = new NIQueryLICFeatureKeysResultImpl(string, null, true, 0);
        nIEscrow.close(nIQueryLICFeatureKeysResultImpl);
        NIOlcLogger.exit(CLASS_NAME, "queryFeatureKeys");
        nIOlcDatabaseSchemaHelper.release();
        return (NIQueryLICFeatureKeysResult)((Object)nIEscrow.issueIou());
    }

    public NIConfigResult releaseRank(NIRankID nIRankID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    public NIPinnedTrackDataResult queryPinnedTracks(NIVolumeID nIVolumeID, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    public NIVolumeGroupUsageResult queryVolumeGroupUsage(NIVolumeGroupID nIVolumeGroupID, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    public NIConfigResult getFBVolumeFormatStatus(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    public NIVolumeMapQueryResult getVolumeMap(NIVolumeGroupID nIVolumeGroupID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    public NIConfigResult installFeatureKey(NIESSID nIESSID, String string) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException();
    }

    public NIQueryVolumeSerialResult queryVolumeSerial(NILSSID nILSSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("Unsupported for this ESS Model.");
    }

    public NIQueryRankExtentsResult queryRankExtents(NIVolumeID nIVolumeID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("Unsupported for this ESS Model.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

