/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.olc.services;

import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.application.resource.NIArraySite;
import com.ibm.storage.ess.ni.application.resource.NIDDMPack;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.application.resource.NIOfflineESS;
import com.ibm.storage.ess.ni.application.resource.NIOfflineLicensedFunction;
import com.ibm.storage.ess.ni.application.resource.NIOfflineStorageFacility;
import com.ibm.storage.ess.ni.application.resource.NIOfflineStoragePlex;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU;
import com.ibm.storage.ess.ni.application.resource.NIStorageEnclosure;
import com.ibm.storage.ess.ni.application.resource.NIStorageFacility;
import com.ibm.storage.ess.ni.application.resource.NIStoragePlex;
import com.ibm.storage.ess.ni.application.resource.NIVersion;
import com.ibm.storage.ess.ni.application.results.NICalendarResult;
import com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIConfigResult;
import com.ibm.storage.ess.ni.application.results.NIHarvestProgressResult;
import com.ibm.storage.ess.ni.application.results.NIVPNResult;
import com.ibm.storage.ess.ni.constants.NIFeatureCodes;
import com.ibm.storage.ess.ni.event.extensions.NIArraySiteCreatedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIESSChangedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIESSCreatedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIESSDeletedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIStorageFacilityChangedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIStorageFacilityCreatedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIStorageFacilityDeletedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIStoragePlexChangedEventImpl;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIEnclosureID;
import com.ibm.storage.ess.ni.identifiers.NIEnterpriseID;
import com.ibm.storage.ess.ni.identifiers.NIFRUID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.identifiers.NIStoragePlexID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.iou.NIEscrow;
import com.ibm.storage.ess.ni.iou.NIEscrowFactory;
import com.ibm.storage.ess.ni.olc.NIOlcCommon;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseHelper;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseManager;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseSchemaHelper;
import com.ibm.storage.ess.ni.olc.NIOlcEventProcessor;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import com.ibm.storage.ess.ni.option.config.NIESSStateOnline;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlMode;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520All;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIAll;
import com.ibm.storage.ess.ni.resource.NIArraySiteImpl;
import com.ibm.storage.ess.ni.resource.NIESCONPortImpl;
import com.ibm.storage.ess.ni.resource.NIESSImpl;
import com.ibm.storage.ess.ni.resource.NIEnclosureImpl;
import com.ibm.storage.ess.ni.resource.NIFRUImpl;
import com.ibm.storage.ess.ni.resource.NIFibreChannelPortImpl;
import com.ibm.storage.ess.ni.resource.NIIOPortImpl;
import com.ibm.storage.ess.ni.resource.NIResourceImpl;
import com.ibm.storage.ess.ni.resource.NIStorageDeviceFRUImpl;
import com.ibm.storage.ess.ni.resource.NIStorageEnclosureImpl;
import com.ibm.storage.ess.ni.resource.NIStorageFacilityImpl;
import com.ibm.storage.ess.ni.resource.NIVersionImpl;
import com.ibm.storage.ess.ni.resource.NIVolumeGroupImpl;
import com.ibm.storage.ess.ni.results.NIConfigCreatedResultImpl;
import com.ibm.storage.ess.ni.services.NIDomainService;
import com.ibm.storage.ess.ni.services.NIOfflineDomainService;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class NIOlcOfflineDomainService
implements NIDomainService,
NIOfflineDomainService {
    private ArrayList alEventsHolder = new ArrayList();
    private NIStoragePlexID activePlex = null;
    private static final int MAX_DA_PAIRS = 4;
    private static final NIOlcCommon c = NIOlcCommon.c;
    private static final String CLASS_NAME = "NIOlcOfflineDomainService";
    private static final int MAX_DEVICES_PER_ENCLOSURE = 16;
    private static final String LIC_VERSION_FILE = "com.ibm.storage.ess.ni.licversion";
    private static final String LIC_VERSION_ID = "BUNDLE_IDENTIFICATION_NUMBER=";
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIConfigResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU;

    public NIOlcOfflineDomainService() {
        if (NIAgentProperties.getAgentType() == 11) {
            NIEnterpriseID nIEnterpriseID = new NIEnterpriseID(1, "$TestEnterprise");
            this.activePlex = new NIStoragePlexID(1, nIEnterpriseID);
        }
    }

    public void setActiveStoragePlex(NIStoragePlexID nIStoragePlexID) {
        NIOlcLogger.enter(CLASS_NAME, "setActiveStoragePlex");
        if (this.activePlex != null) {
            String string = this.activePlex.getEnterprise().getDatabase();
            NIOlcLogger.info("ActivePlex:" + nIStoragePlexID);
            if (NIOlcDatabaseManager.workingDatabaseExists(string)) {
                NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string);
                this.activePlex = nIStoragePlexID;
                nIOlcDatabaseSchemaHelper.release();
            } else {
                this.activePlex = nIStoragePlexID;
            }
        } else {
            this.activePlex = nIStoragePlexID;
        }
        NIOlcLogger.exit(CLASS_NAME, "setActiveStoragePlex");
    }

    public NIConfigCreatedResult createStorageFacility(NIOfflineStorageFacility nIOfflineStorageFacility) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIVolumeGroupImpl[] nIVolumeGroupImplArray;
        Object object;
        Serializable serializable;
        NIOfflineESS[] nIOfflineESSArray;
        NIOlcLogger.enter(CLASS_NAME, "createStorageFacility");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        NIStorageFacilityImpl nIStorageFacilityImpl = (NIStorageFacilityImpl)nIOfflineStorageFacility;
        HashMap<Serializable, NIVolumeGroupImpl[]> hashMap = new HashMap<Serializable, NIVolumeGroupImpl[]>();
        NIStorageFacilityID nIStorageFacilityID = (NIStorageFacilityID)nIStorageFacilityImpl.getID();
        String string = nIStorageFacilityID.getStoragePlex().getEnterprise().getDatabase();
        String string2 = nIStorageFacilityID.getType();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string);
        if (nIStorageFacilityID.getSequence() == null || nIStorageFacilityID.getSequence().trim().equals("")) {
            nIOfflineESSArray = this._generateSequenceNumber(nIStorageFacilityID.getStoragePlex(), nIOlcDatabaseSchemaHelper);
            nIStorageFacilityID.setSequence((String)nIOfflineESSArray);
        }
        nIOlcDatabaseSchemaHelper.beginXA();
        bl = nIOlcDatabaseSchemaHelper.insertStorageFacility(nIStorageFacilityImpl, nIStorageFacilityID.getStoragePlex());
        this.alEventsHolder.add(new NIStorageFacilityCreatedEventImpl(nIStorageFacilityImpl));
        nIOfflineESSArray = nIStorageFacilityImpl.getOfflineESSs();
        int n4 = 1;
        while (n4 <= nIOfflineESSArray.length) {
            NIESSImpl nIESSImpl = (NIESSImpl)nIOfflineESSArray[n4 - 1];
            serializable = new NIESSID(nIStorageFacilityID, n4);
            object = ((NIESSID)serializable).getSequence();
            while (((String)object).charAt(0) == '0' && ((String)object).length() > 1) {
                object = ((String)object).substring(1);
            }
            nIESSImpl.setID((NIResourceID)serializable);
            nIESSImpl.setUserName("Storage Facility Image " + (String)object);
            nIESSImpl.setUserDescription("");
            nIESSImpl.setState(NIESSStateOnline.Option);
            bl &= nIOlcDatabaseSchemaHelper.insertEss(nIESSImpl);
            this.alEventsHolder.add(new NIESSCreatedEventImpl(nIESSImpl));
            nIVolumeGroupImplArray = new NIVolumeGroupImpl[3];
            NIVolumeGroupImpl nIVolumeGroupImpl = (NIVolumeGroupImpl)NIResourceFactory.newVolumeGroup((NIESSID)serializable, "All CKD", NIVolumeGroupTypeFiconEsconAll.Option);
            nIVolumeGroupImpl.setID(new NIVolumeGroupID((NIESSID)serializable, 10));
            bl &= nIOlcDatabaseSchemaHelper.insertVolumeGroup(nIVolumeGroupImpl);
            nIVolumeGroupImplArray[0] = nIVolumeGroupImpl;
            nIVolumeGroupImpl = (NIVolumeGroupImpl)NIResourceFactory.newVolumeGroup((NIESSID)serializable, "All Fixed Block-512", NIVolumeGroupTypeSCSIAll.Option);
            nIVolumeGroupImpl.setID(new NIVolumeGroupID((NIESSID)serializable, 20));
            bl &= nIOlcDatabaseSchemaHelper.insertVolumeGroup(nIVolumeGroupImpl);
            nIVolumeGroupImplArray[1] = nIVolumeGroupImpl;
            nIVolumeGroupImpl = (NIVolumeGroupImpl)NIResourceFactory.newVolumeGroup((NIESSID)serializable, "All Fixed Block-520", NIVolumeGroupTypeSCSI520All.Option);
            nIVolumeGroupImpl.setID(new NIVolumeGroupID((NIESSID)serializable, 30));
            bl &= nIOlcDatabaseSchemaHelper.insertVolumeGroup(nIVolumeGroupImpl);
            nIVolumeGroupImplArray[2] = nIVolumeGroupImpl;
            hashMap.put(serializable, nIVolumeGroupImplArray);
            NIIOPort[] nIIOPortArray = nIESSImpl.getIoPorts();
            if (nIIOPortArray != null) {
                int n5 = 0;
                while (n5 < nIIOPortArray.length) {
                    NIIOPortImpl nIIOPortImpl = (NIIOPortImpl)nIIOPortArray[n5];
                    int n6 = ((NIIOPortID)nIIOPortImpl.getID()).getInterfaceIdentifier();
                    NIIOPortID nIIOPortID = new NIIOPortID((NIESSID)serializable, n6);
                    nIIOPortImpl.setID(nIIOPortID);
                    bl &= nIOlcDatabaseSchemaHelper.insertIOPort(nIIOPortImpl);
                    if (nIIOPortImpl.getPortType() == 20) {
                        ++n;
                    } else if (nIIOPortImpl.getPortType() == 21) {
                        ++n2;
                    } else if (nIIOPortImpl.getPortType() == 10) {
                        ++n3;
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        nIStorageFacilityImpl.setNumFibreChannelLongWave(n / 4);
        nIStorageFacilityImpl.setNumFibreChannelShortWave(n2 / 4);
        nIStorageFacilityImpl.setNumEscon(n3);
        bl &= nIOlcDatabaseSchemaHelper.modifyStorageFacility(nIStorageFacilityImpl);
        boolean bl2 = false;
        serializable = (NIESSImpl)nIOfflineESSArray[0];
        if (string2.equals("1750")) {
            object = nIOfflineESSArray[0];
            nIVolumeGroupImplArray = new NIStorageFacilityID((NIESSID)object.getID(), nIStorageFacilityID.getStoragePlex());
            nIStorageFacilityImpl.setID((NIResourceID)nIVolumeGroupImplArray);
            bl &= nIOlcDatabaseSchemaHelper.modifyStorageFacility(nIStorageFacilityImpl);
            if (bl2) {
                bl &= this._distribute_1750_AAL(nIStorageFacilityImpl, nIOlcDatabaseSchemaHelper);
            } else if (((NIESSImpl)serializable).getArraysites() != null) {
                bl &= this._distribute_1750_AOL_Arraysites(nIStorageFacilityImpl, nIOlcDatabaseSchemaHelper);
            } else if (((NIESSImpl)serializable).getDdmPacks() != null) {
                bl &= this._distribute_1750_AOL(nIStorageFacilityImpl, nIOlcDatabaseSchemaHelper);
            }
        } else if (string2.equals("2107")) {
            if (((NIESSImpl)serializable).getArraysites() != null) {
                bl &= this._distribute_2107_Arraysites(nIStorageFacilityImpl, nIOlcDatabaseSchemaHelper);
            } else if (((NIESSImpl)serializable).getDdmPacks() != null) {
                bl &= this._distribute_2107(nIStorageFacilityImpl, nIOlcDatabaseSchemaHelper);
            }
        }
        if (bl &= (bl &= nIOlcDatabaseSchemaHelper.modifyStorageFacility(nIStorageFacilityImpl)) ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIOlcLogger.exit(CLASS_NAME, "createStorageFacility");
        nIOlcDatabaseSchemaHelper.release();
        return (NIConfigCreatedResult)c.handleConfig(nIStorageFacilityID, nIEscrow, bl);
    }

    public NIConfigResult modifyStorageFacility(NIOfflineStorageFacility nIOfflineStorageFacility) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "modifyStorageFacility");
        NIStorageFacilityID nIStorageFacilityID = (NIStorageFacilityID)nIOfflineStorageFacility.getID();
        NIEnterpriseID nIEnterpriseID = nIStorageFacilityID.getStoragePlex().getEnterprise();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(nIEnterpriseID.getDatabase());
        NIOfflineStorageFacility nIOfflineStorageFacility2 = (NIOfflineStorageFacility)nIOlcDatabaseSchemaHelper.getFacilityByID(new NIStorageFacilityID[]{nIStorageFacilityID}).get(0);
        boolean bl = nIOlcDatabaseSchemaHelper.modifyStorageFacility(nIOfflineStorageFacility);
        this.alEventsHolder.add(new NIStorageFacilityChangedEventImpl(nIOfflineStorageFacility2, nIOfflineStorageFacility));
        if (bl) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIOlcLogger.exit(CLASS_NAME, "modifyStorageFacility");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleConfig(nIOfflineStorageFacility.getID(), nIEscrow, bl);
    }

    public NIConfigResult deleteStorageFacility(NIStorageFacilityID nIStorageFacilityID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        Object object;
        NIOlcLogger.enter(CLASS_NAME, "deleteStorageFacility");
        String string = nIStorageFacilityID.getStoragePlex().getEnterprise().getDatabase();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string);
        NIStorageFacility nIStorageFacility = (NIStorageFacility)nIOlcDatabaseSchemaHelper.getFacilityByID(new NIStorageFacilityID[]{nIStorageFacilityID}).get(0);
        boolean bl = true;
        nIOlcDatabaseSchemaHelper.beginXA();
        List list = nIOlcDatabaseSchemaHelper.getEssByFacility(nIStorageFacilityID);
        int n = 0;
        while (n < list.size()) {
            object = (NIESS)list.get(n);
            bl &= NIOlcOfflineDomainService.deleteESSImage((NIESS)object, nIOlcDatabaseSchemaHelper);
            this.alEventsHolder.add(new NIESSDeletedEventImpl((NIESS)object));
            ++n;
        }
        this.alEventsHolder.add(new NIStorageFacilityDeletedEventImpl(nIStorageFacility));
        if (bl &= (bl &= nIOlcDatabaseSchemaHelper.deleteStorageFacility(nIStorageFacilityID)) ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        object = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIOlcLogger.exit(CLASS_NAME, "deleteStorageFacility");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleConfig(nIStorageFacilityID, (NIEscrow)object, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIConfigCreatedResult importStorageFacility(NIStoragePlexID nIStoragePlexID, String string, String string2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "importStorageFacility");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        BufferedReader bufferedReader = null;
        boolean bl = true;
        boolean bl2 = false;
        if (!string.toUpperCase().endsWith("CFR")) {
            nIEscrow.close(new NIConfigCreatedResultImpl(nIStoragePlexID, false, -1099689965L));
            return (NIConfigCreatedResult)((Object)nIEscrow.issueIou());
        }
        try {
            String string3;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.substring(0, 2).equals("08") && !string3.substring(0, 2).equals("25")) continue;
                String string4 = string3.substring(2, 6);
                String string5 = string3.substring(7, 10);
                int n = Integer.parseInt(string3.substring(10, 15).trim());
                String string6 = string3.substring(15);
                if ((!string4.equals("2107") || !string2.equals("2107") && !string2.equals("ALL")) && (!string4.equals("1750") || !string2.equals("1750") && !string2.equals("ALL"))) continue;
                bl &= this._createImportStorageFacility(nIStoragePlexID, string4, string5, n, string6);
                bl2 = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            NIOlcLogger.severe("", fileNotFoundException);
            bl = false;
        }
        catch (NumberFormatException numberFormatException) {
            NIOlcLogger.severe("", numberFormatException);
            bl = false;
        }
        catch (IOException iOException) {
            NIOlcLogger.severe("", iOException);
            bl = false;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    NIOlcLogger.info(iOException.getMessage());
                }
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "importStorageFacility");
        return (NIConfigCreatedResult)c.handleConfig(nIStoragePlexID, nIEscrow, bl && bl2);
    }

    public NIConfigCreatedResult importStorageFacility(NIStoragePlexID nIStoragePlexID, String string) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        return this.importStorageFacility(nIStoragePlexID, string, "ALL");
    }

    private boolean _createImportStorageFacility(NIStoragePlexID nIStoragePlexID, String string, String string2, int n, String string3) throws NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIServerException {
        Object object;
        ArrayList<NIDDMPack> arrayList = new ArrayList<NIDDMPack>();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = string2.equals("9A2") ? 2 : 1;
        boolean bl2 = true;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n6 = 0;
        while (n6 + 12 <= string3.length()) {
            String string4 = string3.substring(n6, n6 + 7).trim();
            object = Integer.valueOf(string3.substring(n6 + 7, n6 + 12).trim());
            hashMap.put(string4, object);
            n6 += 12;
        }
        int n7 = 0;
        while (n7 < n) {
            NIResource nIResource;
            object = NIFeatureCodes.testForFeature(NIFeatureCodes.ESCON_ADAPTERS, hashMap);
            if (object != null) {
                n4 = (Integer)hashMap.get(object);
            }
            if ((object = NIFeatureCodes.testForFeature(NIFeatureCodes.FCP_LONG_WAVE_ADAPTERS, hashMap)) != null) {
                n3 = (Integer)hashMap.get(object);
            }
            if ((object = NIFeatureCodes.testForFeature(NIFeatureCodes.FCP_SHORT_WAVE_ADAPTERS, hashMap)) != null) {
                n2 = (Integer)hashMap.get(object);
            }
            int n8 = 0;
            while (n8 < NIFeatureCodes.DDM.length) {
                String string5 = NIFeatureCodes.testForFeature(NIFeatureCodes.DDM[n8], hashMap);
                if (string5 != null) {
                    int n9 = (Integer)hashMap.get(string5);
                    arrayList.add(NIResourceFactory.newDDMPack(NIFeatureCodes.DDM_CAPACITY[n8], NIFeatureCodes.DDM_RPM[n8], n9, 1));
                }
                ++n8;
            }
            int n10 = 0;
            ArrayList<NIResource> arrayList2 = new ArrayList<NIResource>();
            int n11 = 0;
            while (n11 < n4 * 2) {
                NIESCONPortImpl nIESCONPortImpl = new NIESCONPortImpl(new NIIOPortID(null, n10), "", 10, 0, 0, null, null, 0, 0);
                arrayList2.add(nIESCONPortImpl);
                ++n10;
                ++n11;
            }
            int n12 = 0;
            while (n12 < n3 * 4) {
                NIFibreChannelPortImpl nIFibreChannelPortImpl = new NIFibreChannelPortImpl(new NIIOPortID(null, n10), "", 20, 0, 0, null, 0, null, 0);
                arrayList2.add(nIFibreChannelPortImpl);
                ++n10;
                ++n12;
            }
            int n13 = 0;
            while (n13 < n2 * 4) {
                nIResource = new NIFibreChannelPortImpl(new NIIOPortID(null, n10), "", 21, 0, 0, null, 0, null, 0);
                arrayList2.add(nIResource);
                ++n10;
                ++n13;
            }
            nIResource = NIResourceFactory.newOfflineESS(string2, arrayList.toArray(new NIDDMPack[0]), arrayList2.toArray(new NIIOPort[0]), new NIOfflineLicensedFunction[0]);
            NIOfflineStorageFacility nIOfflineStorageFacility = NIResourceFactory.newOfflineStorageFacility(nIStoragePlexID, "Imported Storage Facility " + n7, string, string2, "Imported via eConfig purchase order file", new NIOfflineESS[]{nIResource});
            bl2 &= this.createStorageFacility(nIOfflineStorageFacility).isSuccessful();
            ++n7;
        }
        return bl2;
    }

    public NIConfigCreatedResult importStorageFacility(NIStoragePlexID nIStoragePlexID, NIServices nIServices, NIStorageFacilityID nIStorageFacilityID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("Use Configuration Loader to import a storage facility");
    }

    public NIConfigQueryResult getESSs() throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        Object object;
        NIOlcLogger.enter(CLASS_NAME, "getESSs()");
        NIOlcLogger.info("ActivePlex:" + this.activePlex);
        ArrayList arrayList = new ArrayList();
        String string = this.activePlex.getEnterprise().getDatabase();
        if (NIOlcDatabaseManager.workingDatabaseExists(string)) {
            object = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string);
            arrayList = (ArrayList)((NIOlcDatabaseSchemaHelper)object).getEssByPlex(this.activePlex);
            ((NIOlcDatabaseHelper)object).release();
        }
        object = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcLogger.exit(CLASS_NAME, "getESSs()");
        return c.handleQuery(arrayList, (NIEscrow)object);
    }

    public NIConfigQueryResult getESSs(NIESSID[] nIESSIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getESSs");
        String string = nIESSIDArray[0].getStorageFacility().getStoragePlex().getEnterprise().getDatabase();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string);
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getEssByID(nIESSIDArray);
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcLogger.exit(CLASS_NAME, "getESSs");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getESSs(NIStorageFacilityID nIStorageFacilityID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getESSs");
        String string = nIStorageFacilityID.getStoragePlex().getEnterprise().getDatabase();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string);
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getEssByFacility(nIStorageFacilityID);
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcLogger.exit(CLASS_NAME, "getESSs");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigResult modifyESS(NIESS nIESS) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "modifyESS");
        String string = ((NIESSID)nIESS.getID()).getStorageFacility().getStoragePlex().getEnterprise().getDatabase();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string);
        NIOfflineESS nIOfflineESS = (NIOfflineESS)nIOlcDatabaseSchemaHelper.getEssByID(new NIESSID[]{(NIESSID)nIESS.getID()}).get(0);
        boolean bl = nIOlcDatabaseSchemaHelper.modifyEss((NIOfflineESS)nIESS);
        this.alEventsHolder.add(new NIESSChangedEventImpl(nIOfflineESS, nIESS));
        if (bl) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIOlcLogger.exit(CLASS_NAME, "modifyESS");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleConfig(nIESS.getID(), nIEscrow, bl);
    }

    public NIConfigQueryResult getStoragePlex() throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        Object object;
        NIOlcLogger.enter(CLASS_NAME, "getStoragePlex");
        NIOlcLogger.info("ActivePlex:" + this.activePlex);
        ArrayList arrayList = new ArrayList();
        String string = this.activePlex.getEnterprise().getDatabase();
        if (NIOlcDatabaseManager.workingDatabaseExists(string)) {
            object = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string);
            arrayList = (ArrayList)((NIOlcDatabaseSchemaHelper)object).getStoragePlex(this.activePlex);
            ((NIOlcDatabaseHelper)object).release();
        }
        object = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcLogger.exit(CLASS_NAME, "getStoragePlex");
        return c.handleQuery(arrayList, (NIEscrow)object);
    }

    public NIConfigResult modifyStoragePlex(NIStoragePlex nIStoragePlex) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        Object object;
        NIOlcLogger.enter(CLASS_NAME, "modifyStoragePlex");
        NIStoragePlexID nIStoragePlexID = (NIStoragePlexID)((NIOfflineStoragePlex)nIStoragePlex).getID();
        String string = nIStoragePlexID.getEnterprise().getDatabase();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string);
        boolean bl = true;
        List list = nIOlcDatabaseSchemaHelper.getStoragePlex(nIStoragePlexID);
        if (list.size() > 0) {
            object = (NIOfflineStoragePlex)list.get(0);
            bl = nIOlcDatabaseSchemaHelper.modifyStoragePlex((NIOfflineStoragePlex)nIStoragePlex);
            this.alEventsHolder.add(new NIStoragePlexChangedEventImpl((NIStoragePlex)object, nIStoragePlex));
        } else {
            bl = false;
        }
        if (bl) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        object = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIOlcLogger.exit(CLASS_NAME, "modifyStoragePlex");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleConfig(nIStoragePlex.getID(), (NIEscrow)object, bl);
    }

    public NIConfigQueryResult getStorageFacilities() throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        Object object;
        NIOlcLogger.enter(CLASS_NAME, "getStorageFacilities");
        NIOlcLogger.info("ActivePlex:" + this.activePlex);
        ArrayList arrayList = new ArrayList();
        String string = this.activePlex.getEnterprise().getDatabase();
        if (NIOlcDatabaseManager.workingDatabaseExists(string)) {
            object = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string);
            arrayList = (ArrayList)((NIOlcDatabaseSchemaHelper)object).getFacilityByPlex(this.activePlex);
            ((NIOlcDatabaseHelper)object).release();
        }
        object = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcLogger.exit(CLASS_NAME, "getStorageFacilities");
        return c.handleQuery(arrayList, (NIEscrow)object);
    }

    public NIConfigQueryResult getStorageFacilities(NIStorageFacilityID[] nIStorageFacilityIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getStorageFacilities");
        String string = nIStorageFacilityIDArray[0].getStoragePlex().getEnterprise().getDatabase();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string);
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getFacilityByID(nIStorageFacilityIDArray);
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcLogger.exit(CLASS_NAME, "getStorageFacilities");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigResult modifyStorageFacility(NIStorageFacility nIStorageFacility) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        return this.modifyStorageFacility((NIOfflineStorageFacility)nIStorageFacility);
    }

    public NIConfigResult manualPowerOn(NIStorageFacility nIStorageFacility) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        final NIStorageFacilityImpl nIStorageFacilityImpl = (NIStorageFacilityImpl)nIStorageFacility;
        nIStorageFacilityImpl.setPowerState(3);
        new Thread(new Runnable(){
            private final NIStorageFacilityImpl storageFac;
            {
                this.storageFac = nIStorageFacilityImpl;
            }

            public void run() {
                try {
                    Thread.sleep(300000L);
                    this.storageFac.setPowerState(1);
                    NIOlcOfflineDomainService.this.modifyStorageFacility(this.storageFac);
                }
                catch (Exception exception) {}
            }
        }).start();
        return this.modifyStorageFacility(nIStorageFacilityImpl);
    }

    public NIConfigResult manualPowerOff(NIStorageFacility nIStorageFacility) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        final NIStorageFacilityImpl nIStorageFacilityImpl = (NIStorageFacilityImpl)nIStorageFacility;
        nIStorageFacilityImpl.setPowerState(2);
        new Thread(new Runnable(){
            private final NIStorageFacilityImpl storageFac;
            {
                this.storageFac = nIStorageFacilityImpl;
            }

            public void run() {
                try {
                    Thread.sleep(300000L);
                    this.storageFac.setPowerState(0);
                    NIOlcOfflineDomainService.this.modifyStorageFacility(this.storageFac);
                }
                catch (Exception exception) {}
            }
        }).start();
        return this.modifyStorageFacility(nIStorageFacilityImpl);
    }

    public NIConfigResult requestPowerControlMode(NIStorageFacilityID nIStorageFacilityID, NISFPowerControlMode nISFPowerControlMode) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.info("requestPowerControl() not supported in OLC.  The requested power control attribute of storage facility should be modified instead.");
        throw new NIUnsupportedException("Not supported in OLC.  Use NIStorageFacility.setRequestedPowerMode() instead.");
    }

    public NIConfigResult forceOffline(NIStorageFacility nIStorageFacility) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    public NIConfigResult forcePowerOff(NIStorageFacility nIStorageFacility) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    public NIConfigResult forceOffline(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    public NIConfigResult forceWarmstart(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    public NIConfigQueryResult getStorageFacility(NIStorageFacilityID nIStorageFacilityID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException();
    }

    public NIConfigQueryResult getStoragePlex(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException();
    }

    public NIConfigQueryResult getAllESS() throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        Object object;
        NIOlcLogger.enter(CLASS_NAME, "getAllESS");
        NIOlcLogger.info("ActivePlex:" + this.activePlex);
        ArrayList<NIResourceID> arrayList = new ArrayList<NIResourceID>();
        String string = this.activePlex.getEnterprise().getDatabase();
        if (NIOlcDatabaseManager.workingDatabaseExists(string)) {
            object = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string);
            ArrayList arrayList2 = (ArrayList)((NIOlcDatabaseSchemaHelper)object).getEssByPlex(this.activePlex);
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                NIESS nIESS = (NIESS)iterator.next();
                arrayList.add(nIESS.getID());
            }
            ((NIOlcDatabaseHelper)object).release();
        }
        object = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcLogger.exit(CLASS_NAME, "getAllESS");
        return c.handleQuery(arrayList, (NIEscrow)object);
    }

    protected static boolean deleteESSImage(NIESS nIESS, NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper) {
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        boolean bl = true;
        bl &= nIOlcDatabaseSchemaHelper.deleteAllByESS(nIESSID);
        return bl &= nIOlcDatabaseSchemaHelper.deleteEss(nIESSID);
    }

    private String _generateSequenceNumber(NIStoragePlexID nIStoragePlexID, NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper) {
        Object object;
        int n = 10;
        List list = nIOlcDatabaseSchemaHelper.getFacilities();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < list.size()) {
            NIOfflineStorageFacility nIOfflineStorageFacility = (NIOfflineStorageFacility)list.get(n2);
            object = (NIStorageFacilityID)nIOfflineStorageFacility.getID();
            arrayList.add(((NIStorageFacilityID)object).getSequence());
            ++n2;
        }
        boolean bl = false;
        object = "";
        while (!bl) {
            object = Integer.toString(n);
            String string = "";
            int n3 = 0;
            while (n3 < 5 - ((String)object).length()) {
                string = n3 == 0 ? "0" : string + "0";
                ++n3;
            }
            object = string + (String)object;
            if (arrayList.contains(object)) {
                n += 10;
                continue;
            }
            bl = true;
        }
        return object;
    }

    private boolean _distribute_1750_AAL(NIStorageFacilityImpl nIStorageFacilityImpl, NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        ArrayList<NIResourceImpl> arrayList = new ArrayList<NIResourceImpl>();
        NIStorageEnclosureImpl nIStorageEnclosureImpl = null;
        NIStorageEnclosureImpl nIStorageEnclosureImpl2 = null;
        int n6 = -2;
        NIESSImpl nIESSImpl = (NIESSImpl)nIStorageFacilityImpl.getOfflineESSs()[0];
        NIESSID nIESSID = (NIESSID)nIESSImpl.getID();
        NIDDMPack[] nIDDMPackArray = nIESSImpl.getDdmPacks();
        Arrays.sort(nIDDMPackArray, Collections.reverseOrder());
        int n7 = 0;
        while (n7 < nIDDMPackArray.length) {
            NIDDMPack nIDDMPack = nIDDMPackArray[n7];
            int n8 = 0;
            while (n8 < nIDDMPack.getQuantity()) {
                NIResourceImpl nIResourceImpl;
                if (hashMap.get(new Integer(n4)) == null) {
                    hashMap.put(new Integer(n4), new Integer(0));
                }
                if (nIStorageEnclosureImpl == null || nIStorageEnclosureImpl2 == null) {
                    int n9 = 10 + (n3 + 1);
                    int n10 = 20 + (n3 + 2);
                    nIStorageEnclosureImpl = new NIStorageEnclosureImpl(new NIEnclosureID(nIESSID, "", "", ""), "S" + n9, 0, "", n9, "", new int[]{0}, 0, 16, 0);
                    nIStorageEnclosureImpl2 = new NIStorageEnclosureImpl(new NIEnclosureID(nIESSID, "", "", ""), "S" + n10, 0, "", n10, "", new int[]{0}, 0, 16, 0);
                    n3 += 2;
                    n6 += 2;
                    n2 += 2;
                    hashMap.put(new Integer(n4), new Integer((Integer)hashMap.get(new Integer(n4)) + 1));
                }
                NIArraySiteID nIArraySiteID = new NIArraySiteID(nIESSID, n5++);
                NIArraySiteID nIArraySiteID2 = new NIArraySiteID(nIESSID, n5++);
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = -1;
                int n16 = 1;
                while (n16 <= 8) {
                    n13 = (int)nIDDMPack.getCapacity();
                    n14 = (int)nIDDMPack.getRPM();
                    n15 = nIDDMPack.getDiskClass();
                    nIResourceImpl = new NIStorageDeviceFRUImpl(new NIFRUID(nIESSID, "", "", "", "", "", "", class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU == null ? NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU") : class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU), "", 0, 0, 0, 0, n4, new int[0], n13, n14, "1", 0, 0, n15, 0, null, "");
                    if (n16 <= 2) {
                        ((NIStorageDeviceFRUImpl)nIResourceImpl).setFRUEnclosureNumber(nIStorageEnclosureImpl.getEnclosureNumber());
                        ((NIFRUImpl)nIResourceImpl).setLocation("P" + n6 + "-D" + nIStorageEnclosureImpl.getNumStorageDevices());
                        nIStorageEnclosureImpl.setNumStorageDevices(nIStorageEnclosureImpl.getNumStorageDevices() + 1);
                    } else {
                        ((NIStorageDeviceFRUImpl)nIResourceImpl).setFRUEnclosureNumber(nIStorageEnclosureImpl2.getEnclosureNumber());
                        ((NIFRUImpl)nIResourceImpl).setLocation("P" + (n6 + 1) + "-D" + nIStorageEnclosureImpl2.getNumStorageDevices());
                        nIStorageEnclosureImpl2.setNumStorageDevices(nIStorageEnclosureImpl2.getNumStorageDevices() + 1);
                    }
                    if (n16 <= 2) {
                        ((NIStorageDeviceFRUImpl)nIResourceImpl).setArraySite(nIArraySiteID);
                        ((NIStorageDeviceFRUImpl)nIResourceImpl).setArraySitePosition(n11++);
                    } else {
                        ((NIStorageDeviceFRUImpl)nIResourceImpl).setArraySite(nIArraySiteID2);
                        ((NIStorageDeviceFRUImpl)nIResourceImpl).setArraySitePosition(n12++);
                    }
                    arrayList.add(nIResourceImpl);
                    ++n16;
                }
                nIResourceImpl = new NIArraySiteImpl(nIArraySiteID, null, null, n4, n13, n14, "", 0L, n15, 1, 1, 0);
                NIArraySiteImpl nIArraySiteImpl = new NIArraySiteImpl(nIArraySiteID2, null, null, n4, n13, n14, "", 0L, n15, 1, 1, 0);
                bl &= nIOlcDatabaseSchemaHelper.insertArraySite((NIArraySite)((Object)nIResourceImpl));
                bl &= nIOlcDatabaseSchemaHelper.insertArraySite(nIArraySiteImpl);
                this.alEventsHolder.add(new NIArraySiteCreatedEventImpl((NIArraySite)((Object)nIResourceImpl)));
                this.alEventsHolder.add(new NIArraySiteCreatedEventImpl(nIArraySiteImpl));
                if (nIStorageEnclosureImpl.getNumStorageDevices() == 16 && nIStorageEnclosureImpl2.getNumStorageDevices() == 16 && n2 == 2 || n7 == nIDDMPackArray.length - 1 && n8 == nIDDMPack.getQuantity() - 1) {
                    bl &= nIOlcDatabaseSchemaHelper.insertStorageEnclosure(nIStorageEnclosureImpl);
                    bl &= nIOlcDatabaseSchemaHelper.insertStorageEnclosure(nIStorageEnclosureImpl2);
                    int n17 = 0;
                    while (n17 < arrayList.size()) {
                        NIStorageDeviceFRU nIStorageDeviceFRU = (NIStorageDeviceFRU)arrayList.get(n17);
                        bl &= nIOlcDatabaseSchemaHelper.insertStorageDeviceFRU(nIStorageDeviceFRU);
                        ++n17;
                    }
                    arrayList.clear();
                    nIStorageEnclosureImpl2 = null;
                    nIStorageEnclosureImpl = null;
                    n2 = 0;
                    ++n4;
                    if (hashMap.get(new Integer(n4 %= 1)) == null) {
                        hashMap.put(new Integer(n4), new Integer(0));
                    }
                    if ((Integer)hashMap.get(new Integer(n4)) > 1) {
                        ++n;
                    }
                    n3 += n * 2;
                }
                ++n8;
            }
            ++n7;
        }
        return bl;
    }

    private boolean _distribute_1750_AOL(NIStorageFacilityImpl nIStorageFacilityImpl, NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper) {
        boolean bl = true;
        int n = 11;
        int n2 = 0;
        int n3 = 1;
        ArrayList<NIStorageDeviceFRUImpl> arrayList = new ArrayList<NIStorageDeviceFRUImpl>();
        HashMap<Integer, ArrayList> hashMap = new HashMap<Integer, ArrayList>();
        NIStorageEnclosureImpl nIStorageEnclosureImpl = null;
        int n4 = -1;
        NIESSImpl nIESSImpl = (NIESSImpl)nIStorageFacilityImpl.getOfflineESSs()[0];
        NIESSID nIESSID = (NIESSID)nIESSImpl.getID();
        NIDDMPack[] nIDDMPackArray = nIESSImpl.getDdmPacks();
        Arrays.sort(nIDDMPackArray, Collections.reverseOrder());
        int n5 = 1;
        int n6 = 1;
        int n7 = 0;
        while (n7 < nIDDMPackArray.length) {
            NIDDMPack nIDDMPack = nIDDMPackArray[n7];
            int n8 = 0;
            while (n8 < nIDDMPack.getQuantity()) {
                ArrayList arrayList2;
                if (nIStorageEnclosureImpl == null) {
                    int n9 = n++;
                    if (n == 19) {
                        n = 21;
                    }
                    nIStorageEnclosureImpl = new NIStorageEnclosureImpl(new NIEnclosureID(nIESSID, "", "", ""), "S" + n9, 0, "", n9, "", new int[]{0}, 0, 16, 0);
                    ++n4;
                }
                NIArraySiteID nIArraySiteID = new NIArraySiteID(nIESSID, n3++);
                int n10 = 0;
                int n11 = (int)nIDDMPack.getCapacity();
                int n12 = (int)nIDDMPack.getRPM();
                int n13 = nIDDMPack.getDiskClass();
                NIArraySiteImpl nIArraySiteImpl = new NIArraySiteImpl(nIArraySiteID, null, null, n2, n11, n12, "", 0L, n13, 0, 1, 0, n6);
                bl &= nIOlcDatabaseSchemaHelper.insertArraySite(nIArraySiteImpl);
                if (hashMap.containsKey(new Integer(n6))) {
                    arrayList2 = (ArrayList)hashMap.get(new Integer(n6));
                    arrayList2.add(nIArraySiteImpl);
                } else {
                    arrayList2 = new ArrayList();
                    arrayList2.add(nIArraySiteImpl);
                    hashMap.put(new Integer(n6), arrayList2);
                }
                this.alEventsHolder.add(new NIArraySiteCreatedEventImpl(nIArraySiteImpl));
                int n14 = 0;
                while (n14 < 4) {
                    NIStorageDeviceFRUImpl nIStorageDeviceFRUImpl = new NIStorageDeviceFRUImpl(new NIFRUID(nIESSID, "", "", "", "", "", "", class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU == null ? NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU") : class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU), "P" + n4 + "-D" + nIStorageEnclosureImpl.getNumStorageDevices(), 0, 0, (NIEnclosureID)nIStorageEnclosureImpl.getID(), 0, n2, new int[0], n11, n12, "1", 0, 0, n13, 0, null, "", n6, "", 0, 0, "", "", "", "");
                    nIStorageDeviceFRUImpl.setFRUEnclosureNumber(nIStorageEnclosureImpl.getEnclosureNumber());
                    nIStorageEnclosureImpl.setNumStorageDevices(nIStorageEnclosureImpl.getNumStorageDevices() + 1);
                    nIStorageDeviceFRUImpl.setArraySite(nIArraySiteID);
                    nIStorageDeviceFRUImpl.setArraySitePosition(n10++);
                    if (n5 % 16 == 0) {
                        int n15 = n6 = n6 == 1 ? 2 : 1;
                    }
                    if (n5 >= 32 && n5 <= 47) {
                        n6 = 2;
                    }
                    ++n5;
                    arrayList.add(nIStorageDeviceFRUImpl);
                    ++n14;
                }
                if (nIStorageEnclosureImpl.getNumStorageDevices() == 16 || n7 == nIDDMPackArray.length - 1 && n8 == nIDDMPack.getQuantity() - 1) {
                    bl &= nIOlcDatabaseSchemaHelper.insertStorageEnclosure(nIStorageEnclosureImpl);
                    int n16 = 0;
                    while (n16 < arrayList.size()) {
                        NIStorageDeviceFRU nIStorageDeviceFRU = (NIStorageDeviceFRU)arrayList.get(n16);
                        bl &= nIOlcDatabaseSchemaHelper.insertStorageDeviceFRU(nIStorageDeviceFRU);
                        ++n16;
                    }
                    arrayList.clear();
                    nIStorageEnclosureImpl = null;
                    ++n2;
                    n2 %= 1;
                }
                ++n8;
            }
            ++n7;
        }
        return bl &= bl ? this._calculateRequiredSpares1750(nIOlcDatabaseSchemaHelper, hashMap) : false;
    }

    private boolean _distribute_1750_AOL_Arraysites(NIStorageFacilityImpl nIStorageFacilityImpl, NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper) {
        int n = 11;
        int n2 = -1;
        int n3 = 0;
        boolean bl = true;
        HashMap<Integer, ArrayList> hashMap = new HashMap<Integer, ArrayList>();
        ArrayList<NIStorageDeviceFRUImpl> arrayList = new ArrayList<NIStorageDeviceFRUImpl>();
        NIEnclosureImpl nIEnclosureImpl = null;
        nIOlcDatabaseSchemaHelper.setConstraints("SET CONSTRAINTS ALL DISABLED");
        NIESSImpl nIESSImpl = (NIESSImpl)nIStorageFacilityImpl.getOfflineESSs()[0];
        NIESSID nIESSID = (NIESSID)nIESSImpl.getID();
        int n4 = 1;
        int n5 = 1;
        NIArraySite[] nIArraySiteArray = nIESSImpl.getArraysites();
        int n6 = 0;
        while (n6 < nIArraySiteArray.length) {
            int n7;
            Serializable serializable;
            NIArraySiteImpl nIArraySiteImpl = (NIArraySiteImpl)nIArraySiteArray[n6];
            int n8 = ((NIArraySiteID)nIArraySiteImpl.getID()).getArraySiteNumber();
            nIArraySiteImpl.setArrayID(null);
            nIArraySiteImpl.setArraySiteStatus(1);
            nIArraySiteImpl.setID(new NIArraySiteID(nIESSID, n8));
            n5 = nIArraySiteImpl.getDualLoop();
            bl &= nIOlcDatabaseSchemaHelper.insertArraySite(nIArraySiteImpl);
            if (hashMap.containsKey(new Integer(n5))) {
                serializable = (ArrayList)hashMap.get(new Integer(n5));
                serializable.add(nIArraySiteImpl);
            } else {
                serializable = new ArrayList();
                serializable.add(nIArraySiteImpl);
                hashMap.put(new Integer(n5), (ArrayList)serializable);
            }
            this.alEventsHolder.add(new NIArraySiteCreatedEventImpl(nIArraySiteImpl));
            serializable = (NIArraySiteID)nIArraySiteImpl.getID();
            if (nIEnclosureImpl == null) {
                n7 = n++;
                if (n == 19) {
                    n = 21;
                }
                nIEnclosureImpl = new NIStorageEnclosureImpl(new NIEnclosureID(nIESSID, "", "", ""), "S" + n7, 0, "", n7, "", new int[]{0}, 0, 16, 0);
                ++n2;
            }
            n7 = 0;
            while (n7 < 4) {
                NIStorageDeviceFRUImpl nIStorageDeviceFRUImpl = new NIStorageDeviceFRUImpl(new NIFRUID(nIESSID, "", "", "", "", "", "", class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU == null ? NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU") : class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU), "", 0, 0, (NIEnclosureID)nIEnclosureImpl.getID(), 0, nIArraySiteImpl.getDeviceAdapterPair(), new int[0], nIArraySiteImpl.getDiskCapacity(), nIArraySiteImpl.getDiskRPM(), "1", 0, 0, nIArraySiteImpl.getDiskClass(), 0, (NIArraySiteID)serializable, "", n5, "", 0, 0, "", "", "", "");
                nIStorageDeviceFRUImpl.setFRUEnclosureNumber(((NIStorageEnclosureImpl)nIEnclosureImpl).getEnclosureNumber());
                nIStorageDeviceFRUImpl.setLocation("P" + n2 + "-D" + ((NIStorageEnclosureImpl)nIEnclosureImpl).getNumStorageDevices());
                ((NIStorageEnclosureImpl)nIEnclosureImpl).setNumStorageDevices(((NIStorageEnclosureImpl)nIEnclosureImpl).getNumStorageDevices() + 1);
                ++n4;
                arrayList.add(nIStorageDeviceFRUImpl);
                ++n7;
            }
            if ((n3 += 4) == 16 || n6 == nIArraySiteArray.length - 1) {
                bl &= nIOlcDatabaseSchemaHelper.insertStorageEnclosure((NIStorageEnclosure)((Object)nIEnclosureImpl));
                int n9 = 0;
                while (n9 < arrayList.size()) {
                    NIStorageDeviceFRU nIStorageDeviceFRU = (NIStorageDeviceFRU)arrayList.get(n9);
                    bl &= nIOlcDatabaseSchemaHelper.insertStorageDeviceFRU(nIStorageDeviceFRU);
                    ++n9;
                }
                arrayList.clear();
                nIEnclosureImpl = null;
            }
            ++n6;
        }
        nIOlcDatabaseSchemaHelper.setConstraints("SET CONSTRAINTS ALL ENABLED");
        return bl;
    }

    private boolean _distribute_2107_Arraysites(NIStorageFacilityImpl nIStorageFacilityImpl, NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper) {
        int n = 0;
        boolean bl = true;
        HashMap hashMap = new HashMap();
        ArrayList<NIStorageDeviceFRUImpl> arrayList = new ArrayList<NIStorageDeviceFRUImpl>();
        NIStorageEnclosureImpl nIStorageEnclosureImpl = null;
        NIStorageEnclosureImpl nIStorageEnclosureImpl2 = null;
        int n2 = -2;
        int n3 = 0;
        nIOlcDatabaseSchemaHelper.setConstraints("SET CONSTRAINTS ALL DISABLED");
        int n4 = 0;
        while (n4 < nIStorageFacilityImpl.getOfflineESSs().length) {
            NIESSImpl nIESSImpl = (NIESSImpl)nIStorageFacilityImpl.getOfflineESSs()[n4];
            NIESSID nIESSID = (NIESSID)nIESSImpl.getID();
            NIArraySite[] nIArraySiteArray = nIESSImpl.getArraysites();
            int n5 = 0;
            while (n5 < nIArraySiteArray.length) {
                int n6;
                int n7;
                NIArraySiteImpl nIArraySiteImpl = (NIArraySiteImpl)nIArraySiteArray[n5];
                int n8 = ((NIArraySiteID)nIArraySiteImpl.getID()).getArraySiteNumber();
                nIArraySiteImpl.setArrayID(null);
                nIArraySiteImpl.setRequiredSpares(0);
                nIArraySiteImpl.setArraySiteStatus(1);
                nIArraySiteImpl.setID(new NIArraySiteID(nIESSID, n8));
                bl &= nIOlcDatabaseSchemaHelper.insertArraySite(nIArraySiteImpl);
                this.alEventsHolder.add(new NIArraySiteCreatedEventImpl(nIArraySiteImpl));
                NIArraySiteID nIArraySiteID = (NIArraySiteID)nIArraySiteImpl.getID();
                if (nIStorageEnclosureImpl == null || nIStorageEnclosureImpl2 == null) {
                    n7 = 10 + (n + 1);
                    n6 = 20 + (n + 2);
                    nIStorageEnclosureImpl = new NIStorageEnclosureImpl(new NIEnclosureID(nIESSID, "", "", ""), "S" + n7, 0, "", n7, "", new int[]{0}, 0, 16, 0);
                    nIStorageEnclosureImpl2 = new NIStorageEnclosureImpl(new NIEnclosureID(nIESSID, "", "", ""), "S" + n6, 0, "", n6, "", new int[]{0}, 0, 16, 0);
                    n += 2;
                    n2 += 2;
                }
                n7 = 0;
                while (n7 < 8) {
                    NIStorageDeviceFRUImpl nIStorageDeviceFRUImpl = new NIStorageDeviceFRUImpl(new NIFRUID(nIESSID, "", "", "", "", "", "", class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU == null ? NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU") : class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU), "", 0, 0, 0, 0, nIArraySiteImpl.getDeviceAdapterPair(), new int[0], nIArraySiteImpl.getDiskCapacity(), nIArraySiteImpl.getDiskRPM(), "1", 0, 0, nIArraySiteImpl.getDiskClass(), 0, nIArraySiteID, "");
                    if (n7 <= 3) {
                        nIStorageDeviceFRUImpl.setFRUEnclosureNumber(nIStorageEnclosureImpl.getEnclosureNumber());
                        nIStorageDeviceFRUImpl.setLocation("P" + n2 + "-D" + nIStorageEnclosureImpl.getNumStorageDevices());
                        nIStorageEnclosureImpl.setNumStorageDevices(nIStorageEnclosureImpl.getNumStorageDevices() + 1);
                    } else {
                        nIStorageDeviceFRUImpl.setFRUEnclosureNumber(nIStorageEnclosureImpl2.getEnclosureNumber());
                        nIStorageDeviceFRUImpl.setLocation("P" + (n2 + 1) + "-D" + nIStorageEnclosureImpl2.getNumStorageDevices());
                        nIStorageEnclosureImpl2.setNumStorageDevices(nIStorageEnclosureImpl2.getNumStorageDevices() + 1);
                    }
                    arrayList.add(nIStorageDeviceFRUImpl);
                    ++n7;
                }
                if ((n3 += 8) == 32 || n5 == nIArraySiteArray.length - 1) {
                    bl &= nIOlcDatabaseSchemaHelper.insertStorageEnclosure(nIStorageEnclosureImpl);
                    bl &= nIOlcDatabaseSchemaHelper.insertStorageEnclosure(nIStorageEnclosureImpl2);
                    n6 = 0;
                    while (n6 < arrayList.size()) {
                        NIStorageDeviceFRU nIStorageDeviceFRU = (NIStorageDeviceFRU)arrayList.get(n6);
                        bl &= nIOlcDatabaseSchemaHelper.insertStorageDeviceFRU(nIStorageDeviceFRU);
                        ++n6;
                    }
                    arrayList.clear();
                    nIStorageEnclosureImpl2 = null;
                    nIStorageEnclosureImpl = null;
                    n += nIArraySiteImpl.getDeviceAdapterPair() * 2;
                }
                ++n5;
            }
            bl &= bl ? this._calculateRequiredSpares(nIOlcDatabaseSchemaHelper, nIESSID) : false;
            ++n4;
        }
        nIOlcDatabaseSchemaHelper.setConstraints("SET CONSTRAINTS ALL ENABLED");
        return bl;
    }

    private boolean _distribute_2107(NIStorageFacilityImpl nIStorageFacilityImpl, NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = nIStorageFacilityImpl.getOfflineESSs().length;
        int[] nArray = new int[n5];
        boolean bl = true;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        ArrayList<NIResourceImpl> arrayList = new ArrayList<NIResourceImpl>();
        NIStorageEnclosureImpl nIStorageEnclosureImpl = null;
        NIStorageEnclosureImpl nIStorageEnclosureImpl2 = null;
        int n6 = -2;
        boolean bl2 = false;
        int n7 = 0;
        while (n7 < n5) {
            nArray[n7] = 1;
            ++n7;
        }
        int n8 = 0;
        while (n8 < n5) {
            NIESSImpl nIESSImpl = (NIESSImpl)nIStorageFacilityImpl.getOfflineESSs()[n8];
            NIESSID nIESSID = (NIESSID)nIESSImpl.getID();
            int n9 = nIESSImpl.getModel().equals("922") || nIESSImpl.getModel().equals("9A2") ? 8 : 4;
            NIDDMPack[] nIDDMPackArray = nIESSImpl.getDdmPacks();
            Arrays.sort(nIDDMPackArray, Collections.reverseOrder());
            int n10 = 0;
            while (n10 < nIDDMPackArray.length) {
                NIDDMPack nIDDMPack = nIDDMPackArray[n10];
                int n11 = 0;
                while (n11 < nIDDMPack.getQuantity()) {
                    NIResourceImpl nIResourceImpl;
                    if (hashMap.get(new Integer(n4)) == null) {
                        hashMap.put(new Integer(n4), new Integer(0));
                    }
                    if (nIStorageEnclosureImpl == null || nIStorageEnclosureImpl2 == null) {
                        int n12 = 10 + (n3 + 1);
                        int n13 = 20 + (n3 + 2);
                        nIStorageEnclosureImpl = new NIStorageEnclosureImpl(new NIEnclosureID(nIESSID, "", "", ""), "S" + n12, 0, "", n12, "", new int[]{0}, 0, 16, 0);
                        nIStorageEnclosureImpl2 = new NIStorageEnclosureImpl(new NIEnclosureID(nIESSID, "", "", ""), "S" + n13, 0, "", n13, "", new int[]{0}, 0, 16, 0);
                        n3 += 2;
                        n6 += 2;
                        n2 += 2;
                        hashMap.put(new Integer(n4), new Integer((Integer)hashMap.get(new Integer(n4)) + 1));
                    }
                    int n14 = n8 % n5;
                    int n15 = nArray[n14];
                    nArray[n14] = n15 + 1;
                    NIArraySiteID nIArraySiteID = new NIArraySiteID(nIESSID, n15);
                    int n16 = n8 % n5;
                    int n17 = nArray[n16];
                    nArray[n16] = n17 + 1;
                    NIArraySiteID nIArraySiteID2 = new NIArraySiteID(nIESSID, n17);
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = -1;
                    int n23 = 1;
                    while (n23 <= 16) {
                        n20 = (int)nIDDMPack.getCapacity();
                        n21 = (int)nIDDMPack.getRPM();
                        n22 = nIDDMPack.getDiskClass();
                        nIResourceImpl = new NIStorageDeviceFRUImpl(new NIFRUID(nIESSID, "", "", "", "", "", "", class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU == null ? NIOlcOfflineDomainService.class$("com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU") : class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU), "", 0, 0, 0, 0, n4, new int[0], n20, n21, "1", 0, 0, n22, 0, null, "");
                        if (n23 <= 8) {
                            ((NIStorageDeviceFRUImpl)nIResourceImpl).setFRUEnclosureNumber(nIStorageEnclosureImpl.getEnclosureNumber());
                            ((NIFRUImpl)nIResourceImpl).setLocation("P" + n6 + "-D" + nIStorageEnclosureImpl.getNumStorageDevices());
                            nIStorageEnclosureImpl.setNumStorageDevices(nIStorageEnclosureImpl.getNumStorageDevices() + 1);
                        } else {
                            ((NIStorageDeviceFRUImpl)nIResourceImpl).setFRUEnclosureNumber(nIStorageEnclosureImpl2.getEnclosureNumber());
                            ((NIFRUImpl)nIResourceImpl).setLocation("P" + (n6 + 1) + "-D" + nIStorageEnclosureImpl2.getNumStorageDevices());
                            nIStorageEnclosureImpl2.setNumStorageDevices(nIStorageEnclosureImpl2.getNumStorageDevices() + 1);
                        }
                        if (n23 > 0 && n23 <= 4 || n23 > 8 && n23 <= 12) {
                            ((NIStorageDeviceFRUImpl)nIResourceImpl).setArraySite(nIArraySiteID);
                            ((NIStorageDeviceFRUImpl)nIResourceImpl).setArraySitePosition(n18++);
                        } else {
                            ((NIStorageDeviceFRUImpl)nIResourceImpl).setArraySite(nIArraySiteID2);
                            ((NIStorageDeviceFRUImpl)nIResourceImpl).setArraySitePosition(n19++);
                        }
                        arrayList.add(nIResourceImpl);
                        ++n23;
                    }
                    nIResourceImpl = new NIArraySiteImpl(nIArraySiteID, null, null, n4, n20, n21, "", 0L, n22, 0, 1, 0);
                    NIArraySiteImpl nIArraySiteImpl = new NIArraySiteImpl(nIArraySiteID2, null, null, n4, n20, n21, "", 0L, n22, 0, 1, 0);
                    bl &= nIOlcDatabaseSchemaHelper.insertArraySite((NIArraySite)((Object)nIResourceImpl));
                    bl &= nIOlcDatabaseSchemaHelper.insertArraySite(nIArraySiteImpl);
                    this.alEventsHolder.add(new NIArraySiteCreatedEventImpl((NIArraySite)((Object)nIResourceImpl)));
                    this.alEventsHolder.add(new NIArraySiteCreatedEventImpl(nIArraySiteImpl));
                    if (nIStorageEnclosureImpl.getNumStorageDevices() == 16 && nIStorageEnclosureImpl2.getNumStorageDevices() == 16 || n10 == nIDDMPackArray.length - 1 && n11 == nIDDMPack.getQuantity() - 1) {
                        bl &= nIOlcDatabaseSchemaHelper.insertStorageEnclosure(nIStorageEnclosureImpl);
                        bl &= nIOlcDatabaseSchemaHelper.insertStorageEnclosure(nIStorageEnclosureImpl2);
                        int n24 = 0;
                        while (n24 < arrayList.size()) {
                            NIStorageDeviceFRU nIStorageDeviceFRU = (NIStorageDeviceFRU)arrayList.get(n24);
                            bl &= nIOlcDatabaseSchemaHelper.insertStorageDeviceFRU(nIStorageDeviceFRU);
                            ++n24;
                        }
                        arrayList.clear();
                        nIStorageEnclosureImpl2 = null;
                        nIStorageEnclosureImpl = null;
                        if (n2 == 4) {
                            n2 = 0;
                            ++n4;
                            n4 %= n9;
                        }
                        if (hashMap.get(new Integer(n4)) == null) {
                            hashMap.put(new Integer(n4), new Integer(0));
                        }
                        if ((Integer)hashMap.get(new Integer(n4)) > 1) {
                            ++n;
                        }
                        n3 += n * 2;
                    }
                    ++n11;
                }
                ++n10;
            }
            int n25 = 0;
            while (n25 < nIStorageFacilityImpl.getOfflineESSs().length) {
                nIESSID = (NIESSID)((NIESSImpl)nIStorageFacilityImpl.getOfflineESSs()[n25]).getID();
                bl &= this._calculateRequiredSpares(nIOlcDatabaseSchemaHelper, nIESSID);
                ++n25;
            }
            ++n8;
        }
        return bl;
    }

    private boolean _calculateRequiredSpares1750(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ArrayList<NIArraySite> arrayList = new ArrayList<NIArraySite>();
            ArrayList arrayList2 = (ArrayList)hashMap.get(iterator.next());
            int n = -1;
            int n2 = -1;
            boolean bl2 = true;
            ListIterator listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() || listIterator.hasPrevious()) {
                NIArraySite nIArraySite = (NIArraySite)(bl2 ? listIterator.next() : listIterator.previous());
                int n3 = nIArraySite.getDiskCapacity();
                int n4 = nIArraySite.getDiskRPM();
                if (n == -1) {
                    n = n3;
                    n2 = n4;
                }
                if (n == n3 && n2 == n4) {
                    arrayList.add(nIArraySite);
                    listIterator.remove();
                }
                if ((!bl2 || listIterator.hasNext()) && (bl2 || listIterator.hasPrevious())) continue;
                int n5 = 2;
                int n6 = arrayList.size();
                while (n6 >= 0) {
                    if ((n6 -= 16) < 0) continue;
                    n5 += 2;
                }
                int n7 = 0;
                int n8 = 0;
                ListIterator listIterator2 = arrayList.listIterator();
                while (listIterator2.hasNext() && n7 < n5) {
                    NIArraySiteImpl nIArraySiteImpl = (NIArraySiteImpl)listIterator2.next();
                    if (n8 % 2 == 0) {
                        nIArraySiteImpl.setRequiredSpares(1);
                        ++n7;
                        bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl);
                    }
                    ++n8;
                }
                bl2 = !bl2;
                n2 = -1;
                n = -1;
                arrayList.clear();
            }
        }
        return bl;
    }

    private boolean _calculateRequiredSpares(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NIESSID nIESSID) {
        Object object;
        Object object2;
        List list = nIOlcDatabaseSchemaHelper.getArraySitesByESS(nIESSID);
        boolean bl = true;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < list.size()) {
            object2 = (NIArraySiteImpl)list.get(n);
            object = new Integer(((NIArraySiteImpl)object2).getDeviceAdapterPair());
            if (!arrayList.contains(object)) {
                arrayList.add(object);
            }
            ++n;
        }
        object2 = new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 0;
                NIArraySiteImpl nIArraySiteImpl = (NIArraySiteImpl)object;
                NIArraySiteImpl nIArraySiteImpl2 = (NIArraySiteImpl)object2;
                if (nIArraySiteImpl.getDiskCapacity() > nIArraySiteImpl2.getDiskCapacity()) {
                    n = -1;
                } else if (nIArraySiteImpl.getDiskCapacity() < nIArraySiteImpl2.getDiskCapacity()) {
                    n = 1;
                }
                return n;
            }

            public boolean equals(Object object) {
                return false;
            }
        };
        object = new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 0;
                NIArraySiteImpl nIArraySiteImpl = (NIArraySiteImpl)object;
                NIArraySiteImpl nIArraySiteImpl2 = (NIArraySiteImpl)object2;
                if (nIArraySiteImpl.getDiskRPM() > nIArraySiteImpl2.getDiskRPM()) {
                    n = -1;
                } else if (nIArraySiteImpl.getDiskRPM() < nIArraySiteImpl2.getDiskRPM()) {
                    n = 1;
                }
                return n;
            }

            public boolean equals(Object object) {
                return false;
            }
        };
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ArrayList<NIArraySite> arrayList2 = new ArrayList<NIArraySite>();
            int n2 = (Integer)iterator.next();
            int n3 = 0;
            while (n3 < list.size()) {
                NIArraySite nIArraySite = (NIArraySite)list.get(n3);
                if (nIArraySite.getDeviceAdapterPair() == n2) {
                    arrayList2.add(nIArraySite);
                }
                ++n3;
            }
            Collections.sort(arrayList2, object2);
            int n4 = 0;
            while (n4 < arrayList2.size() && n4 < 4) {
                if (arrayList2.get(n4) != null) {
                    NIArraySiteImpl nIArraySiteImpl = (NIArraySiteImpl)arrayList2.get(n4);
                    nIArraySiteImpl.setRequiredSpares(1);
                    bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl);
                }
                ++n4;
            }
            Collections.sort(arrayList2, object);
            int n5 = 0;
            while (n5 < arrayList2.size() && n5 < 2) {
                NIArraySiteImpl nIArraySiteImpl;
                if (arrayList2.get(n5) != null && (nIArraySiteImpl = (NIArraySiteImpl)arrayList2.get(n5)).getRequiredSpares() != 1) {
                    nIArraySiteImpl.setRequiredSpares(1);
                    bl &= nIOlcDatabaseSchemaHelper.modifyArraySite(nIArraySiteImpl);
                }
                ++n5;
            }
        }
        return bl;
    }

    public NICalendarResult getCalendar(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("not supported by offline");
    }

    public NICalendarResult setCalendar(NIESSID nIESSID, Calendar calendar) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("not supported by offline");
    }

    public NIVersion getManagementLevel() throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIVersionImpl nIVersionImpl;
        String string = null;
        try {
            String string2;
            int n;
            String string3 = System.getProperty(LIC_VERSION_FILE);
            FileReader fileReader = new FileReader(string3);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((n = (string2 = bufferedReader.readLine()).indexOf(LIC_VERSION_ID)) == -1) {
            }
            string = string2.substring(n + LIC_VERSION_ID.length()).trim();
            String[] stringArray = string.split("\\.");
            int[] nArray = new int[stringArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                nArray[n2] = Integer.parseInt(stringArray[n2]);
                ++n2;
            }
            nIVersionImpl = new NIVersionImpl(nArray);
        }
        catch (Exception exception) {
            NIOlcLogger.severe("Returing dummy version, exception was caught while retrieving version:", exception);
            nIVersionImpl = new NIVersionImpl(new int[]{0, 0, 0, 0});
        }
        return nIVersionImpl;
    }

    public NIHarvestProgressResult getHarvestProgress(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("Command not supported on OLC.");
    }

    public NIVPNResult initiateRemoteSupportVPN(int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("Command not supported on OLC.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

