/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.resource;

import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupMap;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.resource.NIVolumeGroupVolumeListImpl;
import java.util.Vector;

public class NIVolumeGroupMapImpl
extends NIVolumeGroupVolumeListImpl
implements NIVolumeGroupMap {
    private static final long serialVersionUID = 6950264445164264752L;

    public NIVolumeGroupMapImpl() {
        super(256);
        int n = 0;
        while (n < 256) {
            this.volumeList.add(null);
            ++n;
        }
    }

    public NIVolumeGroupMapImpl(NIVolumeID[] nIVolumeIDArray) throws NIParameterInvalidServerException {
        super(256);
        if (nIVolumeIDArray.length <= 256) {
            int n = 0;
            while (n < nIVolumeIDArray.length) {
                if (nIVolumeIDArray[n] != null && this.volumeList.indexOf(nIVolumeIDArray[n]) != -1) {
                    throw new NIParameterInvalidServerException(2, (Object)nIVolumeIDArray, "Duplicate volume supplied: " + nIVolumeIDArray[n]);
                }
                this.volumeList.add(nIVolumeIDArray[n]);
                ++n;
            }
            int n2 = 256 - nIVolumeIDArray.length;
            int n3 = 0;
            while (n3 < n2) {
                this.volumeList.add(null);
                ++n3;
            }
        } else {
            throw new NIParameterInvalidServerException(2, (Object)nIVolumeIDArray, "Number of volumes supplied, " + nIVolumeIDArray.length + ", is greater than max allowed");
        }
    }

    public synchronized int add(NIVolumeID nIVolumeID) {
        int n = 1;
        if (this.size() < 256) {
            if (nIVolumeID != null) {
                if (this.volumeList.indexOf(nIVolumeID) == -1) {
                    int n2 = this.volumeList.indexOf(null);
                    this.volumeList.setElementAt(nIVolumeID, n2);
                }
            } else {
                n = 3;
            }
        } else {
            n = 2;
        }
        return n;
    }

    public synchronized boolean remove(NIVolumeID nIVolumeID) {
        boolean bl = true;
        if (nIVolumeID != null) {
            int n = this.volumeList.indexOf(nIVolumeID);
            if (n >= 0) {
                this.volumeList.setElementAt(null, n);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized boolean contains(NIVolumeID nIVolumeID) {
        boolean bl = false;
        if (nIVolumeID != null) {
            bl = this.volumeList.contains(nIVolumeID);
        }
        return bl;
    }

    public synchronized int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.volumeList.size()) {
            if (this.volumeList.get(n2) != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public synchronized void compressMap() {
        int n = this.volumeList.size() - 1;
        while (n >= 0) {
            if (this.volumeList.get(n) == null) {
                this.volumeList.remove(n);
            }
            --n;
        }
        int n2 = 256 - this.volumeList.size();
        int n3 = 0;
        while (n3 < n2) {
            this.volumeList.add(null);
            ++n3;
        }
    }

    public synchronized Vector getMapContents() {
        return (Vector)this.volumeList.clone();
    }

    public synchronized Vector getVolumesInVolumeGroup() {
        Vector vector = new Vector(this.size());
        int n = 0;
        while (n < this.volumeList.size()) {
            Object e = this.volumeList.get(n);
            if (e != null) {
                vector.add(e);
            }
            ++n;
        }
        return vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NIVolumeGroupMapImpl: [");
        stringBuffer.append(super.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

