/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.resource;

import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.option.config.NIDataType;
import com.ibm.storage.ess.ni.option.config.NIDataType3380;
import com.ibm.storage.ess.ni.option.config.NIDataType3390;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock512;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Protected;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Unprotected;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFBOddBlockSize;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeUnknown;
import com.ibm.storage.ess.ni.option.config.NIVolumeType;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDBase;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDCrossCUAlias;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDMap;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDSingleCuAlias;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockBase;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockMap;
import com.ibm.storage.ess.ni.resource.NIResourceImpl;
import java.lang.reflect.Field;

public class NIVolumeImpl
extends NIResourceImpl
implements NIVolume {
    private static final long serialVersionUID = -6646813712080054066L;
    private static final long MAX_VOL_CAPACITY_503 = (long)Math.pow(2.0, 32.0);
    private static final long MIN_VOL_CAPACITY = 1L;
    protected NIVolumeID baseVolume;
    protected String userName;
    protected NIVolumeID originalBaseVolumeID;
    protected NIAddressGroupID addressGroup;
    protected NIVolumeGroupID aliasMapVolumeGroup;
    protected NIExtentPoolID extentPool;
    protected boolean alias;
    protected NIVolumeType volumeType;
    protected NIDataType dataType;
    protected long capacity;
    protected int mtm;
    protected int accessState;
    protected int dataState;
    protected int configState;
    protected NIDeviceType deviceType = null;
    protected int writeCacheMode;
    protected long errorCode;

    public NIVolumeImpl(NIVolumeID nIVolumeID, String string, NIVolumeID nIVolumeID2, NIAddressGroupID nIAddressGroupID, NIVolumeGroupID nIVolumeGroupID, NIExtentPoolID nIExtentPoolID, boolean bl, NIVolumeType nIVolumeType, NIDataType nIDataType, long l, int n, int n2, int n3, int n4) {
        this.baseVolume = nIVolumeID;
        this.userName = string;
        this.originalBaseVolumeID = nIVolumeID2;
        this.addressGroup = nIAddressGroupID;
        this.aliasMapVolumeGroup = nIVolumeGroupID;
        this.extentPool = nIExtentPoolID;
        this.alias = bl;
        this.volumeType = nIVolumeType;
        this.dataType = nIDataType;
        this.capacity = l;
        this.mtm = n;
        this.accessState = n2;
        this.dataState = n3;
        this.configState = n4;
        this.writeCacheMode = 0;
        this.determineDeviceType();
        this.checkVolSizeRange();
    }

    private void checkVolSizeRange() {
        if (this.deviceType instanceof NIDeviceTypeFB) {
            if (this.capacity < 1L) {
                this.addChangedMethod("volSizeTooSmall");
                this.deviceType = NIDeviceTypeFBOddBlockSize.Option;
            } else if (this.capacity > MAX_VOL_CAPACITY_503) {
                this.addChangedMethod("volSizeTooLarge503");
                this.deviceType = NIDeviceTypeFBOddBlockSize.Option;
            }
        }
    }

    public NIVolumeImpl() {
    }

    public NIVolumeImpl(NIVolumeID nIVolumeID, String string, NIVolumeID nIVolumeID2, NIAddressGroupID nIAddressGroupID, NIVolumeGroupID nIVolumeGroupID, NIExtentPoolID nIExtentPoolID, boolean bl, NIVolumeType nIVolumeType, NIDataType nIDataType, long l, int n, int n2, int n3, int n4, int n5) {
        this(nIVolumeID, string, nIVolumeID2, nIAddressGroupID, nIVolumeGroupID, nIExtentPoolID, bl, nIVolumeType, nIDataType, l, n, n2, n3, n4);
        this.writeCacheMode = n5;
    }

    private void determineDeviceType() {
        this.deviceType = this.dataType instanceof NIDataType3380 || this.dataType instanceof NIDataType3390 ? NIDeviceTypeCKD.Option : (this.dataType instanceof NIDataTypeBlock512 || this.dataType instanceof NIDataTypeBlock520Protected || this.dataType instanceof NIDataTypeBlock520Unprotected ? ((this.capacity + 63L) / 64L % 2L == 1L ? NIDeviceTypeFBOddBlockSize.Option : NIDeviceTypeFB.Option) : NIDeviceTypeUnknown.Option);
    }

    public NIResourceID getID() {
        return this.baseVolume;
    }

    public String getUserName() {
        return this.userName;
    }

    public NIVolumeID getOriginalBaseVolumeID() {
        return this.originalBaseVolumeID;
    }

    public String getSerialNumber() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.baseVolume.getESS().toString();
        String string2 = Integer.toHexString(this.baseVolume.getLSS().getLSSNumber()).toUpperCase();
        String string3 = Integer.toHexString(this.baseVolume.getVolNumber()).toUpperCase();
        stringBuffer.append(string).append("/");
        stringBuffer.append(string2.length() < 2 ? "0" + string2 : string2);
        stringBuffer.append(string3.length() < 2 ? "0" + string3 : string3);
        return stringBuffer.toString();
    }

    public NIAddressGroupID getAddressGroup() {
        return this.addressGroup;
    }

    public NIDeviceType getDeviceType() {
        if (this.deviceType == null) {
            this.determineDeviceType();
        }
        return this.deviceType;
    }

    public NIVolumeGroupID getAliasMapVolumeGroup() {
        return this.aliasMapVolumeGroup;
    }

    public NIExtentPoolID getExtentPool() {
        return this.extentPool;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public NIVolumeType getVolumeType() {
        return this.volumeType;
    }

    public NIDataType getDataType() {
        return this.dataType;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public int getMTM() {
        return this.mtm;
    }

    public int getAccessState() {
        return this.accessState;
    }

    public int getDataState() {
        return this.dataState;
    }

    public int getConfigState() {
        return this.configState;
    }

    public void setUserName(String string) {
        this.addChangedMethod("setUserName");
        this.userName = string;
    }

    public void setOriginalBaseVolumeID(NIVolumeID nIVolumeID) {
        this.addChangedMethod("setOriginalBaseVolumeID");
        this.originalBaseVolumeID = nIVolumeID;
    }

    public void setExtentPool(NIExtentPoolID nIExtentPoolID) {
        this.addChangedMethod("setExtentPool");
        this.extentPool = nIExtentPoolID;
    }

    public void setVolumeType(NIVolumeType nIVolumeType) {
        this.addChangedMethod("setVolumeType");
        this.volumeType = nIVolumeType;
    }

    public void setDataType(NIDataType nIDataType) {
        this.addChangedMethod("setDataType");
        this.dataType = nIDataType;
    }

    public void setID(NIResourceID nIResourceID) {
        this.baseVolume = (NIVolumeID)nIResourceID;
    }

    public void setAddressGroup(NIAddressGroupID nIAddressGroupID) {
        this.addChangedMethod("setAddressGroup");
        this.addressGroup = nIAddressGroupID;
    }

    public void setAliasMapVolumeGroup(NIVolumeGroupID nIVolumeGroupID) {
        this.addChangedMethod("setAliasMapVolumeGroup");
        this.aliasMapVolumeGroup = nIVolumeGroupID;
    }

    public void setAlias(boolean bl) {
        this.addChangedMethod("setAlias");
        this.alias = bl;
    }

    public void setCapacity(long l) {
        this.addChangedMethod("setCapacity");
        this.capacity = l;
        this.checkVolSizeRange();
    }

    public void setMTM(int n) {
        this.addChangedMethod("setMTM");
        this.mtm = n;
    }

    public void setAccessState(int n) {
        this.addChangedMethod("setAccessState");
        this.accessState = n;
    }

    public void setDataState(int n) {
        this.addChangedMethod("setDataState");
        this.dataState = n;
    }

    public void setConfigState(int n) {
        this.addChangedMethod("setConfigState");
        this.configState = n;
    }

    public int getWriteCacheMode() {
        return this.writeCacheMode;
    }

    public void setWriteCacheMode(int n) {
        this.addChangedMethod("setWriteCacheMode");
        this.writeCacheMode = n;
    }

    public int getErrorCode() {
        return (int)this.errorCode;
    }

    public void setErrorCode(long l) {
        this.errorCode = l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NIVolume: [");
        stringBuffer.append("id = " + this.baseVolume + ", ");
        stringBuffer.append("userName = " + this.userName + ", ");
        stringBuffer.append("originalBaseVolumeID = " + this.originalBaseVolumeID + ", ");
        stringBuffer.append("volumeSerialNumber = " + this.getSerialNumber() + ", ");
        stringBuffer.append("addressGroup = " + this.addressGroup + ", ");
        stringBuffer.append("aliasMapVolumeGroup = " + this.aliasMapVolumeGroup + ", ");
        stringBuffer.append("extentPool = " + this.extentPool + ", ");
        stringBuffer.append("alias = " + this.alias + ", ");
        stringBuffer.append("volumeType = " + this.volumeType + ", ");
        stringBuffer.append("dataType = " + this.dataType + ", ");
        stringBuffer.append("capacity = " + this.capacity + ", ");
        stringBuffer.append("mtm = " + this.mtm + ", ");
        stringBuffer.append("accessState = " + this.accessState + ", ");
        stringBuffer.append("dataState = " + this.dataState + ", ");
        stringBuffer.append("configState = " + this.configState + ", ");
        stringBuffer.append("writeCacheMode = " + this.writeCacheMode + ", ");
        stringBuffer.append("errorCode = " + this.errorCode + "] ");
        return stringBuffer.toString();
    }

    public String toXml() {
        Class<?> clazz = this.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        Object object = "";
        String string = "<Volume ";
        int n = 0;
        while (n < fieldArray.length) {
            try {
                if (!fieldArray[n].getType().isArray() && (fieldArray[n].isAccessible() || fieldArray[n].getName() != "serialVersionUID")) {
                    object = fieldArray[n].get(this);
                    if (object instanceof NIVolumeID) {
                        if (fieldArray[n].getName().equals("baseVolume")) {
                            int n2 = ((NIVolumeID)object).getVolNumber();
                            string = string + "number=\"" + n2 + "\" ";
                            NILSSID nILSSID = ((NIVolumeID)object).getLSS();
                            int n3 = nILSSID.getLSSNumber();
                            string = string + "lssNumber=\"" + n3 + "\" ";
                        } else if (fieldArray[n].getName().equals("originalBaseVolumeID")) {
                            int n4 = ((NIVolumeID)object).getVolNumber();
                            string = string + "baseVolumeNumber=\"" + n4 + "\" ";
                        }
                    } else if (object instanceof NIDataType) {
                        String string2 = "";
                        if (object instanceof NIDataTypeBlock520Unprotected) {
                            string2 = "520Unprotected";
                        } else if (object instanceof NIDataTypeBlock520Protected) {
                            string2 = "520Protected";
                        } else if (object instanceof NIDataTypeBlock512) {
                            string2 = "512";
                        } else if (object instanceof NIDataType3390) {
                            string2 = "3390";
                        } else if (object instanceof NIDataType3380) {
                            string2 = "3380";
                        }
                        string = string + fieldArray[n].getName() + "=\"";
                        string = string + string2 + "\" ";
                    } else if (object instanceof NIVolumeType) {
                        String string3 = "";
                        if (object instanceof NIVolumeTypeFixedBlockMap) {
                            string3 = "FBMap";
                        } else if (object instanceof NIVolumeTypeFixedBlockBase) {
                            string3 = "FBBase";
                        } else if (object instanceof NIVolumeTypeCKDMap) {
                            string3 = "CKDMap";
                        } else if (object instanceof NIVolumeTypeCKDSingleCuAlias) {
                            string3 = "CKDSingleCUAlias";
                        } else if (object instanceof NIVolumeTypeCKDCrossCUAlias) {
                            string3 = "CKDCrossCUAlias";
                        } else if (object instanceof NIVolumeTypeCKDBase) {
                            string3 = "CKDBase";
                        }
                        string = string + "volumeType=\"";
                        string = string + string3 + "\" ";
                    } else if (object instanceof NIAddressGroupID) {
                        int n5 = ((NIAddressGroupID)object).getAddressGroupNumber();
                        string = string + "addressGroupNumber=\"" + n5 + "\" ";
                    } else if (object instanceof NIExtentPoolID) {
                        int n6 = ((NIExtentPoolID)object).getExtentPoolNumber();
                        string = string + "extentPoolNumber=\"" + n6 + "\" ";
                    } else if (!(object instanceof NIDeviceType) && !(object instanceof NIVolumeGroupID) && object != null) {
                        string = string + fieldArray[n].getName();
                        string = object.toString().equals("-1") ? string + "=\"\" " : string + "=\"" + object.toString() + "\" ";
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                string = string + fieldArray[n].getName();
                string = string + "=\"\" ";
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println(illegalAccessException.toString());
            }
            ++n;
        }
        string = string + "/>";
        return string;
    }

    public boolean isCapacityValid() {
        return this.alias || this.capacity >= 1L && this.capacity <= MAX_VOL_CAPACITY_503;
    }
}

