/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.results;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.results.NIXDCOutOfSyncStatus;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.identifiers.NISessionID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NIXDCResultImpl;
import com.ibm.storage.ess.ni.util.NIByteArray;
import java.io.Serializable;

public class NIXDCOutOfSyncStatusImpl
extends NIXDCResultImpl
implements NIXDCOutOfSyncStatus,
Serializable {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$results$NIXDCOutOfSyncStatusImpl == null ? (class$com$ibm$storage$ess$ni$results$NIXDCOutOfSyncStatusImpl = NIXDCOutOfSyncStatusImpl.class$("com.ibm.storage.ess.ni.results.NIXDCOutOfSyncStatusImpl")) : class$com$ibm$storage$ess$ni$results$NIXDCOutOfSyncStatusImpl);
    private static final long serialVersionUID = 1L;
    private int[] rawData = null;
    private byte[] actualRawData;
    private NIByteArray byteArray;
    private int byteDataLength = 0;
    private boolean dataAvailable = false;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$results$NIXDCOutOfSyncStatusImpl;

    public NIXDCOutOfSyncStatusImpl(byte[] byArray, long l) {
        super(l == 0L, l);
        this.actualRawData = byArray;
        this.byteDataLength = this.actualRawData.length;
        if (this.byteDataLength > 0 && l == 0L) {
            this.dataAvailable = true;
            this.byteArray = new NIByteArray(this.actualRawData);
        }
    }

    public void updateFrom2105Data() {
        if (this.rawData != null) {
            this.actualRawData = new byte[this.rawData.length * 4];
            int n = 0;
            int n2 = 0;
            while (n < this.rawData.length) {
                this.actualRawData[n2++] = (byte)((this.rawData[n] & 0xFF000000) >>> 24);
                this.actualRawData[n2++] = (byte)((this.rawData[n] & 0xFF0000) >>> 16);
                this.actualRawData[n2++] = (byte)((this.rawData[n] & 0xFF00) >>> 8);
                this.actualRawData[n2++] = (byte)(this.rawData[n] & 0xFF);
                ++n;
            }
            this.rawData = null;
            this.byteDataLength = this.actualRawData.length;
            if (this.byteDataLength > 0 && this.getCode() == 0) {
                this.byteArray = new NIByteArray(this.actualRawData);
                this.dataAvailable = true;
            }
        }
    }

    public byte[] getRawData() {
        return this.actualRawData;
    }

    public boolean allOOSBitmapsForAllVolumesAreZero() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(0, 0);
        }
        return true;
    }

    public boolean sessionIsTimedOutOrIncorrectState() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(0, 1);
        }
        return false;
    }

    public boolean dataIsInaccessible() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(0, 4);
        }
        return true;
    }

    public boolean rcForVolumesSuspendedSimplexEtc() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(1, 0);
        }
        return false;
    }

    public boolean rcForCannotActivateChgRecording() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(1, 1);
        }
        return false;
    }

    public boolean rcForVolumesInaccessibleOfflineEtc() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(1, 2);
        }
        return false;
    }

    public boolean rcForIncorrectStateFromWriteSameEtc() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(1, 3);
        }
        return false;
    }

    public NISessionID getSessionID() {
        int n = this.byteArray.getByteAsInt(5);
        NISessionID nISessionID = null;
        try {
            nISessionID = new NISessionID(64, n);
        }
        catch (NIParameterInvalidServerException nIParameterInvalidServerException) {
            logger.throwable((Throwable)nIParameterInvalidServerException);
        }
        return nISessionID;
    }

    public int getNumVolumesWithoutZeroedBitmapForOOS() {
        return this.byteArray.getIntValueFromBytes(6, 7);
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("XDC Out of Sync State, x4B: \n");
            stringBuffer.append(super.toString() + "\n");
            if (this.dataAvailable) {
                stringBuffer.append("Flag Byte 0: 0x" + Integer.toHexString(0xFF & this.byteArray.extractByte(0)) + " \n");
                if (!this.dataIsInaccessible()) {
                    if (this.sessionIsTimedOutOrIncorrectState()) {
                        stringBuffer.append("Reason code for error condition: 0x" + Integer.toHexString(0xFF & this.byteArray.extractByte(1)) + " \n");
                    }
                    stringBuffer.append(this.getSessionID() + "\n");
                    stringBuffer.append("Volumes with non-zero OOS bitmaps: " + this.byteArray.getIntValueFromBytes(6, 7) + " \n");
                }
            } else {
                stringBuffer.append("No rawData available or query is not successful");
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            return "ERROR";
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

