/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.sa;

import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.option.NICodeLoadOption;
import com.ibm.storage.ess.ni.sa.NISACodeLoad;
import com.ibm.storage.ess.ni.sa.NISAInvalidParameterException;
import com.ibm.storage.ess.ni.sa.NISAMonitor;
import com.ibm.storage.ess.ni.sa.NISAResult;
import com.ibm.storage.ess.ni.sa.NISAUtilities;
import java.net.InetAddress;

public class NISACodeLoadStatus {
    private NISACodeLoad codeLoad;
    private NIESSID essid;
    private InetAddress konaIp;
    private NISAResult codeLoadResult = null;
    private int progress = 0;
    private String clReport = null;
    private int percents;
    private NISAMonitor monitor;

    public NISACodeLoadStatus(NISACodeLoad nISACodeLoad) {
        this.codeLoad = nISACodeLoad;
    }

    public NISACodeLoadStatus(NIESSID nIESSID, InetAddress inetAddress) throws NISAInvalidParameterException {
        NISAUtilities.getLog().info("NISACodeLoadStatus() - start essid=" + nIESSID + " ip=" + inetAddress.getHostAddress());
        if (!NISAUtilities.isMatchIpId(nIESSID, inetAddress)) {
            NISAUtilities.getLog().warning("NISACodeLoadStatus() - essid not belong to this ip");
            throw new NISAInvalidParameterException("essid=" + nIESSID + " not belong to ip=" + inetAddress.getHostAddress());
        }
        this.essid = nIESSID;
        this.konaIp = inetAddress;
        this.monitor = new NISAMonitor();
        NISAUtilities.getLog().info("NISACodeLoadStatus() - created");
    }

    public NISAResult updateCodeLoadStatuse(NICodeLoadOption nICodeLoadOption) {
        NISAUtilities.getLog().info("updateCodeLoadStatuse() - start codeLoadOption=" + nICodeLoadOption.toString());
        String[] stringArray = null;
        String string = null != this.codeLoad ? this.codeLoad.getClStatLine() : new NISAMonitor().clState(this.konaIp);
        String[] stringArray2 = null == string ? null : (stringArray = string.split("\\s").length < 3 ? null : string.split("\\s"));
        if (null == stringArray) {
            NISAUtilities.getLog().warning("updateCodeLoadStatuse() - can't get cl report or the split report missing required fields, RC=" + Integer.toHexString(-1098383300));
            return new NISAResult(false, -1098383300);
        }
        try {
            this.percents = Integer.valueOf(stringArray[1]);
            this.progress = Integer.valueOf(stringArray[2]);
            this.codeLoadResult = 0 < this.progress ? null : (0 == this.progress ? new NISAResult(true, 0) : new NISACodeLoad().convert2saresult(string, this.progress, nICodeLoadOption));
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("updateCodeLoadStatuse() - can't parse clSplitReport, \nRC=" + Integer.toHexString(-1098383300) + " exception: \n" + NISAUtilities.getExceptionStackTrace(exception));
            return new NISAResult(false, -1098383300);
        }
        NISAUtilities.getLog().info("updateCodeLoadStatuse() - finish OK");
        return new NISAResult(true, 0);
    }

    public int getPercentComplete() {
        if (null != this.codeLoad) {
            return this.codeLoad.getPercentComplete();
        }
        return this.percents;
    }

    public boolean isCodeLoadFailed() {
        if (null != this.codeLoad) {
            return this.codeLoad.isCodeLoadFailed();
        }
        return this.progress < 0;
    }

    public NISAResult getCodeLoadResult() {
        return this.codeLoadResult;
    }

    public String isCodeLoadActive() {
        if (null != this.codeLoad) {
            return this.codeLoad.getClProgress() > 0 ? "yes" : "no";
        }
        return this.monitor.isCodeLoadActive(this.konaIp);
    }
}

