/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.sa;

import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.sa.NISAMonitor;
import com.ibm.storage.ess.ni.sa.NISAResult;
import com.ibm.storage.ess.ni.sa.NISAUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;

public class NISAGuestCmd {
    public NISAResult reboot(NIESSID nIESSID, InetAddress inetAddress, String string, boolean bl) {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("reboot essid=" + nIESSID + " IP=" + inetAddress.getHostAddress() + " dual=" + bl);
        int n = this.isMatchIpId(nIESSID, inetAddress) ? this.execGuestCmd("rootcmd reboot " + (bl ? "-d" : "-s"), string, inetAddress) : -1098383307;
        n = this.convertResult(n, "reboot");
        NISAUtilities.getLog().info("reboot finish: rc=" + Integer.toHexString(n));
        return new NISAResult(0 == n, n);
    }

    public NISAResult cst(NIESSID nIESSID, InetAddress inetAddress, String string) {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("cst start: essid=" + nIESSID + " IP=" + inetAddress.getHostAddress());
        int n = this.isMatchIpId(nIESSID, inetAddress) ? this.execGuestCmd("rootcmd cst -f", string, inetAddress) : -1098383307;
        n = this.convertResult(n, "cst");
        NISAUtilities.getLog().info("cst finish: rc=" + Integer.toHexString(n));
        return new NISAResult(0 == n, n);
    }

    public NISAResult activateSM(NIESSID nIESSID, InetAddress inetAddress, String string) {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("activateSM start: essid=" + nIESSID + " IP=" + inetAddress.getHostAddress());
        int n = this.isMatchIpId(nIESSID, inetAddress) ? this.execGuestCmd("rootcmd activateSM", string, inetAddress) : -1098383307;
        n = this.convertResult(n, "activateSM");
        NISAUtilities.getLog().info("activateSM finish: rc=" + Integer.toHexString(n));
        return new NISAResult(0 == n, n);
    }

    public NISAResult fbs(NIESSID nIESSID, InetAddress inetAddress, String string) {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("fbs start: essid=" + nIESSID + " IP=" + inetAddress.getHostAddress());
        int n = this.isMatchIpId(nIESSID, inetAddress) ? this.execGuestCmd("rootcmd fbs", string, inetAddress) : -1098383307;
        n = this.convertResult(n, "fbs");
        NISAUtilities.getLog().info("fbs finish: rc=" + Integer.toHexString(n));
        return new NISAResult(0 == n, n);
    }

    protected NISAResult test(NIESSID nIESSID, InetAddress inetAddress, String string) {
        NISAUtilities.getLog().info("test IP=" + inetAddress.getHostAddress());
        int n = this.execGuestCmd("rootcmd test", string, inetAddress);
        if (0 != n) {
            n = this.convertResult(n, "test");
        }
        return new NISAResult(0 == n, n);
    }

    private int execGuestCmd(String string, String string2, InetAddress inetAddress) {
        NISAUtilities.getLog().info("execRootCmd() - Start: cmd=" + string + " IP=" + inetAddress.getHostAddress());
        String string3 = null;
        String string4 = null;
        String string5 = NISAUtilities.getProperty("SCP_RESPONSE");
        int n = 0;
        File file = null;
        try {
            file = new File(NISAUtilities.getEnvVariable(NISAUtilities.getProperty("REEF_TEMP_DIR_ENV_NAME")) + File.separator + "guestResOutput");
        }
        catch (IOException iOException) {
            NISAUtilities.getLog().warning("execGuestCmd() - fail to create redirect file " + file + " \n the Exception is:\n" + NISAUtilities.getExceptionStackTrace(iOException));
            n = -1098383358;
        }
        File file2 = null;
        File file3 = null;
        if (NISAUtilities.winOs()) {
            string3 = NISAUtilities.getProperty("SSH_TO_REEF_WIN_CMD");
            string4 = "guest@" + inetAddress.getHostAddress() + " -pw " + string2 + " " + string;
            file3 = file;
        } else if (NISAUtilities.linuxOs()) {
            string3 = NISAUtilities.getProperty("SSH_TO_REEF_LNX_CMD");
            string4 = string2 + " guest@" + inetAddress.getHostAddress() + " " + string;
            file2 = file;
        } else {
            n = -1098383350;
        }
        if (0 == n) {
            NISAUtilities.getLog().info("execGuestCmd() -  sshScript=" + string3 + "; sshParm=" + string4);
            n = NISAUtilities.sysExec(string3, string4, string5, file2, file3);
            if (0 != n) {
                NISAUtilities.getLog().warning("execGuestCmd() - Fail, check the pswd");
                try {
                    if (this.isWrongPswd(file)) {
                        NISAUtilities.getLog().warning("execGuestCmd() - wrong pswd");
                        n = -1098383295;
                    }
                }
                catch (IOException iOException) {
                    NISAUtilities.getLog().warning("execGuestCmd() - can't read resFile\n the exception is:\n " + NISAUtilities.getExceptionStackTrace(iOException));
                    n = -1098383358;
                }
            }
        }
        NISAUtilities.getLog().info("execGuestCmd() - success del sdtErr file = " + file.delete());
        NISAUtilities.getLog().info("execGuestCmd() - Finish rc=" + n);
        return n;
    }

    private boolean isWrongPswd(File file) throws IOException {
        String string;
        NISAUtilities.getLog().info("isWrongPswd() - start outputFile=" + file);
        boolean bl = false;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string2 = NISAUtilities.winOs() ? "Access denied.*" : "Permission denied.*";
        while (null != (string = bufferedReader.readLine())) {
            if (!string.matches(string2)) continue;
            NISAUtilities.getLog().warning("isWrongPswd() - wrong pswd");
            bl = true;
            break;
        }
        NISAUtilities.getLog().info("isWrongPswd() - not pswd problem");
        bufferedReader.close();
        return bl;
    }

    private int convertResult(int n, String string) {
        NISAUtilities.getLog().info("convertResult() - rc=" + n + " cmd=" + string);
        int n2 = n;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: 
            case 127: {
                n2 = NISAResult.REASON_FAILURE_COMMAND_NOT_FOUND;
                break;
            }
            case 5: {
                if (!string.equals("cst") && !string.equals("reboot")) break;
                n2 = NISAResult.REASON_FAILURE_QUIESCE;
                break;
            }
            case 51: {
                if (!string.equals("cst") && !string.equals("reboot")) break;
                n2 = -1098383294;
                break;
            }
            case 7: 
            case 8: {
                if (!string.equals("cst")) break;
                n2 = -1098383303;
                break;
            }
            case 20: {
                n2 = -1098383306;
                break;
            }
            case -1098383358: 
            case -1098383350: 
            case -1098383307: 
            case -1098383295: {
                n2 = n;
                break;
            }
            default: {
                n2 = -1098383344;
            }
        }
        NISAUtilities.getLog().info("convertResult() - new rc=" + Integer.toHexString(n2));
        return n2;
    }

    private boolean isMatchIpId(NIESSID nIESSID, InetAddress inetAddress) {
        String string = new NISAMonitor().getSerialNum(inetAddress);
        if (null != string && null != nIESSID && nIESSID.toString().matches(".*" + string)) {
            return true;
        }
        NISAUtilities.getLog().warning("isMatchIpId() - unMatch boxSerial=" + string + " cmdSerial=" + nIESSID);
        return false;
    }
}

