/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.sa;

import com.ibm.storage.ess.ni.sa.NISAUtilities;
import java.net.InetAddress;

public class NISAMonitor {
    protected String queryResult;
    protected static final String QUERY_DATE = "bdate";
    protected static final String QUERY_FILESTAT = "fstat ";
    protected static final String QUERY_SERIALNUM = "serialnum";
    protected static final String QUERY_MD5SUM = "md5sum ";
    protected static final String QUERY_CLSTAT = "";
    protected static final String QUERY_CLACTIVE = "isclactive";
    protected static final String QUERY_DFPERSIST = "dfpersist";

    protected String clState(InetAddress inetAddress) {
        this.getClQuery(QUERY_CLSTAT, inetAddress, false, "CL_STAT_REPORT");
        return this.queryResult;
    }

    protected String isCodeLoadActive(InetAddress inetAddress) {
        String string = "CL_ACTIVE";
        this.getClQuery(QUERY_CLACTIVE, inetAddress, false, string);
        String string2 = this.queryResult;
        return null == string2 ? null : (string2.substring(string.length() + 1).matches("no") ? "no" : "yes");
    }

    protected String getSerialNum(InetAddress inetAddress) {
        String string = "SERIAL_NUM";
        this.getClQuery(QUERY_SERIALNUM, inetAddress, false, string);
        String string2 = this.queryResult;
        return null == string2 ? null : string2.substring(string.length() + 1);
    }

    protected String date(InetAddress inetAddress) {
        String string = "DATE";
        this.getClQuery(QUERY_DATE, inetAddress, false, string);
        String string2 = this.queryResult;
        return null == string2 ? null : string2.substring(string.length() + 1);
    }

    protected String pDate(InetAddress inetAddress) {
        String string = "DATE";
        this.getClQuery(QUERY_DATE, inetAddress, true, string);
        String string2 = this.queryResult;
        return null == string2 ? null : string2.substring(string.length() + 1);
    }

    protected String md5sum(String string, InetAddress inetAddress) {
        String string2 = "MD5SUM";
        this.getClQuery(QUERY_MD5SUM + string, inetAddress, false, string2);
        String string3 = this.queryResult;
        return null == string3 ? null : string3.substring(string2.length() + 1, string3.indexOf(string) - 1);
    }

    protected String fileStat(String string, InetAddress inetAddress) {
        String string2 = "FSTAT";
        this.getClQuery(QUERY_FILESTAT + string, inetAddress, false, string2);
        String string3 = this.queryResult;
        return null == string3 ? null : string3.substring(string2.length() + 1);
    }

    protected long dfPersist(InetAddress inetAddress) {
        long l;
        NISAUtilities.getLog().info("dfPersist(): Start kona=" + inetAddress.getHostAddress());
        this.getClQuery(QUERY_DFPERSIST, inetAddress, false, "DF_PERSIST");
        String string = this.queryResult;
        try {
            l = null != string ? Long.parseLong(string.split(" ")[4]) : -1L;
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("dfPersist(): Exception: \n" + NISAUtilities.getExceptionStackTrace(exception));
            l = -1L;
        }
        NISAUtilities.getLog().info("dfPersist(): Finish return_value=" + l);
        return l;
    }

    protected void getClQuery(String string, InetAddress inetAddress, boolean bl, String string2) {
        String string3;
        NISAUtilities.getLog().info("getClQuery() start - query=" + string + " IP=" + inetAddress.getHostAddress() + " parallel=" + bl);
        this.queryResult = null;
        String string4 = NISAUtilities.getProperty("SCP_RESPONSE");
        String string5 = "cl cl@" + inetAddress.getHostAddress() + " " + string;
        if (NISAUtilities.winOs()) {
            string3 = NISAUtilities.getProperty("SSH_TO_REEF_WIN_CMD");
            string5 = "-pw " + string5;
        } else if (NISAUtilities.linuxOs()) {
            string3 = NISAUtilities.getProperty("SSH_TO_REEF_LNX_CMD");
        } else {
            NISAUtilities.getLog().warning("getClQuery() fail - unknown Operation System - queryResult = null");
            return;
        }
        RunQueryWithTimeout runQueryWithTimeout = new RunQueryWithTimeout(string3, string5, string4, 900000L, string2);
        runQueryWithTimeout.start();
        NISAUtilities.getLog().info("getClQuery() - send command to RunQueryWithTimeout thread");
        if (bl) {
            NISAUtilities.getLog().info("getClQuery() - parallel, exit without wait for the thread");
            return;
        }
        try {
            runQueryWithTimeout.join();
        }
        catch (InterruptedException interruptedException) {
            NISAUtilities.getLog().warning("getClQuery() - RunQueryWithTimeout inturrupted. the Exception is: \n" + NISAUtilities.getExceptionStackTrace(interruptedException));
        }
        NISAUtilities.getLog().info("getClQuery() - sequence mode finish");
    }

    private class RunQuery
    extends Thread {
        private String command;
        private String args;
        private String response;
        private String header;

        public RunQuery(String string, String string2, String string3, String string4) {
            this.command = string;
            this.args = string2;
            this.response = string3;
            this.header = string4;
        }

        public void run() {
            NISAUtilities.getLog().info("RunQuery - start to run");
            try {
                NISAMonitor.this.queryResult = NISAUtilities.getExecOutput(this.command, this.args, this.response, this.header);
                NISAUtilities.getLog().info("RunQuery - finish");
            }
            catch (Exception exception) {
                NISAUtilities.getLog().warning("RunQuery - Exception: \n" + NISAUtilities.getExceptionStackTrace(exception));
                return;
            }
        }
    }

    private class RunQueryWithTimeout
    extends Thread {
        private String command;
        private String args;
        private String response;
        private String header;
        private long timeout;

        public RunQueryWithTimeout(String string, String string2, String string3, long l, String string4) {
            this.command = string;
            this.args = string2;
            this.response = string3;
            this.timeout = l;
            this.header = string4;
            NISAMonitor.this.queryResult = null;
        }

        public void run() {
            block3: {
                RunQuery runQuery = new RunQuery(this.command, this.args, this.response, this.header);
                runQuery.start();
                NISAUtilities.getLog().info("ParallelQuery - sent start to runQuery, timeout=" + this.timeout);
                try {
                    runQuery.join(this.timeout);
                    if (runQuery.isAlive()) {
                        NISAUtilities.getLog().warning("ParallelQuery - timeout on RunQuery, kill it");
                        runQuery.interrupt();
                        break block3;
                    }
                    NISAUtilities.getLog().info("\n clQuery result from REEF = " + NISAMonitor.this.queryResult);
                }
                catch (InterruptedException interruptedException) {
                    NISAUtilities.getLog().warning("ParallelQuery - Exception: \n" + NISAUtilities.getExceptionStackTrace(interruptedException));
                }
            }
        }
    }
}

