/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.sa;

import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.application.results.NIPEPackageResult;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.option.NIKonaLeft;
import com.ibm.storage.ess.ni.option.NIKonaOption;
import com.ibm.storage.ess.ni.option.NIKonaRight;
import com.ibm.storage.ess.ni.sa.NISAMonitor;
import com.ibm.storage.ess.ni.sa.NISAResult;
import com.ibm.storage.ess.ni.sa.NISAUtilities;
import com.ibm.storage.ess.ni.services.NITraceService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;

public class NISAStatesave {
    private NITraceService trServise;

    public NISAResult copyAll(NIServices nIServices, NIESSID nIESSID) {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("copyAll() - Starat. essId=" + nIESSID);
        File file = NISAUtilities.getSend2IBMDir();
        if (null == file) {
            NISAUtilities.getLog().warning("copyAll() - fail to getthe send2IBM dir ");
            return new NISAResult(false, -1098383325);
        }
        NISAResult nISAResult = this.copyAll(nIServices, nIESSID, file);
        NISAUtilities.getLog().info("copyAll() - Finish, successful= " + nISAResult.getCode() + "\n");
        return nISAResult;
    }

    public NISAResult copyAll(NIServices nIServices, NIESSID nIESSID, File file) {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("NISAStatesave.copyAll() Start: destinationDir = " + file);
        NISAResult nISAResult = NISAUtilities.preCond(nIServices, nIESSID, file);
        if (!nISAResult.isSuccessful()) {
            NISAUtilities.getLog().warning("copyAll() - Fail preCond");
            return nISAResult;
        }
        String[] stringArray = nISAResult.getArray();
        try {
            new NISAMonitor().pDate(InetAddress.getByName(stringArray[0]));
        }
        catch (UnknownHostException unknownHostException) {
            NISAUtilities.getLog().warning("copyAll() - can't get the reef date.\n the Exception is: \n" + NISAUtilities.getExceptionStackTrace(unknownHostException));
        }
        this.trServise = nIServices.getTraceService();
        if (null == this.trServise) {
            NISAUtilities.getLog().warning("NISAStatesave.copyAll() - Fail to get NITraceService from essni connection");
            nISAResult.setCode(-1098383334);
            return nISAResult;
        }
        NISAUtilities.getLog().info("NISAStatesave.copyAll() - get TraceService - success");
        NISAResult[] nISAResultArray = new NISAResult[2];
        String[][] stringArrayArray = new String[2][];
        int[] nArray = new int[2];
        int n = 0;
        int n2 = 0;
        while (n2 < 2) {
            try {
                nISAResultArray[n2] = this.copySsFromKona(n2, stringArray[n2], file, nIESSID, nIServices);
                stringArrayArray[n2] = nISAResultArray[n2].getCopiedFiles();
                nArray[n2] = null == stringArrayArray[n2] ? 0 : stringArrayArray[n2].length;
                n += nArray[n2];
            }
            catch (Exception exception) {
                NISAUtilities.getLog().warning("copyAll() - Fail in kona " + n2 + " The Exception is: \n " + NISAUtilities.getExceptionStackTrace(exception) + "\n");
                nISAResultArray[n2].setCode(-1098383328);
            }
            ++n2;
        }
        if (!nISAResultArray[0].isSuccessful() && !nISAResultArray[1].isSuccessful()) {
            if (-1098383320 == nISAResultArray[0].getCode() && -1098383320 == nISAResultArray[1].getCode()) {
                NISAUtilities.getLog().warning("copyAll() - no SS in both konas ");
                return new NISAResult(false, -1098383320);
            }
            NISAUtilities.getLog().warning("copyAll() - Fail in both konas - no StateSave! \n");
            return new NISAResult(false, -1098383345);
        }
        String[] stringArray2 = new String[n];
        int n3 = 0;
        while (n3 < nArray[0]) {
            stringArray2[n3] = stringArrayArray[0][n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < nArray[1]) {
            stringArray2[n4 + nArray[0]] = stringArrayArray[1][n4];
            ++n4;
        }
        NISAUtilities.getLog().info("copyAll() finish - getCopiedFilesList - OK. cl0-" + nArray[0] + " cl1-" + nArray[0]);
        nISAResult.setCopiedFiles(stringArray2);
        if (nISAResultArray[0].isSuccessful() && !nISAResultArray[1].isSuccessful() && -1098383320 != nISAResultArray[1].getCode()) {
            nISAResult.setCode(-1098383321);
        } else if (!nISAResultArray[0].isSuccessful() && nISAResultArray[1].isSuccessful() && -1098383320 != nISAResultArray[1].getCode()) {
            nISAResult.setCode(-1098383322);
        } else {
            nISAResult.setSuccessful(true);
        }
        NISAUtilities.getLog().info("copyAll() - finish. RC0= " + nISAResultArray[0].getCode() + " RC1= " + nISAResultArray[1].getCode());
        return nISAResult;
    }

    private NISAResult copySsFromKona(int n, String string, File file, NIESSID nIESSID, NIServices nIServices) throws NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIServerException {
        NISAUtilities.getLog().info("\nNISAStatesave.copySsFromKona() - Start \n for kona-" + n + " konaIP=" + string + " destDir=" + file);
        NISAResult nISAResult = new NISAResult();
        String string2 = NISAUtilities.getPassword(nIESSID, nIServices, n);
        if (null == string2) {
            NISAUtilities.getLog().warning("copySsFromKona Fail to get password");
            return new NISAResult(false, -1098383343);
        }
        NISAUtilities.getLog().info("copySsFromKona finish get password - OK");
        NIKonaOption nIKonaOption = 0 == n ? NIKonaLeft.Option : NIKonaRight.Option;
        String string3 = null;
        NIPEPackageResult nIPEPackageResult = this.trServise.updateSSlist(nIESSID, nIKonaOption, 0);
        int n2 = nIPEPackageResult.getCode();
        switch (n2) {
            case 0: {
                string3 = NISAUtilities.getProperty("DA_SRC_SS_DIR");
                nISAResult = this.copySS(nIESSID, nIKonaOption, string, string3, string2, file, 0);
                break;
            }
            case -1099694075: {
                NISAUtilities.getLog().info("No new SS on DApart.");
                return new NISAResult(false, -1098383320);
            }
            default: {
                NISAUtilities.getLog().warning("Fail to updateDAsslist. " + (n2 == 2 ? "DApart not mounted" : (n2 == -1099694077 ? "script not found" : "unknows Error")));
                if (!this.trServise.updateSSlist(nIESSID, nIKonaOption, 2).isSuccessful()) {
                    NISAUtilities.getLog().warning("copySsFromKona() - Fail to create CFSS4Copy");
                    return new NISAResult(false, -1098383316);
                }
                nIPEPackageResult = this.trServise.updateSSlist(nIESSID, nIKonaOption, 1);
                if (nIPEPackageResult.isSuccessful()) {
                    string3 = NISAUtilities.getProperty("CF_SRC_SS_DIR");
                    nISAResult = this.copySS(nIESSID, nIKonaOption, string, string3, string2, file, 1);
                    break;
                }
                if (-1099694075 == nIPEPackageResult.getCode()) {
                    NISAUtilities.getLog().warning("No new SS on the CF");
                    nISAResult.setCode(-1098383320);
                    break;
                }
                NISAUtilities.getLog().warning("Fail to update the sslist on CF");
                nISAResult.setCode(-1098383327);
            }
        }
        return nISAResult;
    }

    private NISAResult copySS(NIESSID nIESSID, NIKonaOption nIKonaOption, String string, String string2, String string3, File file, int n) {
        Object object;
        Object object2;
        NISAUtilities.getLog().info("\ncopySS() - Start. essid=" + nIESSID + " konaOpt=" + nIKonaOption + " srcDir=" + string2 + " mode=" + n);
        NIPEPackageResult nIPEPackageResult = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = NISAUtilities.getProperty("MN_USER_NAME");
        File file2 = null;
        String string5 = NISAUtilities.getProperty("STATESAVE_LIST_FILE_NAME");
        String string6 = NISAUtilities.getProperty("HEADER_SUFFIX");
        String string7 = NISAUtilities.getProperty("LEVEL_CPSS_FILE_NAME");
        File[] fileArray = new File[3];
        if (n == 1) {
            fileArray[0] = this.copySSFile(string3, string4, string, string2, file, string6);
            if (null == fileArray[0]) {
                NISAUtilities.getLog().warning("copySS() - can't get header");
            }
            if (null == (fileArray[2] = this.copySSFile(string3, string4, string, string2, file, string7))) {
                NISAUtilities.getLog().warning("copySS() - can't get level_cpss file");
            }
        }
        Object object3 = null;
        int n2 = 0;
        while (n2 < 3) {
            try {
                nIPEPackageResult = this.trServise.updateSSlist(nIESSID, nIKonaOption, n);
                NISAUtilities.getLog().info("\ncopySS() - update sslist cycle " + n2 + " results- " + (nIPEPackageResult.isSuccessful() ? "dumps exist" : (nIPEPackageResult.getCode() == -1099694075 ? "no Dumps" : "Error RC= " + String.valueOf(nIPEPackageResult.getCode()))));
            }
            catch (Exception exception) {
                NISAUtilities.getLog().warning("copySS() - fail update sslist cycle-" + n2 + " The Exception is \n" + NISAUtilities.getExceptionStackTrace(exception));
                break;
            }
            if (!nIPEPackageResult.isSuccessful()) break;
            file2 = this.copySSFile(string3, string4, string, string2, file, string5);
            if (null == file2) {
                NISAUtilities.getLog().warning("copySS() - fail to copy the sslist. kona " + nIKonaOption);
                return new NISAResult(false, -1098383327);
            }
            try {
                object2 = new BufferedReader(new FileReader(file2));
            }
            catch (FileNotFoundException fileNotFoundException) {
                NISAUtilities.getLog().warning("copySS() - sslist not found. kona " + nIKonaOption + ". the Exception is: \n" + NISAUtilities.getExceptionStackTrace(fileNotFoundException));
                return new NISAResult(false, -1098383339);
            }
            if (null == object2) {
                NISAUtilities.getLog().warning("copySS() - can't open sslist" + string5 + " kona " + nIKonaOption);
                return new NISAResult(false, -1098383358);
            }
            try {
                String string8;
                while (null != (string8 = ((BufferedReader)object2).readLine())) {
                    NISAUtilities.getLog().info("copySS() - read line- " + string8);
                    File file3 = null;
                    file3 = NIKonaLeft.Option == nIKonaOption ? NISAUtilities.getCopyFrom0Dir() : NISAUtilities.getCopyFrom1Dir();
                    String[] stringArray = file3.list();
                    int n3 = stringArray.length;
                    boolean bl = false;
                    int n4 = 0;
                    while (n4 < n3) {
                        if (stringArray[n4] == string8) {
                            bl = true;
                            NISAUtilities.getLog().warning(string8 + " is in " + file3 + "cant scp the file now, it maybe used by another process");
                            break;
                        }
                        ++n4;
                    }
                    if (bl) continue;
                    object3 = this.copySSFile(string3, string4, string, string2, file3, string8);
                    if (null == object3) {
                        NISAUtilities.getLog().warning("Failed to scp " + object3);
                        continue;
                    }
                    object = new File(file, string8);
                    if (!NISAUtilities.renameFile((File)object3, (File)object)) continue;
                    object3 = object;
                    if (n == 1) {
                        fileArray[1] = object3;
                        object3 = NISAUtilities.zipFiles(file, string8 + ".zip", fileArray);
                        if (null == object3) {
                            NISAUtilities.getLog().warning("copySS() - Fail to zip " + string8);
                            continue;
                        }
                        if (fileArray[1].delete()) {
                            NISAUtilities.getLog().info("copySS() - delete " + fileArray[1].getName());
                        } else {
                            NISAUtilities.getLog().warning("copySS() -  fail to del " + fileArray[1].getName());
                        }
                    }
                    if (!arrayList.add(((File)object3).getAbsolutePath())) {
                        NISAUtilities.getLog().warning("copySS() - fail to add " + ((File)object3).getName() + " to copiedFileList");
                    } else {
                        NISAUtilities.getLog().info("copySS() - " + ((File)object3).getName() + " added to copiedFileList");
                    }
                    if (this.trServise.markStateSaveCopied(nIESSID, nIKonaOption, string8, n).isSuccessful()) {
                        NISAUtilities.getLog().info("copySS() - marked as copied file " + string8);
                        continue;
                    }
                    NISAUtilities.getLog().warning("copySS() - fail to marked as copied file " + string8);
                }
            }
            catch (Exception exception) {
                NISAUtilities.getLog().warning("copySS() - fail read sslist. exception is: \n" + NISAUtilities.getExceptionStackTrace(exception));
            }
            NISAUtilities.getLog().info("copySS() - finish reading " + string5);
            try {
                ((BufferedReader)object2).close();
            }
            catch (IOException iOException) {
                NISAUtilities.getLog().warning("copySS() - fail close sslist cycle-" + n2 + " The Exception is \n" + NISAUtilities.getExceptionStackTrace(iOException));
                break;
            }
            if (file2.delete()) {
                NISAUtilities.getLog().info("copySS() - sslist deleted " + nIKonaOption);
            } else {
                NISAUtilities.getLog().warning("copySS() - sslist NOT deleted " + nIKonaOption);
            }
            ++n2;
        }
        if (null != fileArray[0]) {
            if (fileArray[0].delete()) {
                NISAUtilities.getLog().info("copySS() - header deleted");
            } else {
                NISAUtilities.getLog().warning("copySS() - fail to delete header");
            }
        }
        if (null != fileArray[2]) {
            if (fileArray[2].delete()) {
                NISAUtilities.getLog().info("copySS() - level_cpss file deleted");
            } else {
                NISAUtilities.getLog().warning("copySS() - fail to delete level_cpss file");
            }
        }
        object2 = this.copiedFilesList2Array(arrayList);
        object = new NISAResult(true, 0);
        ((NISAResult)object).setCopiedFiles((String[])object2);
        return object;
    }

    private String[] copiedFilesList2Array(ArrayList arrayList) {
        NISAUtilities.getLog().info("NISAStatesave.copiedFilesList2Array() - start");
        int n = arrayList.size();
        NISAUtilities.getLog().info("NISAStatesave.copiedFilesList2Array() - copiedFilesList size = " + n);
        String[] stringArray = new String[n];
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringArray[n2] = (String)iterator.next();
            ++n2;
        }
        return stringArray;
    }

    private File copySSFile(String string, String string2, String string3, String string4, File file, String string5) {
        NISAUtilities.getLog().info("\nNISAStatesave.copySSFile() - start with: **** " + string3 + " " + string4 + " " + file.getAbsolutePath() + " " + string5);
        int n = -1;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        try {
            if (NISAUtilities.linuxOs()) {
                string7 = NISAUtilities.getProperty("COPY_STATESAVE_LNX");
                string8 = string + " " + string2 + "@" + string3 + ":/" + string4 + string5 + " " + file.getAbsolutePath();
            } else if (NISAUtilities.winOs()) {
                string7 = NISAUtilities.getProperty("COPY_STATESAVE_WIN");
                string6 = NISAUtilities.getProperty("SCP_RESPONSE");
                string8 = "-pw " + string + " " + string2 + "@" + string3 + ":/" + string4 + string5 + " \"" + file.getAbsolutePath() + "\"";
            } else {
                System.err.println("can not recognized the Operation System type");
                NISAUtilities.getLog().warning("NISAStatesave.copySSFile() -  Fail - can't recognized the Operation System");
                return null;
            }
            NISAUtilities.getLog().info("copySSFile() - cmdParms= " + (13 < string8.length() ? string8.substring(13) : " Error cmdParms"));
            n = NISAUtilities.ourExec(string7, string8, string6, null);
            if (0 != n) {
                NISAUtilities.getLog().warning("NISAStatesave.copySSFile() - fail to run the scp - rc = " + n);
                return null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            NISAUtilities.getLog().warning("NISAStatesave.copySSFile() - fail the Exception is : \n" + NISAUtilities.getExceptionStackTrace(fileNotFoundException));
            return null;
        }
        NISAUtilities.getLog().info("NISAStatesave.copySSFile() - finish copy file " + string5 + " check it ...");
        File file2 = new File(file, string5);
        if (!file2.isFile()) {
            NISAUtilities.getLog().warning("NISAStatesave.copySSFile() - fail the copied file is not a file");
            return null;
        }
        NISAUtilities.getLog().info("NISAStatesave.copySSFile() - file " + file2.getAbsolutePath() + " copied correctly");
        return file2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getCopiedFilesList(File file, String string) {
        String string2;
        File file2;
        ArrayList<String> arrayList;
        block7: {
            NISAUtilities.getLog().info("NISAStatesave.getCopiedFilesList() Start  dir = " + file.getAbsolutePath() + ", filesList = " + string);
            String string3 = file.getAbsolutePath() + File.separator + string;
            arrayList = new ArrayList<String>();
            try {
                file2 = new File(string3);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                if (null == bufferedReader) {
                    NISAUtilities.getLog().warning("NISAStatesave.getCopiedFilesList() - finish - Fail to open the file " + string);
                    return null;
                }
                while (true) {
                    if (null == (string2 = bufferedReader.readLine())) {
                        bufferedReader.close();
                        if (!file2.delete()) break;
                        NISAUtilities.getLog().info("NISAStatesave.getCopiedFilesList() - delte the file list -  " + file2.getName());
                        break block7;
                    }
                    arrayList.add(string2);
                }
                NISAUtilities.getLog().warning("NISAStatesave.getCopiedFilesList() - Fail to delete file list -  " + file2.getName());
            }
            catch (IOException iOException) {
                NISAUtilities.getLog().warning("NISAStatesave.getCopiedFilesList() Filed IOException Exception for file " + string + " the Exception" + " details - \n " + NISAUtilities.getExceptionStackTrace(iOException));
                return null;
            }
        }
        string2 = System.getProperty("file.separator");
        String[] stringArray = new String[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            file2 = new File(file.getAbsoluteFile() + string2 + stringArray[n]);
            if (!file2.exists()) {
                NISAUtilities.getLog().warning("NISAStatesave.getCopiedFilesList() Filed the file " + stringArray[n] + "doesn't copied");
                return null;
            }
            ++n;
        }
        NISAUtilities.getLog().info("NISAStatesave.getCopiedFilesList() - Finish - OK");
        return stringArray;
    }

    protected NISAResult getSSList(NIServices nIServices, NIESSID nIESSID, NIKonaOption nIKonaOption) {
        NISAUtilities.getLog().info("getSSList() - for kona " + nIKonaOption);
        File file = NISAUtilities.getSend2IBMDir();
        if (null == file) {
            return new NISAResult(false, -1098383325);
        }
        NISAResult nISAResult = NISAUtilities.preCond(nIServices, nIESSID, file);
        if (!nISAResult.isSuccessful()) {
            NISAUtilities.getLog().warning("getSSList() - no preConditions ");
            return nISAResult;
        }
        String[] stringArray = nISAResult.getArray();
        String string = NISAUtilities.getProperty("MN_USER_NAME");
        String string2 = null;
        int n = nIKonaOption instanceof NIKonaLeft ? 0 : 1;
        string2 = NISAUtilities.getPassword(nIESSID, nIServices, n);
        if (null == string2) {
            return new NISAResult(false, -1098383343);
        }
        String string3 = null;
        NITraceService nITraceService = nIServices.getTraceService();
        NIPEPackageResult nIPEPackageResult = null;
        try {
            nIPEPackageResult = nITraceService.updateSSlist(nIESSID, nIKonaOption, 0);
            int n2 = nIPEPackageResult.getCode();
            switch (n2) {
                case 0: {
                    NISAUtilities.getLog().info("getSSList() - dump exist under DApart");
                    string3 = NISAUtilities.getProperty("DA_SRC_SS_DIR");
                    break;
                }
                case -1099694075: {
                    NISAUtilities.getLog().info("getSSList() - No SS in DApart");
                    return new NISAResult(false, -1098383320);
                }
                default: {
                    NISAUtilities.getLog().warning("getSSList() - Fail updateDAsslist. " + (n2 == 2 ? "DApart not mounted" : (n2 == -1099694077 ? "script not found" : "unknows Error")));
                    n2 = nITraceService.updateSSlist(nIESSID, nIKonaOption, 2).getCode();
                    if (0 != n2) {
                        NISAUtilities.getLog().warning("getSSList() - Fail to create CFSS4Copy. RC=" + n2);
                        return new NISAResult(false, -1098383316);
                    }
                    NISAUtilities.getLog().info("getSSList() - CFSS4Copy created OK");
                    n2 = nITraceService.updateSSlist(nIESSID, nIKonaOption, 1).getCode();
                    if (0 != n2) {
                        NISAUtilities.getLog().warning("getSSList() - Fail update CF sslist. RC=" + n2);
                        return new NISAResult(false, -1098383327);
                    }
                    string3 = NISAUtilities.getProperty("CF_SRC_SS_DIR");
                    break;
                }
            }
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("getSSList() - fail updateSSlist.the Exception is:\n " + NISAUtilities.getExceptionStackTrace(exception));
            return new NISAResult(false, -1098383328);
        }
        String string4 = NISAUtilities.getProperty("STATESAVE_LIST_FILE_NAME");
        File file2 = this.copySSFile(string2, string, stringArray[n], string3, file, string4);
        if (null == file2) {
            NISAUtilities.getLog().warning("getSSList() - Fail to copy the sslist");
            return new NISAResult(false, -1098383338);
        }
        String[] stringArray2 = NISAUtilities.fileList2array(file2);
        if (null == stringArray2) {
            NISAUtilities.getLog().warning("getSSList() - Fail converet sslist to array");
            return new NISAResult(false, 1);
        }
        file2.delete();
        nISAResult.setArray(stringArray2);
        NISAUtilities.getLog().info("getSSList() - Finish. listZize=" + stringArray2.length);
        return nISAResult;
    }

    protected NISAResult copySSFile(NIServices nIServices, NIESSID nIESSID, String string, NIKonaOption nIKonaOption) {
        Object object;
        NISAUtilities.getLog().info("copySSFile() - Start. essid-" + nIESSID + " ssFile-" + string + " kona-" + nIKonaOption);
        boolean bl = string.matches(".*" + NISAUtilities.getProperty("STATESAVE_FILES_TYPE"));
        String string2 = bl ? NISAUtilities.getProperty("DA_SRC_SS_DIR") : NISAUtilities.getProperty("CF_SRC_SS_DIR");
        File file = NISAUtilities.getSend2IBMDir();
        if (null == file) {
            return new NISAResult(false, -1098383326);
        }
        String[] stringArray = null;
        NISAResult nISAResult = NISAUtilities.preCond(nIServices, nIESSID, file);
        if (!nISAResult.isSuccessful()) {
            return nISAResult;
        }
        stringArray = nISAResult.getArray();
        String string3 = NISAUtilities.getProperty("MN_USER_NAME");
        String string4 = null;
        int n = nIKonaOption instanceof NIKonaLeft ? 0 : 1;
        string4 = NISAUtilities.getPassword(nIESSID, nIServices, n);
        if (null == string4) {
            return new NISAResult(false, -1098383343);
        }
        File file2 = this.copySSFile(string4, string3, stringArray[n], string2, file, string);
        if (null == file2) {
            return new NISAResult(false, -1098383345);
        }
        if (!bl) {
            object = this.copySSFile(string4, string3, stringArray[n], string2, file, NISAUtilities.getProperty("HEADER_SUFFIX"));
            File[] fileArray = new File[]{object, file2};
            File file3 = NISAUtilities.zipFiles(file, string + ".zip", fileArray);
            if (null == file3) {
                NISAUtilities.getLog().warning("copySSFile() - fail - zip SS & header");
            }
            ((File)object).delete();
            file2.delete();
            string = file3.getName();
        }
        object = new String[]{string};
        nISAResult.setCopiedFiles((String[])object);
        return nISAResult;
    }
}

