/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.sa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class NISASystemCommand {
    private String[] cmd;
    private File workingDirectory;
    private Process process;
    private File inFile;
    private File outFile;
    private File errFile;
    private OutputThread outThread;
    private OutputThread errThread;

    public NISASystemCommand(String[] stringArray, File file, File file2, File file3, File file4) {
        if (stringArray == null) {
            throw new IllegalArgumentException("null command");
        }
        this.cmd = stringArray;
        this.workingDirectory = file;
        this.inFile = file2;
        this.outFile = file3;
        this.errFile = file4;
    }

    public int exec() throws Exception {
        if (this.cmd.length == 0) {
            throw new IllegalArgumentException("empty command");
        }
        try {
            this.process = Runtime.getRuntime().exec(this.cmd, null, this.workingDirectory);
        }
        catch (IOException iOException) {
            throw new Exception("exec failed");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        try {
            this.outThread = new OutputThread(bufferedReader, this.outFile);
        }
        catch (IOException iOException) {
            throw new Exception("stdout redirection failed");
        }
        this.outThread.start();
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        try {
            this.errThread = new OutputThread(bufferedReader2, this.errFile);
        }
        catch (IOException iOException) {
            throw new Exception("stderr redirection failed");
        }
        this.errThread.start();
        if (this.inFile != null) {
            BufferedReader bufferedReader3;
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(this.process.getOutputStream()));
            try {
                bufferedReader3 = new BufferedReader(new FileReader(this.inFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Exception("input file not found: " + this.inFile);
            }
            while (true) {
                String string;
                try {
                    string = bufferedReader3.readLine();
                }
                catch (IOException iOException) {
                    break;
                }
                if (string == null) break;
                printWriter.println(string);
            }
            printWriter.close();
            try {
                bufferedReader3.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int n = -13;
        try {
            n = this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        return n;
    }

    public static void main(String[] stringArray) {
        NISASystemCommand nISASystemCommand = new NISASystemCommand(new String[]{"ftp", "-i", "-v", "-n"}, null, new File("cmd"), new File("out"), null);
        try {
            int n = nISASystemCommand.exec();
            System.out.println("rc = " + n);
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
        }
    }

    public static class Exception
    extends java.lang.Exception {
        private static final long serialVersionUID = 6363464561002912514L;

        public Exception(String string) {
            super(string);
        }
    }

    private class OutputThread
    extends Thread {
        BufferedReader in;
        PrintWriter out;

        OutputThread(BufferedReader bufferedReader, File file) throws IOException {
            this.in = bufferedReader;
            if (file != null) {
                this.out = new PrintWriter(new FileWriter(file));
            }
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                String string;
                try {
                    string = this.in.readLine();
                }
                catch (IOException iOException) {
                    break;
                }
                if (string == null) break;
                if (this.out == null) continue;
                this.out.println(string);
            }
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.out != null) {
                this.out.close();
            }
        }
    }
}

