/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.security;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.security.common.NIRecoveryToolPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class NIConnectionManager {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$security$NIConnectionManager == null ? (class$com$ibm$storage$ess$ni$security$NIConnectionManager = NIConnectionManager.class$("com.ibm.storage.ess.ni.security.NIConnectionManager")) : class$com$ibm$storage$ess$ni$security$NIConnectionManager);
    public static final int portNumber = 1723;
    private ServerSocket serverConnection = null;
    private Socket socketConnection = null;
    private DataInputStream input = null;
    private DataOutputStream output = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$security$NIConnectionManager;

    public boolean createServerSocket() {
        boolean bl = true;
        try {
            this.serverConnection = new ServerSocket(1723, 5, InetAddress.getByName(null));
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
            bl = false;
            this.closeConnection();
        }
        return bl;
    }

    public boolean createClientSocket() {
        boolean bl = true;
        try {
            this.socketConnection = new Socket(InetAddress.getByName(null), 1723);
            this.input = new DataInputStream(this.socketConnection.getInputStream());
            this.output = new DataOutputStream(this.socketConnection.getOutputStream());
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
            bl = false;
            this.closeConnection();
        }
        return bl;
    }

    public static int getPortNumber() {
        return 1723;
    }

    public boolean listenForConnection() {
        boolean bl = true;
        try {
            this.socketConnection = this.serverConnection.accept();
            this.input = new DataInputStream(this.socketConnection.getInputStream());
            this.output = new DataOutputStream(this.socketConnection.getOutputStream());
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
            bl = false;
            this.closeConnection();
        }
        return bl;
    }

    public NIRecoveryToolPacket readPacket() {
        try {
            int n = this.input.readInt();
            int n2 = this.input.readInt();
            int n3 = this.input.readInt();
            return new NIRecoveryToolPacket(n, n2, n3);
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
            return null;
        }
    }

    public void writePacket(NIRecoveryToolPacket nIRecoveryToolPacket) {
        try {
            int n = nIRecoveryToolPacket.getPacketType();
            this.output.writeInt(n);
            if (n == 0) {
                this.output.writeInt(nIRecoveryToolPacket.getRequestData());
            } else if (n == 1) {
                this.output.writeInt(nIRecoveryToolPacket.getResponseData());
            }
            int n2 = nIRecoveryToolPacket.getResponseType();
            this.output.writeInt(n2);
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
        }
    }

    public void writeNumberOfPacketsToExpect(int n) {
        try {
            this.output.writeInt(n);
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
        }
    }

    public int readNumberOfPacketsToExpect() {
        try {
            return this.input.readInt();
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
            return -1;
        }
    }

    public void closeConnection() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
            if (this.socketConnection != null) {
                this.socketConnection.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void closeServerConnection() {
        try {
            if (this.serverConnection != null) {
                this.serverConnection.close();
            }
        }
        catch (IOException iOException) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

