/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.security;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.results.security.NISecurityResult;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseHelper;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseManager;
import com.ibm.storage.ess.ni.security.NISecuritySynchronizer;
import com.ibm.storage.ess.ni.security.common.NISecurityTableEntry;
import com.ibm.storage.ess.ni.security.common.NISynchronizationData;

public class NIOverwriteBackgroundRequest
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$security$NIOverwriteBackgroundRequest == null ? (class$com$ibm$storage$ess$ni$security$NIOverwriteBackgroundRequest = NIOverwriteBackgroundRequest.class$("com.ibm.storage.ess.ni.security.NIOverwriteBackgroundRequest")) : class$com$ibm$storage$ess$ni$security$NIOverwriteBackgroundRequest);
    private NISecuritySynchronizer synchronizer;
    private NISecurityDatabaseHelper repositoryHelper;
    private NISynchronizationData currRequest = new NISynchronizationData(8);
    private boolean running = false;
    private boolean complete = false;
    private long WAIT_TIME = 60000L;
    private static NIOverwriteBackgroundRequest singleton = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$security$NIOverwriteBackgroundRequest;

    private NIOverwriteBackgroundRequest() {
        this.synchronizer = NISecuritySynchronizer.getSecuritySynchronizer();
        this.repositoryHelper = NISecurityDatabaseManager.getDatabaseHelper();
    }

    public static NIOverwriteBackgroundRequest getOverwriteBackgroundRequest() {
        if (singleton == null) {
            singleton = new NIOverwriteBackgroundRequest();
        }
        return singleton;
    }

    public void run() {
        logger.debug_general("Starting background overwrite request");
        this.running = true;
        while (this.running) {
            NISecurityResult nISecurityResult = this.synchronizer.performRequest(this.currRequest);
            if (nISecurityResult.isSuccessful()) {
                if (this.currRequest.getTypeOfTransaction() == 8) {
                    logger.debug_general("Successfully completed overwrite request. Starting background security settings update");
                    this.setRequestForSettings();
                    continue;
                }
                logger.debug_general("Completed overwrite request and security settings udpate");
                this.running = false;
                this.complete = true;
                continue;
            }
            logger.error("Failed to perform request and return code is 0x" + Integer.toHexString(nISecurityResult.getCode()));
            this.waitForPeer();
            if (this.currRequest.getTypeOfTransaction() == 8) continue;
            this.setRequestForSettings();
        }
        logger.debug_general("Background request thread is exiting");
    }

    private void setRequestForSettings() {
        NISecurityTableEntry nISecurityTableEntry = this.repositoryHelper.getSecurityEntry();
        nISecurityTableEntry.setOutOfSyncHMCs(false);
        this.currRequest = new NISynchronizationData(2, 3, nISecurityTableEntry, null);
    }

    private synchronized void waitForPeer() {
        try {
            this.wait(this.WAIT_TIME);
        }
        catch (InterruptedException interruptedException) {
            logger.throwable((Throwable)interruptedException);
        }
    }

    public synchronized void notifyPeerIsUp() {
        this.notify();
    }

    public boolean needToRun() {
        return !this.complete && !this.running;
    }

    public void shutdown() {
        logger.debug_general("Shutting down NIOverwriteBackgroundRequest.");
        this.running = false;
        this.interrupt();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

