/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.security;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIUserAccount;
import com.ibm.storage.ess.ni.application.resource.NIUserGroup;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseHelper;
import com.ibm.storage.ess.ni.security.common.NISecurityTableEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class NISecurityDatabaseImplementation
extends NISecurityDatabaseHelper {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$security$NISecurityDatabaseImplementation == null ? (class$com$ibm$storage$ess$ni$security$NISecurityDatabaseImplementation = NISecurityDatabaseImplementation.class$("com.ibm.storage.ess.ni.security.NISecurityDatabaseImplementation")) : class$com$ibm$storage$ess$ni$security$NISecurityDatabaseImplementation);
    private final String USERS_TABLE = "UserAccounts";
    private final String GROUPS_TABLE = "UserGroups";
    private final String SECURITY_TABLE = "SecuritySettings";
    private PreparedStatement insertUser = null;
    private PreparedStatement deleteUser = null;
    private PreparedStatement updateUser = null;
    private PreparedStatement selectUser = null;
    private PreparedStatement selectAllUsers = null;
    private PreparedStatement selectNumUsers = null;
    private PreparedStatement insertGroup = null;
    private PreparedStatement deleteGroup = null;
    private PreparedStatement updateGroup = null;
    private PreparedStatement selectGroup = null;
    private PreparedStatement selectAllGroups = null;
    private PreparedStatement selectNumGroups = null;
    private PreparedStatement insertSecurityEntry = null;
    private PreparedStatement deleteSecurityEntry = null;
    private PreparedStatement updateSecurityEntry = null;
    private PreparedStatement selectSecurityEntry = null;
    private final short FAILED_UPDATE = (short)-1;
    private final short NO_ACTION = 0;
    private final short SINGLE_UPDATE = 1;
    private Connection conn;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$security$NISecurityDatabaseImplementation;

    public NISecurityDatabaseImplementation(Connection connection) {
        this.conn = connection;
    }

    protected synchronized void prepareAllStatements() {
        this.insertUser = this.prepareStatement("INSERT INTO UserAccounts(object) VALUES(?)");
        this.deleteUser = this.prepareStatement("DELETE FROM UserAccounts WHERE object.getName().equals(?)");
        this.updateUser = this.prepareStatement("UPDATE UserAccounts SET object=? WHERE object.getName().equals(?)");
        this.selectUser = this.prepareStatement("SELECT object FROM UserAccounts WHERE object.getName().equals(?)");
        this.selectAllUsers = this.prepareStatement("SELECT * FROM UserAccounts");
        this.selectNumUsers = this.prepareStatement("SELECT COUNT(*) FROM UserAccounts");
        this.insertGroup = this.prepareStatement("INSERT INTO UserGroups(object) VALUES(?)");
        this.deleteGroup = this.prepareStatement("DELETE FROM UserGroups WHERE object.getName().equals(?)");
        this.updateGroup = this.prepareStatement("UPDATE UserGroups SET object=? WHERE object.getName().equals(?)");
        this.selectGroup = this.prepareStatement("SELECT object FROM UserGroups WHERE object.getName().equals(?)");
        this.selectAllGroups = this.prepareStatement("SELECT * FROM UserGroups");
        this.selectNumGroups = this.prepareStatement("SELECT COUNT(*) FROM UserGroups");
        this.insertSecurityEntry = this.prepareStatement("INSERT INTO SecuritySettings(setting_id, object) VALUES(?,?)");
        this.deleteSecurityEntry = this.prepareStatement("DELETE FROM SecuritySettings WHERE setting_id=?");
        this.updateSecurityEntry = this.prepareStatement("UPDATE SecuritySettings SET object=? WHERE setting_id=?");
        this.selectSecurityEntry = this.prepareStatement("SELECT object FROM SecuritySettings WHERE setting_id=?");
    }

    protected synchronized void close() {
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn = null;
    }

    private synchronized PreparedStatement prepareStatement(String string) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(string, 1);
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return preparedStatement;
    }

    private synchronized ResultSet executeQuery(Statement statement, String string) {
        ResultSet resultSet;
        block3: {
            resultSet = null;
            try {
                if (string == null) {
                    resultSet = ((PreparedStatement)statement).executeQuery();
                    break block3;
                }
                resultSet = statement.executeQuery(string);
            }
            catch (SQLException sQLException) {
                logger.throwable((Throwable)sQLException);
            }
        }
        return resultSet;
    }

    private synchronized ResultSet executeQuery(Statement statement) {
        return this.executeQuery(statement, null);
    }

    private synchronized int executeUpdate(Statement statement, String string) {
        int n;
        block3: {
            n = 0;
            try {
                if (string == null) {
                    n = ((PreparedStatement)statement).executeUpdate();
                    break block3;
                }
                n = statement.executeUpdate(string, 1);
            }
            catch (SQLException sQLException) {
                logger.throwable((Throwable)sQLException);
                n = -1;
            }
        }
        return n;
    }

    private synchronized int executeUpdate(Statement statement) {
        return this.executeUpdate(statement, null);
    }

    protected synchronized int insertUserAccount(NIUserAccount nIUserAccount) {
        int n;
        block9: {
            n = -1099689591;
            try {
                if (this.getNumUserAccounts() < 100) {
                    NIUserAccount nIUserAccount2 = this.getUserAccount(nIUserAccount.getName());
                    if (nIUserAccount2 == null) {
                        this.insertUser.setObject(1, nIUserAccount);
                        switch (this.executeUpdate(this.insertUser)) {
                            case 1: {
                                n = 0;
                                break;
                            }
                            case -1: 
                            case 0: {
                                n = -1099689594;
                            }
                        }
                    } else {
                        n = -1099689598;
                    }
                    break block9;
                }
                n = -1099689593;
            }
            catch (SQLException sQLException) {
                logger.throwable((Throwable)sQLException);
            }
        }
        return n;
    }

    protected synchronized int deleteUserAccount(String string) {
        int n = -1099689591;
        try {
            this.deleteUser.setObject(1, string);
            switch (this.executeUpdate(this.deleteUser)) {
                case 1: {
                    n = 0;
                    break;
                }
                case 0: {
                    n = -1099689600;
                    break;
                }
                case -1: {
                    n = -1099689594;
                }
            }
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return n;
    }

    protected synchronized int updateUserAccount(String string, NIUserAccount nIUserAccount) {
        int n = -1099689591;
        try {
            this.updateUser.setObject(1, nIUserAccount);
            this.updateUser.setObject(2, string);
            switch (this.executeUpdate(this.updateUser)) {
                case 1: {
                    n = 0;
                    break;
                }
                case 0: {
                    n = -1099689600;
                    break;
                }
                case -1: {
                    n = -1099689594;
                }
            }
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return n;
    }

    public synchronized NIUserAccount getUserAccount(String string) {
        NIUserAccount nIUserAccount = null;
        try {
            this.selectUser.setObject(1, string);
            ResultSet resultSet = this.executeQuery(this.selectUser);
            if (resultSet.next()) {
                nIUserAccount = (NIUserAccount)resultSet.getObject(1);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return nIUserAccount;
    }

    public synchronized Vector getAllUserAccounts() {
        Vector<Object> vector = new Vector<Object>(this.getNumUserAccounts());
        try {
            ResultSet resultSet = this.executeQuery(this.selectAllUsers);
            while (resultSet.next()) {
                vector.add(resultSet.getObject(2));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return vector;
    }

    public synchronized Vector getAllUserAccountNames() {
        Vector vector = this.getAllUserAccounts();
        Vector<String> vector2 = new Vector<String>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            vector2.add(((NIUserAccount)vector.elementAt(n)).getName());
            ++n;
        }
        return vector2;
    }

    public synchronized int getNumUserAccounts() {
        int n = 0;
        try {
            ResultSet resultSet = this.executeQuery(this.selectNumUsers);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return n;
    }

    protected synchronized int insertUserGroup(NIUserGroup nIUserGroup) {
        int n = -1099689591;
        try {
            this.insertGroup.setObject(1, nIUserGroup);
            switch (this.executeUpdate(this.insertGroup)) {
                case 1: {
                    n = 0;
                    break;
                }
                case -1: 
                case 0: {
                    n = -1099689594;
                }
            }
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return n;
    }

    protected synchronized int deleteUserGroup(String string) {
        int n = -1099689591;
        try {
            this.deleteGroup.setObject(1, string);
            switch (this.executeUpdate(this.deleteGroup)) {
                case 1: {
                    n = 0;
                    break;
                }
                case 0: {
                    n = -1099689599;
                    break;
                }
                case -1: {
                    n = -1099689594;
                }
            }
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return n;
    }

    protected synchronized int updateUserGroup(NIUserGroup nIUserGroup) {
        int n = -1099689591;
        try {
            this.updateGroup.setObject(1, nIUserGroup);
            this.updateGroup.setObject(2, nIUserGroup.getName());
            switch (this.executeUpdate(this.updateGroup)) {
                case 1: {
                    n = 0;
                    break;
                }
                case 0: {
                    n = -1099689599;
                    break;
                }
                case -1: {
                    n = -1099689594;
                }
            }
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return n;
    }

    public synchronized NIUserGroup getUserGroup(String string) {
        NIUserGroup nIUserGroup = null;
        try {
            this.selectGroup.setObject(1, string);
            ResultSet resultSet = this.executeQuery(this.selectGroup);
            if (resultSet.next()) {
                nIUserGroup = (NIUserGroup)resultSet.getObject(1);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return nIUserGroup;
    }

    public synchronized Vector getAllUserGroups() {
        Vector<Object> vector = new Vector<Object>(this.getNumUserGroups());
        try {
            ResultSet resultSet = this.executeQuery(this.selectAllGroups);
            while (resultSet.next()) {
                vector.add(resultSet.getObject(2));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return vector;
    }

    public synchronized Vector getAllUserGroupNames() {
        Vector vector = this.getAllUserGroups();
        Vector<String> vector2 = new Vector<String>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            vector2.add(((NIUserGroup)vector.elementAt(n)).getName());
            ++n;
        }
        return vector2;
    }

    public synchronized int getNumUserGroups() {
        int n = 0;
        try {
            ResultSet resultSet = this.executeQuery(this.selectNumGroups);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return n;
    }

    protected synchronized int insertSecurityEntry(NISecurityTableEntry nISecurityTableEntry) {
        int n = -1099689591;
        try {
            this.insertSecurityEntry.setInt(1, 1);
            this.insertSecurityEntry.setObject(2, nISecurityTableEntry);
            switch (this.executeUpdate(this.insertSecurityEntry)) {
                case 1: {
                    n = 0;
                    break;
                }
                case -1: 
                case 0: {
                    n = -1099689594;
                }
            }
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return n;
    }

    protected synchronized int deleteSecurityEntry() {
        int n = -1099689591;
        try {
            this.deleteSecurityEntry.setInt(1, 1);
            switch (this.executeUpdate(this.deleteSecurityEntry)) {
                case 1: {
                    n = 0;
                    break;
                }
                case 0: {
                    n = -1099689592;
                    break;
                }
                case -1: {
                    n = -1099689594;
                }
            }
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return n;
    }

    protected synchronized int updateSecurityEntry(NISecurityTableEntry nISecurityTableEntry) {
        int n = -1099689591;
        try {
            this.updateSecurityEntry.setObject(1, nISecurityTableEntry);
            this.updateSecurityEntry.setInt(2, 1);
            switch (this.executeUpdate(this.updateSecurityEntry)) {
                case 1: {
                    n = 0;
                    break;
                }
                case 0: {
                    n = -1099689592;
                    break;
                }
                case -1: {
                    n = -1099689594;
                }
            }
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return n;
    }

    public synchronized NISecurityTableEntry getSecurityEntry() {
        NISecurityTableEntry nISecurityTableEntry = null;
        try {
            this.selectSecurityEntry.setInt(1, 1);
            ResultSet resultSet = this.executeQuery(this.selectSecurityEntry);
            if (resultSet.next()) {
                nISecurityTableEntry = (NISecurityTableEntry)resultSet.getObject(1);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            logger.throwable((Throwable)sQLException);
        }
        return nISecurityTableEntry;
    }

    protected boolean storeAccounts(Vector vector) {
        logger.error("Not supported for database implementation");
        return false;
    }

    protected boolean storeGroups(Vector vector) {
        logger.error("Not supported for database implementation");
        return false;
    }

    protected boolean storeSecuritySettings(NISecurityTableEntry nISecurityTableEntry) {
        logger.error("Not supported for database implementation");
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

