/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.security;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.application.resource.NIUserAccount;
import com.ibm.storage.ess.ni.application.resource.NIUserGroup;
import com.ibm.storage.ess.ni.application.results.security.NISecurityResult;
import com.ibm.storage.ess.ni.communication.extensions.server.NICommunicationServer;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.resource.NIUserAccountImpl;
import com.ibm.storage.ess.ni.results.NISecurityResultImpl;
import com.ibm.storage.ess.ni.security.NIMRSecurityCommunicator;
import com.ibm.storage.ess.ni.security.NIOverwriteBackgroundRequest;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseHelper;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseManager;
import com.ibm.storage.ess.ni.security.common.NIRecoveryToolPacket;
import com.ibm.storage.ess.ni.security.common.NISecurityTableEntry;
import com.ibm.storage.ess.ni.security.common.NIServerConfiguration;
import com.ibm.storage.ess.ni.security.common.NISynchronizationData;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;

public class NISecuritySynchronizer
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$security$NISecuritySynchronizer == null ? (class$com$ibm$storage$ess$ni$security$NISecuritySynchronizer = NISecuritySynchronizer.class$("com.ibm.storage.ess.ni.security.NISecuritySynchronizer")) : class$com$ibm$storage$ess$ni$security$NISecuritySynchronizer);
    public static final String NO_ALTERNATE = "NO_ALTERNATE";
    private NIMRSecurityCommunicator communicator = null;
    private NISecurityDatabaseHelper databaseHelper = null;
    private boolean alternateConfigured;
    private Vector workQueue = new Vector(20);
    private static NISecuritySynchronizer securitySynchronizer = null;
    private boolean alive = false;
    private boolean locked = false;
    private int curTransactionID;
    private NISynchronizationData lastRequest;
    private NISecurityResult currentResult;
    private Object peerDataWaitObject = new Object();
    private Object responsesWaitObject = new Object();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$security$NISecuritySynchronizer;

    private NISecuritySynchronizer(String string) {
        this.databaseHelper = NISecurityDatabaseManager.getDatabaseHelper();
        this.setAlternateServer(string);
    }

    public static NISecuritySynchronizer getSecuritySynchronizer() {
        if (securitySynchronizer == null) {
            securitySynchronizer = new NISecuritySynchronizer(NO_ALTERNATE);
        }
        return securitySynchronizer;
    }

    public synchronized void addPeer(String string) {
        this.setAlternateServer(string);
        if (this.communicator.send(new NIServerConfiguration(this.alternateConfigured))) {
            NISecurityResult nISecurityResult = this.performRequest(new NISynchronizationData(8));
            if (!nISecurityResult.isSuccessful()) {
                logger.error("Failed to sync/overwrite repositories and return code is 0x" + Integer.toHexString(nISecurityResult.getCode()));
            }
        } else {
            logger.error("Failed to send configuration message to alternate. Therefore, unable to sync/overwrite user accounts");
        }
    }

    public synchronized void removePeer() {
        if (!this.communicator.send(new NIServerConfiguration(false))) {
            logger.error("Failed to send configuration message to alternate");
        }
        this.setAlternateServer(NO_ALTERNATE);
    }

    public synchronized void setAlternateServer(String string) {
        NIMessageRouterAddress nIMessageRouterAddress;
        if (string != null && !string.equals(NO_ALTERNATE)) {
            nIMessageRouterAddress = new NIMessageRouterAddress(7, string);
            this.alternateConfigured = true;
        } else {
            nIMessageRouterAddress = new NIMessageRouterAddress(7, "HMC2");
            this.alternateConfigured = false;
        }
        if (this.communicator == null) {
            this.communicator = new NIMRSecurityCommunicator(nIMessageRouterAddress, this);
            this.communicator.start();
        } else {
            this.communicator.setAlternateAddress(nIMessageRouterAddress);
        }
        logger.debug_general("alternateConfigured set to " + this.alternateConfigured);
    }

    private void unlock() {
        this.locked = false;
        this.currentResult = null;
        this.lastRequest = null;
    }

    public void run() {
        this.alive = true;
        if (this.alternateConfigured) {
            this.communicator.send(new NISynchronizationData(9));
            logger.debug_general("Sent alive message to peer");
        }
        while (this.alive) {
            if (this.workQueue.size() == 0) {
                this.waitForDataFromPeer();
                continue;
            }
            this.processRequest(this.workQueue.remove(0));
        }
    }

    private void processRequest(Object object) {
        if (object instanceof NIRecoveryToolPacket) {
            this.processRecoveryToolRequest((NIRecoveryToolPacket)object);
        } else if (object instanceof NISynchronizationData) {
            this.processSynchronizationTransaction((NISynchronizationData)object);
        } else if (object instanceof NIServerConfiguration) {
            String string = ((NIServerConfiguration)object).isAlternateConfigured() ? "HMC1" : NO_ALTERNATE;
            logger.debug_general("Received a configuration change");
            this.setAlternateServer(string);
        } else {
            logger.error("Security Synchronization object received an invalid request: " + object);
        }
    }

    private void processRecoveryToolRequest(NIRecoveryToolPacket nIRecoveryToolPacket) {
        int n = nIRecoveryToolPacket.getPacketType();
        int n2 = nIRecoveryToolPacket.getRequestData();
        if (n == 0) {
            switch (n2) {
                case 2: {
                    logger.debug_general("Security Synch received a reset request.");
                    this.handleResetRequest();
                    break;
                }
                case 3: {
                    logger.debug_general("Security Sync received a resynchronize request.");
                    this.handleResyncOverwriteRequest(true);
                    break;
                }
                default: {
                    logger.error("Security Synch received unsupported recovery tool request type of " + n2);
                    break;
                }
            }
        } else {
            logger.error("Security Synch received unsupported recovery tool packet type of " + n);
        }
    }

    private void handleResetRequest() {
        String[] stringArray = new String[]{"Administrator"};
        NIUserAccountImpl nIUserAccountImpl = new NIUserAccountImpl("admin", "admin", stringArray);
        NISecurityResult nISecurityResult = new NISecurityResultImpl(false, -1099689587);
        if (!this.locked) {
            int n = this.databaseHelper.getUserAccount(nIUserAccountImpl.getName()) == null ? 1 : 2;
            nISecurityResult = this.localSingleUpdate(n, 1, nIUserAccountImpl, nIUserAccountImpl.getName());
        } else {
            logger.debug_general("Local is locked, so failing current request.");
        }
        this.handleResult(nISecurityResult);
    }

    private void handleResyncOverwriteRequest(boolean bl) {
        NISecurityResult nISecurityResult;
        if (!this.locked) {
            if (this.alternateConfigured) {
                this.locked = true;
                nISecurityResult = this.startSyncRepositories(bl);
            } else {
                nISecurityResult = new NISecurityResultImpl(false, -1099689723);
            }
        } else {
            logger.debug_general("Local is locked, so failing current request.");
            nISecurityResult = new NISecurityResultImpl(false, -1099689587);
        }
        if (!nISecurityResult.isSuccessful()) {
            this.handleResult(nISecurityResult);
        }
    }

    private void processSynchronizationTransaction(NISynchronizationData nISynchronizationData) {
        int n = nISynchronizationData.getTypeOfTransaction();
        switch (n) {
            case 1: {
                logger.debug_general("Security Sync received a single update request for both repositories");
                this.lastRequest = nISynchronizationData;
                this.handleSingleUpdateRequestForBothRepositories(nISynchronizationData);
                break;
            }
            case 2: {
                logger.debug_general("Security Sync received a single update request for the local, from the alternate");
                this.handleSingleUpdateRequestOnLocalRepository(nISynchronizationData);
                break;
            }
            case 4: {
                if (nISynchronizationData.isResyncOperation()) {
                    logger.debug_general("Security Sync received a request from the alternate to resynchronize");
                } else {
                    logger.debug_general("Security Sync received a request from the alternate to overwrite");
                }
                this.handleResyncRepository(nISynchronizationData);
                break;
            }
            case 5: {
                logger.debug_general("Security Sync received a single update response from the alternate");
                this.handleSingleUpdateResponse(nISynchronizationData);
                break;
            }
            case 6: {
                logger.debug_general("Security Sync received a resynchronize response from the alternate");
                this.handleResyncResponse(nISynchronizationData);
                break;
            }
            case 7: {
                logger.debug_general("Security Sync received a resynchronize request");
                this.handleResyncOverwriteRequest(true);
                break;
            }
            case 8: {
                logger.debug_general("Security Sync received an overwrite request");
                this.handleResyncOverwriteRequest(false);
                break;
            }
            case 9: {
                logger.debug_general("Security Sync received a message from the peer indicating it is up");
                if (NIAgentProperties.getAgentType() != 3 || !NIMessageRouterMetaData.getEssServerName().equals("HMC1")) break;
                if (!this.alternateConfigured) {
                    this.setAlternateServer("HMC2");
                }
                NISecurityTableEntry nISecurityTableEntry = this.databaseHelper.getSecurityEntry();
                NIOverwriteBackgroundRequest nIOverwriteBackgroundRequest = NIOverwriteBackgroundRequest.getOverwriteBackgroundRequest();
                if (!nISecurityTableEntry.getOutOfSyncHMCs()) break;
                if (nIOverwriteBackgroundRequest.needToRun()) {
                    try {
                        nIOverwriteBackgroundRequest.start();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        logger.throwable((Throwable)illegalThreadStateException);
                    }
                    break;
                }
                nIOverwriteBackgroundRequest.notifyPeerIsUp();
                break;
            }
            default: {
                logger.error("Received unsupported synchronization request of " + n);
            }
        }
    }

    private void handleSingleUpdateRequestForBothRepositories(NISynchronizationData nISynchronizationData) {
        NISecurityResult nISecurityResult = new NISecurityResultImpl(false, -1099689587);
        boolean bl = true;
        if (!this.locked) {
            if (this.alternateConfigured) {
                this.locked = true;
                this.curTransactionID = nISynchronizationData.getTransactionID();
                nISecurityResult = this.startSingleUpdate(nISynchronizationData.getSingleUpdateAction(), nISynchronizationData.getObjectTypeToUpdate(), nISynchronizationData.getSingleUpdateObject(), nISynchronizationData.getAccountName(), this.curTransactionID);
                if (nISecurityResult.isSuccessful()) {
                    bl = false;
                }
            } else {
                nISecurityResult = this.localSingleUpdate(nISynchronizationData.getSingleUpdateAction(), nISynchronizationData.getObjectTypeToUpdate(), nISynchronizationData.getSingleUpdateObject(), nISynchronizationData.getAccountName());
            }
        } else {
            logger.debug_general("Local is locked, so failing current request.");
        }
        if (bl) {
            this.handleResult(nISecurityResult);
        }
    }

    private void handleSingleUpdateRequestOnLocalRepository(NISynchronizationData nISynchronizationData) {
        NISecurityResult nISecurityResult = new NISecurityResultImpl(false, -1099689587);
        boolean bl = true;
        if (!this.locked && this.alternateConfigured) {
            String string = nISynchronizationData.getAccountName();
            int n = nISynchronizationData.getSingleUpdateAction();
            int n2 = nISynchronizationData.getObjectTypeToUpdate();
            boolean bl2 = false;
            boolean bl3 = true;
            if (n2 == 1 && n == 2) {
                NIUserAccountImpl nIUserAccountImpl = (NIUserAccountImpl)this.databaseHelper.getUserAccount(string);
                if (nIUserAccountImpl != null) {
                    bl2 = nIUserAccountImpl.isPasswordExpired();
                }
                bl3 = ((NIUserAccountImpl)nISynchronizationData.getSingleUpdateObject()).isPasswordExpired();
            }
            if ((nISecurityResult = this.localSingleUpdate(n, n2, nISynchronizationData.getSingleUpdateObject(), string)).isSuccessful() && bl2 && !bl3) {
                try {
                    logger.debug_general("Updating authorizations of clients due to changes of account: " + string);
                    NICommunicationServer.getInstanceOf().updateClientsAuthorization(string);
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                }
            }
        } else if (this.locked) {
            logger.debug_general("Local is locked, so failing current request.");
        } else {
            bl = false;
            logger.debug_general("Local does not have a peer defined, so dropping the current request.");
        }
        if (bl && !this.communicator.send(new NISynchronizationData(nISecurityResult, nISynchronizationData.getTransactionID()))) {
            logger.debug_general("Failed to send the single update response to the alternate");
        }
    }

    private void handleResyncRepository(NISynchronizationData nISynchronizationData) {
        NISecurityResultImpl nISecurityResultImpl = new NISecurityResultImpl(false, -1099689587);
        boolean bl = true;
        if (!this.locked && this.alternateConfigured) {
            nISynchronizationData = nISynchronizationData.isResyncOperation() ? this.localResyncRepository(nISynchronizationData) : this.overwriteRepository(nISynchronizationData);
        } else if (this.locked) {
            nISynchronizationData = new NISynchronizationData(nISecurityResultImpl, null, nISynchronizationData.getTransactionID());
            logger.debug_general("Local is locked, so failing current request.");
        } else {
            bl = false;
            logger.debug_general("Local does not have a peer defined, so dropping the current request.");
        }
        if (bl && !this.communicator.send(nISynchronizationData)) {
            logger.debug_general("Failed to send the resync response to the alternate");
        }
    }

    private void handleSingleUpdateResponse(NISynchronizationData nISynchronizationData) {
        NISecurityResult nISecurityResult = nISynchronizationData.getResult();
        if (this.locked && this.alternateConfigured && this.curTransactionID == nISynchronizationData.getTransactionID()) {
            if (nISecurityResult.isSuccessful()) {
                nISecurityResult = this.lastRequest != null ? this.localSingleUpdate(this.lastRequest.getSingleUpdateAction(), this.lastRequest.getObjectTypeToUpdate(), this.lastRequest.getSingleUpdateObject(), this.lastRequest.getAccountName()) : new NISecurityResultImpl(false, -1099689591);
            } else {
                int n = ((NISecurityResultImpl)nISecurityResult).convertErrorToAlternate();
                if (n != 1) {
                    nISecurityResult = new NISecurityResultImpl(false, n);
                }
            }
            this.handleResult(nISecurityResult);
        } else if (!this.locked) {
            logger.debug_general("Local is not locked, so dropping response: " + nISynchronizationData);
        } else if (!this.alternateConfigured) {
            logger.debug_general("Local does not have a peer defined, so dropping response: " + nISynchronizationData);
        } else {
            logger.debug_general("Dropping unexpected response: " + nISynchronizationData);
        }
    }

    private void handleResyncResponse(NISynchronizationData nISynchronizationData) {
        NISecurityResult nISecurityResult = nISynchronizationData.getResult();
        if (this.locked && this.alternateConfigured && this.curTransactionID == nISynchronizationData.getTransactionID()) {
            if (nISecurityResult.isSuccessful()) {
                nISecurityResult = this.handleResyncResponse(nISynchronizationData.getObjects());
            } else {
                int n = ((NISecurityResultImpl)nISecurityResult).convertErrorToAlternate();
                if (n != 1) {
                    nISecurityResult = new NISecurityResultImpl(false, n);
                }
            }
            this.handleResult(nISecurityResult);
        } else if (!this.locked) {
            logger.debug_general("Local is not locked, so dropping response: " + nISynchronizationData);
        } else if (!this.alternateConfigured) {
            logger.debug_general("Local does not have a peer defined, so dropping response: " + nISynchronizationData);
        } else {
            logger.debug_general("Dropping unexpected response: " + nISynchronizationData);
        }
    }

    public void addRequestToWorkQueue(Object object) {
        this.workQueue.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NISecurityResult performRequest(Object object) {
        logger.debug_general("Entering");
        NISecurityResult nISecurityResult = new NISecurityResultImpl(false, -1099689717);
        this.currentResult = null;
        Object object2 = this.responsesWaitObject;
        synchronized (object2) {
            this.addRequestToWorkQueue(object);
            this.notifyForDataFromPeer();
            this.waitForResponseFromPeer();
        }
        if (this.currentResult != null) {
            nISecurityResult = this.currentResult;
        }
        this.unlock();
        logger.debug_general("Exiting");
        return nISecurityResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDataFromPeer() {
        logger.debug_general("Entering");
        try {
            Object object = this.peerDataWaitObject;
            synchronized (object) {
                this.peerDataWaitObject.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            logger.throwable((Throwable)interruptedException);
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            logger.throwable((Throwable)illegalMonitorStateException);
        }
        logger.debug_general("Exiting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyForDataFromPeer() {
        logger.debug_general("Entering");
        try {
            Object object = this.peerDataWaitObject;
            synchronized (object) {
                this.peerDataWaitObject.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            logger.throwable((Throwable)illegalMonitorStateException);
        }
        logger.debug_general("Exiting");
    }

    private void waitForResponseFromPeer() {
        logger.debug_general("Entering");
        try {
            this.responsesWaitObject.wait(50000L);
        }
        catch (InterruptedException interruptedException) {
            logger.throwable((Throwable)interruptedException);
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            logger.throwable((Throwable)illegalMonitorStateException);
        }
        logger.debug_general("Exiting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyForResponseFromPeer() {
        logger.debug_general("Entering");
        try {
            Object object = this.responsesWaitObject;
            synchronized (object) {
                this.responsesWaitObject.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            logger.throwable((Throwable)illegalMonitorStateException);
        }
        logger.debug_general("Exiting");
    }

    private void handleResult(NISecurityResult nISecurityResult) {
        this.currentResult = nISecurityResult;
        this.notifyForResponseFromPeer();
    }

    private NISecurityResult startSyncRepositories(boolean bl) {
        NISecurityResultImpl nISecurityResultImpl = new NISecurityResultImpl(false, -1099689723);
        Vector vector = this.databaseHelper.getAllUserAccounts();
        Vector vector2 = this.databaseHelper.getAllUserGroups();
        vector.ensureCapacity(vector.size() + vector2.size() + 1);
        vector.addAll(vector2);
        vector.add(this.databaseHelper.getSecurityEntry());
        NISynchronizationData nISynchronizationData = new NISynchronizationData(vector, bl);
        this.curTransactionID = nISynchronizationData.getTransactionID();
        if (this.communicator.send(nISynchronizationData)) {
            nISecurityResultImpl = new NISecurityResultImpl(true, 0);
        }
        return nISecurityResultImpl;
    }

    private NISecurityResult startSingleUpdate(int n, int n2, Object object, String string, int n3) {
        NISynchronizationData nISynchronizationData = new NISynchronizationData(n, n2, object, string, n3);
        NISecurityResultImpl nISecurityResultImpl = this.communicator.send(nISynchronizationData) ? new NISecurityResultImpl(true, 0) : new NISecurityResultImpl(false, -1099689723);
        return nISecurityResultImpl;
    }

    private NISecurityResult localSingleUpdate(int n, int n2, Object object, String string) {
        NISecurityResultImpl nISecurityResultImpl;
        int n3 = -1099689591;
        block0 : switch (n) {
            case 1: {
                switch (n2) {
                    case 1: {
                        logger.debug_general("Inserting user account: " + ((NIUserAccount)object).getName());
                        n3 = this.databaseHelper.insertUserAccount((NIUserAccount)object);
                        break block0;
                    }
                    case 2: {
                        logger.debug_general("Inserting user group: " + ((NIUserGroup)object).getName());
                        n3 = this.databaseHelper.insertUserGroup((NIUserGroup)object);
                        break block0;
                    }
                    case 3: {
                        logger.debug_general("Inserting the security settings entry");
                        n3 = this.databaseHelper.insertSecurityEntry((NISecurityTableEntry)object);
                        break block0;
                    }
                }
                logger.error("Received invalid object type to insert: " + n2);
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: {
                        logger.debug_general("Deleting user account: " + object);
                        n3 = this.databaseHelper.deleteUserAccount((String)object);
                        break block0;
                    }
                    case 2: {
                        logger.debug_general("Deleting user group: " + object);
                        n3 = this.databaseHelper.deleteUserGroup((String)object);
                        break block0;
                    }
                    case 3: {
                        logger.debug_general("Deleting the security settings entry");
                        n3 = this.databaseHelper.deleteSecurityEntry();
                        break block0;
                    }
                }
                logger.error("Received invalid object type to delete: " + n2);
                break;
            }
            case 2: {
                switch (n2) {
                    case 1: {
                        logger.debug_general("Modifying user account: " + string);
                        n3 = this.databaseHelper.updateUserAccount(string, (NIUserAccount)object);
                        break block0;
                    }
                    case 2: {
                        logger.debug_general("Modifying user group: " + ((NIUserGroup)object).getName());
                        n3 = this.databaseHelper.updateUserGroup((NIUserGroup)object);
                        break block0;
                    }
                    case 3: {
                        logger.debug_general("Modifying the security settings entry");
                        n3 = this.databaseHelper.updateSecurityEntry((NISecurityTableEntry)object);
                        break block0;
                    }
                }
                logger.error("Received invalid object type to modify: " + n2);
                break;
            }
            default: {
                logger.error("Received invalid update action:" + n);
            }
        }
        if (n3 == 0) {
            nISecurityResultImpl = new NISecurityResultImpl(true, 0);
        } else {
            logger.debug_general("The update failed with reason code: " + Integer.toHexString(n3));
            nISecurityResultImpl = new NISecurityResultImpl(false, n3);
        }
        return nISecurityResultImpl;
    }

    private NISynchronizationData localResyncRepository(NISynchronizationData nISynchronizationData) {
        NISecurityResultImpl nISecurityResultImpl = new NISecurityResultImpl(true, 0);
        Vector vector = nISynchronizationData.getObjects();
        Vector vector2 = this.databaseHelper.getAllUserAccounts();
        Vector vector3 = (Vector)vector2.clone();
        Vector vector4 = this.databaseHelper.getAllUserGroups();
        NISecurityTableEntry nISecurityTableEntry = this.databaseHelper.getSecurityEntry();
        if (vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                int n2;
                int n3;
                Object e = vector.get(n);
                if (e instanceof NIUserAccount) {
                    n3 = Collections.binarySearch(vector2, e);
                    if (n3 < 0) {
                        n2 = Math.abs(n3 + 1);
                        vector2.add(n2, e);
                        logger.debug_general("Adding new account: " + ((NIUserAccount)e).getName());
                    } else {
                        vector2.set(n3, e);
                        logger.debug_general("Updating account: " + ((NIUserAccount)e).getName());
                        n3 = Collections.binarySearch(vector3, e);
                        vector3.remove(n3);
                    }
                } else if (e instanceof NIUserGroup) {
                    n3 = Collections.binarySearch(vector4, e);
                    if (n3 < 0) {
                        n2 = Math.abs(n3 + 1);
                        vector4.add(n2, e);
                        logger.debug_general("Adding new group: " + ((NIUserGroup)e).getName());
                    } else {
                        vector4.set(n3, e);
                        logger.debug_general("Updating group: " + ((NIUserGroup)e).getName());
                    }
                } else if (e instanceof NISecurityTableEntry) {
                    nISecurityTableEntry = (NISecurityTableEntry)e;
                    logger.debug_general("Updating security settings");
                } else {
                    logger.error("Dropping invalid object from the alternate: " + e);
                }
                ++n;
            }
            if (vector2.size() <= 100) {
                if (!(this.databaseHelper.storeAccounts(vector2) && this.databaseHelper.storeGroups(vector4) && this.databaseHelper.storeSecuritySettings(nISecurityTableEntry))) {
                    nISecurityResultImpl = new NISecurityResultImpl(false, -1099689594);
                }
            } else {
                nISecurityResultImpl = new NISecurityResultImpl(false, -1099689714);
            }
        } else {
            nISecurityResultImpl = new NISecurityResultImpl(false, -1099689591);
        }
        if (!nISecurityResultImpl.isSuccessful()) {
            logger.debug_general("The resync request failed with reason code: " + Integer.toHexString(nISecurityResultImpl.getCode()));
            vector3 = new Vector();
        }
        return new NISynchronizationData(nISecurityResultImpl, vector3, nISynchronizationData.getTransactionID());
    }

    private NISynchronizationData overwriteRepository(NISynchronizationData nISynchronizationData) {
        Vector vector = nISynchronizationData.getObjects();
        NISecurityResultImpl nISecurityResultImpl = new NISecurityResultImpl(true, 0);
        Vector vector2 = new Vector(200);
        Vector vector3 = new Vector(20);
        NISecurityTableEntry nISecurityTableEntry = null;
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.get(n);
            if (e instanceof NIUserAccount) {
                vector2.add(e);
                logger.debug_general("Received account: " + ((NIUserAccount)e).getName());
            } else if (e instanceof NIUserGroup) {
                vector3.add(e);
                logger.debug_general("Received group: " + ((NIUserGroup)e).getName());
            } else if (e instanceof NISecurityTableEntry) {
                nISecurityTableEntry = (NISecurityTableEntry)e;
                logger.debug_general("Received security settings");
            } else {
                logger.error("Dropping invalid object from the alternate: " + e);
            }
            ++n;
        }
        if (!(this.databaseHelper.storeAccounts(vector2) && this.databaseHelper.storeGroups(vector3) && this.databaseHelper.storeSecuritySettings(nISecurityTableEntry))) {
            nISecurityResultImpl = new NISecurityResultImpl(false, -1099689594);
            logger.debug_general("The overwrite request failed with reason code: " + Integer.toHexString(nISecurityResultImpl.getCode()));
        }
        return new NISynchronizationData(nISecurityResultImpl, new Vector(), nISynchronizationData.getTransactionID());
    }

    private NISecurityResult handleResyncResponse(Vector vector) {
        NISecurityResultImpl nISecurityResultImpl = new NISecurityResultImpl(true, 0);
        if (vector.size() > 0) {
            Vector vector2 = this.databaseHelper.getAllUserAccounts();
            int n = 0;
            while (n < vector.size()) {
                Object e = vector.get(n);
                vector2.add(e);
                logger.debug_general("Adding new account: " + ((NIUserAccount)e).getName());
                ++n;
            }
            if (!this.databaseHelper.storeAccounts(vector2)) {
                nISecurityResultImpl = new NISecurityResultImpl(false, -1099689594);
            }
        }
        return nISecurityResultImpl;
    }

    public void shutdown() {
        logger.debug_general("Shutting down NISecuritySynchronizer.");
        this.alive = false;
        if (this.communicator != null) {
            this.communicator.shutDown();
        }
        this.interrupt();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

