/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.security;

import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NIUserAccount;
import com.ibm.storage.ess.ni.security.NIConnectionManager;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseHelper;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseManager;
import com.ibm.storage.ess.ni.security.common.NIRecoveryToolPacket;
import java.util.Vector;

public class SecurityRecoveryUtility {
    private static final int MAX_NUMBER_OF_REQUESTS = 3;
    private boolean isESSNIAvailable = false;
    private boolean isParametersValid = false;
    private NIConnectionManager connManager = null;
    private int[] requests = null;
    private Vector invalidParams = new Vector();
    NISecurityDatabaseManager databaseManager = null;
    NISecurityDatabaseHelper dbHelper = null;

    public SecurityRecoveryUtility(String[] stringArray) {
        int n;
        this.requests = new int[stringArray.length];
        this.isParametersValid = this.verifyAndSetupParmeters(stringArray);
        if (!this.isParametersValid) {
            n = 0;
            while (n < this.invalidParams.size()) {
                System.out.println("SecurityRecoveryUtility: Not a recognized argument: " + this.invalidParams.get(n));
                ++n;
            }
            System.out.println("Usage: [-s] Synchronize, [-r] Reset, [-t] terminate");
            System.exit(1);
        }
        this.connManager = new NIConnectionManager();
        this.isESSNIAvailable = this.connManager.createClientSocket();
        if (this.isESSNIAvailable) {
            this.connManager.writeNumberOfPacketsToExpect(this.requests.length);
            n = 0;
            while (n < this.requests.length) {
                this.connManager.writePacket(new NIRecoveryToolPacket(0, this.requests[n], -1));
                ++n;
            }
            int n2 = 0;
            while (n2 < this.requests.length) {
                NIRecoveryToolPacket nIRecoveryToolPacket = this.connManager.readPacket();
                if (nIRecoveryToolPacket.getResponseData() == 0) {
                    if (nIRecoveryToolPacket.getResponseType() == 2) {
                        System.out.println("SecurityRecoveryUtility: Reset command was successful");
                    } else if (nIRecoveryToolPacket.getResponseType() == 4) {
                        System.out.println("SecurityRecoveryUtility: Termination command was successful");
                    } else {
                        System.out.println("SecurityRecoveryUtility: Synchronization command was successful");
                    }
                } else {
                    if (nIRecoveryToolPacket.getResponseType() == 2) {
                        System.out.println("SecurityRecoveryUtility: Reset command failed, return code = " + Integer.toHexString(nIRecoveryToolPacket.getResponseData()));
                    } else {
                        System.out.println("SecurityRecoveryUtility: Synchronization command failed, return code = " + Integer.toHexString(nIRecoveryToolPacket.getResponseData()));
                    }
                    System.exit(1);
                }
                ++n2;
            }
        } else {
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-r")) {
                    this.databaseManager = NISecurityDatabaseManager.getDatabaseManager();
                    this.dbHelper = NISecurityDatabaseManager.getDatabaseHelper();
                    String[] stringArray2 = new String[]{"Administrator"};
                    NIUserAccount nIUserAccount = NIResourceFactory.newUserAccount("admin", "admin", stringArray2);
                    int n3 = this.dbHelper.getUserAccount(nIUserAccount.getName()) == null ? this.dbHelper.insertUserAccount(nIUserAccount) : this.dbHelper.updateUserAccount(nIUserAccount.getName(), nIUserAccount);
                    if (n3 == 0) {
                        System.out.println("SecurityRecoveryUtility: Reset successful.");
                    } else {
                        System.out.println("SecurityRecoveryUtility: Reset failed, return code = " + Integer.toHexString(n3));
                        System.exit(1);
                    }
                } else if (stringArray[n].equals("-t")) {
                    System.out.println("SecurityRecoveryUtility: Termination failed, ESSNI server is either already down or unavailable");
                    System.exit(1);
                } else {
                    System.out.println("SecurityRecoveryUtility: Synchronizaton failed, ESSNI server not available");
                    System.exit(1);
                }
                ++n;
            }
        }
    }

    private boolean verifyAndSetupParmeters(String[] stringArray) {
        boolean bl = true;
        if (stringArray.length > 3 || stringArray.length == 0) {
            System.out.println("SecurityRecoveryUtility: Specify one or two arguments");
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-r")) {
                this.requests[n] = 2;
            } else if (stringArray[n].equals("-s")) {
                this.requests[n] = 3;
            } else if (stringArray[n].equals("-t")) {
                if (stringArray.length != 1) {
                    System.out.println("SecurityRecoveryUtility: Do not specify the termiante flag, with other flags");
                    return false;
                }
                this.requests[n] = 4;
            } else {
                this.invalidParams.add(stringArray[n]);
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        SecurityRecoveryUtility securityRecoveryUtility = new SecurityRecoveryUtility(stringArray);
    }
}

