/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.security.authentication;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.resource.NIUserAccountImpl;
import com.ibm.storage.ess.ni.security.NIClientAuthenticator;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseHelper;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseManager;
import com.ibm.storage.ess.ni.security.NISecuritySynchronizer;
import com.ibm.storage.ess.ni.security.common.NIAuthenticationInfo;
import com.ibm.storage.ess.ni.security.common.NISecurityTableEntry;
import com.ibm.storage.ess.ni.security.common.NISynchronizationData;
import java.util.Calendar;
import java.util.Date;

public class NISecureClientAuthenticator
implements NIClientAuthenticator {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$security$authentication$NISecureClientAuthenticator == null ? (class$com$ibm$storage$ess$ni$security$authentication$NISecureClientAuthenticator = NISecureClientAuthenticator.class$("com.ibm.storage.ess.ni.security.authentication.NISecureClientAuthenticator")) : class$com$ibm$storage$ess$ni$security$authentication$NISecureClientAuthenticator);
    private NISecurityDatabaseHelper databaseHelper = NISecurityDatabaseManager.getDatabaseHelper();
    private NISecuritySynchronizer syncObject = NISecuritySynchronizer.getSecuritySynchronizer();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$security$authentication$NISecureClientAuthenticator;

    public int isAuthenticated(NIAuthenticationInfo nIAuthenticationInfo) {
        int n;
        if (nIAuthenticationInfo != null) {
            NIUserAccountImpl nIUserAccountImpl = (NIUserAccountImpl)this.databaseHelper.getUserAccount(nIAuthenticationInfo.getUsername());
            NISecurityTableEntry nISecurityTableEntry = this.databaseHelper.getSecurityEntry();
            if (nIUserAccountImpl != null && nISecurityTableEntry != null && !nIUserAccountImpl.isAccountLocked()) {
                Object object;
                if (nIAuthenticationInfo.getPassword() != null && nIAuthenticationInfo.getPassword().equals(nIUserAccountImpl.getPassword())) {
                    n = 7;
                    nIUserAccountImpl.setNumFailedLogins(0);
                    nIUserAccountImpl.setLastAuthenticatedDate(new Date());
                    int n2 = nISecurityTableEntry.getDaysToExpire();
                    if (n2 > 0) {
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime(nIUserAccountImpl.getPasswordChangedDate());
                        ((Calendar)object).add(5, n2);
                        Calendar calendar = Calendar.getInstance();
                        if (calendar.after(object)) {
                            nIUserAccountImpl.setPasswordExpired();
                        }
                    }
                } else {
                    nIUserAccountImpl.setNumFailedLogins(nIUserAccountImpl.getNumFailedLogins() + 1);
                    n = 1;
                    if (nISecurityTableEntry.getMaxFailedLogins() != 0 && nIUserAccountImpl.getNumFailedLogins() >= nISecurityTableEntry.getMaxFailedLogins()) {
                        nIUserAccountImpl.setAccountLocked(true);
                    }
                }
                NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 1, nIUserAccountImpl, nIUserAccountImpl.getName());
                logger.debug_general("Going to call NISecuritySynchronizer.performRequest");
                object = this.syncObject.performRequest(nISynchronizationData);
                logger.debug_general("Came back from call to NISecuritySynchronizer.performRequest");
                if (!object.isSuccessful()) {
                    logger.error("Failed to update user account: " + nIAuthenticationInfo.getUsername() + ", and failure code is 0x" + Integer.toHexString(object.getCode()));
                }
            } else {
                n = nIUserAccountImpl == null ? 2 : (nISecurityTableEntry == null ? 4 : 3);
            }
        } else {
            n = 5;
            logger.debug_general("The authentication info object passed in is null, authentication failed");
        }
        logger.debug_general("isAuthenticated is returning the " + this.getTextForFailure(n) + " code for user: " + nIAuthenticationInfo.getUsername());
        return n;
    }

    private String getTextForFailure(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "wrong password failure";
                break;
            }
            case 2: {
                string = "account does not exist failure";
                break;
            }
            case 3: {
                string = "account locked failure";
                break;
            }
            case 4: {
                string = "database not accessible failure";
                break;
            }
            case 5: {
                string = "invalid parameters failure";
                break;
            }
            case 7: {
                string = "successful return";
                break;
            }
            default: {
                string = Integer.toString(n);
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

