/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.server;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.agent.NIManagementCommandAgent;
import com.ibm.storage.ess.ni.agent.common.rmcutil.NIMcSessionManager;
import com.ibm.storage.ess.ni.agent.hmc.NIHMCCommandAgent;
import com.ibm.storage.ess.ni.agent.hmc.NIHybridManagementConsoleCommandAgent;
import com.ibm.storage.ess.ni.agent.simulation.NISimulationCommandAgent;
import com.ibm.storage.ess.ni.callhome.server.NICallHomeServer;
import com.ibm.storage.ess.ni.commandagent.NICommandAgentStartupException;
import com.ibm.storage.ess.ni.communication.NICommunicationExecutor;
import com.ibm.storage.ess.ni.communication.extensions.server.NICommunicationServer;
import com.ibm.storage.ess.ni.eventManager.client.NIEventServer;
import com.ibm.storage.ess.ni.eventManager.server.NIEventServerImpl;
import com.ibm.storage.ess.ni.logging.NIFileMaintenanceThread;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterThread;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.olc.NIOlc;
import com.ibm.storage.ess.ni.security.NIClientAuthenticator;
import com.ibm.storage.ess.ni.security.NICommandAuthorizer;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseManager;
import com.ibm.storage.ess.ni.security.authentication.NIClientAuthenticatorFactory;
import com.ibm.storage.ess.ni.security.authorization.NICommandAuthorizerFactory;
import com.ibm.storage.ess.ni.server.NIServerThreadGroup;
import com.ibm.storage.ess.ni.server.command.NICommandRouter;
import com.ibm.storage.ess.ni.server.command.NIResponseReceiver;
import com.ibm.storage.ess.ni.server.common.NIServer;
import com.ibm.storage.ess.ni.server.event.NIEventReceiver;
import com.ibm.storage.ess.ni.services.NIAsyncPPRCService;
import com.ibm.storage.ess.ni.services.NICopyCommonService;
import com.ibm.storage.ess.ni.services.NIDomainService;
import com.ibm.storage.ess.ni.services.NIFlashCopyService;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import com.ibm.storage.ess.ni.services.NIPPRCService;
import com.ibm.storage.ess.ni.services.NISessionService;
import java.io.FileNotFoundException;
import java.io.IOException;

public class NIESSNIServer
implements NIServer {
    private static NIESSNIServer singleton = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$server$NIESSNIServer == null ? (class$com$ibm$storage$ess$ni$server$NIESSNIServer = NIESSNIServer.class$("com.ibm.storage.ess.ni.server.NIESSNIServer")) : class$com$ibm$storage$ess$ni$server$NIESSNIServer);
    private NIClientAuthenticator authenticator;
    private NICommandAuthorizer authorizer;
    private NICommunicationServer communicationServer;
    private NIResponseReceiver responseReceiver;
    private NIESSNIServerThread serverThread = null;
    private NIMessageRouterChannel channel;
    private NIManagementCommandAgent commandAgent;
    private NIEventServer eventServer;
    private NICallHomeServer callHomeServer;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$server$NIESSNIServer;

    private NIESSNIServer() throws IOException, FileNotFoundException {
        logger.debug_general("****************Server Started**********");
        this.communicationServer = NICommunicationServer.getInstanceOf();
        this.communicationServer.setESSNIServer(this);
        logger.debug_general("Communication Server Started");
        NISecurityDatabaseManager nISecurityDatabaseManager = NISecurityDatabaseManager.getDatabaseManager();
        this.authenticator = NIClientAuthenticatorFactory.createClientAuthenticator(1);
        logger.debug_general("Client Authenticator set to: SECURITY_REPOSITORY");
        this.authorizer = NICommandAuthorizerFactory.createCommandAuthorizer(1);
        logger.debug_general("Command Authorizer set to: SECURITY_REPOSITORY");
        int n = NIAgentProperties.getAgentType();
        NIMessageRouter nIMessageRouter = NIMessageRouterFactory.getInstanceOf();
        NIEventReceiver nIEventReceiver = new NIEventReceiver(this.communicationServer);
        this.eventServer = new NIEventServerImpl(nIEventReceiver);
        logger.debug_general("Event Server Started");
        if (n == 3) {
            NIMcSessionManager.establishSessions(false);
            this.startMessageRouter(nIMessageRouter, false);
            logger.debug_general("Message Router Started - in online mode");
            this.startHMCCommandAgent(nIMessageRouter);
            logger.debug_general("HMC Command Agent Started");
        } else if (n == 11) {
            this.startMessageRouter(nIMessageRouter, true);
            logger.debug_general("Message Router Started - in simulation mode");
            this.startSimulationCommandAgent(nIMessageRouter);
            logger.debug_general("Simulation Command Agent Started");
        } else if (n == 1) {
            this.startMessageRouter(nIMessageRouter, false);
            logger.debug_general("Message Router Started - in hyrid mode");
            this.startHybridCommandAgent(nIMessageRouter);
            logger.debug_general("Hybrid Command Agent Started");
        } else if (n == 10) {
            this.startMessageRouter(nIMessageRouter, true);
            logger.debug_general("Message Router Started - in offline mode");
            this.startHybridCommandAgent(nIMessageRouter);
            logger.debug_general("Offline Command Agent Started");
        } else {
            logger.error("Agent type of " + n + " not supported for ESSNI Server.  Shutting down server.");
            this.shutdown();
            return;
        }
        this.responseReceiver = new NIResponseReceiver(this.channel, this.communicationServer);
        logger.debug_general("Response Reciever Started");
        NIFileMaintenanceThread.start();
        logger.debug_general("File Maintenance Thread Started");
    }

    private void startHybridCommandAgent(NIMessageRouter nIMessageRouter) {
        try {
            this.commandAgent = new NIHybridManagementConsoleCommandAgent(this.eventServer, new NIMessageRouterAddress(2, nIMessageRouter.getEssServerName()));
            this.commandAgent.start();
            int n = NIAgentProperties.getAgentType();
            if (n == 1) {
                this.callHomeServer = new NICallHomeServer();
                this.callHomeServer.start();
            }
            NIOlc.startCloudscape();
            logger.debug_general("Cloudscape Started");
            NIOlc.importXML("olc.xml");
            logger.debug_general("XML Imported");
        }
        catch (NICommandAgentStartupException nICommandAgentStartupException) {
            logger.throwable((Throwable)nICommandAgentStartupException);
            logger.error("Unable to start command agent.");
        }
    }

    private void startHMCCommandAgent(NIMessageRouter nIMessageRouter) {
        try {
            this.commandAgent = new NIHMCCommandAgent(this.eventServer, new NIMessageRouterAddress(2, nIMessageRouter.getEssServerName()), this.communicationServer);
            this.commandAgent.start();
            NIOlc.startCloudscape();
        }
        catch (NICommandAgentStartupException nICommandAgentStartupException) {
            logger.throwable((Throwable)nICommandAgentStartupException);
            logger.error("Unable to start command agent.");
        }
    }

    private void startSimulationCommandAgent(NIMessageRouter nIMessageRouter) {
        try {
            this.commandAgent = new NISimulationCommandAgent(new NIMessageRouterAddress(3, nIMessageRouter.getEssServerName()), this.eventServer);
            this.commandAgent.start();
            NIOlc.startCloudscape();
            logger.debug_general("Cloudscape Started");
            NIOlc.importXML("olc.xml");
            logger.debug_general("XML Imported");
        }
        catch (NICommandAgentStartupException nICommandAgentStartupException) {
            logger.throwable((Throwable)nICommandAgentStartupException);
            logger.error("Unable to start command agent.");
        }
    }

    private void startMessageRouter(NIMessageRouter nIMessageRouter, boolean bl) {
        NIMessageRouterThread nIMessageRouterThread = null;
        try {
            nIMessageRouterThread = new NIMessageRouterThread();
            nIMessageRouterThread.start();
            if (!bl) {
                Thread.sleep(2000L);
            }
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            logger.error("Unable to create Message Router due to invalid message router metadata file.");
        }
        try {
            this.channel = nIMessageRouter.createNIMessageRouterChannel(4);
        }
        catch (NIMessageRouterException nIMessageRouterException) {
            logger.throwable((Throwable)nIMessageRouterException);
            logger.error("Unable to create Message Router process channel because it is already in use.");
        }
    }

    public NICommandAuthorizer getCommandAuthorizer() {
        return this.authorizer;
    }

    public NIClientAuthenticator getClientAuthenticator() {
        return this.authenticator;
    }

    public NIEventServer getEventServer() {
        return this.eventServer;
    }

    public NIFlashCopyService getFlashCopyService() {
        return null;
    }

    public NIPPRCService getPPRCService() {
        return null;
    }

    public NIDomainService getDomainService() {
        return null;
    }

    public NICopyCommonService getCopyCommonService() {
        return null;
    }

    public NIAsyncPPRCService getAsyncPPRCService() {
        return null;
    }

    public NISessionService getSessionService() {
        return null;
    }

    public NILogicalConfigurationService getLogicalConfigurationService() {
        return null;
    }

    public void shutdown() {
        logger.debug_general("NIESSNIServer: Server initiating shutdown");
        if (this.commandAgent != null) {
            this.commandAgent.stop();
        }
        if (this.communicationServer != null) {
            this.communicationServer.shutdown();
            this.communicationServer = null;
        }
        if (this.responseReceiver != null) {
            this.responseReceiver.shutdown();
            this.serverThread = null;
        }
        if (this.serverThread != null) {
            this.serverThread.shutdown();
            this.serverThread = null;
        }
        if (this.callHomeServer != null) {
            this.callHomeServer.shutdown();
            this.callHomeServer = null;
        }
        logger.debug_general("File Maintenance Thread Stoping");
        NIFileMaintenanceThread.stop();
        logger.debug_general("Ending all NIMcSessions");
        NIMcSessionManager.stopAll();
        logger.debug_general("Server shutdown complete");
    }

    private void run() {
        this.serverThread = new NIESSNIServerThread();
        this.serverThread.start();
        try {
            this.communicationServer.startup();
            logger.debug_general("Ready to receive connections");
            this.serverThread.join();
        }
        catch (InterruptedException interruptedException) {
            logger.debug_general("Server interrupted and shutdown");
        }
    }

    public static NIESSNIServer getInstanceOf() throws Exception {
        if (singleton == null) {
            singleton = new NIESSNIServer();
        }
        return singleton;
    }

    public static void main(String[] stringArray) {
        try {
            NIESSNIServer nIESSNIServer = null;
            try {
                nIESSNIServer = NIESSNIServer.getInstanceOf();
            }
            catch (IOException iOException) {
                logger.throwable((Throwable)iOException);
                logger.error("Exception creating ESSNIServer.  Exiting");
                System.exit(1);
            }
            nIESSNIServer.run();
            System.exit(0);
        }
        catch (Throwable throwable) {
            logger.error("Unhandled exception caught during Runtime.  Shutting down...", "NIESSNIServer", "main", null);
            logger.throwable(throwable);
            System.exit(1);
        }
    }

    public NICommunicationExecutor getDefaultCommunicationExecutor(NICommunicationServer nICommunicationServer) {
        return NICommandRouter.getCommandRouter(this.channel, nICommunicationServer);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NIESSNIServerThread
    extends Thread {
        private boolean running;

        public NIESSNIServerThread() {
            super((ThreadGroup)NIServerThreadGroup.getServerThreadGroup(), "NIESSNIServerThread");
        }

        public NIESSNIServerThread(Runnable runnable) {
            super(runnable);
        }

        public NIESSNIServerThread(ThreadGroup threadGroup, Runnable runnable) {
            super(threadGroup, runnable);
        }

        public NIESSNIServerThread(String string) {
            super(string);
        }

        public NIESSNIServerThread(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
        }

        public NIESSNIServerThread(Runnable runnable, String string) {
            super(runnable, string);
        }

        public NIESSNIServerThread(ThreadGroup threadGroup, Runnable runnable, String string) {
            super(threadGroup, runnable, string);
        }

        public void shutdown() {
            this.running = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            try {
                NIESSNIServerThread nIESSNIServerThread = this;
                synchronized (nIESSNIServerThread) {
                    while (this.running) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                logger.debug_general("Server thread shutting down");
            }
        }
    }
}

