/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.server.command;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.command.extensions.NICommandID;
import com.ibm.storage.ess.ni.command.extensions.NICommandTransporter;
import com.ibm.storage.ess.ni.command.extensions.NIConnectionCommand;
import com.ibm.storage.ess.ni.command.extensions.NIConnectionTypeQuery;
import com.ibm.storage.ess.ni.command.extensions.NIGetPeerHMCAddressCommand;
import com.ibm.storage.ess.ni.command.extensions.NISecurityCommand;
import com.ibm.storage.ess.ni.command.extensions.NIStopESSNIServer;
import com.ibm.storage.ess.ni.communication.NICommunication;
import com.ibm.storage.ess.ni.communication.NICommunicationExecutor;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.communication.extensions.server.NIClientConnection;
import com.ibm.storage.ess.ni.communication.extensions.server.NICommunicationServer;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterOutputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.common.NIESSNIConstants;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.server.command.NIShutdownThread;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;

public class NICommandRouter
extends NICommunicationExecutor
implements NIESSNIConstants {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$server$command$NICommandRouter == null ? (class$com$ibm$storage$ess$ni$server$command$NICommandRouter = NICommandRouter.class$("com.ibm.storage.ess.ni.server.command.NICommandRouter")) : class$com$ibm$storage$ess$ni$server$command$NICommandRouter);
    private NIMessageRouterAddress myAddress;
    private String myServerName;
    private NIMessageRouter messageRouterInterface = NIMessageRouterFactory.getInstanceOf();
    private static NICommandRouter commandRouter;
    private NIMessageRouterChannel channel;
    private NIMessageRouterOutputStream mros;
    private NICommunicationServer commServer;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$server$command$NICommandRouter;

    private NICommandRouter(NIMessageRouterChannel nIMessageRouterChannel, NICommunicationServer nICommunicationServer) {
        this.myServerName = this.messageRouterInterface.getEssServerName();
        this.myAddress = new NIMessageRouterAddress(4, this.myServerName);
        this.channel = nIMessageRouterChannel;
        this.commServer = nICommunicationServer;
        this.mros = nIMessageRouterChannel.getNIMessageRouterOutputStream();
    }

    public static NICommandRouter getCommandRouter(NIMessageRouterChannel nIMessageRouterChannel, NICommunicationServer nICommunicationServer) {
        if (commandRouter == null) {
            commandRouter = new NICommandRouter(nIMessageRouterChannel, nICommunicationServer);
        }
        return commandRouter;
    }

    protected NICommunication executeImpl(NICommunication nICommunication) {
        NICommand nICommand = (NICommand)nICommunication;
        String string = this.messageRouterInterface.getEssServerName();
        if (!this.myServerName.equals(string)) {
            this.myServerName = string;
            this.myAddress = new NIMessageRouterAddress(4, this.myServerName);
        }
        nICommand.getAddress().setReturnAddress(this.myAddress);
        if (nICommand instanceof NIConnectionCommand) {
            this.handleConnectionCommand((NIConnectionCommand)nICommand);
        } else if (this.isCommandAuthorized(nICommand)) {
            int n = NIAgentProperties.getAgentType();
            if (n == 11 && !(nICommand instanceof NISecurityCommand)) {
                String string2 = nICommand.getAddress().getDestinationAddress().getEssServerName();
                if (!string2.equals("HMC1") && !string2.equals("MN0") && string2.endsWith("1")) {
                    nICommand.setException(new NIUnavailableServerException());
                    nICommand.getAddress().reverseAddress();
                } else {
                    nICommand.getAddress().setDestinationAddress(new NIMessageRouterAddress(3, this.messageRouterInterface.getEssServerName()));
                }
            }
        } else {
            if (this.isSupported(nICommand)) {
                if (this.isPasswordExpired(nICommand)) {
                    if (this.isNewAccount(nICommand)) {
                        nICommand.setException(new NIUnauthorizedServerException(2, 3, "Client # " + Integer.toHexString(nICommand.getID().getClientID().toInteger()) + " is using a new account whose password must be changed prior to use, so the following command is not authorized: " + nICommand));
                    } else {
                        nICommand.setException(new NIUnauthorizedServerException(2, 2, "Client # " + Integer.toHexString(nICommand.getID().getClientID().toInteger()) + " is using an account whose password is expired, so the following command is not authorized: " + nICommand));
                    }
                } else {
                    nICommand.setException(new NIUnauthorizedServerException(2, 1, "Client # " + Integer.toHexString(nICommand.getID().getClientID().toInteger()) + " the following command is not authorized for this client: " + nICommand));
                }
            }
            nICommand.getAddress().reverseAddress();
        }
        this.sendToMR(nICommand);
        return null;
    }

    private boolean isSupported(NICommand nICommand) {
        boolean bl = false;
        try {
            Class[] classArray = nICommand.getParamTypes();
            Class.forName(nICommand.getServiceName()).getMethod(nICommand.getMethodName(), classArray);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            nICommand.setException(new NIUnsupportedException(noSuchMethodException.toString()));
        }
        catch (SecurityException securityException) {
            nICommand.setException(new NIUnsupportedException(securityException.toString()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            nICommand.setException(new NIUnsupportedException(classNotFoundException.toString()));
        }
        catch (IllegalAccessException illegalAccessException) {
            nICommand.setException(new NIUnsupportedException(illegalAccessException.toString()));
        }
        catch (InvocationTargetException invocationTargetException) {
            NIServerException nIServerException;
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof NIUnsupportedException) {
                nIServerException = (NIUnsupportedException)throwable;
            } else {
                nIServerException = new NIServerException(2, invocationTargetException.toString());
                nIServerException.initCause(throwable);
            }
            nICommand.setException(nIServerException);
        }
        catch (NIServerException nIServerException) {
            nICommand.setException(nIServerException);
        }
        catch (Exception exception) {
            nICommand.setException(new NIServerException(2, exception.toString()));
        }
        return bl;
    }

    private void sendToMR(NICommand nICommand) {
        NICommandTransporter nICommandTransporter = new NICommandTransporter(nICommand);
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = null;
        try {
            nIMessageRouterReturnStatus = this.mros.send(nICommandTransporter.getAddress().getDestinationAddress(), nICommandTransporter);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            logger.error("Client # " + Integer.toHexString(nICommand.getID().getClientID().toInteger()) + " had exception sending command to message router: " + nICommand);
            this.handleMessageRouterError(nICommand, -20);
        }
        if (nIMessageRouterReturnStatus.getStatus() != 1 && nIMessageRouterReturnStatus.getStatus() != 9) {
            logger.error("Client # " + Integer.toHexString(nICommand.getID().getClientID().toInteger()) + " had status of send to NIMessageRouterOutputStream of " + nIMessageRouterReturnStatus.getStatus() + " for the command: " + nICommand);
            this.handleMessageRouterError(nICommand, nIMessageRouterReturnStatus.getStatus());
        } else {
            logger.debug_general("Client # " + Integer.toHexString(nICommand.getID().getClientID().toInteger()) + " sent command to Message Router: " + nICommand);
        }
    }

    private void handleConnectionCommand(NIConnectionCommand nIConnectionCommand) {
        if (nIConnectionCommand instanceof NIGetPeerHMCAddressCommand) {
            NIGetPeerHMCAddressCommand nIGetPeerHMCAddressCommand = (NIGetPeerHMCAddressCommand)nIConnectionCommand;
            NIMessageRouter nIMessageRouter = NIMessageRouterFactory.getInstanceOf();
            InetAddress inetAddress = null;
            InetAddress[] inetAddressArray = nIMessageRouter.getPeerIPAddresses();
            if (inetAddressArray != null && inetAddressArray.length >= 1) {
                inetAddress = inetAddressArray[0];
                logger.debug_general("Client # " + Integer.toHexString(nIGetPeerHMCAddressCommand.getID().getClientID().toInteger()) + " found peer HMC: " + inetAddress.getHostAddress());
            } else {
                inetAddress = null;
                logger.debug_general("Client # " + Integer.toHexString(nIGetPeerHMCAddressCommand.getID().getClientID().toInteger()) + " found no peer HMC.");
            }
            nIGetPeerHMCAddressCommand.setPeerHMCAddress(inetAddress);
            if (nIMessageRouter.getEssServerName().equals("HMC1")) {
                nIConnectionCommand.getAddress().setDestinationAddress(new NIMessageRouterAddress(2, "HMC2"));
                nIGetPeerHMCAddressCommand.setHMCNumber(1);
            } else {
                nIConnectionCommand.getAddress().setDestinationAddress(new NIMessageRouterAddress(2, "HMC1"));
                nIGetPeerHMCAddressCommand.setHMCNumber(2);
            }
        } else if (nIConnectionCommand instanceof NIConnectionTypeQuery) {
            NIConnectionTypeQuery nIConnectionTypeQuery = (NIConnectionTypeQuery)nIConnectionCommand;
            nIConnectionTypeQuery.setConnectionType(NIAgentProperties.getAgentType());
            nIConnectionCommand.getAddress().reverseAddress();
        } else if (nIConnectionCommand instanceof NIStopESSNIServer) {
            logger.debug_general("ESSNI Server shutting down.");
            NIShutdownThread nIShutdownThread = new NIShutdownThread();
            nIShutdownThread.start();
            nIConnectionCommand.getAddress().reverseAddress();
        }
    }

    private void handleMessageRouterError(NICommand nICommand, int n) {
        int n2 = -1;
        switch (n) {
            case -6: {
                n2 = 4;
                break;
            }
            case -3: {
                n2 = 5;
            }
        }
        nICommand.setException(new NIUnavailableServerException(n2, "Unable to send command from server: " + nICommand));
        this.loopbackCommand(nICommand);
    }

    private void loopbackCommand(NICommand nICommand) {
        NIMessageRouterAddress nIMessageRouterAddress = nICommand.getAddress().getDestinationAddress();
        nICommand.getAddress().setDestinationAddress(nICommand.getAddress().getReturnAddress());
        nICommand.getAddress().setReturnAddress(nIMessageRouterAddress);
        NICommandTransporter nICommandTransporter = new NICommandTransporter(nICommand);
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = null;
        try {
            nIMessageRouterReturnStatus = this.mros.send(nICommandTransporter.getAddress().getDestinationAddress(), nICommandTransporter);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            logger.error("Client # " + Integer.toHexString(nICommand.getID().getClientID().toInteger()) + " had exception while trying to loop command which fialed to send over message router back to self: " + nICommand);
        }
        if (nIMessageRouterReturnStatus.getStatus() != 1 && nIMessageRouterReturnStatus.getStatus() != 9) {
            logger.error("Client # " + Integer.toHexString(nICommand.getID().getClientID().toInteger()) + " had error while trying to loop command which fialed to send over message router back to self with status of " + nIMessageRouterReturnStatus.getStatus() + " for the command: " + nICommand);
        }
    }

    private boolean isCommandAuthorized(NICommand nICommand) {
        NICommandID nICommandID = nICommand.getID();
        NIClientConnectionToken nIClientConnectionToken = nICommandID.getClientID();
        NIClientConnection nIClientConnection = this.commServer.getClient(nIClientConnectionToken);
        boolean bl = false;
        if (nIClientConnection == null) {
            logger.error("Obtained a null client connection for token: " + nIClientConnectionToken);
            throw new NullPointerException("Obtained a null client connection for token: " + nIClientConnectionToken);
        }
        bl = nIClientConnection.isCommandAuthorized(nICommand);
        return bl;
    }

    private boolean isPasswordExpired(NICommand nICommand) {
        NICommandID nICommandID = nICommand.getID();
        NIClientConnectionToken nIClientConnectionToken = nICommandID.getClientID();
        NIClientConnection nIClientConnection = this.commServer.getClient(nIClientConnectionToken);
        boolean bl = false;
        if (nIClientConnection == null) {
            logger.error("Obtained a null client connection for token: " + nIClientConnectionToken);
            throw new NullPointerException("Obtained a null client connection for token: " + nIClientConnectionToken);
        }
        bl = nIClientConnection.isPasswordExpired();
        return bl;
    }

    private boolean isNewAccount(NICommand nICommand) {
        NICommandID nICommandID = nICommand.getID();
        NIClientConnectionToken nIClientConnectionToken = nICommandID.getClientID();
        NIClientConnection nIClientConnection = this.commServer.getClient(nIClientConnectionToken);
        boolean bl = false;
        if (nIClientConnection == null) {
            logger.error("Obtained a null client connection for token: " + nIClientConnectionToken);
            throw new NullPointerException("Obtained a null client connection for token: " + nIClientConnectionToken);
        }
        bl = nIClientConnection.isNewAccount();
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

