/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.server.command;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogCommandResponseQueue;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogProcessor;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.command.extensions.NICommandAddress;
import com.ibm.storage.ess.ni.command.extensions.NICommandTransporter;
import com.ibm.storage.ess.ni.command.extensions.NIUnsupportedCommand;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientUnavailableException;
import com.ibm.storage.ess.ni.communication.extensions.server.NICommunicationServer;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterInputStream;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.server.NIServerThreadGroup;
import java.io.IOException;

public class NIResponseReceiver
implements Runnable {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$server$command$NIResponseReceiver == null ? (class$com$ibm$storage$ess$ni$server$command$NIResponseReceiver = NIResponseReceiver.class$("com.ibm.storage.ess.ni.server.command.NIResponseReceiver")) : class$com$ibm$storage$ess$ni$server$command$NIResponseReceiver);
    private NIMessageRouterAddress myAddress;
    private NIMessageRouterInputStream inputStream;
    private NIMessageRouterChannel channel;
    private NICommunicationServer commServer;
    private boolean running = false;
    private Thread myThread;
    private NIAuditLogProcessor auditLogProcessor;
    private NIAuditLogCommandResponseQueue auditLogResponseQueue = NIAuditLogCommandResponseQueue.getInstance();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$server$command$NIResponseReceiver;

    public NIResponseReceiver(NIMessageRouterChannel nIMessageRouterChannel, NICommunicationServer nICommunicationServer) {
        this.commServer = nICommunicationServer;
        NIMessageRouter nIMessageRouter = NIMessageRouterFactory.getInstanceOf();
        this.myAddress = new NIMessageRouterAddress(4, nIMessageRouter.getEssServerName());
        this.channel = nIMessageRouterChannel;
        this.inputStream = nIMessageRouterChannel.getNIMessageRouterInputStream();
        this.myThread = new Thread(NIServerThreadGroup.getServerThreadGroup(), this, "NIResponseReceiver");
        this.running = true;
        this.myThread.start();
        this.auditLogProcessor = new NIAuditLogProcessor();
        this.auditLogProcessor.start();
    }

    public void shutdown() {
        logger.debug_general("Shutting down NIResponseReceiver and NIMessageRouterChannel.");
        this.running = false;
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            logger.error("Unable to properly shut down NIMessageRouterChannel.");
            logger.throwable((Throwable)iOException);
        }
        this.auditLogProcessor.shutdown();
    }

    public void run() {
        while (this.running) {
            try {
                NICommandTransporter nICommandTransporter = null;
                NICommand nICommand = null;
                try {
                    nICommandTransporter = (NICommandTransporter)this.inputStream.readObject();
                    nICommand = nICommandTransporter.getCommand();
                }
                catch (InterruptedException interruptedException) {
                    logger.warning("Read from message router channel was interrupted.");
                    logger.throwable((Throwable)interruptedException);
                }
                catch (NIMessageRouterException nIMessageRouterException) {
                    logger.warning("Read from message router failed with an IO excpetion.");
                    logger.throwable((Throwable)nIMessageRouterException);
                }
                if (nICommand == null) {
                    nICommand = new NIUnsupportedCommand(nICommandTransporter.getAddress());
                    continue;
                }
                NIClientConnectionToken nIClientConnectionToken = nICommand.getID().getClientID();
                NICommandAddress nICommandAddress = nICommand.getAddress();
                String string = nICommandAddress.getDestinationAddress().getEssServerName();
                int n = 4;
                if (!string.startsWith("HMC")) {
                    nICommand.setException(new NIUnavailableServerException(n, "Unable to send command from alternate server to destination server: " + nICommand));
                }
                logger.debug_general("Client # " + nIClientConnectionToken + " recieving command from Message Router: " + nICommand);
                this.auditLogResponseQueue.enqueue(nICommand);
                try {
                    this.commServer.send(nIClientConnectionToken, nICommand);
                }
                catch (NIClientUnavailableException nIClientUnavailableException) {
                    logger.error("Unable to send command to client #" + nIClientConnectionToken + ".");
                    logger.throwable((Throwable)nIClientUnavailableException);
                }
                catch (NIUnsupportedException nIUnsupportedException) {
                    logger.error("Command is not supported by the connected client #" + nIClientConnectionToken);
                    logger.throwable((Throwable)nIUnsupportedException);
                }
            }
            catch (Exception exception) {
                logger.error("Unexpected error occurred");
                logger.throwable((Throwable)exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

