/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.util;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NIWakeupTask;
import java.util.TreeMap;

public class NIWatchdogManager
implements Runnable {
    private static NIWatchdogManager singleton = null;
    private Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$util$NIWatchdogManager == null ? (class$com$ibm$storage$ess$ni$util$NIWatchdogManager = NIWatchdogManager.class$("com.ibm.storage.ess.ni.util.NIWatchdogManager")) : class$com$ibm$storage$ess$ni$util$NIWatchdogManager);
    private TreeMap queue;
    private Object lock = new Object();
    private boolean running = false;
    private boolean updated = false;
    private Thread executionThread;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$util$NIWatchdogManager;

    public static synchronized NIWatchdogManager getWatchdogManager() {
        if (singleton == null) {
            singleton = new NIWatchdogManager();
        }
        return singleton;
    }

    private NIWatchdogManager() {
        this.queue = new TreeMap();
        this.executionThread = new Thread((Runnable)this, "NIWatchdogManager");
        this.executionThread.setDaemon(true);
        this.executionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                while (!this.queue.isEmpty()) {
                    Long l = (Long)this.queue.firstKey();
                    NIWakeupTask nIWakeupTask = (NIWakeupTask)this.queue.get(l);
                    long l2 = l - System.currentTimeMillis();
                    try {
                        if (l2 > 0L) {
                            this.lock.wait(l2);
                        }
                        if (this.updated) {
                            this.updated = false;
                            continue;
                        }
                        if (!nIWakeupTask.cancelled) {
                            nIWakeupTask.logger.debug_general("timer popped, interrupting");
                            nIWakeupTask.thread.interrupt();
                        }
                        this.queue.remove(l);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.error("interrupted exception caught");
                        this.logger.throwable((Throwable)interruptedException);
                    }
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.logger.error("interrupted while waiting for tasks... ignoring");
                    this.logger.throwable((Throwable)interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIWakeupTask scheduleWakeup(Logger logger, long l) {
        Object object = this.lock;
        synchronized (object) {
            long l2 = System.currentTimeMillis() + l;
            Long l3 = new Long(l2);
            while (this.queue.get(l3) != null) {
                l3 = new Long(++l2);
            }
            NIWakeupTask nIWakeupTask = new NIWakeupTask(logger, Thread.currentThread(), l2);
            this.queue.put(l3, nIWakeupTask);
            this.updated = true;
            this.lock.notify();
            return nIWakeupTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelWakeup(NIWakeupTask nIWakeupTask) {
        Object object = this.lock;
        synchronized (object) {
            Long l = new Long(nIWakeupTask.wakeupTime);
            NIWakeupTask nIWakeupTask2 = (NIWakeupTask)this.queue.get(l);
            if (nIWakeupTask2 == nIWakeupTask) {
                nIWakeupTask.logger.debug_general("timer cancelled");
                this.queue.remove(l);
                this.updated = true;
                this.lock.notify();
            } else {
                this.logger.error("cancelWakeup called, but given task is not in the queue at the right place");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

