/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.util;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;

public class NIWatchdogTimer
implements Runnable {
    private Thread executionThread;
    private boolean destroyed = false;
    private boolean active = false;
    private Object lock = new Object();
    private Object activationLock = new Object();
    private long waitTime;
    private Thread target;
    private Logger logger;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$util$NIWatchdogTimer;

    public NIWatchdogTimer() {
        this.logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$util$NIWatchdogTimer == null ? (class$com$ibm$storage$ess$ni$util$NIWatchdogTimer = NIWatchdogTimer.class$("com.ibm.storage.ess.ni.util.NIWatchdogTimer")) : class$com$ibm$storage$ess$ni$util$NIWatchdogTimer);
        this.executionThread = new Thread(this);
        this.executionThread.start();
    }

    public NIWatchdogTimer(Logger logger) {
        this.logger = logger;
        this.executionThread = new Thread(this);
        this.executionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.destroyed) {
            Object object = this.lock;
            synchronized (object) {
                if (this.active) {
                    try {
                        this.lock.wait(this.waitTime);
                        if (this.active && !this.destroyed) {
                            this.logger.debug_general("Timer popped!!!.... calling interrupt on " + this.target);
                            this.target.interrupt();
                            this.active = false;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.error("Interrupted while waiting the specified time");
                        this.logger.throwable((Throwable)interruptedException);
                    }
                } else {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.error("Interrupted while waiting to be activated");
                        this.logger.throwable((Throwable)interruptedException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void activate(long l) throws InterruptedException {
        Object object = this.activationLock;
        synchronized (object) {
            while (this.active) {
                try {
                    this.activationLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.logger.error("Interrupted while waiting for my turn to use watchdog... no fair!");
                    this.logger.throwable((Throwable)interruptedException);
                }
            }
            this.active = true;
            this.waitTime = l;
            this.target = Thread.currentThread();
            Object object2 = this.lock;
            synchronized (object2) {
                this.lock.notify();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.activationLock;
        synchronized (object) {
            if (Thread.currentThread() == this.target) {
                this.active = false;
                Object object2 = this.lock;
                synchronized (object2) {
                    this.lock.notify();
                }
                this.activationLock.notify();
            } else {
                this.logger.error("Bad thread! (" + Thread.currentThread() + ")  ...trying to cancel " + this.target + "'s watchdog...  go to your room!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.destroyed = true;
            this.lock.notify();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

