/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.pf;

import com.ibm.storage.ess.pf.PFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Vector;

public class PF
extends Thread {
    private ServerSocketChannel ssc;
    private InetAddress remoteAddr = null;
    private int localPort = 0;
    private int remotePort = 0;
    protected boolean running;
    private Vector pfProcessors = new Vector();
    private boolean verbose;
    private InetAddress[] allowedHosts;

    PF(String string, String string2, String string3, boolean bl, String[] stringArray) throws PFException {
        super("PF");
        this.verbose = bl;
        if (bl) {
            System.out.println("PF: Forwarding localhost:" + string + " to " + string2 + ":" + string3);
        }
        try {
            this.localPort = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("[ERROR]PF: illegal local port given: \"" + string + "\"");
            if (bl) {
                numberFormatException.printStackTrace();
            }
            throw new PFException("Illegal local port given: " + string);
        }
        try {
            if (bl) {
                System.out.println("PF: creating server socket channel");
            }
            this.ssc = ServerSocketChannel.open();
            this.ssc.socket().bind(new InetSocketAddress(this.localPort));
        }
        catch (IOException iOException) {
            System.out.println("[ERROR]PF: cannot create socket on port " + this.localPort);
            if (bl) {
                iOException.printStackTrace();
            }
            throw new PFException("cannot create socket on port " + this.localPort);
        }
        this.setRemoteAddr(string2);
        this.setRemotePort(string3);
        this.setAllowedHosts(stringArray);
        this.running = true;
    }

    String getLocalPort() {
        return Integer.toString(this.localPort);
    }

    void setRemotePort(String string) throws PFException {
        try {
            this.remotePort = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("[ERROR]PF: illegal remote port given: \"" + string + "\"");
            if (this.verbose) {
                numberFormatException.printStackTrace();
            }
            throw new PFException("illegal remote port given: \"" + string + "\"");
        }
    }

    void setRemoteAddr(String string) throws PFException {
        try {
            this.remoteAddr = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("[ERROR]PF: cannot resolve host \"" + string + "\"");
            if (this.verbose) {
                unknownHostException.printStackTrace();
            }
            throw new PFException("cannot resolve host \"" + string + "\"");
        }
    }

    void setAllowedHosts(String[] stringArray) throws PFException {
        if (stringArray != null) {
            this.allowedHosts = new InetAddress[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                try {
                    this.allowedHosts[n] = InetAddress.getByName(stringArray[n]);
                }
                catch (UnknownHostException unknownHostException) {
                    System.out.println("[ERROR]PF: cannot resolve host \"" + stringArray[n] + "\"");
                    if (this.verbose) {
                        unknownHostException.printStackTrace();
                    }
                    throw new PFException("cannot resolve host \"" + stringArray[n] + "\"");
                }
                ++n;
            }
        } else {
            this.allowedHosts = null;
        }
    }

    void modify(String string, String string2, boolean bl, String[] stringArray) throws PFException {
        this.verbose = bl;
        if (bl) {
            System.out.println("modify called, with remote address " + string + " , the remote port" + string2);
        }
        this.setRemoteAddr(string);
        this.setRemotePort(string2);
        this.setAllowedHosts(stringArray);
    }

    private boolean hostAllowed(InetAddress inetAddress) {
        boolean bl = false;
        System.out.println("checking whether " + inetAddress + " is allowed to connect");
        if (this.allowedHosts == null) {
            bl = true;
        } else {
            int n = 0;
            while (n < this.allowedHosts.length) {
                System.out.println("comparing to " + this.allowedHosts[n]);
                if (inetAddress.equals(this.allowedHosts[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public void run() {
        block9: {
            while (this.running) {
                try {
                    InetAddress inetAddress;
                    if (this.verbose) {
                        System.out.println("PF: accepting server socket channel");
                    }
                    SocketChannel socketChannel = this.ssc.accept();
                    if (this.verbose) {
                        System.out.println("PF: accepted a connection");
                    }
                    if (this.hostAllowed(inetAddress = socketChannel.socket().getInetAddress())) {
                        PFProcessor pFProcessor = new PFProcessor(socketChannel, inetAddress);
                        this.pfProcessors.add(pFProcessor);
                        continue;
                    }
                    if (this.verbose) {
                        System.out.println("PF: did not accept connection from host: " + inetAddress);
                    }
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    if (!this.running) continue;
                    System.err.println("[ERROR]PF: incoming connection attempt failed");
                    if (!this.verbose) continue;
                    iOException.printStackTrace(System.err);
                }
            }
            try {
                this.ssc.close();
            }
            catch (IOException iOException) {
                if (!this.verbose) break block9;
                iOException.printStackTrace();
            }
        }
    }

    public void terminate() {
        PFProcessor pFProcessor;
        block3: {
            pFProcessor = null;
            this.running = false;
            try {
                this.ssc.close();
            }
            catch (IOException iOException) {
                if (!this.verbose) break block3;
                iOException.printStackTrace();
            }
        }
        this.interrupt();
        Iterator iterator = this.pfProcessors.iterator();
        while (iterator.hasNext()) {
            pFProcessor = (PFProcessor)iterator.next();
            pFProcessor.terminate();
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        String[] stringArray2 = null;
        if (stringArray.length < 3) {
            System.out.println("usage: java pf <local port> <remote host> <remote port> [-verbose] [-allow <host 1> ... <host n>]");
            System.exit(0);
        } else if (stringArray.length > 3) {
            if (stringArray[3].compareTo("-verbose") == 0 || stringArray[3].compareTo("verbose") == 0) {
                bl = true;
                if (stringArray.length > 4 && (stringArray[4].compareTo("-allow") == 0 || stringArray[4].compareTo("allow") == 0)) {
                    stringArray2 = new String[stringArray.length - 5];
                    System.arraycopy(stringArray, 5, stringArray2, 0, stringArray2.length);
                }
            } else if (stringArray[3].compareTo("-allow") == 0 || stringArray[3].compareTo("allow") == 0) {
                stringArray2 = new String[stringArray.length - 4];
                System.arraycopy(stringArray, 4, stringArray2, 0, stringArray2.length);
            }
        }
        try {
            PF pF = new PF(stringArray[0], stringArray[1], stringArray[2], bl, stringArray2);
            pF.start();
        }
        catch (PFException pFException) {
            pFException.printStackTrace();
        }
    }

    private class PFProcessor {
        private SocketChannel localSocketChannel;
        private SocketChannel remoteSocketChannel;
        private PFHalfDuplexProcessor localToRemote;
        private PFHalfDuplexProcessor remoteToLocal;
        private InetAddress connectingAddress;
        protected boolean running;

        public PFProcessor(SocketChannel socketChannel, InetAddress inetAddress) {
            block7: {
                this.localSocketChannel = socketChannel;
                this.connectingAddress = inetAddress;
                this.running = true;
                try {
                    if (PF.this.verbose) {
                        System.out.println("PFProcessor: creating remote socket");
                    }
                    this.remoteSocketChannel = SocketChannel.open(new InetSocketAddress(PF.this.remoteAddr, PF.this.remotePort));
                    if (PF.this.verbose) {
                        System.out.println("PFProcessor: local socket channel: " + this.localSocketChannel);
                        System.out.println("PFProcessor: remote socket channel: " + this.remoteSocketChannel);
                    }
                    this.localToRemote = new PFHalfDuplexProcessor(this.localSocketChannel, this.remoteSocketChannel);
                    this.remoteToLocal = new PFHalfDuplexProcessor(this.remoteSocketChannel, this.localSocketChannel);
                    this.localToRemote.start();
                    this.remoteToLocal.start();
                }
                catch (IOException iOException) {
                    System.out.println("[ERROR]PFProcessor: couldn't connect to remote port");
                    if (PF.this.verbose) {
                        iOException.printStackTrace();
                    }
                    try {
                        socketChannel.close();
                    }
                    catch (IOException iOException2) {
                        System.out.println("[ERROR]PFProcessor: exception when closing local port");
                        if (!PF.this.verbose) break block7;
                        iOException2.printStackTrace();
                    }
                }
            }
        }

        public void terminate() {
            block2: {
                this.running = false;
                try {
                    this.localSocketChannel.close();
                    this.remoteSocketChannel.close();
                }
                catch (IOException iOException) {
                    if (!PF.this.verbose) break block2;
                    iOException.printStackTrace();
                }
            }
        }

        private class PFHalfDuplexProcessor
        extends Thread {
            private SocketChannel in;
            private SocketChannel out;
            private ByteBuffer buffer;
            private int maxRead;
            private static final int BUFFER_SIZE = 65536;

            public PFHalfDuplexProcessor(SocketChannel socketChannel, SocketChannel socketChannel2) {
                super("PFHalfDuplexProcessor");
                this.in = socketChannel;
                this.out = socketChannel2;
                this.buffer = ByteBuffer.allocateDirect(65536);
                this.maxRead = 0;
            }

            public void run() {
                while (PFProcessor.this.running) {
                    int n = 0;
                    int n2 = 0;
                    this.buffer.clear();
                    try {
                        n = this.in.read(this.buffer);
                        if (n == -1) {
                            if (PF.this.verbose) {
                                System.out.println("PFHalfDuplexProcessor: EOF reached... terminating");
                            }
                            PFProcessor.this.terminate();
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        if (PFProcessor.this.running) {
                            System.out.println("[ERROR]PFHalfDuplexProcessor: problem reading from input stream.... terminating");
                            iOException.printStackTrace();
                        }
                        PFProcessor.this.terminate();
                        return;
                    }
                    this.buffer.flip();
                    while (n2 < n) {
                        try {
                            n2 = this.out.write(this.buffer);
                        }
                        catch (IOException iOException) {
                            if (PFProcessor.this.running) {
                                System.out.println("[ERROR]PFHalfDuplexProcessor: problem writing to output stream");
                                iOException.printStackTrace();
                            }
                            PFProcessor.this.terminate();
                            return;
                        }
                    }
                }
            }
        }
    }
}

