/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.util.PartnerVersionUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;

public class Version {
    public static final String PROJECT_NAME = "IBM Java ORB";
    public static final String BUILD = "orb1420-20040626";
    public static final String FULL = "IBM Java ORB build orb1420-20040626";
    public static final String PARTNER_VERSION = Integer.toHexString(Version.getVersionMajor()) + ":" + Version.getVersionMinor();
    public static final String MAIN = "IBM Java ORB build orb1420-20040626 version " + PARTNER_VERSION;
    private static final String thisClassName = "com.ibm.rmi.util.Version";
    private static String fullversion = null;

    public static String asString() {
        return FULL;
    }

    public static String getBuildLevel() {
        return BUILD;
    }

    public static short getVersionMajor() {
        return PartnerVersionUtil.getORB_MAJOR();
    }

    public static short getVersionMinor() {
        return PartnerVersionUtil.getORB_MINOR();
    }

    private static String getBaseversion() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.version");
            }
        });
        int n = string.indexOf(46);
        int n2 = string.indexOf(46, n + 1);
        return string.substring(0, n2);
    }

    private static String getFullversion() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.fullversion");
            }
        });
    }

    public static void logVersions() {
        if (ORBRas.isTrcLogging) {
            if (fullversion == null) {
                fullversion = Version.getFullversion();
            }
            ORBRas.orbTrcLogger.trace(8208L, thisClassName, "logVersions:111", FULL);
            ORBRas.orbTrcLogger.trace(8208L, thisClassName, "logVersions:115", fullversion);
        }
    }

    public static void checkVersions() {
        String string = "";
        String string2 = Version.getBaseversion();
        short s = Version.getVersionMajor();
        short s2 = Version.getVersionMinor();
        double d = Double.valueOf(string2);
        try {
            if (!PartnerVersionUtil.isORB14OrGreater(s, s2) && d >= 1.4) {
                string = "Cannot use a 1.3.x ORB with a 1.4.x JDK";
                System.err.println(string);
                throw new Exception(string);
            }
            if (PartnerVersionUtil.isORB14OrGreater(s, s2) && d < 1.4) {
                string = "Cannot use a 1.4.x ORB with a 1.3.x JDK";
                System.err.println(string);
                throw new Exception(string);
            }
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "checkVersions:150", exception);
            throw new INITIALIZE(exception.toString(), 1229124869, CompletionStatus.COMPLETED_NO);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(MAIN);
    }
}

